/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.entityhub.servicesapi.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.stanbol.entityhub.servicesapi.model.rdf.RdfResourceEnum;

public enum MappingState {
    rejected(RdfResourceEnum.mappingStateRejected.getUri()),
    proposed(RdfResourceEnum.mappingStateProposed.getUri()),
    expired(RdfResourceEnum.mappingStateExpired.getUri()),
    confirmed(RdfResourceEnum.mappingStateConfirmed.getUri());

    private String uri;
    private static Map<String, MappingState> URI_TO_STATE;

    private MappingState(String uri) {
        this.uri = uri;
    }

    public String getUri() {
        return this.uri;
    }

    public String toString() {
        return this.uri;
    }

    public static MappingState getState(String uri) throws IllegalArgumentException {
        MappingState state = URI_TO_STATE.get(uri);
        if (state == null) {
            throw new IllegalArgumentException(String.format("Unknown MappingState URI %s (supported states URIs: %s)", uri, URI_TO_STATE.keySet()));
        }
        return state;
    }

    public static boolean isState(String uri) {
        return URI_TO_STATE.containsKey(uri);
    }

    static {
        HashMap<String, MappingState> mappings = new HashMap<String, MappingState>();
        for (MappingState state : MappingState.values()) {
            mappings.put(state.getUri(), state);
        }
        URI_TO_STATE = Collections.unmodifiableMap(mappings);
    }
}

