/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.entityhub.servicesapi.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.stanbol.entityhub.servicesapi.model.rdf.RdfResourceEnum;

public enum ManagedEntityState {
    removed(RdfResourceEnum.entityStateRemoved.getUri()),
    depreciated(RdfResourceEnum.entityStateDepreciated.getUri()),
    proposed(RdfResourceEnum.entityStateProposed.getUri()),
    active(RdfResourceEnum.entityStateActive.getUri());

    private String uri;
    private static Map<String, ManagedEntityState> URI_TO_STATE;

    private ManagedEntityState(String uri) {
        this.uri = uri;
    }

    public String getUri() {
        return this.uri;
    }

    public String toString() {
        return this.uri;
    }

    public static ManagedEntityState getState(String uri) throws IllegalArgumentException {
        ManagedEntityState state = URI_TO_STATE.get(uri);
        if (state == null) {
            throw new IllegalArgumentException(String.format("Unknown SymbolState URI %s (supported states URIs: %s)", uri, URI_TO_STATE.keySet()));
        }
        return state;
    }

    public static boolean isState(String uri) {
        return URI_TO_STATE.containsKey(uri);
    }

    static {
        HashMap<String, ManagedEntityState> mappings = new HashMap<String, ManagedEntityState>();
        for (ManagedEntityState state : ManagedEntityState.values()) {
            mappings.put(state.getUri(), state);
        }
        URI_TO_STATE = Collections.unmodifiableMap(mappings);
    }
}

