/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.entityhub.servicesapi.defaults;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.datatype.Duration;
import javax.xml.namespace.QName;
import org.apache.stanbol.entityhub.servicesapi.defaults.NamespaceEnum;
import org.apache.stanbol.entityhub.servicesapi.model.Reference;
import org.apache.stanbol.entityhub.servicesapi.model.Text;

public enum DataTypeEnum {
    Reference(NamespaceEnum.entityhub, "ref", Reference.class, new Class[0]),
    Text(NamespaceEnum.entityhub, "text", Text.class, new Class[0]),
    AnyUri("anyURI", Reference.class, URI.class, URL.class),
    Boolean("boolean", Boolean.class, new Class[0]),
    Byte("byte", Byte.class, new Class[0]),
    Short("short", Short.class, new Class[0]),
    Integer("integer", BigInteger.class, new Class[0]),
    Decimal("decimal", BigDecimal.class, new Class[0]),
    Int("int", Integer.class, new Class[0]),
    Long("long", Long.class, new Class[0]),
    Float("float", Float.class, new Class[0]),
    Double("double", Double.class, new Class[0]),
    String("string", String.class, Text.class),
    Time("time", Date.class, new Class[0]),
    Date("date", Date.class, new Class[0]),
    DateTime("dateTime", Date.class, new Class[0]),
    Duration("duration", Duration.class, new Class[0]);

    private final Class<?> javaType;
    private final QName qName;
    private final String shortName;
    private final String uri;
    private final Set<Class<?>> additional;
    private static Map<Class<?>, Set<DataTypeEnum>> class2DataTypeMap;
    private static Map<Class<?>, Set<DataTypeEnum>> interface2DataTypeMap;
    private static Map<Class<?>, Set<DataTypeEnum>> allClass2DataTypeMap;
    private static Map<Class<?>, Set<DataTypeEnum>> allInterface2DataTypeMap;
    private static Map<String, DataTypeEnum> uri2DataType;
    private static Map<String, DataTypeEnum> shortName2DataType;

    private DataTypeEnum(Class<?> javaType, Class<?> ... additional) {
        this((NamespaceEnum)null, (String)null, javaType, additional);
    }

    private DataTypeEnum(String localName, Class<?> javaType, Class<?> ... additional) {
        this(null, localName, javaType, additional);
    }

    private DataTypeEnum(NamespaceEnum namespace, Class<?> javaType, Class<?> ... additional) {
        this(namespace, (String)null, javaType, additional);
    }

    private DataTypeEnum(NamespaceEnum namespace, String localName, Class<?> javaType, Class<?> ... additional) {
        if (namespace == null) {
            namespace = NamespaceEnum.xsd;
        }
        if (localName == null) {
            localName = this.name();
        }
        this.additional = additional != null && additional.length > 0 ? Collections.unmodifiableSet(new HashSet(Arrays.asList(additional))) : Collections.emptySet();
        this.javaType = javaType;
        this.qName = new QName(namespace.getNamespace(), localName, namespace.getPrefix());
        this.shortName = this.qName.getPrefix() + ':' + this.qName.getLocalPart();
        this.uri = this.qName.getNamespaceURI() + this.qName.getLocalPart();
    }

    public final String getLocalName() {
        return this.qName.getLocalPart();
    }

    public final Class<?> getJavaType() {
        return this.javaType;
    }

    public Set<Class<?>> getAdditionalJavaTypes() {
        return this.additional;
    }

    public final NamespaceEnum getNamespace() {
        return NamespaceEnum.forNamespace(this.qName.getNamespaceURI());
    }

    public final String getUri() {
        return this.uri;
    }

    public final String getShortName() {
        return this.shortName;
    }

    public final QName getQName() {
        return this.qName;
    }

    public String toString() {
        return this.getUri();
    }

    public static Set<DataTypeEnum> getPrimaryDataTypes(Class<?> javaClass) {
        EnumSet<DataTypeEnum> dataTypes = EnumSet.noneOf(DataTypeEnum.class);
        Set<DataTypeEnum> classesTypes = class2DataTypeMap.get(javaClass);
        if (classesTypes != null) {
            dataTypes.addAll(classesTypes);
        }
        for (Map.Entry<Class<?>, Set<DataTypeEnum>> entry : interface2DataTypeMap.entrySet()) {
            if (!entry.getKey().isAssignableFrom(javaClass)) continue;
            dataTypes.addAll((Collection<DataTypeEnum>)entry.getValue());
        }
        return dataTypes;
    }

    public static Set<DataTypeEnum> getAllDataTypes(Class<?> javaClass) {
        Set<DataTypeEnum> all = DataTypeEnum.getPrimaryDataTypes(javaClass);
        Set<DataTypeEnum> additionalClassesTypes = allClass2DataTypeMap.get(javaClass);
        if (additionalClassesTypes != null) {
            all.addAll(additionalClassesTypes);
        }
        for (Map.Entry<Class<?>, Set<DataTypeEnum>> entry : allInterface2DataTypeMap.entrySet()) {
            if (!entry.getKey().isAssignableFrom(javaClass)) continue;
            all.addAll((Collection<DataTypeEnum>)entry.getValue());
        }
        return all;
    }

    public static DataTypeEnum getDataType(String uri) {
        return uri2DataType.get(uri);
    }

    public static DataTypeEnum getDataTypeByShortName(String shortName) {
        return shortName2DataType.get(shortName);
    }

    static {
        HashMap c2d = new HashMap();
        HashMap i2d = new HashMap();
        HashMap ac2d = new HashMap();
        HashMap ai2d = new HashMap();
        HashMap<String, DataTypeEnum> u2d = new HashMap<String, DataTypeEnum>();
        HashMap<String, DataTypeEnum> s2d = new HashMap<String, DataTypeEnum>();
        for (DataTypeEnum dataType : DataTypeEnum.values()) {
            Set<DataTypeEnum> dataTypes;
            if (dataType.javaType.isInterface()) {
                dataTypes = (EnumSet<DataTypeEnum>)i2d.get(dataType.javaType);
                if (dataTypes == null) {
                    dataTypes = EnumSet.noneOf(DataTypeEnum.class);
                    i2d.put(dataType.javaType, (EnumSet<DataTypeEnum>)dataTypes);
                }
                dataTypes.add(dataType);
            } else {
                dataTypes = (Set)c2d.get(dataType.javaType);
                if (dataTypes == null) {
                    dataTypes = EnumSet.noneOf(DataTypeEnum.class);
                    c2d.put(dataType.javaType, (EnumSet<DataTypeEnum>)dataTypes);
                }
                dataTypes.add(dataType);
            }
            for (Class<?> additionalClass : dataType.additional) {
                Set<DataTypeEnum> dataTypes2;
                if (additionalClass.isInterface()) {
                    dataTypes2 = (EnumSet<DataTypeEnum>)ai2d.get(additionalClass);
                    if (dataTypes2 == null) {
                        dataTypes2 = EnumSet.noneOf(DataTypeEnum.class);
                        ai2d.put(additionalClass, (EnumSet<DataTypeEnum>)dataTypes2);
                    }
                    dataTypes2.add(dataType);
                    continue;
                }
                dataTypes2 = (Set)ac2d.get(additionalClass);
                if (dataTypes2 == null) {
                    dataTypes2 = EnumSet.noneOf(DataTypeEnum.class);
                    ac2d.put(additionalClass, (EnumSet<DataTypeEnum>)dataTypes2);
                }
                dataTypes2.add(dataType);
            }
            if (u2d.containsKey(dataType.getUri())) {
                throw new IllegalStateException(java.lang.String.format("Invalid configuration in DataTypeEnum because dataType uri %s is used for %s and %s!", dataType.getUri(), dataType.name(), ((DataTypeEnum)((Object)u2d.get(dataType.getUri()))).name()));
            }
            u2d.put(dataType.getUri(), dataType);
            if (s2d.containsKey(dataType.getShortName())) {
                throw new IllegalStateException(java.lang.String.format("Invalid configuration in DataTypeEnum because dataType short name (prefix:localname) %s is used for %s and %s!", dataType.getShortName(), dataType.name(), ((DataTypeEnum)((Object)s2d.get(dataType.getShortName()))).name()));
            }
            s2d.put(dataType.getShortName(), dataType);
        }
        class2DataTypeMap = Collections.unmodifiableMap(c2d);
        interface2DataTypeMap = Collections.unmodifiableMap(i2d);
        allClass2DataTypeMap = Collections.unmodifiableMap(ac2d);
        allInterface2DataTypeMap = Collections.unmodifiableMap(ai2d);
        uri2DataType = Collections.unmodifiableMap(u2d);
        shortName2DataType = Collections.unmodifiableMap(s2d);
    }
}

