/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.entityhub.servicesapi.query;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.stanbol.entityhub.servicesapi.query.Constraint;

public class ValueConstraint
extends Constraint {
    public static final MODE DEFAULT_MODE = MODE.any;
    private final Set<Object> values;
    private final Collection<String> dataTypeUris;
    private final MODE mode;

    public ValueConstraint(Object value) {
        this(value, null);
    }

    public ValueConstraint(Object value, Iterable<String> dataTypes) {
        this(value, dataTypes, null);
    }

    public ValueConstraint(Object value, Iterable<String> dataTypes, MODE mode) {
        super(Constraint.ConstraintType.value);
        if (value == null) {
            this.values = null;
        } else if (value instanceof Iterable) {
            LinkedHashSet v = new LinkedHashSet();
            Iterable values = (Iterable)value;
            for (Object val : values) {
                if (val == null) continue;
                v.add(val);
            }
            if (v.isEmpty()) {
                throw new IllegalArgumentException("The values MUST BE NULL or contain at least a single NOT NULL value MUST BE parsed!");
            }
            this.values = Collections.unmodifiableSet(v);
        } else {
            this.values = Collections.singleton(value);
        }
        if (dataTypes != null) {
            LinkedHashSet<String> dataTypeUris = new LinkedHashSet<String>();
            for (String dataType : dataTypes) {
                if (dataType == null || dataType.isEmpty()) continue;
                dataTypeUris.add(dataType);
            }
            if (dataTypeUris.isEmpty()) {
                throw new IllegalArgumentException("At least a single NOT NULL and not empty data type uri MUST BE parsed (NULL will trigger detection of the data type based on the parsed value(s))!");
            }
            this.dataTypeUris = Collections.unmodifiableSet(dataTypeUris);
        } else {
            this.dataTypeUris = null;
        }
        this.mode = mode == null ? DEFAULT_MODE : mode;
    }

    public final Set<Object> getValues() {
        return this.values;
    }

    public MODE getMode() {
        return this.mode;
    }

    public final Collection<String> getDataTypes() {
        return this.dataTypeUris;
    }

    public String toString() {
        return String.format("ValueConstraint[values=%s|types:%s]", this.values, this.dataTypeUris);
    }

    public static enum MODE {
        any,
        all;

    }
}

