/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.entityhub.jersey.resource;

import at.newmedialab.ldpath.api.backend.RDFBackend;
import at.newmedialab.ldpath.exception.LDPathParseException;
import at.newmedialab.ldpath.model.programs.Program;
import com.sun.jersey.api.view.Viewable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.clerezza.rdf.core.MGraph;
import org.apache.clerezza.rdf.ontologies.RDFS;
import org.apache.stanbol.commons.indexedgraph.IndexedMGraph;
import org.apache.stanbol.commons.web.base.ContextHelper;
import org.apache.stanbol.commons.web.base.CorsHelper;
import org.apache.stanbol.commons.web.base.resource.BaseStanbolResource;
import org.apache.stanbol.commons.web.base.utils.MediaTypeUtil;
import org.apache.stanbol.entityhub.core.query.QueryResultListImpl;
import org.apache.stanbol.entityhub.core.utils.AdaptingIterator;
import org.apache.stanbol.entityhub.jersey.utils.JerseyUtils;
import org.apache.stanbol.entityhub.jersey.utils.LDPathHelper;
import org.apache.stanbol.entityhub.ldpath.EntityhubLDPath;
import org.apache.stanbol.entityhub.ldpath.backend.AbstractBackend;
import org.apache.stanbol.entityhub.ldpath.backend.SiteBackend;
import org.apache.stanbol.entityhub.ldpath.query.LDPathSelect;
import org.apache.stanbol.entityhub.model.clerezza.RdfRepresentation;
import org.apache.stanbol.entityhub.model.clerezza.RdfValueFactory;
import org.apache.stanbol.entityhub.servicesapi.defaults.NamespaceEnum;
import org.apache.stanbol.entityhub.servicesapi.model.Entity;
import org.apache.stanbol.entityhub.servicesapi.model.Representation;
import org.apache.stanbol.entityhub.servicesapi.model.ValueFactory;
import org.apache.stanbol.entityhub.servicesapi.query.FieldQuery;
import org.apache.stanbol.entityhub.servicesapi.query.QueryResultList;
import org.apache.stanbol.entityhub.servicesapi.site.License;
import org.apache.stanbol.entityhub.servicesapi.site.ReferencedSite;
import org.apache.stanbol.entityhub.servicesapi.site.ReferencedSiteException;
import org.apache.stanbol.entityhub.servicesapi.site.ReferencedSiteManager;
import org.apache.stanbol.entityhub.servicesapi.site.SiteConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/entityhub/site/{site}")
public class ReferencedSiteRootResource
extends BaseStanbolResource {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final Set<String> RDF_MEDIA_TYPES = new TreeSet<String>(Arrays.asList("text/rdf+n3", "text/rdf+nt", "application/rdf+xml", "text/turtle", "application/x-turtle", "application/rdf+json"));
    public static final String LICENSE_PATH = "license";
    private static final String LICENSE_NAME = "LICENSE";
    private static final String DEFAULT_FIND_FIELD = RDFS.label.getUnicodeString();
    private static final int DEFAULT_FIND_RESULT_LIMIT = 5;
    private ReferencedSite site;

    public ReferencedSiteRootResource(@PathParam(value="site") String siteId, @Context ServletContext servletContext) {
        this.log.info("<init> with site {}", (Object)siteId);
        ReferencedSiteManager referencedSiteManager = (ReferencedSiteManager)ContextHelper.getServiceFromContext(ReferencedSiteManager.class, (ServletContext)servletContext);
        if (siteId == null || siteId.isEmpty()) {
            this.log.error("Missing path parameter site={}", (Object)siteId);
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        this.site = referencedSiteManager.getReferencedSite(siteId);
        if (this.site == null) {
            this.log.error("Site {} not found (no referenced site with that ID is present within the Entityhub", (Object)siteId);
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
    }

    @OPTIONS
    public Response handleCorsPreflight(@Context HttpHeaders headers) {
        Response.ResponseBuilder res = Response.ok();
        CorsHelper.enableCORS((ServletContext)this.servletContext, (Response.ResponseBuilder)res, (HttpHeaders)headers, (String[])new String[0]);
        return res.build();
    }

    @GET
    @Produces(value={"text/html"})
    public Response getHtmlInfo(@Context HttpHeaders headers) {
        Response.ResponseBuilder rb = Response.ok((Object)new Viewable("index", (Object)this));
        rb.header("Content-Type", (Object)"text/html; charset=utf-8");
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        return rb.build();
    }

    @GET
    @Produces(value={"application/json", "application/rdf+xml", "text/rdf+n3", "text/turtle", "application/x-turtle", "application/rdf+json", "text/rdf+nt"})
    public Response getInfo(@Context HttpHeaders headers, @Context UriInfo uriInfo) {
        MediaType acceptedMediaType = MediaTypeUtil.getAcceptableMediaType((HttpHeaders)headers, JerseyUtils.REPRESENTATION_SUPPORTED_MEDIA_TYPES, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        Response.ResponseBuilder rb = Response.ok((Object)this.site2Representation(uriInfo.getAbsolutePath().toString()));
        rb.header("Content-Type", (Object)(acceptedMediaType + "; charset=utf-8"));
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        return rb.build();
    }

    @GET
    @Path(value="license/{name}")
    public Response getLicenseInfo(@Context HttpHeaders headers, @Context UriInfo uriInfo, @PathParam(value="name") String name) {
        MediaType acceptedMediaType = MediaTypeUtil.getAcceptableMediaType((HttpHeaders)headers, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        if (name != null && !name.isEmpty() && name.startsWith(LICENSE_NAME)) {
            try {
                String numberString = name.substring(LICENSE_NAME.length());
                if (numberString.isEmpty()) {
                    numberString = "0";
                }
                int count = -1;
                if (this.site.getConfiguration().getLicenses() != null) {
                    for (License license : this.site.getConfiguration().getLicenses()) {
                        if (license.getUrl() == null) {
                            ++count;
                        }
                        if (!Integer.toString(count).equals(numberString)) continue;
                        Response.ResponseBuilder rb = Response.ok((Object)this.license2Representation(uriInfo.getAbsolutePath().toString(), license));
                        rb.header("Content-Type", (Object)(acceptedMediaType + "; charset=utf-8"));
                        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
                        return rb.build();
                    }
                }
            }
            catch (NumberFormatException e) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"No License found.\n").header("Accept", (Object)acceptedMediaType).build();
            }
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @OPTIONS
    @Path(value="/entity")
    public Response handleCorsPreflightEntity(@Context HttpHeaders headers) {
        Response.ResponseBuilder res = Response.ok();
        CorsHelper.enableCORS((ServletContext)this.servletContext, (Response.ResponseBuilder)res, (HttpHeaders)headers, (String[])new String[]{"OPTIONS", "GET"});
        return res.build();
    }

    @GET
    @Path(value="/entity")
    public Response getEntityById(@QueryParam(value="id") String id, @Context HttpHeaders headers) {
        Entity entity;
        this.log.info("site/{}/entity Request", (Object)this.site.getId());
        this.log.info("  > id       : " + id);
        this.log.info("  > accept   : " + headers.getAcceptableMediaTypes());
        this.log.info("  > mediaType: " + headers.getMediaType());
        HashSet<String> supported = new HashSet<String>(JerseyUtils.ENTITY_SUPPORTED_MEDIA_TYPES);
        supported.add("text/html");
        MediaType acceptedMediaType = MediaTypeUtil.getAcceptableMediaType((HttpHeaders)headers, supported, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        if (id == null || id.isEmpty()) {
            if (MediaType.TEXT_HTML_TYPE.isCompatible(acceptedMediaType)) {
                Response.ResponseBuilder rb = Response.ok((Object)new Viewable("entity", (Object)this));
                rb.header("Content-Type", (Object)"text/html; charset=utf-8");
                CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
                return rb.build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"No or empty ID was parsed. Missing parameter id.\n").header("Accept", (Object)acceptedMediaType).build();
        }
        this.log.info("handle Request for Entity {} of Site {}", (Object)id, (Object)this.site.getId());
        try {
            entity = this.site.getEntity(id);
        }
        catch (ReferencedSiteException e) {
            this.log.error("ReferencedSiteException while accessing Site " + this.site.getConfiguration().getName() + " (id=" + this.site.getId() + ")", (Throwable)e);
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        if (entity != null) {
            Response.ResponseBuilder rb = Response.ok((Object)entity);
            rb.header("Content-Type", (Object)(acceptedMediaType + "; charset=utf-8"));
            CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
            return rb.build();
        }
        this.log.info(" ... Entity {} not found on referenced site {}", (Object)id, (Object)this.site.getId());
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Entity '" + id + "' not found on referenced site '" + this.site.getId() + "'\n")).header("Accept", (Object)acceptedMediaType).build();
    }

    @OPTIONS
    @Path(value="/find")
    public Response handleCorsPreflightFind(@Context HttpHeaders headers) {
        Response.ResponseBuilder res = Response.ok();
        CorsHelper.enableCORS((ServletContext)this.servletContext, (Response.ResponseBuilder)res, (HttpHeaders)headers, (String[])new String[0]);
        return res.build();
    }

    @GET
    @Path(value="/find")
    public Response findEntitybyGet(@QueryParam(value="name") String name, @QueryParam(value="field") String field, @QueryParam(value="lang") String language, @QueryParam(value="limit") @DefaultValue(value="-1") int limit, @QueryParam(value="offset") @DefaultValue(value="0") int offset, @QueryParam(value="ldpath") String ldpath, @Context HttpHeaders headers) {
        return this.findEntity(name, field, language, limit, offset, ldpath, headers);
    }

    @POST
    @Path(value="/find")
    public Response findEntity(@FormParam(value="name") String name, @FormParam(value="field") String field, @FormParam(value="lang") String language, @FormParam(value="limit") Integer limit, @FormParam(value="offset") Integer offset, @FormParam(value="ldpath") String ldpath, @Context HttpHeaders headers) {
        this.log.debug("site/{}/find Request", (Object)this.site.getId());
        HashSet<String> supported = new HashSet<String>(JerseyUtils.QUERY_RESULT_SUPPORTED_MEDIA_TYPES);
        supported.add("text/html");
        MediaType acceptedMediaType = MediaTypeUtil.getAcceptableMediaType((HttpHeaders)headers, supported, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        if (name == null || name.isEmpty()) {
            if (MediaType.TEXT_HTML_TYPE.isCompatible(acceptedMediaType)) {
                Response.ResponseBuilder rb = Response.ok((Object)new Viewable("find", (Object)this));
                rb.header("Content-Type", (Object)"text/html; charset=utf-8");
                CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
                return rb.build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"The name must not be null nor empty for find requests. Missing parameter name.\n").header("Accept", (Object)acceptedMediaType).build();
        }
        if (field == null) {
            field = DEFAULT_FIND_FIELD;
        } else if ((field = field.trim()).isEmpty()) {
            field = DEFAULT_FIND_FIELD;
        }
        return this.executeQuery(JerseyUtils.createFieldQueryForFindRequest(name, field, language, limit == null || limit < 1 ? 5 : limit, offset, ldpath), headers);
    }

    @OPTIONS
    @Path(value="/query")
    public Response handleCorsPreflightQuery(@Context HttpHeaders headers) {
        Response.ResponseBuilder res = Response.ok();
        CorsHelper.enableCORS((ServletContext)this.servletContext, (Response.ResponseBuilder)res, (HttpHeaders)headers, (String[])new String[0]);
        return res.build();
    }

    @POST
    @Path(value="/query")
    @Consumes(value={"application/json"})
    public Response queryEntities(FieldQuery query, @Context HttpHeaders headers) {
        return this.executeQuery(query, headers);
    }

    @GET
    @Path(value="/query")
    @Produces(value={"text/html"})
    public Response getQueryDocumentation(@Context HttpHeaders headers) {
        Response.ResponseBuilder rb = Response.ok((Object)new Viewable("query", (Object)this));
        rb.header("Content-Type", (Object)"text/html; charset=utf-8");
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        return rb.build();
    }

    private Response executeQuery(FieldQuery query, HttpHeaders headers) throws WebApplicationException {
        QueryResultList result;
        MediaType mediaType = MediaTypeUtil.getAcceptableMediaType((HttpHeaders)headers, JerseyUtils.ENTITY_SUPPORTED_MEDIA_TYPES, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        if (query instanceof LDPathSelect && ((LDPathSelect)query).getLDPathSelect() != null) {
            return this.executeLDPathQuery(query, ((LDPathSelect)query).getLDPathSelect(), mediaType, headers);
        }
        try {
            result = this.site.find(query);
        }
        catch (ReferencedSiteException e) {
            String message = String.format("Unable to Query Site '%s' (message: %s)", this.site.getId(), e.getMessage());
            this.log.error(message, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)message).header("Accept", (Object)mediaType).build();
        }
        Response.ResponseBuilder rb = Response.ok((Object)result);
        rb.header("Content-Type", (Object)(mediaType + "; charset=utf-8"));
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        return rb.build();
    }

    private Response executeLDPathQuery(FieldQuery query, String ldpathProgramString, MediaType mediaType, HttpHeaders headers) {
        AdaptingIterator resultIt;
        Program<Object> program;
        RdfValueFactory vf = new RdfValueFactory((MGraph)new IndexedMGraph());
        SiteBackend backend = new SiteBackend(this.site, (ValueFactory)vf);
        EntityhubLDPath ldPath = new EntityhubLDPath((RDFBackend)backend, (ValueFactory)vf);
        HashSet<String> selectedFields = new HashSet<String>(query.getSelectedFields());
        try {
            program = LDPathHelper.prepairQueryLDPathProgram(ldpathProgramString, selectedFields, (AbstractBackend)backend, ldPath);
        }
        catch (LDPathParseException e) {
            this.log.warn("Unable to parse LDPath program used as select for Query:");
            this.log.warn("FieldQuery: \n {}", (Object)query);
            this.log.warn("LDPath: \n {}", (Object)((LDPathSelect)query).getLDPathSelect());
            this.log.warn("Exception:", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Unable to parse LDPath program (Messages: " + LDPathHelper.getLDPathParseExceptionMessage(e) + ")!\n")).header("Accept", (Object)mediaType).build();
        }
        catch (IllegalStateException e) {
            this.log.warn("parsed LDPath program is not compatible with parsed Query!", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).header("Accept", (Object)mediaType).build();
        }
        try {
            resultIt = new AdaptingIterator(this.site.findEntities(query).iterator(), (AdaptingIterator.Adapter)new AdaptingIterator.Adapter<Entity, Representation>(){

                public Representation adapt(Entity value, Class<Representation> type) {
                    return value.getRepresentation();
                }
            }, Representation.class);
        }
        catch (ReferencedSiteException e) {
            String message = String.format("Unable to Query Site '%s' (message: %s)", this.site.getId(), e.getMessage());
            this.log.error(message, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)message).header("Accept", (Object)mediaType).build();
        }
        Collection<Representation> transformedResults = LDPathHelper.transformQueryResults((Iterator<Representation>)resultIt, program, selectedFields, ldPath, (AbstractBackend)backend, (ValueFactory)vf);
        QueryResultListImpl result = new QueryResultListImpl(query, transformedResults, Representation.class);
        Response.ResponseBuilder rb = Response.ok((Object)result);
        rb.header("Content-Type", (Object)(mediaType + "; charset=utf-8"));
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        return rb.build();
    }

    @OPTIONS
    @Path(value="/ldpath")
    public Response handleCorsPreflightLDPath(@Context HttpHeaders headers) {
        Response.ResponseBuilder res = Response.ok();
        CorsHelper.enableCORS((ServletContext)this.servletContext, (Response.ResponseBuilder)res, (HttpHeaders)headers, (String[])new String[]{"OPTIONS", "GET", "POST"});
        return res.build();
    }

    @GET
    @Path(value="/ldpath")
    public Response handleLDPathGet(@QueryParam(value="context") Set<String> contexts, @QueryParam(value="ldpath") String ldpath, @Context HttpHeaders headers) {
        return this.handleLDPathPost(contexts, ldpath, headers);
    }

    @POST
    @Path(value="/ldpath")
    public Response handleLDPathPost(@FormParam(value="context") Set<String> contexts, @FormParam(value="ldpath") String ldpath, @Context HttpHeaders headers) {
        return LDPathHelper.handleLDPathRequest(this, (RDFBackend<Object>)new SiteBackend(this.site), ldpath, contexts, headers, this.servletContext);
    }

    private Representation site2Representation(String id) {
        RdfValueFactory valueFactory = RdfValueFactory.getInstance();
        RdfRepresentation rep = valueFactory.createRepresentation(id);
        String namespace = NamespaceEnum.entityhubModel.getNamespace();
        rep.add(namespace + "localMode", (Object)this.site.supportsLocalMode());
        rep.add(namespace + "supportsSearch", (Object)this.site.supportsSearch());
        SiteConfiguration config = this.site.getConfiguration();
        rep.add(NamespaceEnum.rdfs + "label", (Object)config.getName());
        rep.add(NamespaceEnum.rdf + "type", (Object)valueFactory.createReference((Object)(namespace + "ReferencedSite")));
        if (config.getDescription() != null) {
            rep.add(NamespaceEnum.rdfs + "description", (Object)config.getDescription());
        }
        if (config.getCacheStrategy() != null) {
            rep.add(namespace + "cacheStrategy", (Object)valueFactory.createReference((Object)(namespace + "cacheStrategy-" + config.getCacheStrategy().name())));
        }
        if (config.getAccessUri() != null) {
            rep.add(namespace + "accessUri", (Object)valueFactory.createReference((Object)config.getAccessUri()));
        }
        if (config.getQueryUri() != null) {
            rep.add(namespace + "queryUri", (Object)valueFactory.createReference((Object)config.getQueryUri()));
        }
        if (config.getAttribution() != null) {
            rep.add(NamespaceEnum.cc.getNamespace() + "attributionName", (Object)config.getAttribution());
        }
        if (config.getAttributionUrl() != null) {
            rep.add(NamespaceEnum.cc.getNamespace() + "attributionURL", (Object)config.getAttributionUrl());
        }
        if (config.getLicenses() != null) {
            int count = 0;
            for (License license : config.getLicenses()) {
                String licenseUrl;
                if (license.getUrl() != null) {
                    licenseUrl = license.getUrl();
                } else {
                    licenseUrl = id + (!id.endsWith("/") ? "/" : "") + LICENSE_PATH + '/' + LICENSE_NAME + (count > 0 ? Integer.valueOf(count) : "");
                    ++count;
                }
                if (license.getName() != null) {
                    rep.add(NamespaceEnum.dcTerms.getNamespace() + LICENSE_PATH, (Object)licenseUrl);
                }
                rep.add(NamespaceEnum.cc.getNamespace() + LICENSE_PATH, (Object)licenseUrl);
            }
        }
        if (config.getEntityPrefixes() != null) {
            for (String prefix : config.getEntityPrefixes()) {
                rep.add(namespace + "entityPrefix", (Object)prefix);
            }
        } else {
            rep.add(namespace + "entityPrefix", (Object)"*");
        }
        return rep;
    }

    private Representation license2Representation(String id, License license) {
        RdfValueFactory valueFactory = RdfValueFactory.getInstance();
        RdfRepresentation rep = valueFactory.createRepresentation(id);
        if (license.getName() != null) {
            rep.add(NamespaceEnum.dcTerms.getNamespace() + LICENSE_PATH, (Object)license.getName());
            rep.add(NamespaceEnum.rdfs + "label", (Object)license.getName());
            rep.add(NamespaceEnum.dcTerms + "title", (Object)license.getName());
        }
        if (license.getText() != null) {
            rep.add(NamespaceEnum.rdfs + "description", (Object)license.getText());
        }
        rep.add(NamespaceEnum.cc.getNamespace() + "licenseUrl", (Object)(license.getUrl() == null ? id : license.getUrl()));
        return rep;
    }
}

