/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.entityhub.jersey.writers;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.clerezza.rdf.core.TripleCollection;
import org.apache.clerezza.rdf.core.serializedform.Serializer;
import org.apache.commons.io.IOUtils;
import org.apache.stanbol.commons.web.base.ContextHelper;
import org.apache.stanbol.entityhub.jersey.writers.EntityToJSON;
import org.apache.stanbol.entityhub.jersey.writers.EntityToRDF;
import org.apache.stanbol.entityhub.servicesapi.model.Representation;
import org.codehaus.jettison.json.JSONException;

@Provider
public class RepresentationWriter
implements MessageBodyWriter<Representation> {
    public static final Set<String> supportedMediaTypes;
    public static final String DEFAULT_ENCODING = "UTF-8";
    @Context
    protected ServletContext servletContext;

    public long getSize(Representation t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        String mediaTypeString = mediaType.getType() + '/' + mediaType.getSubtype();
        return Representation.class.isAssignableFrom(type) && supportedMediaTypes.contains(mediaTypeString);
    }

    public void writeTo(Representation rep, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        String mediaTypeString = mediaType.getType() + '/' + mediaType.getSubtype();
        String encoding = (String)mediaType.getParameters().get("charset");
        if (encoding == null) {
            encoding = DEFAULT_ENCODING;
        }
        if ("application/json".equals(mediaTypeString)) {
            try {
                IOUtils.write((String)EntityToJSON.toJSON(rep).toString(4), (OutputStream)entityStream, (String)encoding);
            }
            catch (JSONException e) {
                throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
            }
        } else {
            Serializer ser = (Serializer)ContextHelper.getServiceFromContext(Serializer.class, (ServletContext)this.servletContext);
            ser.serialize(entityStream, (TripleCollection)EntityToRDF.toRDF(rep), mediaTypeString);
        }
    }

    static {
        HashSet<String> types = new HashSet<String>();
        types.add("application/json");
        types.add("application/ld+json");
        types.add("text/rdf+n3");
        types.add("text/rdf+nt");
        types.add("application/rdf+json");
        types.add("application/rdf+xml");
        types.add("text/turtle");
        types.add("application/x-turtle");
        supportedMediaTypes = Collections.unmodifiableSet(types);
    }
}

