/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.entityhub.jersey.writers;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.clerezza.rdf.core.MGraph;
import org.apache.clerezza.rdf.core.NonLiteral;
import org.apache.clerezza.rdf.core.Resource;
import org.apache.clerezza.rdf.core.TripleCollection;
import org.apache.clerezza.rdf.core.impl.TripleImpl;
import org.apache.clerezza.rdf.core.serializedform.Serializer;
import org.apache.commons.io.IOUtils;
import org.apache.stanbol.commons.namespaceprefix.NamespacePrefixService;
import org.apache.stanbol.commons.web.base.ContextHelper;
import org.apache.stanbol.entityhub.jersey.writers.FieldQueryToJSON;
import org.apache.stanbol.entityhub.jersey.writers.QueryResultsToJSON;
import org.apache.stanbol.entityhub.jersey.writers.QueryResultsToRDF;
import org.apache.stanbol.entityhub.servicesapi.query.FieldQuery;
import org.apache.stanbol.entityhub.servicesapi.query.QueryResultList;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class QueryResultListWriter
implements MessageBodyWriter<QueryResultList<?>> {
    protected static final Set<String> produces;
    public static final String DEFAULT_ENCODING = "UTF-8";
    private final Logger log = LoggerFactory.getLogger(QueryResultListWriter.class);
    @Context
    protected ServletContext servletContext;

    protected Serializer getSerializer() {
        return (Serializer)ContextHelper.getServiceFromContext(Serializer.class, (ServletContext)this.servletContext);
    }

    private NamespacePrefixService getNsPrefixService() {
        return (NamespacePrefixService)ContextHelper.getServiceFromContext(NamespacePrefixService.class, (ServletContext)this.servletContext);
    }

    public long getSize(QueryResultList<?> result, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        String mediaTypeString = mediaType.getType() + '/' + mediaType.getSubtype();
        return QueryResultList.class.isAssignableFrom(type) && produces.contains(mediaTypeString);
    }

    public void writeTo(QueryResultList<?> resultList, Class<?> doNotUse, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        String mediaTypeString = mediaType.getType() + '/' + mediaType.getSubtype();
        String encoding = (String)mediaType.getParameters().get("charset");
        if (encoding == null) {
            encoding = DEFAULT_ENCODING;
        }
        if ("application/json".equals(mediaTypeString)) {
            try {
                IOUtils.write((String)QueryResultsToJSON.toJSON(resultList, this.getNsPrefixService()).toString(4), (OutputStream)entityStream, (String)encoding);
            }
            catch (JSONException e) {
                throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
            }
        } else {
            MGraph resultGraph = QueryResultsToRDF.toRDF(resultList);
            this.addFieldQuery(resultList.getQuery(), resultGraph, this.getNsPrefixService());
            this.getSerializer().serialize(entityStream, (TripleCollection)resultGraph, mediaTypeString);
        }
    }

    private void addFieldQuery(FieldQuery query, MGraph resultGraph, NamespacePrefixService nsPrefixService) {
        if (query == null) {
            return;
        }
        try {
            JSONObject fieldQueryJson = FieldQueryToJSON.toJSON(query, nsPrefixService);
            if (fieldQueryJson != null) {
                resultGraph.add((Object)new TripleImpl((NonLiteral)QueryResultsToRDF.QUERY_RESULT_LIST, QueryResultsToRDF.FIELD_QUERY, (Resource)QueryResultsToRDF.literalFactory.createTypedLiteral((Object)fieldQueryJson.toString())));
            }
        }
        catch (JSONException e) {
            this.log.warn(String.format("Unable to serialize Fieldquery %s to JSON", query), (Throwable)e);
        }
    }

    static {
        HashSet<String> p = new HashSet<String>();
        p.add("application/json");
        p.add("application/ld+json");
        p.add("text/rdf+n3");
        p.add("text/rdf+nt");
        p.add("application/rdf+xml");
        p.add("text/turtle");
        p.add("application/x-turtle");
        p.add("application/rdf+json");
        produces = Collections.unmodifiableSet(p);
    }
}

