/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.entityhub.jersey.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.ParseException;
import javax.mail.util.ByteArrayDataSource;
import javax.ws.rs.core.MediaType;
import org.apache.stanbol.entityhub.jersey.utils.JerseyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessageBodyReaderUtils {
    private static final Logger log = LoggerFactory.getLogger(MessageBodyReaderUtils.class);

    private MessageBodyReaderUtils() {
    }

    public static RequestData formForm(InputStream formData, String charset, String encodingParam, List<String> contentParams) throws IOException, UnsupportedEncodingException, IllegalArgumentException {
        MediaType mediaType;
        Map<String, String> params = JerseyUtils.parseForm(formData, charset);
        log.debug("Read from Form:");
        if (encodingParam != null) {
            String mediaTypeString = params.get(encodingParam);
            log.debug("  > encoding: {}={}", (Object)encodingParam, (Object)mediaTypeString);
            if (mediaTypeString != null) {
                try {
                    mediaType = MediaType.valueOf((String)mediaTypeString);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalStateException(String.format("Illegal formatted Content-Type %s parsed by parameter %s", encodingParam, mediaTypeString), e);
                }
            } else {
                mediaType = null;
            }
        } else {
            log.debug("  > encoding: no encoding prameter set");
            mediaType = null;
        }
        log.debug("      <- mediaType = {}", mediaType);
        ByteArrayInputStream entityStream = null;
        String contentParam = null;
        Iterator<String> contentParamIterator = contentParams.iterator();
        while (entityStream == null && contentParamIterator.hasNext()) {
            contentParam = contentParamIterator.next();
            String content = params.get(contentParam);
            log.debug("  > content: {}={}", (Object)contentParam, (Object)content);
            if (content == null) continue;
            entityStream = new ByteArrayInputStream(content.getBytes(charset));
        }
        if (entityStream == null) {
            throw new IllegalArgumentException(String.format("No content found for any of the following parameters %s", contentParams));
        }
        return new RequestData(mediaType, contentParam, entityStream);
    }

    public static List<RequestData> fromMultipart(InputStream mimeData, MediaType mediaType) throws IOException, IllegalArgumentException {
        ByteArrayDataSource ds = new ByteArrayDataSource(mimeData, mediaType.toString());
        ArrayList<RequestData> contents = new ArrayList<RequestData>();
        try {
            MimeMultipart data = new MimeMultipart((DataSource)ds);
            for (int i = 0; i < data.getCount(); ++i) {
                MediaType mt;
                BodyPart bp = data.getBodyPart(i);
                String fileName = bp.getFileName();
                try {
                    mt = bp.getContentType() != null ? MediaType.valueOf((String)bp.getContentType()) : null;
                }
                catch (IllegalArgumentException e) {
                    log.warn(String.format("Unable to parse MediaType form Mime Bodypart %s:  fileName %s | Disposition %s | Description %s", i + 1, fileName, bp.getDisposition(), bp.getDescription()), (Throwable)e);
                    mt = null;
                }
                InputStream stream = bp.getInputStream();
                if (stream == null) {
                    throw new IllegalArgumentException(String.format("Unable to get InputStream for Mime Bodypart %s: mediaType %s fileName %s | Disposition %s | Description %s", i + 1, fileName, bp.getDisposition(), bp.getDescription()));
                }
                contents.add(new RequestData(mt, bp.getFileName(), stream));
            }
        }
        catch (ParseException e) {
            throw new IllegalStateException(String.format("Unable to parse data from %s request", MediaType.MULTIPART_FORM_DATA_TYPE), e);
        }
        catch (MessagingException e) {
            throw new IOException("Exception while reading " + MediaType.MULTIPART_FORM_DATA_TYPE + " request", e);
        }
        return contents;
    }

    public static class RequestData {
        private final MediaType mediaType;
        private final InputStream entityStream;
        private final String contentName;

        public RequestData(MediaType mediaType, String contentName, InputStream entityStream) {
            if (entityStream == null) {
                throw new IllegalArgumentException("The parsed Inputstream MUST NOT be NULL!");
            }
            this.mediaType = mediaType;
            this.entityStream = entityStream;
            this.contentName = contentName;
        }

        public MediaType getMediaType() {
            return this.mediaType;
        }

        public InputStream getEntityStream() {
            return this.entityStream;
        }

        public String getName() {
            return this.contentName;
        }
    }
}

