/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.entityhub.jersey.utils;

import at.newmedialab.ldpath.api.backend.RDFBackend;
import at.newmedialab.ldpath.api.selectors.NodeSelector;
import at.newmedialab.ldpath.api.transformers.NodeTransformer;
import at.newmedialab.ldpath.exception.LDPathParseException;
import at.newmedialab.ldpath.model.fields.FieldMapping;
import at.newmedialab.ldpath.model.programs.Program;
import at.newmedialab.ldpath.model.selectors.PropertySelector;
import at.newmedialab.ldpath.model.transformers.DoubleTransformer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.clerezza.rdf.core.MGraph;
import org.apache.stanbol.commons.indexedgraph.IndexedMGraph;
import org.apache.stanbol.commons.viewable.Viewable;
import org.apache.stanbol.commons.web.base.CorsHelper;
import org.apache.stanbol.commons.web.base.resource.BaseStanbolResource;
import org.apache.stanbol.commons.web.base.utils.MediaTypeUtil;
import org.apache.stanbol.entityhub.core.model.InMemoryValueFactory;
import org.apache.stanbol.entityhub.jersey.utils.JerseyUtils;
import org.apache.stanbol.entityhub.ldpath.EntityhubLDPath;
import org.apache.stanbol.entityhub.ldpath.LDPathUtils;
import org.apache.stanbol.entityhub.ldpath.backend.AbstractBackend;
import org.apache.stanbol.entityhub.model.clerezza.RdfValueFactory;
import org.apache.stanbol.entityhub.servicesapi.model.Reference;
import org.apache.stanbol.entityhub.servicesapi.model.Representation;
import org.apache.stanbol.entityhub.servicesapi.model.ValueFactory;
import org.apache.stanbol.entityhub.servicesapi.model.rdf.RdfResourceEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDPathHelper {
    private static final Logger log = LoggerFactory.getLogger(LDPathHelper.class);
    public static final FieldMapping<Double, Object> RESULT_SCORE_MAPPING = new FieldMapping(RdfResourceEnum.resultScore.getUri(), "http://www.w3.org/2001/XMLSchema#double", (NodeSelector)new PropertySelector((Object)InMemoryValueFactory.getInstance().createReference((Object)RdfResourceEnum.resultScore.getUri())), (NodeTransformer)new DoubleTransformer(), null);

    private static MGraph executeLDPath(RDFBackend<Object> backend, String ldpath, Set<String> contexts) throws LDPathParseException {
        IndexedMGraph data = new IndexedMGraph();
        RdfValueFactory vf = new RdfValueFactory((MGraph)data);
        EntityhubLDPath ldPath = new EntityhubLDPath(backend, (ValueFactory)vf);
        Program program = ldPath.parseProgram(LDPathUtils.getReader((String)ldpath));
        if (log.isDebugEnabled()) {
            log.debug("Execute on Context(s) '{}' LDPath program: \n{}", contexts, (Object)program.getPathExpression(backend));
        }
        for (String context : contexts) {
            ldPath.execute((Reference)vf.createReference((Object)context), program);
        }
        return data;
    }

    public static Map<String, String> getLDPathParseExceptionMessage(LDPathParseException e) {
        LinkedHashMap<String, String> messages = new LinkedHashMap<String, String>();
        Throwable t = e;
        do {
            messages.put(t.getClass().getSimpleName(), t.getMessage());
        } while ((t = t.getCause()) != null);
        return messages;
    }

    public static Response handleLDPathRequest(BaseStanbolResource resource, RDFBackend<Object> backend, String ldpath, Set<String> contexts, HttpHeaders headers, ServletContext servletContext) {
        MGraph data;
        HashSet<String> supported = new HashSet<String>(JerseyUtils.ENTITY_SUPPORTED_MEDIA_TYPES);
        supported.add("text/html");
        MediaType acceptedMediaType = MediaTypeUtil.getAcceptableMediaType((HttpHeaders)headers, supported, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        boolean printDocu = false;
        contexts.remove(null);
        contexts.remove("");
        if (contexts == null || contexts.isEmpty()) {
            if (MediaType.TEXT_HTML_TYPE.isCompatible(acceptedMediaType)) {
                printDocu = true;
            } else {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"No context was provided by the Request. Missing parameter context.\n").header("Accept", (Object)acceptedMediaType).build();
            }
        }
        if (!printDocu & (ldpath == null || ldpath.isEmpty())) {
            if (MediaType.TEXT_HTML_TYPE.isCompatible(acceptedMediaType)) {
                printDocu = true;
            } else {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"No ldpath program was provided by the Request. Missing or empty parameter ldpath.\n").header("Accept", (Object)acceptedMediaType).build();
            }
        }
        if (printDocu) {
            Response.ResponseBuilder rb = Response.ok((Object)new Viewable("ldpath", (Object)resource));
            rb.header("Content-Type", (Object)"text/html; charset=utf-8");
            CorsHelper.addCORSOrigin((ServletContext)servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
            return rb.build();
        }
        if (acceptedMediaType.equals((Object)MediaType.TEXT_HTML_TYPE)) {
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).entity((Object)"The requested content type text/html is not supported.\n").header("Accept", (Object)acceptedMediaType).build();
        }
        try {
            data = LDPathHelper.executeLDPath(backend, ldpath, contexts);
        }
        catch (LDPathParseException e) {
            log.warn("Unable to parse LDPath program:\n" + ldpath, (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Unable to parse LDPath program (Messages: " + LDPathHelper.getLDPathParseExceptionMessage(e) + ")!\n")).header("Accept", (Object)acceptedMediaType).build();
        }
        Response.ResponseBuilder rb = Response.ok((Object)data);
        rb.header("Content-Type", (Object)(acceptedMediaType + "; charset=utf-8"));
        CorsHelper.addCORSOrigin((ServletContext)servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        return rb.build();
    }

    public static Collection<Representation> transformQueryResults(Iterator<Representation> resultIt, Program<Object> program, Set<String> selectedFields, EntityhubLDPath ldPath, AbstractBackend backend, ValueFactory vf) {
        LinkedHashSet<Representation> transformedResults = new LinkedHashSet<Representation>();
        while (resultIt.hasNext()) {
            Representation rep = resultIt.next();
            backend.addLocal(rep);
            Representation transformed = ldPath.execute(vf.createReference((Object)rep.getId()), program);
            for (String selected : selectedFields) {
                Iterator values = rep.get(selected);
                if (values == null) continue;
                while (values.hasNext()) {
                    transformed.add(selected, values.next());
                }
            }
            transformedResults.add(transformed);
        }
        return transformedResults;
    }

    public static Program<Object> prepareQueryLDPathProgram(String ldpathProgram, Set<String> selectedFields, AbstractBackend backend, EntityhubLDPath ldPath) throws LDPathParseException {
        Program program = ldPath.parseProgram(LDPathUtils.getReader((String)ldpathProgram));
        StringBuilder conflicting = null;
        String resultScoreProperty = RdfResourceEnum.resultScore.getUri();
        boolean foundRsultRankingField = false;
        for (FieldMapping ldPathField : program.getFields()) {
            String field = ldPathField.getFieldName();
            if (!foundRsultRankingField && resultScoreProperty.equals(field)) {
                foundRsultRankingField = true;
            }
            if (!selectedFields.remove(ldPathField.getFieldName())) continue;
            if (conflicting == null) {
                conflicting = new StringBuilder();
            }
            conflicting.append('\n').append("  > ").append(ldPathField.getPathExpression((RDFBackend)backend));
        }
        if (conflicting != null) {
            throw new IllegalStateException("Selected Fields conflict with Fields defined bythe LDPath program! Conflicts: " + conflicting.toString());
        }
        if (!foundRsultRankingField) {
            program.addMapping(RESULT_SCORE_MAPPING);
        }
        return program;
    }
}

