/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.entityhub.jersey.parsers;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.apache.commons.io.IOUtils;
import org.apache.stanbol.commons.namespaceprefix.NamespaceMappingUtils;
import org.apache.stanbol.commons.namespaceprefix.NamespacePrefixService;
import org.apache.stanbol.commons.web.base.ContextHelper;
import org.apache.stanbol.entityhub.core.mapping.ValueConverterFactory;
import org.apache.stanbol.entityhub.core.model.InMemoryValueFactory;
import org.apache.stanbol.entityhub.core.query.FieldQueryImpl;
import org.apache.stanbol.entityhub.ldpath.query.LDPathFieldQueryImpl;
import org.apache.stanbol.entityhub.servicesapi.model.ValueFactory;
import org.apache.stanbol.entityhub.servicesapi.query.Constraint;
import org.apache.stanbol.entityhub.servicesapi.query.FieldQuery;
import org.apache.stanbol.entityhub.servicesapi.query.RangeConstraint;
import org.apache.stanbol.entityhub.servicesapi.query.ReferenceConstraint;
import org.apache.stanbol.entityhub.servicesapi.query.SimilarityConstraint;
import org.apache.stanbol.entityhub.servicesapi.query.TextConstraint;
import org.apache.stanbol.entityhub.servicesapi.query.ValueConstraint;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class FieldQueryReader
implements MessageBodyReader<FieldQuery> {
    private static final Logger log = LoggerFactory.getLogger(FieldQueryReader.class);
    private static final ValueFactory valueFactory = InMemoryValueFactory.getInstance();
    private static final ValueConverterFactory converterFactory = ValueConverterFactory.getDefaultInstance();
    private ServletContext context;

    public FieldQueryReader(@Context ServletContext context) {
        this.context = context;
    }

    private NamespacePrefixService getNsPrefixService() {
        return (NamespacePrefixService)ContextHelper.getServiceFromContext(NamespacePrefixService.class, (ServletContext)this.context);
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        log.debug("isReadable type {}, mediaType {}", type, (Object)mediaType);
        return FieldQuery.class.isAssignableFrom(type);
    }

    public FieldQuery readFrom(Class<FieldQuery> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        String queryString = IOUtils.toString((InputStream)entityStream);
        log.debug("Parsed QueryString: \n{}", (Object)queryString);
        MediaType acceptedType = MediaType.valueOf((String)((String)httpHeaders.getFirst((Object)"Accept")));
        if (acceptedType.isWildcardType()) {
            acceptedType = MediaType.TEXT_PLAIN_TYPE;
        }
        try {
            return FieldQueryReader.fromJSON(queryString, acceptedType, this.getNsPrefixService());
        }
        catch (JSONException e) {
            log.error("Unable to parse Request ", (Throwable)e);
            StringBuilder message = new StringBuilder();
            message.append("Parsed FieldQuery is not valid JSON\n");
            message.append("Parsed String:\n");
            message.append(queryString);
            log.warn(message.toString());
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)message.toString()).header("Accept", (Object)acceptedType.toString()).build());
        }
    }

    public static FieldQuery fromJSON(String jsonQueryString, MediaType acceptedMediaType, NamespacePrefixService nsPrefixService) throws JSONException, WebApplicationException {
        FieldQueryImpl query;
        if (jsonQueryString == null) {
            throw new IllegalArgumentException("The parsed JSON object MUST NOT be NULL!");
        }
        JSONObject jQuery = new JSONObject(jsonQueryString);
        if (jQuery.has("ldpath")) {
            LDPathFieldQueryImpl ldPathQuery = new LDPathFieldQueryImpl();
            ldPathQuery.setLDPathSelect(jQuery.getString("ldpath"));
            query = ldPathQuery;
        } else {
            query = new FieldQueryImpl();
        }
        if (!jQuery.has("constraints")) {
            StringBuilder message = new StringBuilder();
            message.append("The parsed Field Query MUST contain at least a single 'constraints'\n");
            message.append("Parsed Query:\n");
            message.append(jQuery.toString(4));
            log.warn(message.toString());
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)message.toString()).header("Accept", (Object)acceptedMediaType.toString()).build());
        }
        JSONArray constraints = jQuery.getJSONArray("constraints");
        boolean parsingError = false;
        StringBuilder parsingErrorMessages = new StringBuilder();
        parsingErrorMessages.append("Constraint parsing Errors:\n");
        for (int i = 0; i < constraints.length(); ++i) {
            JSONObject jConstraint = constraints.getJSONObject(i);
            if (jConstraint.has("field")) {
                String field = jConstraint.getString("field");
                if (field == null || field.isEmpty()) {
                    parsingErrorMessages.append('\n');
                    parsingErrorMessages.append("Each Field Query Constraint MUST define a value for 'field'\n");
                    parsingErrorMessages.append("Parsed Constraint:\n");
                    parsingErrorMessages.append(jConstraint.toString(4));
                    parsingErrorMessages.append('\n');
                    parsingError = true;
                    continue;
                }
                String fieldUri = nsPrefixService.getFullName(field);
                if (fieldUri == null) {
                    parsingErrorMessages.append('\n');
                    parsingErrorMessages.append("The 'field' '").append(field).append("uses an unknown namespace prefix '");
                    parsingErrorMessages.append(NamespaceMappingUtils.getPrefix((String)field)).append("'\n");
                    parsingErrorMessages.append("Parsed Constraint:\n");
                    parsingErrorMessages.append(jConstraint.toString(4));
                    parsingErrorMessages.append('\n');
                    parsingError = true;
                    continue;
                }
                if (query.isConstrained(fieldUri)) {
                    parsingErrorMessages.append('\n');
                    parsingErrorMessages.append("The parsed Query defines multiple constraints fr the field '" + fieldUri + "'!\n");
                    parsingErrorMessages.append("FieldQuery allows only a single Constraint for a field\n");
                    parsingErrorMessages.append("Parsed Constraints:\n");
                    parsingErrorMessages.append(constraints.toString(4));
                    parsingErrorMessages.append('\n');
                    parsingError = true;
                    continue;
                }
                try {
                    query.setConstraint(fieldUri, FieldQueryReader.parseConstraint(jConstraint, nsPrefixService));
                }
                catch (IllegalArgumentException e) {
                    parsingErrorMessages.append('\n');
                    parsingErrorMessages.append(e.getMessage());
                    parsingErrorMessages.append('\n');
                    parsingError = true;
                }
                continue;
            }
            parsingErrorMessages.append('\n');
            parsingErrorMessages.append("Constraints MUST define a value for 'field'\n");
            parsingErrorMessages.append("Parsed Constraint:\n");
            parsingErrorMessages.append(jConstraint.toString(4));
            parsingErrorMessages.append('\n');
            parsingError = true;
        }
        if (parsingError) {
            String message = parsingErrorMessages.toString();
            log.warn(message);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)message).header("Accept", (Object)acceptedMediaType.toString()).build());
        }
        JSONArray selected = jQuery.optJSONArray("selected");
        if (selected != null) {
            for (int i = 0; i < selected.length(); ++i) {
                String selectedField = selected.getString(i);
                if ((selectedField = nsPrefixService.getFullName(selectedField)) == null || selectedField.isEmpty()) continue;
                query.addSelectedField(selectedField);
            }
        }
        if (jQuery.has("limit") && !jQuery.isNull("limit")) {
            try {
                query.setLimit(Integer.valueOf(jQuery.getInt("limit")));
            }
            catch (JSONException e) {
                parsingErrorMessages.append('\n');
                parsingErrorMessages.append("Property \"limit\" MUST BE a valid integer number!\n");
                parsingErrorMessages.append("Parsed Value:");
                parsingErrorMessages.append(jQuery.get("init"));
                parsingErrorMessages.append('\n');
                parsingError = true;
            }
        }
        if (jQuery.has("offset") && !jQuery.isNull("offset")) {
            try {
                query.setOffset(jQuery.getInt("offset"));
            }
            catch (JSONException e) {
                parsingErrorMessages.append('\n');
                parsingErrorMessages.append("Property \"offset\" MUST BE a valid integer number!\n");
                parsingErrorMessages.append("Parsed Value:");
                parsingErrorMessages.append(jQuery.get("init"));
                parsingErrorMessages.append('\n');
                parsingError = true;
            }
        }
        return query;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Constraint parseConstraint(JSONObject jConstraint, NamespacePrefixService nsPrefixService) throws JSONException {
        Constraint constraint;
        block7: {
            block8: {
                String type;
                block10: {
                    block9: {
                        if (!jConstraint.has("type") || jConstraint.isNull("type")) break block8;
                        type = jConstraint.getString("type");
                        if (!type.equals("reference")) break block9;
                        constraint = FieldQueryReader.parseReferenceConstraint(jConstraint, nsPrefixService);
                        break block7;
                    }
                    if (!type.equals(Constraint.ConstraintType.value.name())) break block10;
                    constraint = FieldQueryReader.parseValueConstraint(jConstraint, nsPrefixService);
                    break block7;
                }
                if (type.equals(Constraint.ConstraintType.text.name())) {
                    constraint = FieldQueryReader.parseTextConstraint(jConstraint);
                    break block7;
                } else if (type.equals(Constraint.ConstraintType.range.name())) {
                    constraint = FieldQueryReader.parseRangeConstraint(jConstraint, nsPrefixService);
                    break block7;
                } else {
                    if (!type.equals(Constraint.ConstraintType.similarity.name())) {
                        log.warn(String.format("Unknown Constraint Type %s. Supported values are %s", Arrays.asList("reference", Constraint.ConstraintType.values())));
                        StringBuilder message = new StringBuilder();
                        message.append("Parsed Constraint uses an unknown value for 'type'!\n");
                        message.append("Supported values: ");
                        message.append(Constraint.ConstraintType.values());
                        message.append('\n');
                        message.append("Parsed Constraint: \n");
                        message.append(jConstraint.toString(4));
                        throw new IllegalArgumentException(message.toString());
                    }
                    constraint = FieldQueryReader.parseSimilarityConstraint(jConstraint, nsPrefixService);
                }
                break block7;
            }
            log.warn(String.format("Earch Constraint MUST HAVE the \"type\" key set to one of the values %s", Arrays.asList("reference", Constraint.ConstraintType.values())));
            StringBuilder message = new StringBuilder();
            message.append("Parsed Constraint does not define a value for the field 'type'!\n");
            message.append("Supported values: ");
            message.append(Constraint.ConstraintType.values());
            message.append('\n');
            message.append("Parsed Constraint: \n");
            message.append(jConstraint.toString(4));
            throw new IllegalArgumentException(message.toString());
        }
        if (jConstraint.has("boost")) {
            double boost = jConstraint.optDouble("boost");
            if (boost == Double.NaN || boost <= 0.0) {
                StringBuilder message = new StringBuilder("The Boost of a Constraint MUST BE a double AND >= 0 (parsed: '");
                message.append(jConstraint.get("boost")).append("')!");
                log.warn(message.toString());
                throw new IllegalArgumentException(message.toString());
            }
            constraint.setBoost(Double.valueOf(boost));
        }
        return constraint;
    }

    private static Constraint parseSimilarityConstraint(JSONObject jConstraint, NamespacePrefixService nsPrefixService) throws JSONException {
        ArrayList<String> fields;
        String context = jConstraint.optString("context");
        if (context == null) {
            throw new IllegalArgumentException("SimilarityConstraints MUST define a \"context\": \n " + jConstraint.toString(4));
        }
        JSONArray addFields = jConstraint.optJSONArray("addFields");
        if (addFields != null && addFields.length() > 0) {
            fields = new ArrayList<String>(addFields.length());
            for (int i = 0; i < addFields.length(); ++i) {
                String field = addFields.optString(i);
                String string = field = field != null ? nsPrefixService.getFullName(field) : null;
                if (field == null || field.isEmpty()) continue;
                fields.add(field);
            }
        } else {
            fields = null;
        }
        return new SimilarityConstraint(context, fields);
    }

    private static Constraint parseRangeConstraint(JSONObject jConstraint, NamespacePrefixService nsPrefixService) throws JSONException {
        boolean inclusive;
        if (jConstraint.has("inclusive")) {
            inclusive = jConstraint.getBoolean("inclusive");
        } else {
            log.debug("RangeConstraint does not define the field 'inclusive'. Use false as default!");
            inclusive = false;
        }
        Object upperBound = jConstraint.opt("upperBound");
        Object lowerBound = jConstraint.opt("lowerBound");
        Collection<String> datatypes = FieldQueryReader.parseDatatypeProperty(jConstraint, nsPrefixService);
        if (datatypes != null && !datatypes.isEmpty()) {
            Iterator<String> it = datatypes.iterator();
            String datatype = it.next();
            if (datatypes.size() > 1) {
                log.warn("Multiple datatypes are not supported by RangeConstriants!");
                log.warn("  used: {}", (Object)datatype);
                while (it.hasNext()) {
                    log.warn("  ignored: {}", (Object)it.next());
                }
            }
            StringBuilder convertingError = null;
            if (upperBound != null) {
                Object convertedUpperBound = converterFactory.convert(upperBound, datatype, valueFactory);
                if (convertedUpperBound == null) {
                    log.warn("Unable to convert upper bound {} to data type {}", upperBound, (Object)datatype);
                    convertingError = new StringBuilder();
                    convertingError.append("Unable to convert the parsed upper bound value ").append(upperBound).append(" to data type ").append(datatype);
                } else {
                    upperBound = convertedUpperBound;
                }
            }
            if (lowerBound != null) {
                Object convertedLowerBound = converterFactory.convert(lowerBound, datatype, valueFactory);
                if (convertedLowerBound == null) {
                    log.warn("Unable to convert lower bound {} to data type {}", lowerBound, (Object)datatype);
                    if (convertingError == null) {
                        convertingError = new StringBuilder();
                    } else {
                        convertingError.append('\n');
                    }
                    convertingError.append("Unable to convert the parsed value ").append(lowerBound).append(" to data type ").append(datatype);
                } else {
                    lowerBound = convertedLowerBound;
                }
            }
            if (convertingError != null) {
                convertingError.append("Parsed Constraint: \n");
                convertingError.append(jConstraint.toString(4));
                throw new IllegalArgumentException(convertingError.toString());
            }
        }
        if (upperBound == null && lowerBound == null) {
            log.warn("Range Constraint does not define an 'upperBound' nor an 'lowerBound'! At least one of the two MUST BE parsed for a valid RangeConstraint.");
            StringBuilder message = new StringBuilder();
            message.append("Range Constraint does not define an 'upperBound' nor an 'lowerBound'!");
            message.append(" At least one of the two MUST BE parsed for a valid RangeConstraint.\n");
            message.append("Parsed Constraint: \n");
            message.append(jConstraint.toString(4));
            throw new IllegalArgumentException(message.toString());
        }
        RangeConstraint constraint = new RangeConstraint(lowerBound, upperBound, inclusive);
        return constraint;
    }

    private static Constraint parseTextConstraint(JSONObject jConstraint) throws JSONException {
        TextConstraint constraint;
        List<Object> languages;
        TextConstraint.PatternType patternType;
        boolean caseSensitive = jConstraint.optBoolean("caseSensitive", false);
        String jPatternType = jConstraint.optString("patternType", null);
        if (jPatternType == null) {
            patternType = TextConstraint.PatternType.none;
        } else {
            try {
                patternType = TextConstraint.PatternType.valueOf((String)jPatternType);
            }
            catch (IllegalArgumentException e) {
                log.warn("Encountered unknown patternType for TextConstraint!", (Throwable)e);
                TextConstraint.PatternType patternType2 = TextConstraint.PatternType.none;
                StringBuilder message = new StringBuilder();
                message.append("Illegal value for field 'patternType'.\n");
                message.append("Supported values are: ");
                message.append(Arrays.toString(TextConstraint.PatternType.values()));
                message.append('\n');
                message.append("Parsed Constraint: \n");
                message.append(jConstraint.toString(4));
                throw new IllegalArgumentException(message.toString());
            }
        }
        String languageKey = null;
        if (jConstraint.has("language")) {
            languageKey = "language";
        } else if (jConstraint.has("languages")) {
            log.warn("The key \"languages\" is deprecated. Use \"language\" instead.");
            languageKey = "languages";
        }
        if (languageKey != null) {
            JSONArray jLanguages = jConstraint.optJSONArray(languageKey);
            if (jLanguages != null && jLanguages.length() > 0) {
                languages = new ArrayList(jLanguages.length());
                for (int i = 0; i < jLanguages.length(); ++i) {
                    String lang = jLanguages.getString(i);
                    if (lang != null && !lang.isEmpty()) {
                        languages.add(lang);
                        continue;
                    }
                    if (languages.contains(null)) continue;
                    languages.add(null);
                }
                if (languages.isEmpty()) {
                    languages = null;
                }
            } else {
                String language = jConstraint.getString(languageKey);
                languages = language.isEmpty() ? null : Collections.singletonList(language);
            }
        } else {
            languages = null;
        }
        if (jConstraint.has("text") && !jConstraint.isNull("text")) {
            List<Object> textConstraints;
            JSONArray jTextConstraints = jConstraint.optJSONArray("text");
            if (jTextConstraints != null) {
                textConstraints = new ArrayList(jTextConstraints.length());
                for (int i = 0; i < jTextConstraints.length(); ++i) {
                    String text = jTextConstraints.getString(i);
                    if (text == null || text.isEmpty()) continue;
                    textConstraints.add(jTextConstraints.getString(i));
                }
            } else {
                String text = jConstraint.getString("text");
                textConstraints = text == null || text.isEmpty() ? Collections.emptyList() : Collections.singletonList(text);
            }
            if (textConstraints.isEmpty()) {
                StringBuilder message = new StringBuilder();
                message.append("Parsed TextConstraint doese not define a valid (none empty) value for the 'text' property !\n");
                message.append("Parsed Constraint: \n");
                message.append(jConstraint.toString(4));
                throw new IllegalArgumentException(message.toString());
            }
            constraint = new TextConstraint(textConstraints, patternType, caseSensitive, languages == null ? null : languages.toArray(new String[languages.size()]));
            if (jConstraint.has("proximityRanking")) {
                constraint.setProximityRanking(jConstraint.optBoolean("proximityRanking", false));
            }
        } else {
            StringBuilder message = new StringBuilder();
            message.append("Parsed TextConstraint doese not define the required field 'text'!\n");
            message.append("Parsed Constraint: \n");
            message.append(jConstraint.toString(4));
            throw new IllegalArgumentException(message.toString());
        }
        return constraint;
    }

    private static Constraint parseValueConstraint(JSONObject jConstraint, NamespacePrefixService nsPrefixService) throws JSONException {
        List<Object> valueList;
        Collection<String> dataTypes = FieldQueryReader.parseDatatypeProperty(jConstraint, nsPrefixService);
        if (jConstraint.has("value") && !jConstraint.isNull("value")) {
            Object value = jConstraint.get("value");
            if (value instanceof JSONArray) {
                valueList = new ArrayList(((JSONArray)value).length());
                for (int i = 0; i < ((JSONArray)value).length(); ++i) {
                    Object v = ((JSONArray)value).get(i);
                    if (v == null || v instanceof JSONArray || v instanceof JSONObject) {
                        log.warn("Parsed ValueConstraint does define illegal values (values={})!", value);
                        StringBuilder message = new StringBuilder();
                        message.append("Parsed ValueConstraint does define illegal values for field 'value'(value MUST NOT contain NULL, JSONObject nor JSONArray values)!\n");
                        message.append("Parsed Constraint: \n");
                        message.append(jConstraint.toString(4));
                        throw new IllegalArgumentException(message.toString());
                    }
                    valueList.add(v);
                }
            } else {
                if (value instanceof JSONObject) {
                    log.warn("Parsed ValueConstraint does define illegal values (values={})!", value);
                    StringBuilder message = new StringBuilder();
                    message.append("Parsed ValueConstraint does define illegal value for field 'value'(value MUST NOT be an JSON object. Only values and JSONArray to parsemultiple values are allowed)!\n");
                    message.append("Parsed Constraint: \n");
                    message.append(jConstraint.toString(4));
                    throw new IllegalArgumentException(message.toString());
                }
                valueList = Collections.singletonList(jConstraint.get("value"));
            }
        } else {
            log.warn("Parsed ValueConstraint does not define the required field \"value\"!");
            StringBuilder message = new StringBuilder();
            message.append("Parsed ValueConstraint does not define the required field 'value'!\n");
            message.append("Parsed Constraint: \n");
            message.append(jConstraint.toString(4));
            throw new IllegalArgumentException(message.toString());
        }
        ValueConstraint.MODE mode = FieldQueryReader.parseConstraintValueMode(jConstraint);
        return new ValueConstraint(valueList, dataTypes, mode);
    }

    private static ValueConstraint.MODE parseConstraintValueMode(JSONObject jConstraint) throws JSONException {
        ValueConstraint.MODE mode;
        if (jConstraint.has("mode")) {
            String jmode = jConstraint.getString("mode");
            try {
                mode = ValueConstraint.MODE.valueOf((String)jmode);
            }
            catch (IllegalArgumentException e) {
                String message = String.format("Parsed ValueConstraint defines an unknown MODE %s (supported: %s)!", jmode, Arrays.asList(ValueConstraint.MODE.values()));
                log.warn(message, (Throwable)e);
                StringBuilder errorMessage = new StringBuilder();
                errorMessage.append(message).append('\n');
                errorMessage.append("Parsed Constraint: \n");
                errorMessage.append(jConstraint.toString(4));
                throw new IllegalArgumentException(message.toString(), e);
            }
        } else {
            mode = null;
        }
        return mode;
    }

    private static Collection<String> parseDatatypeProperty(JSONObject jConstraint, NamespacePrefixService nsPrefixService) throws JSONException {
        Collection<Object> dataTypes;
        String dataTypeKey = null;
        if (jConstraint.has("datatype")) {
            dataTypeKey = "datatype";
        } else if (jConstraint.has("dataTypes")) {
            log.warn("The use of \"dataTypes\" is deprecated. Please use \"dataType\" instead");
            dataTypeKey = "dataTypes";
        }
        if (dataTypeKey != null) {
            JSONArray jDataTypes = jConstraint.optJSONArray(dataTypeKey);
            if (jDataTypes != null && jDataTypes.length() > 0) {
                dataTypes = new ArrayList(jDataTypes.length());
                for (int i = 0; i < jDataTypes.length(); ++i) {
                    String dataType = jDataTypes.getString(i);
                    String string = dataType = dataType != null ? nsPrefixService.getFullName(dataType) : null;
                    if (dataType == null || dataType.isEmpty()) continue;
                    dataTypes.add(dataType);
                }
                if (dataTypes.isEmpty()) {
                    dataTypes = null;
                }
            } else {
                String dataType = jConstraint.getString(dataTypeKey);
                String string = dataType = dataType != null ? nsPrefixService.getFullName(dataType) : null;
                dataTypes = dataType != null && !dataType.isEmpty() ? Collections.singleton(dataType) : null;
            }
        } else {
            dataTypes = null;
        }
        return dataTypes;
    }

    private static Constraint parseReferenceConstraint(JSONObject jConstraint, NamespacePrefixService nsPrefixService) throws JSONException {
        if (jConstraint.has("value") && !jConstraint.isNull("value")) {
            List<Object> refList;
            Object value = jConstraint.get("value");
            if (value instanceof JSONArray) {
                refList = new ArrayList(((JSONArray)value).length());
                for (int i = 0; i < ((JSONArray)value).length(); ++i) {
                    String field = ((JSONArray)value).getString(i);
                    String string = field = field != null ? nsPrefixService.getFullName(field) : null;
                    if (field == null || field.isEmpty()) continue;
                    refList.add(field);
                }
            } else {
                if (value instanceof JSONObject) {
                    log.warn("Parsed ValueConstraint does define illegal values (values={})!", value);
                    StringBuilder message = new StringBuilder();
                    message.append("Parsed ValueConstraint does define illegal value for field 'value'(value MUST NOT be an JSON object. Only values and JSONArray to parsemultiple values are allowed)!\n");
                    message.append("Parsed Constraint: \n");
                    message.append(jConstraint.toString(4));
                    throw new IllegalArgumentException(message.toString());
                }
                String field = jConstraint.getString("value");
                field = field != null ? nsPrefixService.getFullName(field) : null;
                refList = field != null ? Collections.singletonList(field) : Collections.emptyList();
            }
            if (refList.isEmpty()) {
                log.warn("Parsed ReferenceConstraint does not define a single valid \"value\"!");
                StringBuilder message = new StringBuilder();
                message.append("Parsed ReferenceConstraint does not define a single valid 'value'!\n");
                message.append("This means values where only null, empty string or '{prefix}:{localname}' values with unknown {prefix}\n");
                message.append("Parsed Constraint: \n");
                message.append(jConstraint.toString(4));
                throw new IllegalArgumentException(message.toString());
            }
            ValueConstraint.MODE mode = FieldQueryReader.parseConstraintValueMode(jConstraint);
            return new ReferenceConstraint(refList, mode);
        }
        log.warn("Parsed ReferenceConstraint does not define the required field \"value\"!");
        StringBuilder message = new StringBuilder();
        message.append("Parsed ReferenceConstraint does not define the required field 'value'!\n");
        message.append("Parsed Constraint: \n");
        message.append(jConstraint.toString(4));
        throw new IllegalArgumentException(message.toString());
    }
}

