/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.entityhub.jersey.writers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.apache.stanbol.commons.namespaceprefix.NamespacePrefixService;
import org.apache.stanbol.entityhub.ldpath.query.LDPathSelect;
import org.apache.stanbol.entityhub.servicesapi.defaults.DataTypeEnum;
import org.apache.stanbol.entityhub.servicesapi.query.Constraint;
import org.apache.stanbol.entityhub.servicesapi.query.FieldQuery;
import org.apache.stanbol.entityhub.servicesapi.query.RangeConstraint;
import org.apache.stanbol.entityhub.servicesapi.query.ReferenceConstraint;
import org.apache.stanbol.entityhub.servicesapi.query.SimilarityConstraint;
import org.apache.stanbol.entityhub.servicesapi.query.TextConstraint;
import org.apache.stanbol.entityhub.servicesapi.query.ValueConstraint;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FieldQueryToJSON {
    private static Logger log = LoggerFactory.getLogger(FieldQueryToJSON.class);

    private FieldQueryToJSON() {
    }

    static JSONObject toJSON(FieldQuery query, NamespacePrefixService nsPrefixService) throws JSONException {
        JSONObject jQuery = new JSONObject();
        jQuery.put("selected", (Object)new JSONArray((Collection)query.getSelectedFields()));
        JSONArray constraints = new JSONArray();
        jQuery.put("constraints", (Object)constraints);
        for (Map.Entry fieldConstraint : query) {
            JSONObject jFieldConstraint = FieldQueryToJSON.convertConstraintToJSON((Constraint)fieldConstraint.getValue(), nsPrefixService);
            jFieldConstraint.put("field", fieldConstraint.getKey());
            constraints.put((Object)jFieldConstraint);
        }
        if (query.getLimit() != null) {
            jQuery.put("limit", (Object)query.getLimit());
        }
        jQuery.put("offset", query.getOffset());
        if (query instanceof LDPathSelect && ((LDPathSelect)query).getLDPathSelect() != null && !((LDPathSelect)query).getLDPathSelect().isEmpty()) {
            jQuery.put("ldpath", (Object)((LDPathSelect)query).getLDPathSelect());
        }
        return jQuery;
    }

    private static JSONObject convertConstraintToJSON(Constraint constraint, NamespacePrefixService nsPrefixService) throws JSONException {
        JSONObject jConstraint = new JSONObject();
        jConstraint.put("type", (Object)constraint.getType().name());
        switch (constraint.getType()) {
            case value: {
                ValueConstraint valueConstraint = (ValueConstraint)constraint;
                if (valueConstraint.getValues() != null) {
                    if (valueConstraint.getValues().size() == 1) {
                        jConstraint.put("value", valueConstraint.getValues().iterator().next());
                    } else {
                        jConstraint.put("value", (Object)new JSONArray((Collection)valueConstraint.getValues()));
                    }
                }
                if (constraint instanceof ReferenceConstraint) {
                    jConstraint.put("type", (Object)"reference");
                } else {
                    jConstraint.put("type", (Object)constraint.getType().name());
                    Collection dataTypes = valueConstraint.getDataTypes();
                    if (dataTypes != null && !dataTypes.isEmpty()) {
                        if (dataTypes.size() == 1) {
                            String dataType = (String)dataTypes.iterator().next();
                            jConstraint.put("datatype", (Object)(nsPrefixService != null ? nsPrefixService.getShortName(dataType) : dataType));
                        } else {
                            ArrayList<String> dataTypeValues = new ArrayList<String>(dataTypes.size());
                            for (String dataType : dataTypes) {
                                dataTypeValues.add(nsPrefixService != null ? nsPrefixService.getShortName(dataType) : dataType);
                            }
                            jConstraint.put("datatype", dataTypeValues);
                        }
                    }
                }
                if (valueConstraint.getMode() == null) break;
                jConstraint.put("mode", (Object)valueConstraint.getMode());
                break;
            }
            case text: {
                TextConstraint textConstraint = (TextConstraint)constraint;
                Set languages = textConstraint.getLanguages();
                if (languages != null && !languages.isEmpty()) {
                    if (languages.size() == 1) {
                        jConstraint.put("language", languages.iterator().next());
                    } else {
                        jConstraint.put("language", (Object)new JSONArray((Collection)languages));
                    }
                }
                jConstraint.put("patternType", (Object)textConstraint.getPatternType().name());
                if (textConstraint.getTexts() != null && !textConstraint.getTexts().isEmpty()) {
                    if (textConstraint.getTexts().size() == 1) {
                        jConstraint.put("text", textConstraint.getTexts().get(0));
                    } else {
                        jConstraint.put("text", (Collection)textConstraint.getTexts());
                    }
                }
                if (!textConstraint.isCaseSensitive()) break;
                jConstraint.put("caseSensitive", true);
                break;
            }
            case range: {
                RangeConstraint rangeConstraint = (RangeConstraint)constraint;
                EnumSet<DataTypeEnum> dataTypes = EnumSet.noneOf(DataTypeEnum.class);
                if (rangeConstraint.getLowerBound() != null) {
                    jConstraint.put("lowerBound", rangeConstraint.getLowerBound());
                    dataTypes.addAll(DataTypeEnum.getPrimaryDataTypes(rangeConstraint.getLowerBound().getClass()));
                }
                if (rangeConstraint.getUpperBound() != null) {
                    jConstraint.put("upperBound", rangeConstraint.getUpperBound());
                    dataTypes.addAll(DataTypeEnum.getPrimaryDataTypes(rangeConstraint.getUpperBound().getClass()));
                }
                jConstraint.put("inclusive", rangeConstraint.isInclusive());
                if (dataTypes.isEmpty()) break;
                jConstraint.put("datatype", (Object)((DataTypeEnum)dataTypes.iterator().next()).getShortName());
                break;
            }
            case similarity: {
                SimilarityConstraint simConstraint = (SimilarityConstraint)constraint;
                jConstraint.put("context", (Object)simConstraint.getContext());
                if (simConstraint.getAdditionalFields().isEmpty()) break;
                jConstraint.put("addFields", (Object)new JSONArray((Collection)simConstraint.getAdditionalFields()));
                break;
            }
            default: {
                log.warn("Unsupported Constriant Type " + constraint.getType() + " (implementing class=" + constraint.getClass() + "| toString=" + constraint + ") -> skiped");
            }
        }
        return jConstraint;
    }
}

