/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.entityhub.jersey.writers;

import java.util.Collection;
import org.apache.clerezza.rdf.core.LiteralFactory;
import org.apache.clerezza.rdf.core.MGraph;
import org.apache.clerezza.rdf.core.NonLiteral;
import org.apache.clerezza.rdf.core.Resource;
import org.apache.clerezza.rdf.core.TripleCollection;
import org.apache.clerezza.rdf.core.TypedLiteral;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.impl.TripleImpl;
import org.apache.clerezza.rdf.ontologies.FOAF;
import org.apache.clerezza.rdf.ontologies.RDF;
import org.apache.stanbol.commons.indexedgraph.IndexedMGraph;
import org.apache.stanbol.entityhub.model.clerezza.RdfValueFactory;
import org.apache.stanbol.entityhub.servicesapi.model.Entity;
import org.apache.stanbol.entityhub.servicesapi.model.Representation;
import org.apache.stanbol.entityhub.servicesapi.model.rdf.RdfResourceEnum;

final class EntityToRDF {
    private static final UriRef FOAF_DOCUMENT = FOAF.Document;
    private static final UriRef FOAF_PRIMARY_TOPIC = FOAF.primaryTopic;
    private static final UriRef FOAF_PRIMARY_TOPIC_OF = FOAF.isPrimaryTopicOf;
    private static final UriRef signSite = new UriRef(RdfResourceEnum.site.getUri());
    private static final RdfValueFactory valueFactory = RdfValueFactory.getInstance();
    static final LiteralFactory literalFactory = LiteralFactory.getInstance();

    private EntityToRDF() {
    }

    static MGraph toRDF(Representation representation) {
        IndexedMGraph graph = new IndexedMGraph();
        EntityToRDF.addRDFTo((MGraph)graph, representation);
        return graph;
    }

    static void addRDFTo(MGraph graph, Representation representation) {
        graph.addAll((Collection)valueFactory.toRdfRepresentation(representation).getRdfGraph());
    }

    static TripleCollection toRDF(Entity entity) {
        IndexedMGraph graph = new IndexedMGraph();
        EntityToRDF.addRDFTo((MGraph)graph, entity);
        return graph;
    }

    static void addRDFTo(MGraph graph, Entity entity) {
        EntityToRDF.addRDFTo(graph, entity.getRepresentation());
        EntityToRDF.addRDFTo(graph, entity.getMetadata());
        EntityToRDF.addEntityTriplesToGraph(graph, entity);
    }

    static void addEntityTriplesToGraph(MGraph graph, Entity sign) {
        UriRef id = new UriRef(sign.getId());
        UriRef metaId = new UriRef(sign.getMetadata().getId());
        graph.add((Object)new TripleImpl((NonLiteral)id, FOAF_PRIMARY_TOPIC_OF, (Resource)metaId));
        graph.add((Object)new TripleImpl((NonLiteral)metaId, FOAF_PRIMARY_TOPIC, (Resource)metaId));
        graph.add((Object)new TripleImpl((NonLiteral)metaId, RDF.type, (Resource)FOAF_DOCUMENT));
        TypedLiteral siteName = literalFactory.createTypedLiteral((Object)sign.getSite());
        graph.add((Object)new TripleImpl((NonLiteral)metaId, signSite, (Resource)siteName));
    }
}

