/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.entityhub.jersey.utils;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.net.URLDecoder;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.stanbol.entityhub.core.query.DefaultQueryFactory;
import org.apache.stanbol.entityhub.ldpath.query.LDPathFieldQueryImpl;
import org.apache.stanbol.entityhub.servicesapi.query.Constraint;
import org.apache.stanbol.entityhub.servicesapi.query.FieldQuery;
import org.apache.stanbol.entityhub.servicesapi.query.FieldQueryFactory;
import org.apache.stanbol.entityhub.servicesapi.query.TextConstraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JerseyUtils {
    private static Logger log = LoggerFactory.getLogger(JerseyUtils.class);
    public static final Set<String> REPRESENTATION_SUPPORTED_MEDIA_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("application/json", "application/rdf+xml", "text/rdf+n3", "text/turtle", "application/x-turtle", "application/rdf+json", "text/rdf+nt")));
    public static final Set<String> ENTITY_SUPPORTED_MEDIA_TYPES = REPRESENTATION_SUPPORTED_MEDIA_TYPES;
    public static final Set<String> QUERY_RESULT_SUPPORTED_MEDIA_TYPES = REPRESENTATION_SUPPORTED_MEDIA_TYPES;
    private static FieldQueryFactory queryFactory = DefaultQueryFactory.getInstance();

    private JerseyUtils() {
    }

    public static FieldQuery createFieldQueryForFindRequest(String name, String field, String language, Integer limit, Integer offset, String ldpath) throws WebApplicationException, IllegalArgumentException {
        FieldQuery query;
        if (name == null || name.trim().isEmpty()) {
            throw new WebApplicationException((Throwable)new IllegalArgumentException("The parsed \"name\" pattern to search entities for MUST NOT be NULL nor EMPTY"), Response.Status.BAD_REQUEST);
        }
        name = name.trim();
        if (field == null || field.trim().isEmpty()) {
            new IllegalArgumentException("The parsed search \"field\" MUST NOT be NULL nor EMPTY");
        } else {
            field = field.trim();
        }
        log.debug("Process Find Request:");
        log.debug("  > name  : " + name);
        log.debug("  > field  : " + field);
        log.debug("  > lang  : " + language);
        log.debug("  > limit : " + limit);
        log.debug("  > offset: " + offset);
        log.debug("  > ldpath: " + ldpath);
        if (ldpath != null && !ldpath.isEmpty()) {
            query = new LDPathFieldQueryImpl();
            ((LDPathFieldQueryImpl)query).setLDPathSelect(ldpath);
        } else {
            query = queryFactory.createFieldQuery();
            ArrayList<String> selectedFields = new ArrayList<String>();
            selectedFields.add(field);
            query.addSelectedFields(selectedFields);
        }
        if (language == null || language.trim().isEmpty()) {
            query.setConstraint(field, (Constraint)new TextConstraint(name, TextConstraint.PatternType.wildcard, false, new String[0]));
        } else {
            query.setConstraint(field, (Constraint)new TextConstraint(name, TextConstraint.PatternType.wildcard, false, new String[]{language}));
        }
        if (limit != null && limit > 0) {
            query.setLimit(limit);
        }
        if (offset != null && offset > 0) {
            query.setOffset(offset.intValue());
        }
        return query;
    }

    public static boolean testType(Class<?> required, Type type) {
        boolean typeOK = false;
        if (type instanceof Class) {
            typeOK = required.isAssignableFrom((Class)type);
            type = ((Class)type).getGenericSuperclass();
        } else if (type instanceof WildcardType) {
            Type upperBound;
            Type lowerBound;
            WildcardType wildcardSetType = (WildcardType)type;
            typeOK = wildcardSetType.getLowerBounds().length > 0 ? (lowerBound = wildcardSetType.getLowerBounds()[0]) instanceof Class && required.isAssignableFrom((Class)lowerBound) : (wildcardSetType.getUpperBounds().length > 0 ? (upperBound = wildcardSetType.getUpperBounds()[0]) instanceof Class && ((Class)upperBound).isAssignableFrom(required) : true);
        } else if (required.isArray() && type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            typeOK = JerseyUtils.testType(required.getComponentType(), arrayType.getGenericComponentType());
        } else if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            typeOK = pType.getRawType() instanceof Class && required.isAssignableFrom((Class)pType.getRawType());
            type = null;
        } else {
            typeOK = false;
        }
        return typeOK;
    }

    public static boolean testParameterizedType(Class<?> rawType, Class<?>[] parameterTypes, Type type) {
        if (!JerseyUtils.testType(rawType, type)) {
            return false;
        }
        while (type != null) {
            Type[] parameters = null;
            if (type instanceof ParameterizedType && (parameters = ((ParameterizedType)type).getActualTypeArguments()).length == parameterTypes.length) {
                boolean compatible = true;
                for (int i = 0; compatible && i < parameters.length; ++i) {
                    compatible = JerseyUtils.testType(parameterTypes[i], parameters[i]);
                }
                if (compatible) {
                    return true;
                }
            }
            if (type instanceof Class) {
                type = ((Class)type).getGenericSuperclass();
                continue;
            }
            return false;
        }
        return false;
    }

    public static Map<String, String> parseForm(InputStream entityStream, String charset) throws IOException {
        String data;
        if (charset == null || charset.isEmpty()) {
            charset = "UTF-8";
        }
        try {
            data = IOUtils.toString((InputStream)entityStream, (String)charset);
        }
        catch (UnsupportedCharsetException e) {
            throw new IOException(e.getMessage(), e);
        }
        HashMap<String, String> form = new HashMap<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(data, "&");
        try {
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                int index = token.indexOf(61);
                if (index < 0) {
                    form.put(URLDecoder.decode(token, charset), null);
                    continue;
                }
                if (index <= 0) continue;
                form.put(URLDecoder.decode(token.substring(0, index), charset), URLDecoder.decode(token.substring(index + 1), charset));
            }
        }
        catch (UnsupportedCharsetException e) {
            throw new IOException(e.getMessage(), e);
        }
        return form;
    }
}

