/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.entityhub.jersey.resource.reconcile;

import javax.servlet.ServletContext;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import org.apache.stanbol.commons.web.base.ContextHelper;
import org.apache.stanbol.entityhub.core.query.DefaultQueryFactory;
import org.apache.stanbol.entityhub.jersey.resource.reconcile.BaseGoogleRefineReconcileResource;
import org.apache.stanbol.entityhub.servicesapi.model.Representation;
import org.apache.stanbol.entityhub.servicesapi.query.FieldQuery;
import org.apache.stanbol.entityhub.servicesapi.query.QueryResultList;
import org.apache.stanbol.entityhub.servicesapi.site.SiteException;
import org.apache.stanbol.entityhub.servicesapi.site.SiteManager;

@Path(value="/entityhub/sites/reconcile")
public class SiteManagerReconcileResource
extends BaseGoogleRefineReconcileResource {
    SiteManager _siteManager;

    public SiteManagerReconcileResource(@Context ServletContext context) {
        super(context);
    }

    private SiteManager getSiteManager() {
        if (this._siteManager == null) {
            this._siteManager = (SiteManager)ContextHelper.getServiceFromContext(SiteManager.class, (ServletContext)this.servletContext);
            if (this._siteManager == null) {
                throw new IllegalStateException("ReferencedSiteManager service is unavailable!");
            }
        }
        return this._siteManager;
    }

    @Override
    protected QueryResultList<Representation> performQuery(FieldQuery query) throws SiteException {
        return this.getSiteManager().find(query);
    }

    @Override
    protected String getSiteName() {
        return "Referenced Site Manager (all sites)";
    }

    @Override
    protected FieldQuery createFieldQuery() {
        return DefaultQueryFactory.getInstance().createFieldQuery();
    }
}

