/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.entityhub.jersey.resource.reconcile;

import javax.servlet.ServletContext;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.stanbol.commons.web.base.ContextHelper;
import org.apache.stanbol.entityhub.jersey.resource.reconcile.BaseGoogleRefineReconcileResource;
import org.apache.stanbol.entityhub.servicesapi.model.Representation;
import org.apache.stanbol.entityhub.servicesapi.query.FieldQuery;
import org.apache.stanbol.entityhub.servicesapi.query.QueryResultList;
import org.apache.stanbol.entityhub.servicesapi.site.Site;
import org.apache.stanbol.entityhub.servicesapi.site.SiteException;
import org.apache.stanbol.entityhub.servicesapi.site.SiteManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/entityhub/site/{site}/reconcile")
public class ReferencedSiteReconcileResource
extends BaseGoogleRefineReconcileResource {
    private final Logger log = LoggerFactory.getLogger(ReferencedSiteReconcileResource.class);
    private SiteManager _siteManager;
    private final String siteId;

    public ReferencedSiteReconcileResource(@Context ServletContext context, @PathParam(value="site") String siteId) {
        super(context);
        if (siteId == null || siteId.isEmpty()) {
            this.log.error("Missing path parameter site={}", (Object)siteId);
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        this.siteId = siteId;
    }

    private Site getSite() throws WebApplicationException {
        Site site;
        if (this._siteManager == null) {
            this._siteManager = (SiteManager)ContextHelper.getServiceFromContext(SiteManager.class, (ServletContext)this.servletContext);
            if (this._siteManager == null) {
                throw new IllegalStateException("Unable to lookup ReferencedSite '" + this.siteId + "' because ReferencedSiteManager service is unavailable!");
            }
        }
        if ((site = this._siteManager.getSite(this.siteId)) == null) {
            String message = String.format("ReferencedSite '%s' not acitve!", this.siteId);
            this.log.error(message);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)message).build());
        }
        return site;
    }

    @Override
    protected QueryResultList<Representation> performQuery(FieldQuery query) throws SiteException {
        return this.getSite().find(query);
    }

    @Override
    protected String getSiteName() {
        return this.getSite().getId() + "Referenced Site";
    }

    @Override
    protected FieldQuery createFieldQuery() {
        return this.getSite().getQueryFactory().createFieldQuery();
    }
}

