/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.entityhub.jersey.resource.reconcile;

import javax.servlet.ServletContext;
import javax.ws.rs.Path;
import org.apache.stanbol.commons.web.base.ContextHelper;
import org.apache.stanbol.entityhub.core.query.DefaultQueryFactory;
import org.apache.stanbol.entityhub.jersey.resource.reconcile.BaseGoogleRefineReconcileResource;
import org.apache.stanbol.entityhub.servicesapi.model.Representation;
import org.apache.stanbol.entityhub.servicesapi.query.FieldQuery;
import org.apache.stanbol.entityhub.servicesapi.query.QueryResultList;
import org.apache.stanbol.entityhub.servicesapi.site.ReferencedSiteException;
import org.apache.stanbol.entityhub.servicesapi.site.ReferencedSiteManager;

@Path(value="/entityhub/sites/reconcile")
public class SiteManagerReconcileResource
extends BaseGoogleRefineReconcileResource {
    ReferencedSiteManager _siteManager;

    private ReferencedSiteManager getSiteManager() {
        if (this._siteManager == null) {
            this._siteManager = (ReferencedSiteManager)ContextHelper.getServiceFromContext(ReferencedSiteManager.class, (ServletContext)this.servletContext);
            if (this._siteManager == null) {
                throw new IllegalStateException("ReferencedSiteManager service is unavailable!");
            }
        }
        return this._siteManager;
    }

    @Override
    protected QueryResultList<Representation> performQuery(FieldQuery query) throws ReferencedSiteException {
        return this.getSiteManager().find(query);
    }

    @Override
    protected String getSiteName() {
        return "Referenced Site Manager (all sites)";
    }

    @Override
    protected FieldQuery createFieldQuery() {
        return DefaultQueryFactory.getInstance().createFieldQuery();
    }
}

