/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.entityhub.jersey.resource;

import at.newmedialab.ldpath.api.backend.RDFBackend;
import at.newmedialab.ldpath.exception.LDPathParseException;
import at.newmedialab.ldpath.model.programs.Program;
import com.sun.jersey.api.view.Viewable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.clerezza.rdf.core.MGraph;
import org.apache.clerezza.rdf.ontologies.RDFS;
import org.apache.stanbol.commons.indexedgraph.IndexedMGraph;
import org.apache.stanbol.commons.web.base.ContextHelper;
import org.apache.stanbol.commons.web.base.CorsHelper;
import org.apache.stanbol.commons.web.base.resource.BaseStanbolResource;
import org.apache.stanbol.commons.web.base.utils.MediaTypeUtil;
import org.apache.stanbol.entityhub.core.query.QueryResultListImpl;
import org.apache.stanbol.entityhub.core.utils.AdaptingIterator;
import org.apache.stanbol.entityhub.jersey.utils.JerseyUtils;
import org.apache.stanbol.entityhub.jersey.utils.LDPathHelper;
import org.apache.stanbol.entityhub.ldpath.EntityhubLDPath;
import org.apache.stanbol.entityhub.ldpath.backend.AbstractBackend;
import org.apache.stanbol.entityhub.ldpath.backend.SiteManagerBackend;
import org.apache.stanbol.entityhub.ldpath.query.LDPathSelect;
import org.apache.stanbol.entityhub.model.clerezza.RdfValueFactory;
import org.apache.stanbol.entityhub.servicesapi.model.Entity;
import org.apache.stanbol.entityhub.servicesapi.model.Representation;
import org.apache.stanbol.entityhub.servicesapi.model.ValueFactory;
import org.apache.stanbol.entityhub.servicesapi.query.FieldQuery;
import org.apache.stanbol.entityhub.servicesapi.query.QueryResultList;
import org.apache.stanbol.entityhub.servicesapi.site.ReferencedSiteManager;
import org.codehaus.jettison.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/entityhub/sites")
public class SiteManagerRootResource
extends BaseStanbolResource {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final Set<String> RDF_MEDIA_TYPES = new TreeSet<String>(Arrays.asList("text/rdf+n3", "text/rdf+nt", "application/rdf+xml", "text/turtle", "application/x-turtle", "application/rdf+json"));
    private static final String DEFAULT_FIND_FIELD = RDFS.label.getUnicodeString();
    private static final int DEFAULT_FIND_RESULT_LIMIT = 5;

    @OPTIONS
    public Response handleCorsPreflight(@Context HttpHeaders headers) {
        Response.ResponseBuilder res = Response.ok();
        CorsHelper.enableCORS((ServletContext)this.servletContext, (Response.ResponseBuilder)res, (HttpHeaders)headers, (String[])new String[0]);
        return res.build();
    }

    @OPTIONS
    @Path(value="/find")
    public Response handleCorsPreflightFind(@Context HttpHeaders headers) {
        Response.ResponseBuilder res = Response.ok();
        CorsHelper.enableCORS((ServletContext)this.servletContext, (Response.ResponseBuilder)res, (HttpHeaders)headers, (String[])new String[0]);
        return res.build();
    }

    @OPTIONS
    @Path(value="/query")
    public Response handleCorsPreflightQuery(@Context HttpHeaders headers) {
        Response.ResponseBuilder res = Response.ok();
        CorsHelper.enableCORS((ServletContext)this.servletContext, (Response.ResponseBuilder)res, (HttpHeaders)headers, (String[])new String[0]);
        return res.build();
    }

    @GET
    @Produces(value={"text/html"})
    public Response getSitesPage(@Context HttpHeaders headers) {
        Response.ResponseBuilder rb = Response.ok((Object)new Viewable("index", (Object)this));
        rb.header("Content-Type", (Object)"text/html; charset=utf-8");
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        return rb.build();
    }

    @GET
    @Path(value="/referenced")
    @Produces(value={"application/json", "text/html"})
    public Response getReferencedSites(@Context UriInfo uriInfo, @Context HttpHeaders headers) {
        MediaType acceptable = MediaTypeUtil.getAcceptableMediaType((HttpHeaders)headers, Arrays.asList("application/json", "text/html"), (MediaType)MediaType.APPLICATION_JSON_TYPE);
        if (MediaType.TEXT_HTML_TYPE.isCompatible(acceptable)) {
            Response.ResponseBuilder rb = Response.ok((Object)new Viewable("referenced", (Object)this));
            rb.header("Content-Type", (Object)"text/html; charset=utf-8");
            CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
            return rb.build();
        }
        ReferencedSiteManager referencedSiteManager = (ReferencedSiteManager)ContextHelper.getServiceFromContext(ReferencedSiteManager.class, (ServletContext)this.servletContext);
        JSONArray referencedSites = new JSONArray();
        for (String site : referencedSiteManager.getReferencedSiteIds()) {
            referencedSites.put((Object)String.format("%sentityhub/site/%s/", uriInfo.getBaseUri(), site));
        }
        Response.ResponseBuilder rb = Response.ok((Object)referencedSites);
        rb.header("Content-Type", (Object)(acceptable + "; charset=utf-8"));
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        return rb.build();
    }

    @OPTIONS
    @Path(value="/entity")
    public Response handleCorsPreflightEntity(@Context HttpHeaders headers) {
        Response.ResponseBuilder res = Response.ok();
        CorsHelper.enableCORS((ServletContext)this.servletContext, (Response.ResponseBuilder)res, (HttpHeaders)headers, (String[])new String[]{"OPTIONS", "GET"});
        return res.build();
    }

    @GET
    @Path(value="/entity")
    public Response getEntityById(@QueryParam(value="id") String id, @Context HttpHeaders headers) {
        this.log.debug("getSignById() request\n\t> id       : {}\n\t> accept   : {}\n\t> mediaType: {}", new Object[]{id, headers.getAcceptableMediaTypes(), headers.getMediaType()});
        HashSet<String> supported = new HashSet<String>(JerseyUtils.ENTITY_SUPPORTED_MEDIA_TYPES);
        supported.add("text/html");
        MediaType acceptedMediaType = MediaTypeUtil.getAcceptableMediaType((HttpHeaders)headers, supported, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        if (id == null || id.isEmpty()) {
            if (MediaType.TEXT_HTML_TYPE.isCompatible(acceptedMediaType)) {
                Response.ResponseBuilder rb = Response.ok((Object)new Viewable("entity", (Object)this));
                rb.header("Content-Type", (Object)"text/html; charset=utf-8");
                CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
                return rb.build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"No or empty ID was parsed. Missing parameter id.\n").header("Accept", (Object)acceptedMediaType).build();
        }
        ReferencedSiteManager referencedSiteManager = (ReferencedSiteManager)ContextHelper.getServiceFromContext(ReferencedSiteManager.class, (ServletContext)this.servletContext);
        Entity sign = referencedSiteManager.getEntity(id);
        if (sign != null) {
            Response.ResponseBuilder rb = Response.ok((Object)sign);
            rb.header("Content-Type", (Object)(acceptedMediaType + "; charset=utf-8"));
            CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
            return rb.build();
        }
        this.log.info("getSignById() entity {} not found on any referenced site");
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Entity with ID '" + id + "' not found an any referenced site\n")).header("Accept", (Object)acceptedMediaType).build();
    }

    @GET
    @Path(value="/find")
    public Response findEntityfromGet(@QueryParam(value="name") String name, @QueryParam(value="field") String field, @QueryParam(value="lang") String language, @QueryParam(value="limit") @DefaultValue(value="-1") int limit, @QueryParam(value="offset") @DefaultValue(value="0") int offset, @QueryParam(value="ldpath") String ldpath, @Context HttpHeaders headers) {
        return this.findEntity(name, field, language, limit, offset, ldpath, headers);
    }

    @POST
    @Path(value="/find")
    public Response findEntity(@FormParam(value="name") String name, @FormParam(value="field") String field, @FormParam(value="lang") String language, @FormParam(value="limit") Integer limit, @FormParam(value="offset") Integer offset, @FormParam(value="ldpath") String ldpath, @Context HttpHeaders headers) {
        this.log.debug("findEntity() Request");
        HashSet<String> supported = new HashSet<String>(JerseyUtils.QUERY_RESULT_SUPPORTED_MEDIA_TYPES);
        supported.add("text/html");
        MediaType acceptedMediaType = MediaTypeUtil.getAcceptableMediaType((HttpHeaders)headers, supported, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        if (name == null || name.isEmpty()) {
            if (MediaType.TEXT_HTML_TYPE.isCompatible(acceptedMediaType)) {
                Response.ResponseBuilder rb = Response.ok((Object)new Viewable("find", (Object)this));
                rb.header("Content-Type", (Object)"text/html; charset=utf-8");
                CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
                return rb.build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"The name must not be null nor empty for find requests. Missing parameter name.\n").header("Accept", (Object)acceptedMediaType).build();
        }
        if (field == null) {
            field = DEFAULT_FIND_FIELD;
        } else if ((field = field.trim()).isEmpty()) {
            field = DEFAULT_FIND_FIELD;
        }
        FieldQuery query = JerseyUtils.createFieldQueryForFindRequest(name, field, language, limit == null || limit < 1 ? 5 : limit, offset, ldpath);
        return this.executeQuery((ReferencedSiteManager)ContextHelper.getServiceFromContext(ReferencedSiteManager.class, (ServletContext)this.servletContext), query, acceptedMediaType, headers);
    }

    @GET
    @Path(value="/query")
    public Response getQueryDocumentation(@Context HttpHeaders headers) {
        Response.ResponseBuilder rb = Response.ok((Object)new Viewable("query", (Object)this));
        rb.header("Content-Type", (Object)"text/html; charset=utf-8");
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        return rb.build();
    }

    @POST
    @Path(value="/query")
    @Consumes(value={"application/json"})
    public Response queryEntities(FieldQuery query, @Context HttpHeaders headers) {
        HashSet<String> supported = new HashSet<String>(JerseyUtils.QUERY_RESULT_SUPPORTED_MEDIA_TYPES);
        supported.add("text/html");
        MediaType acceptedMediaType = MediaTypeUtil.getAcceptableMediaType((HttpHeaders)headers, supported, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        if (query == null) {
            if (MediaType.TEXT_HTML_TYPE.isCompatible(acceptedMediaType)) {
                return this.getQueryDocumentation(headers);
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"The query must not be null nor empty for query requests. Missing parameter query.\n").header("Accept", (Object)acceptedMediaType).build();
        }
        return this.executeQuery((ReferencedSiteManager)ContextHelper.getServiceFromContext(ReferencedSiteManager.class, (ServletContext)this.servletContext), query, acceptedMediaType, headers);
    }

    @OPTIONS
    @Path(value="/ldpath")
    public Response handleCorsPreflightLDPath(@Context HttpHeaders headers) {
        Response.ResponseBuilder res = Response.ok();
        CorsHelper.enableCORS((ServletContext)this.servletContext, (Response.ResponseBuilder)res, (HttpHeaders)headers, (String[])new String[]{"OPTIONS", "GET", "POST"});
        return res.build();
    }

    @GET
    @Path(value="/ldpath")
    public Response handleLDPathGet(@QueryParam(value="context") Set<String> contexts, @QueryParam(value="ldpath") String ldpath, @Context HttpHeaders headers) {
        return this.handleLDPathPost(contexts, ldpath, headers);
    }

    @POST
    @Path(value="/ldpath")
    public Response handleLDPathPost(@FormParam(value="context") Set<String> contexts, @FormParam(value="ldpath") String ldpath, @Context HttpHeaders headers) {
        ReferencedSiteManager referencedSiteManager = (ReferencedSiteManager)ContextHelper.getServiceFromContext(ReferencedSiteManager.class, (ServletContext)this.servletContext);
        return LDPathHelper.handleLDPathRequest(this, (RDFBackend<Object>)new SiteManagerBackend(referencedSiteManager), ldpath, contexts, headers, this.servletContext);
    }

    private Response executeQuery(ReferencedSiteManager manager, FieldQuery query, MediaType mediaType, HttpHeaders headers) throws WebApplicationException {
        if (query instanceof LDPathSelect && ((LDPathSelect)query).getLDPathSelect() != null) {
            return this.executeLDPathQuery(manager, query, ((LDPathSelect)query).getLDPathSelect(), mediaType, headers);
        }
        QueryResultList result = manager.find(query);
        Response.ResponseBuilder rb = Response.ok((Object)result);
        rb.header("Content-Type", (Object)(mediaType + "; charset=utf-8"));
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        return rb.build();
    }

    private Response executeLDPathQuery(ReferencedSiteManager manager, FieldQuery query, String ldpathProgramString, MediaType mediaType, HttpHeaders headers) {
        Program<Object> program;
        RdfValueFactory vf = new RdfValueFactory((MGraph)new IndexedMGraph());
        SiteManagerBackend backend = new SiteManagerBackend(manager);
        EntityhubLDPath ldPath = new EntityhubLDPath((RDFBackend)backend, (ValueFactory)vf);
        HashSet<String> selectedFields = new HashSet<String>(query.getSelectedFields());
        try {
            program = LDPathHelper.prepairQueryLDPathProgram(ldpathProgramString, selectedFields, (AbstractBackend)backend, ldPath);
        }
        catch (LDPathParseException e) {
            this.log.warn("Unable to parse LDPath program used as select for a Query to the '/sites' endpoint:");
            this.log.warn("FieldQuery: \n {}", (Object)query);
            this.log.warn("LDPath: \n {}", (Object)((LDPathSelect)query).getLDPathSelect());
            this.log.warn("Exception:", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Unable to parse LDPath program (Messages: " + LDPathHelper.getLDPathParseExceptionMessage(e) + ")!\n")).header("Accept", (Object)mediaType).build();
        }
        catch (IllegalStateException e) {
            this.log.warn("parsed LDPath program is not compatible with the Query parsed to the '/sites' endpoint!", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).header("Accept", (Object)mediaType).build();
        }
        AdaptingIterator resultIt = new AdaptingIterator(manager.findEntities(query).iterator(), (AdaptingIterator.Adapter)new AdaptingIterator.Adapter<Entity, Representation>(){

            public Representation adapt(Entity value, Class<Representation> type) {
                return value.getRepresentation();
            }
        }, Representation.class);
        Collection<Representation> transformedResults = LDPathHelper.transformQueryResults((Iterator<Representation>)resultIt, program, selectedFields, ldPath, (AbstractBackend)backend, (ValueFactory)vf);
        QueryResultListImpl result = new QueryResultListImpl(query, transformedResults, Representation.class);
        Response.ResponseBuilder rb = Response.ok((Object)result);
        rb.header("Content-Type", (Object)(mediaType + "; charset=utf-8"));
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        return rb.build();
    }
}

