/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.entityhub.jersey.grefine;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.stanbol.entityhub.jersey.grefine.ReconcileProperty;
import org.apache.stanbol.entityhub.jersey.grefine.ReconcileValue;
import org.apache.stanbol.entityhub.servicesapi.defaults.NamespaceEnum;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconcileQuery {
    private static final Logger log = LoggerFactory.getLogger(ReconcileQuery.class);
    public static final Integer DEFAULT_LIMIT = 5;
    public static final TYPE_STRICT DEFAULT_TYPE_STRICT = TYPE_STRICT.any;
    private final String query;
    private final Set<String> types;
    private Integer limit;
    private final Map<ReconcileProperty, Collection<ReconcileValue>> properties = new HashMap<ReconcileProperty, Collection<ReconcileValue>>();
    private TYPE_STRICT typeStrict;

    public final Integer getLimit() {
        return this.limit;
    }

    public final void setLimit(Integer limit) {
        this.limit = limit;
    }

    public final TYPE_STRICT getTypeStrict() {
        return this.typeStrict;
    }

    public final void setTypeStrict(TYPE_STRICT typeStrict) {
        this.typeStrict = typeStrict;
    }

    public final String getQuery() {
        return this.query;
    }

    public final Set<String> getTypes() {
        return this.types;
    }

    public ReconcileQuery(String query, Collection<String> types) {
        if (query == null || query.isEmpty()) {
            throw new IllegalArgumentException("The parsed query string MUST NOT be NULL nor empty!");
        }
        this.query = query;
        if (types == null || types.isEmpty()) {
            this.types = Collections.emptySet();
        } else {
            HashSet<String> t = new HashSet<String>(types.size());
            for (String type : types) {
                if (type == null || type.isEmpty()) continue;
                t.add(type);
            }
            this.types = Collections.unmodifiableSet(t);
        }
    }

    public Collection<ReconcileValue> putProperty(String field, Collection<ReconcileValue> values) {
        if (field == null || field.isEmpty()) {
            throw new IllegalArgumentException("The field for an property MUST NOT be NULL!");
        }
        ReconcileProperty property = ReconcileProperty.parseProperty(field);
        if (property != null) {
            if (values == null || values.isEmpty()) {
                return this.properties.remove(values);
            }
            return this.properties.put(property, values);
        }
        return null;
    }

    public Collection<ReconcileValue> removeProperty(String field) {
        return this.properties.remove(field);
    }

    public Collection<ReconcileValue> getProperty(String field) {
        return this.properties.get(field);
    }

    public Iterable<Map.Entry<ReconcileProperty, Collection<ReconcileValue>>> getProperties() {
        return this.properties.entrySet();
    }

    public static Map<String, ReconcileQuery> parseQueries(String queriesString) throws WebApplicationException {
        JSONObject jQueries;
        try {
            jQueries = new JSONObject(queriesString);
        }
        catch (JSONException e) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("The parsed query is illegal formatted! \n query: \n" + queriesString + "\n")).build());
        }
        Iterator keys = jQueries.keys();
        HashMap<String, ReconcileQuery> queries = new HashMap<String, ReconcileQuery>();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            try {
                ReconcileQuery query = ReconcileQuery.parseQuery(jQueries.getJSONObject(key));
                queries.put(key, query);
            }
            catch (JSONException e) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("The query of key '" + key + "is illegal formatted! \n query: \n" + queriesString + "\n")).build());
            }
        }
        return queries;
    }

    public static ReconcileQuery parseQuery(String queryString) throws WebApplicationException {
        JSONObject jQuery;
        try {
            if (queryString.charAt(0) == '{') {
                jQuery = new JSONObject(queryString);
            } else {
                jQuery = new JSONObject();
                jQuery.put("query", (Object)queryString);
            }
        }
        catch (JSONException e) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("The parsed query is illegal formatted! \n query: \n" + queryString + "\n")).build());
        }
        return ReconcileQuery.parseQuery(jQuery);
    }

    private static ReconcileQuery parseQuery(JSONObject jQuery) throws WebApplicationException {
        Set<String> types;
        String value = jQuery.optString("query");
        if (value == null || value.isEmpty()) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("The parsed query is illegal formatted! \n query: \n" + jQuery.toString() + "\n")).build());
        }
        JSONArray jTypes = null;
        if (!jQuery.has("type")) {
            types = Collections.emptySet();
        } else {
            jTypes = jQuery.optJSONArray("type");
            if (jTypes != null) {
                types = new HashSet<String>(jTypes.length());
                for (int i = 0; i < jTypes.length(); ++i) {
                    String type = NamespaceEnum.getFullName((String)jTypes.optString(i));
                    if (type == null || type.isEmpty()) continue;
                    types.add(type);
                }
            } else {
                String type = jQuery.optString("type");
                types = type != null && !type.isEmpty() ? Collections.singleton(type) : Collections.emptySet();
            }
        }
        ReconcileQuery reconcileQuery = new ReconcileQuery(value, types);
        String jTypeStrict = jQuery.optString("type_strict");
        if (jTypeStrict != null) {
            try {
                reconcileQuery.setTypeStrict(TYPE_STRICT.valueOf(jTypeStrict));
            }
            catch (RuntimeException e) {
                log.warn("Unknown \"type_strict\" value in Google Refine Reconcile Request (use default '{}')\n {}", (Object)DEFAULT_TYPE_STRICT, (Object)jQuery.toString());
                reconcileQuery.setTypeStrict(DEFAULT_TYPE_STRICT);
            }
        } else {
            reconcileQuery.setTypeStrict(DEFAULT_TYPE_STRICT);
        }
        reconcileQuery.setLimit(jQuery.optInt("limit", DEFAULT_LIMIT.intValue()));
        JSONArray jProperties = jQuery.optJSONArray("properties");
        if (jProperties != null) {
            for (int i = 0; i < jProperties.length(); ++i) {
                ReconcileQuery.parseProperty(reconcileQuery, jProperties.optJSONObject(i));
            }
        }
        return reconcileQuery;
    }

    private static void parseProperty(ReconcileQuery reconcileQuery, JSONObject jProperty) {
        if (jProperty != null) {
            String property = jProperty.optString("pid");
            if (property == null) {
                log.warn("Ignore Property because of missing 'pid'! \n{}", (Object)jProperty.toString());
            } else {
                Object jValue;
                Collection<ReconcileValue> values = reconcileQuery.getProperty(property);
                if (values == null) {
                    values = new LinkedHashSet<ReconcileValue>();
                }
                if ((jValue = jProperty.opt("v")) == null) {
                    log.warn("Ignore Property '{}' because it has no value! \n {}", (Object)property, (Object)jProperty.toString());
                } else if (jValue instanceof JSONObject) {
                    ReconcileValue value = ReconcileQuery.parseValueFromV(jValue);
                    if (value != null) {
                        values.add(value);
                    } else {
                        log.warn("ignore value for property {} because no name is present (value: {})!", (Object)property, (Object)jValue.toString());
                    }
                } else if (jValue instanceof JSONArray) {
                    JSONArray jValueArray = (JSONArray)jValue;
                    for (int j = 0; j < jValueArray.length(); ++j) {
                        jValue = jValueArray.opt(j);
                        if (jValue instanceof JSONObject) {
                            ReconcileValue value = ReconcileQuery.parseValueFromV(jValue);
                            if (value != null) {
                                values.add(value);
                                continue;
                            }
                            log.warn("ignore value for property {} because no name is present (value: {})!", (Object)property, (Object)jValue.toString());
                            continue;
                        }
                        if (jValue == null) continue;
                        values.add(new ReconcileValue(jValue));
                    }
                    if (values.isEmpty()) {
                        log.warn("Ignore Property '{}' because it does not define a valid value! \n {}", (Object)property, (Object)jProperty.toString());
                    }
                } else {
                    values.add(new ReconcileValue(jValue));
                }
                if (!values.isEmpty()) {
                    reconcileQuery.putProperty(property, values);
                }
            }
        }
    }

    private static ReconcileValue parseValueFromV(Object jValue) {
        String id = ((JSONObject)jValue).optString("id");
        String value = ((JSONObject)jValue).optString("name");
        return value != null ? new ReconcileValue(id, value) : null;
    }

    public static enum TYPE_STRICT {
        any,
        all,
        should;

    }
}

