/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.jobmanager.event.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.clerezza.rdf.core.Graph;
import org.apache.clerezza.rdf.core.MGraph;
import org.apache.clerezza.rdf.core.NonLiteral;
import org.apache.clerezza.rdf.core.TripleCollection;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.collections.bidimap.DualHashBidiMap;
import org.apache.stanbol.enhancer.servicesapi.ContentItem;
import org.apache.stanbol.enhancer.servicesapi.EnhancementEngine;
import org.apache.stanbol.enhancer.servicesapi.NoSuchPartException;
import org.apache.stanbol.enhancer.servicesapi.helper.EnhancementEngineHelper;
import org.apache.stanbol.enhancer.servicesapi.helper.ExecutionMetadataHelper;
import org.apache.stanbol.enhancer.servicesapi.helper.ExecutionPlanHelper;
import org.apache.stanbol.enhancer.servicesapi.rdf.ExecutionMetadata;
import org.apache.stanbol.enhancer.servicesapi.rdf.ExecutionPlan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnhancementJob {
    private final Logger log = LoggerFactory.getLogger(EnhancementJob.class);
    private final Lock readLock;
    private final Lock writeLock;
    private final Graph executionPlan;
    private final MGraph executionMetadata;
    private final BidiMap executionsMap;
    private final NonLiteral chainExecutionNode;
    private final NonLiteral executionPlanNode;
    private final String chain;
    private final ContentItem contentItem;
    private final Set<NonLiteral> completed = new HashSet<NonLiteral>();
    private Set<NonLiteral> completedExec = Collections.emptySet();
    private final Set<NonLiteral> running = new HashSet<NonLiteral>();
    private Set<NonLiteral> runningExec = Collections.emptySet();
    private Set<NonLiteral> executable;
    private Exception error = null;

    public EnhancementJob(ContentItem contentItem, String chainName, Graph executionPlan, boolean isDefaultChain) {
        if (contentItem == null || chainName == null || executionPlan == null) {
            throw new IllegalArgumentException("The parsed contentItem and executionPlan MUST NOT be NULL");
        }
        this.readLock = contentItem.getLock().readLock();
        this.writeLock = contentItem.getLock().writeLock();
        this.executionMetadata = ExecutionMetadataHelper.initExecutionMetadataContentPart((ContentItem)contentItem);
        if (!this.executionMetadata.isEmpty()) {
            throw new IllegalArgumentException("Unable to create EnhancementJob for a parsed execution plan if the ContentItem already contains some Execution Metadata!");
        }
        this.executionsMap = new DualHashBidiMap(ExecutionMetadataHelper.initExecutionMetadata((MGraph)this.executionMetadata, (TripleCollection)executionPlan, (UriRef)contentItem.getUri(), (String)chainName, (Boolean)isDefaultChain));
        this.chainExecutionNode = ExecutionMetadataHelper.getChainExecution((TripleCollection)this.executionMetadata, (UriRef)contentItem.getUri());
        this.executionPlanNode = ExecutionMetadataHelper.getExecutionPlanNode((TripleCollection)this.executionMetadata, (NonLiteral)this.chainExecutionNode);
        this.executionMetadata.addAll((Collection)executionPlan);
        this.contentItem = contentItem;
        this.executionPlan = executionPlan;
        this.chain = chainName;
        this.checkExecutable();
    }

    public EnhancementJob(ContentItem contentItem) {
        if (contentItem == null) {
            throw new IllegalArgumentException("The parsed ContentItem MUST NOT be NULL!");
        }
        this.contentItem = contentItem;
        this.readLock = contentItem.getLock().readLock();
        this.writeLock = contentItem.getLock().writeLock();
        try {
            contentItem.getPart(ExecutionMetadata.CHAIN_EXECUTION, MGraph.class);
        }
        catch (NoSuchPartException e) {
            throw new IllegalArgumentException("Cannot (re)initialise an EnhancementJobwithout existing execution metadata content part!", e);
        }
        this.executionMetadata = ExecutionMetadataHelper.initExecutionMetadataContentPart((ContentItem)contentItem);
        this.executionPlan = this.executionMetadata.getGraph();
        this.chainExecutionNode = ExecutionMetadataHelper.getChainExecution((TripleCollection)this.executionMetadata, (UriRef)contentItem.getUri());
        if (this.chainExecutionNode == null) {
            throw new IllegalArgumentException("Cannot (re)initialise an EnhancementJobbecause the ExecutionMetadata do not contain an em:ChainExecutionfor the given ContentItem '" + contentItem.getUri() + "'!");
        }
        this.executionPlanNode = ExecutionMetadataHelper.getExecutionPlanNode((TripleCollection)this.executionMetadata, (NonLiteral)this.chainExecutionNode);
        if (this.executionPlanNode == null) {
            throw new IllegalArgumentException("Cannot (re)initialise an EnhancementJobbecause the ExecutionMetadata do not contain an ep:ExecutionPlanfor the given ContentItem '" + contentItem.getUri() + "'!");
        }
        this.chain = EnhancementEngineHelper.getString((TripleCollection)this.executionPlan, (NonLiteral)this.executionPlanNode, (UriRef)ExecutionPlan.CHAIN);
        if (this.chain == null || this.chain.isEmpty()) {
            throw new IllegalArgumentException("Cannot (re)initialise an EnhancementJob because the ExecutionMetadata do not define a valid chain name for the ep:ExecutionPlan node '" + this.executionPlanNode + "' as used to " + "enhance  ContentItem '" + contentItem.getUri() + "'!");
        }
        Map executionsMap = ExecutionMetadataHelper.initExecutionMetadata((MGraph)this.executionMetadata, (TripleCollection)this.executionPlan, (UriRef)contentItem.getUri(), null, null);
        for (Map.Entry executionEntry : executionsMap.entrySet()) {
            UriRef status = EnhancementEngineHelper.getReference((TripleCollection)this.executionMetadata, (NonLiteral)((NonLiteral)executionEntry.getKey()), (UriRef)ExecutionMetadata.STATUS);
            if (status == null) {
                throw new IllegalArgumentException("The ex:Execution '" + executionEntry.getKey() + "' of the ex:ChainExecution for ContentItme '" + contentItem.getUri() + "' is missing a required value for the property '" + ExecutionMetadata.STATUS + "'!");
            }
            if (status.equals((Object)ExecutionMetadata.STATUS_IN_PROGRESS)) {
                ExecutionMetadataHelper.setExecutionScheduled((MGraph)this.executionMetadata, (NonLiteral)((NonLiteral)executionEntry.getKey()));
                continue;
            }
            if (!status.equals((Object)ExecutionMetadata.STATUS_COMPLETED) && !status.equals((Object)ExecutionMetadata.STATUS_FAILED)) continue;
            this.completed.add((NonLiteral)executionEntry.getValue());
        }
        this.executionsMap = new DualHashBidiMap(executionsMap);
        this.checkExecutable();
    }

    public NonLiteral getExecutionNode(NonLiteral execution) {
        NonLiteral node = (NonLiteral)this.executionsMap.get((Object)execution);
        if (node == null) {
            throw new IllegalArgumentException("Unknown sp:ExecutionNode instance " + node);
        }
        return node;
    }

    public NonLiteral getExecution(NonLiteral executionNode) {
        NonLiteral execution = (NonLiteral)this.executionsMap.getKey((Object)executionNode);
        if (execution == null) {
            throw new IllegalArgumentException("Unknown em:Execution instance " + executionNode);
        }
        return execution;
    }

    public final Graph getExecutionPlan() {
        return this.executionPlan;
    }

    public final ContentItem getContentItem() {
        return this.contentItem;
    }

    public final String getChainName() {
        return this.chain;
    }

    public final ReadWriteLock getLock() {
        return this.contentItem.getLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<NonLiteral> getRunning() {
        this.log.trace("++ r: {}", (Object)"getRunning");
        this.readLock.lock();
        try {
            this.log.trace(">> r: {}", (Object)"getRunning");
            Set<NonLiteral> set = this.runningExec;
            return set;
        }
        finally {
            this.log.trace("<< r: {}", (Object)"getRunning");
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<NonLiteral> getCompleted() {
        this.log.trace("++ r: {}", (Object)"getCompleted");
        this.readLock.lock();
        try {
            this.log.trace(">> r: {}", (Object)"getCompleted");
            Set<NonLiteral> set = this.completedExec;
            return set;
        }
        finally {
            this.log.trace("<< r: {}", (Object)"getCompleted");
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCompleted(NonLiteral execution) {
        if (execution == null) {
            throw new IllegalArgumentException("The parsed em:Execution instance MUST NOT be NULL!");
        }
        this.writeLock.lock();
        NonLiteral executionNode = this.getExecutionNode(execution);
        this.log.trace("++ w: {}: {}", (Object)"setCompleted", (Object)ExecutionPlanHelper.getEngine((TripleCollection)this.executionPlan, (NonLiteral)executionNode));
        try {
            this.log.trace(">> w: {}: {}", (Object)"setCompleted", (Object)ExecutionPlanHelper.getEngine((TripleCollection)this.executionPlan, (NonLiteral)executionNode));
            this.setNodeCompleted(executionNode);
            ExecutionMetadataHelper.setExecutionCompleted((MGraph)this.executionMetadata, (NonLiteral)execution, null);
        }
        finally {
            this.log.trace("<< w: {}: {}", (Object)"setCompleted", (Object)ExecutionPlanHelper.getEngine((TripleCollection)this.executionPlan, (NonLiteral)executionNode));
            this.writeLock.unlock();
        }
    }

    private void setNodeCompleted(NonLiteral executionNode) {
        String engine = ExecutionPlanHelper.getEngine((TripleCollection)this.executionPlan, (NonLiteral)executionNode);
        boolean optional = ExecutionPlanHelper.isOptional((TripleCollection)this.executionPlan, (NonLiteral)executionNode);
        Set dependsOn = ExecutionPlanHelper.getDependend((TripleCollection)this.executionPlan, (NonLiteral)executionNode);
        if (this.completed.contains(executionNode)) {
            this.log.warn("Execution of Engine '{}' for ContentItem {} already marked as completed(chain: {}, node: {}, optional {}). -> call ignored", new Object[]{engine, this.contentItem.getUri().getUnicodeString(), this.chain, executionNode, optional});
            return;
        }
        if (!this.completed.containsAll(dependsOn)) {
            throw new IllegalStateException("Unable to set state of ExectionNode '" + executionNode + "' (chain '" + this.chain + "' | contentItem '" + this.contentItem.getUri() + "') to completed, because some of its depended " + "nodes are not marked completed yet. This indicates an Bug in the " + "implementation of the JobManager used to execute the ExecutionPlan. " + "(this.dependsOn=" + dependsOn + "| chain.completed " + this.completed + " | chain.running " + this.running + ")!");
        }
        if (this.running.remove(executionNode)) {
            this.log.trace("Execution of '{}' for ContentItem {} completed (chain: {}, node: {}, optional {})", new Object[]{engine, this.contentItem.getUri().getUnicodeString(), this.chain, executionNode, optional});
        }
        this.completed.add(executionNode);
        this.updateCompletedExec();
        this.updateRunningExec();
        this.checkExecutable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRunning(NonLiteral execution) {
        if (execution == null) {
            throw new IllegalArgumentException("The parsed em:Execution instance MUST NOT be NULL!");
        }
        NonLiteral executionNode = this.getExecutionNode(execution);
        String engine = ExecutionPlanHelper.getEngine((TripleCollection)this.executionPlan, (NonLiteral)executionNode);
        boolean optional = ExecutionPlanHelper.isOptional((TripleCollection)this.executionPlan, (NonLiteral)executionNode);
        Set dependsOn = ExecutionPlanHelper.getDependend((TripleCollection)this.executionPlan, (NonLiteral)executionNode);
        this.log.trace("++ w: {}: {}", (Object)"setRunning", (Object)ExecutionPlanHelper.getEngine((TripleCollection)this.executionPlan, (NonLiteral)executionNode));
        this.writeLock.lock();
        try {
            this.log.trace(">> w: {}: {}", (Object)"setRunning", (Object)ExecutionPlanHelper.getEngine((TripleCollection)this.executionPlan, (NonLiteral)executionNode));
            if (this.completed.contains(executionNode)) {
                String message = "Unable to set state of ExectionNode '" + executionNode + "'(chain '" + this.chain + "' | contentItem '" + this.contentItem.getUri() + "') to running, because" + "it is already marked as completed. This indicates " + "an Bug in the implementation of the JobManager " + "used to execute the ExecutionPlan (chain state: " + "completed " + this.completed + " | running " + this.running + ")!";
                this.log.error(message);
                throw new IllegalStateException(message);
            }
            if (!this.completed.containsAll(dependsOn)) {
                String message = "Unable to set state of ExectionNode '" + executionNode + "' (chain '" + this.chain + "' | contentItem '" + this.contentItem.getUri() + "') to running, because " + "some of its depended nodes are not marked " + "completed yet. This indicates an Bug in the " + "implementation of the JobManager used to execute " + "the ExecutionPlan (this.dependsOn=" + dependsOn + "| chain.completed " + this.completed + " | chain.running " + this.running + ")!";
                this.log.error(message);
                throw new IllegalStateException(message);
            }
            if (!this.running.add(executionNode)) {
                this.log.warn("Execution of Engine '{}' for ContentItem {} already marked as running(chain: {}, node: {}, optional {}). -> call ignored", new Object[]{engine, this.contentItem.getUri().getUnicodeString(), this.chain, executionNode, optional});
                return;
            }
            this.log.trace("Started Execution of '{}' for ContentItem {} (chain: {}, node: {}, optional {})", new Object[]{engine, this.contentItem.getUri().getUnicodeString(), this.chain, executionNode, optional});
            ExecutionMetadataHelper.setExecutionInProgress((MGraph)this.executionMetadata, (NonLiteral)execution);
            this.updateRunningExec();
            this.checkExecutable();
        }
        finally {
            this.log.trace("<< w: {}: {}", (Object)"setRunning", (Object)ExecutionPlanHelper.getEngine((TripleCollection)this.executionPlan, (NonLiteral)executionNode));
            this.writeLock.unlock();
        }
    }

    private void updateRunningExec() {
        HashSet<NonLiteral> runningExec = new HashSet<NonLiteral>(this.running.size());
        for (NonLiteral node : this.running) {
            runningExec.add(this.getExecution(node));
        }
        this.runningExec = Collections.unmodifiableSet(runningExec);
    }

    private void updateCompletedExec() {
        HashSet<NonLiteral> completedExec = new HashSet<NonLiteral>(this.completed.size());
        for (NonLiteral node : this.completed) {
            completedExec.add(this.getExecution(node));
        }
        this.completedExec = Collections.unmodifiableSet(completedExec);
    }

    private void checkExecutable() {
        Set executeableNodes = ExecutionPlanHelper.getExecutable((TripleCollection)this.executionPlan, this.completed);
        if (!ExecutionMetadata.STATUS_FAILED.equals((Object)EnhancementEngineHelper.getReference((TripleCollection)this.executionMetadata, (NonLiteral)this.chainExecutionNode, (UriRef)ExecutionMetadata.STATUS))) {
            executeableNodes.removeAll(this.running);
            if (this.log.isDebugEnabled()) {
                ArrayList<String> engines = new ArrayList<String>(executeableNodes.size());
                for (NonLiteral node : executeableNodes) {
                    engines.add(ExecutionPlanHelper.getEngine((TripleCollection)this.executionPlan, (NonLiteral)node));
                }
                this.log.trace("MARK {} as executeable", engines);
            }
            if (executeableNodes.isEmpty()) {
                this.executable = Collections.emptySet();
            } else if (executeableNodes.size() == 1) {
                this.executable = Collections.singleton(this.getExecution((NonLiteral)executeableNodes.iterator().next()));
            } else {
                HashSet<NonLiteral> executable = new HashSet<NonLiteral>(executeableNodes.size());
                for (NonLiteral exeutableNode : executeableNodes) {
                    executable.add(this.getExecution(exeutableNode));
                }
                this.executable = Collections.unmodifiableSet(executable);
            }
        } else {
            this.executable = Collections.emptySet();
        }
        if (this.isFinished() && !this.isFailed()) {
            ExecutionMetadataHelper.setExecutionCompleted((MGraph)this.executionMetadata, (NonLiteral)this.chainExecutionNode, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<NonLiteral> getExecutable() {
        this.log.trace("++ r: {}", (Object)"getExecutable");
        this.readLock.lock();
        this.log.trace(">> r: {}", (Object)"getExecutable");
        try {
            Set<NonLiteral> set = this.executable;
            return set;
        }
        finally {
            this.log.trace("<< r: {}:{}", (Object)"getExecutable", this.executable);
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFinished() {
        this.log.trace("++ r: {}", (Object)"isFinished");
        this.readLock.lock();
        try {
            this.log.trace(">> r: {}", (Object)"isFinished");
            boolean bl = this.running.isEmpty() && (this.executable.isEmpty() || this.isFailed());
            return bl;
        }
        finally {
            this.log.trace("<< r: {}", (Object)"isFinished");
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFailed(NonLiteral execution, EnhancementEngine engine, Exception exception) {
        if (execution == null) {
            throw new IllegalArgumentException("The parsed em:Execution instance MUST NOT be NULL!");
        }
        NonLiteral executionNode = this.getExecutionNode(execution);
        boolean optional = ExecutionPlanHelper.isOptional((TripleCollection)this.executionPlan, (NonLiteral)executionNode);
        String engineName = ExecutionPlanHelper.getEngine((TripleCollection)this.executionPlan, (NonLiteral)executionNode);
        this.log.trace("++ w: {}: {}", (Object)"setFailed", (Object)ExecutionPlanHelper.getEngine((TripleCollection)this.executionPlan, (NonLiteral)executionNode));
        this.writeLock.lock();
        try {
            this.log.trace(">> w: {}: {}", (Object)"setFailed", (Object)ExecutionPlanHelper.getEngine((TripleCollection)this.executionPlan, (NonLiteral)executionNode));
            StringBuilder message = new StringBuilder();
            message.append(String.format("Unable to process ContentItem '%s' with Enhancement Engine '%s' because the engine ", this.contentItem.getUri(), engineName));
            if (engine == null) {
                message.append("is currently not active");
            } else {
                message.append(String.format("was unable to process the content (Engine class: %s)", engine.getClass().getName()));
            }
            if (exception != null) {
                message.append("(Reason: ").append(exception.getMessage()).append(')');
            }
            message.append('!');
            this.setNodeCompleted(executionNode);
            ExecutionMetadataHelper.setExecutionFaild((MGraph)this.executionMetadata, (NonLiteral)execution, (String)message.toString());
            if (!optional && !ExecutionMetadataHelper.isExecutionFailed((TripleCollection)this.executionMetadata, (NonLiteral)this.chainExecutionNode)) {
                String chainMessage = String.format("Enhancement Chain failed because of required Engine '%s' failed with Message: %s", engineName, message);
                ExecutionMetadataHelper.setExecutionFaild((MGraph)this.executionMetadata, (NonLiteral)this.chainExecutionNode, (String)chainMessage);
                this.error = exception;
            }
        }
        finally {
            this.log.trace("<< w: {}: {}", (Object)"setFailed", (Object)ExecutionPlanHelper.getEngine((TripleCollection)this.executionPlan, (NonLiteral)executionNode));
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFailed() {
        this.log.trace("++ r: {}", (Object)"isFailed");
        this.readLock.lock();
        try {
            this.log.trace(">> r: {}", (Object)"isFailed");
            boolean bl = ExecutionMetadataHelper.isExecutionFailed((TripleCollection)this.executionMetadata, (NonLiteral)this.chainExecutionNode);
            return bl;
        }
        finally {
            this.log.trace("<< r: {}", (Object)"isFailed");
            this.readLock.unlock();
        }
    }

    public String toString() {
        return "EnhancementJob for ContentItem " + this.contentItem.getUri();
    }

    public Exception getError() {
        return this.error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getErrorMessage() {
        this.readLock.lock();
        try {
            String string = EnhancementEngineHelper.getString((TripleCollection)this.executionMetadata, (NonLiteral)this.chainExecutionNode, (UriRef)ExecutionMetadata.STATUS_MESSAGE);
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public MGraph getExecutionMetadata() {
        return this.executionMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startProcessing() {
        this.writeLock.lock();
        try {
            ExecutionMetadataHelper.setExecutionInProgress((MGraph)this.executionMetadata, (NonLiteral)this.chainExecutionNode);
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

