/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.engines.entityhublinking;

import java.util.Map;
import org.apache.stanbol.enhancer.engines.entitylinking.EntitySearcher;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public abstract class TrackingEntitySearcher<T>
implements EntitySearcher {
    private ServiceTracker searchServiceTracker;
    protected BundleContext bundleContext;

    protected TrackingEntitySearcher(BundleContext context, Class<T> serviceClass, Map<String, String> filterEntries, ServiceTrackerCustomizer customizer) {
        this.bundleContext = context;
        if (filterEntries == null || filterEntries.isEmpty()) {
            this.searchServiceTracker = new ServiceTracker(context, serviceClass.getName(), customizer);
        } else {
            Filter filter;
            StringBuffer filterString = new StringBuffer();
            filterString.append(String.format("(&(objectclass=%s)", serviceClass.getName()));
            for (Map.Entry<String, String> filterEntry : filterEntries.entrySet()) {
                if (filterEntry.getKey() != null && !filterEntry.getKey().isEmpty() && filterEntry.getValue() != null && !filterEntry.getValue().isEmpty()) {
                    filterString.append(String.format("(%s=%s)", filterEntry.getKey(), filterEntry.getValue()));
                    continue;
                }
                throw new IllegalArgumentException("Illegal filterEntry " + filterEntry + ". Both key and value MUST NOT be NULL nor emtpty!");
            }
            filterString.append(')');
            try {
                filter = context.createFilter(filterString.toString());
            }
            catch (InvalidSyntaxException e) {
                throw new IllegalArgumentException(String.format("Unable to build Filter for '%s' (class=%s,filter=%s)", filterString, serviceClass, filterEntries), e);
            }
            this.searchServiceTracker = new ServiceTracker(context, filter, customizer);
        }
    }

    public void open() {
        this.searchServiceTracker.open();
    }

    protected T getSearchService() {
        if (this.searchServiceTracker == null) {
            throw new IllegalStateException("This TrackingEntitySearcher is already closed!");
        }
        return (T)this.searchServiceTracker.getService();
    }

    public void close() {
        this.searchServiceTracker.close();
        this.searchServiceTracker = null;
        this.bundleContext = null;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

