/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.engines.entityhublinking;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.clerezza.rdf.core.Resource;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.impl.PlainLiteralImpl;
import org.apache.stanbol.enhancer.engines.entityhublinking.EntitySearcherUtils;
import org.apache.stanbol.enhancer.engines.entityhublinking.EntityhubEntity;
import org.apache.stanbol.enhancer.engines.entityhublinking.TrackingEntitySearcher;
import org.apache.stanbol.enhancer.engines.entitylinking.Entity;
import org.apache.stanbol.enhancer.engines.entitylinking.EntitySearcher;
import org.apache.stanbol.enhancer.engines.entitylinking.impl.Statistic;
import org.apache.stanbol.entityhub.servicesapi.model.Representation;
import org.apache.stanbol.entityhub.servicesapi.model.rdf.RdfResourceEnum;
import org.apache.stanbol.entityhub.servicesapi.query.FieldQuery;
import org.apache.stanbol.entityhub.servicesapi.query.QueryResultList;
import org.apache.stanbol.entityhub.servicesapi.site.Site;
import org.apache.stanbol.entityhub.servicesapi.site.SiteException;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReferencedSiteSearcher
extends TrackingEntitySearcher<Site>
implements EntitySearcher {
    private final Logger log = LoggerFactory.getLogger(ReferencedSiteSearcher.class);
    private final String siteId;
    private final Integer limit;
    private Map<UriRef, Collection<Resource>> originInfo;
    Statistic queryStats = new Statistic("query", 100, this.log);
    Statistic resultStats = new Statistic("result", 1000, this.log);

    public ReferencedSiteSearcher(BundleContext context, String siteId, Integer limit) {
        this(context, siteId, limit, null);
    }

    public ReferencedSiteSearcher(BundleContext context, String siteId, Integer limit, ServiceTrackerCustomizer customizer) {
        super(context, Site.class, Collections.singletonMap("org.apache.stanbol.entityhub.site.id", siteId), customizer);
        this.siteId = siteId;
        this.limit = limit != null && limit > 0 ? limit : null;
        this.originInfo = Collections.singletonMap(new UriRef(RdfResourceEnum.site.getUri()), Collections.singleton(new PlainLiteralImpl(siteId)));
    }

    public Entity get(UriRef id, Set<UriRef> fields, String ... languages) {
        org.apache.stanbol.entityhub.servicesapi.model.Entity entity;
        if (id == null || id.getUnicodeString().isEmpty()) {
            return null;
        }
        Site site = (Site)this.getSearchService();
        if (site == null) {
            throw new IllegalStateException("ReferencedSite " + this.siteId + " is currently not available");
        }
        try {
            entity = site.getEntity(id.getUnicodeString());
        }
        catch (SiteException e) {
            throw new IllegalStateException("Exception while getting " + id + " from the ReferencedSite " + site.getId(), e);
        }
        if (entity != null) {
            Set<String> languageSet = languages == null || languages.length < 1 ? null : (languages.length == 1 ? Collections.singleton(languages[0]) : new HashSet<String>(Arrays.asList(languages)));
            return new EntityhubEntity(entity.getRepresentation(), fields, languageSet);
        }
        return null;
    }

    public Collection<? extends Entity> lookup(UriRef field, Set<UriRef> includeFields, List<String> search, String[] languages, Integer limit, Integer offset) throws IllegalStateException {
        QueryResultList results;
        Site site = (Site)this.getSearchService();
        if (site == null) {
            throw new IllegalStateException("ReferencedSite " + this.siteId + " is currently not available");
        }
        this.queryStats.begin();
        FieldQuery query = EntitySearcherUtils.createFieldQuery(site.getQueryFactory(), field, includeFields, search, languages);
        if (limit != null && limit > 0) {
            query.setLimit(limit);
        } else if (this.limit != null) {
            query.setLimit(this.limit);
        }
        if (offset != null && offset > 0) {
            query.setOffset(offset.intValue());
        }
        try {
            results = site.find(query);
        }
        catch (SiteException e) {
            throw new IllegalStateException("Exception while searchign for " + search + '@' + Arrays.toString(languages) + "in the ReferencedSite " + site.getId(), e);
        }
        this.queryStats.complete();
        if (!results.isEmpty()) {
            HashSet<String> languagesSet = new HashSet<String>(Arrays.asList(languages));
            ArrayList<EntityhubEntity> entities = new ArrayList<EntityhubEntity>(results.size());
            for (Representation result : results) {
                this.resultStats.begin();
                entities.add(new EntityhubEntity(result, null, languagesSet));
                this.resultStats.complete();
            }
            return entities;
        }
        return Collections.emptyList();
    }

    public boolean supportsOfflineMode() {
        Site site = (Site)this.getSearchService();
        return site == null ? false : site.supportsLocalMode();
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Map<UriRef, Collection<Resource>> getOriginInformation() {
        return this.originInfo;
    }
}

