/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.engines.entityhublinking;

import java.util.Iterator;
import java.util.Set;
import org.apache.clerezza.rdf.core.LiteralFactory;
import org.apache.clerezza.rdf.core.NonLiteral;
import org.apache.clerezza.rdf.core.TripleCollection;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.stanbol.enhancer.engines.entitylinking.Entity;
import org.apache.stanbol.enhancer.servicesapi.helper.EnhancementEngineHelper;
import org.apache.stanbol.entityhub.model.clerezza.RdfRepresentation;
import org.apache.stanbol.entityhub.model.clerezza.RdfValueFactory;
import org.apache.stanbol.entityhub.servicesapi.model.Representation;
import org.apache.stanbol.entityhub.servicesapi.model.Text;
import org.apache.stanbol.entityhub.servicesapi.model.rdf.RdfResourceEnum;

public class EntityhubEntity
extends Entity {
    private static RdfValueFactory vf = RdfValueFactory.getInstance();
    private static UriRef entityRanking = new UriRef(RdfResourceEnum.entityRank.getUri());

    public EntityhubEntity(Representation rep, Set<UriRef> fields, Set<String> languages) {
        super(new UriRef(rep.getId()), EntityhubEntity.toGraph(rep, fields, languages));
    }

    public Float getEntityRanking() {
        return (Float)EnhancementEngineHelper.get((TripleCollection)this.data, (NonLiteral)this.uri, (UriRef)entityRanking, Float.class, (LiteralFactory)lf);
    }

    private static TripleCollection toGraph(Representation rep, Set<UriRef> includeFields, Set<String> languages) {
        if (rep instanceof RdfRepresentation) {
            return ((RdfRepresentation)rep).getRdfGraph();
        }
        RdfRepresentation clerezzaRep = vf.createRepresentation(rep.getId());
        Iterator fields = rep.getFieldNames();
        while (fields.hasNext()) {
            String field = (String)fields.next();
            if (includeFields != null && !includeFields.contains(field)) continue;
            Iterator fieldValues = rep.get(field);
            while (fieldValues.hasNext()) {
                Object value = fieldValues.next();
                if (languages != null && value instanceof Text && !languages.contains(((Text)value).getLanguage())) continue;
                clerezzaRep.add(field, value);
            }
        }
        return clerezzaRep.getRdfGraph();
    }
}

