/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.contenthub.web.resources;

import com.sun.jersey.api.view.Viewable;
import com.sun.jersey.core.header.FormDataContentDisposition;
import com.sun.jersey.multipart.FormDataBodyPart;
import com.sun.jersey.multipart.FormDataParam;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.clerezza.rdf.core.TripleCollection;
import org.apache.clerezza.rdf.core.access.TcManager;
import org.apache.clerezza.rdf.core.serializedform.Serializer;
import org.apache.clerezza.rdf.core.sparql.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.stanbol.commons.web.base.ContextHelper;
import org.apache.stanbol.commons.web.base.CorsHelper;
import org.apache.stanbol.commons.web.base.resource.BaseStanbolResource;
import org.apache.stanbol.contenthub.search.featured.util.SolrContentItemConverter;
import org.apache.stanbol.contenthub.search.solr.SolrSearchImpl;
import org.apache.stanbol.contenthub.servicesapi.search.SearchException;
import org.apache.stanbol.contenthub.servicesapi.search.featured.DocumentResult;
import org.apache.stanbol.contenthub.servicesapi.search.solr.SolrSearch;
import org.apache.stanbol.contenthub.servicesapi.store.StoreException;
import org.apache.stanbol.contenthub.servicesapi.store.solr.SolrContentItem;
import org.apache.stanbol.contenthub.servicesapi.store.solr.SolrStore;
import org.apache.stanbol.contenthub.servicesapi.store.vocabulary.SolrVocabulary;
import org.apache.stanbol.contenthub.web.util.JSONUtils;
import org.apache.stanbol.enhancer.jersey.resource.ContentItemResource;
import org.apache.stanbol.enhancer.servicesapi.ContentItem;
import org.apache.stanbol.enhancer.servicesapi.EngineException;
import org.apache.stanbol.enhancer.servicesapi.helper.ContentItemHelper;
import org.codehaus.jettison.json.JSONException;
import org.osgi.framework.InvalidSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/contenthub/{index}/store")
public class StoreResource
extends BaseStanbolResource {
    public static final Set<String> RDF_MEDIA_TYPES = new TreeSet<String>(Arrays.asList("text/rdf+n3", "text/rdf+nt", "application/rdf+xml", "text/turtle", "application/x-turtle", "application/rdf+json"));
    private static final Logger log = LoggerFactory.getLogger(StoreResource.class);
    private TcManager tcManager;
    private SolrStore solrStore;
    private SolrSearch solrSearch;
    private Serializer serializer;
    private UriInfo uriInfo;
    private int offset = 0;
    private int pageSize = 5;
    private List<DocumentResult> recentlyEnhanced;
    private String indexName;

    public StoreResource(@Context ServletContext context, @Context UriInfo uriInfo, @PathParam(value="index") String indexName) {
        this.indexName = indexName;
        this.solrStore = (SolrStore)ContextHelper.getServiceFromContext(SolrStore.class, (ServletContext)context);
        this.solrSearch = (SolrSearch)ContextHelper.getServiceFromContext(SolrSearch.class, (ServletContext)context);
        this.tcManager = (TcManager)ContextHelper.getServiceFromContext(TcManager.class, (ServletContext)context);
        this.serializer = (Serializer)ContextHelper.getServiceFromContext(Serializer.class, (ServletContext)context);
        this.uriInfo = uriInfo;
        if (this.solrStore == null) {
            log.error("Missing Solr Store Service");
            throw new WebApplicationException(404);
        }
        if (this.solrSearch == null) {
            log.error("Missing Solr Search Service");
            throw new WebApplicationException(404);
        }
        if (this.tcManager == null) {
            log.error("Missing tcManager");
            throw new WebApplicationException(404);
        }
    }

    @OPTIONS
    public Response handleCorsPreflight(@Context HttpHeaders headers) {
        Response.ResponseBuilder res = Response.ok();
        CorsHelper.enableCORS((ServletContext)this.servletContext, (Response.ResponseBuilder)res, (HttpHeaders)headers, (String[])new String[0]);
        return res.build();
    }

    @OPTIONS
    @Path(value="/content/{uri:.+}")
    public Response handleCorsPreflightContent(@Context HttpHeaders headers) {
        Response.ResponseBuilder res = Response.ok();
        CorsHelper.enableCORS((ServletContext)this.servletContext, (Response.ResponseBuilder)res, (HttpHeaders)headers, (String[])new String[0]);
        return res.build();
    }

    @OPTIONS
    @Path(value="/download/{type}/{uri:.+}")
    public Response handleCorsPreflightDownload(@Context HttpHeaders headers) {
        Response.ResponseBuilder res = Response.ok();
        CorsHelper.enableCORS((ServletContext)this.servletContext, (Response.ResponseBuilder)res, (HttpHeaders)headers, (String[])new String[0]);
        return res.build();
    }

    @OPTIONS
    @Path(value="/metadata/{uri:.+}")
    public Response handleCorsPreflightMetadata(@Context HttpHeaders headers) {
        Response.ResponseBuilder res = Response.ok();
        CorsHelper.enableCORS((ServletContext)this.servletContext, (Response.ResponseBuilder)res, (HttpHeaders)headers, (String[])new String[0]);
        return res.build();
    }

    @OPTIONS
    @Path(value="/raw/{uri:.+}")
    public Response handleCorsPreflightRaw(@Context HttpHeaders headers) {
        Response.ResponseBuilder res = Response.ok();
        CorsHelper.enableCORS((ServletContext)this.servletContext, (Response.ResponseBuilder)res, (HttpHeaders)headers, (String[])new String[0]);
        return res.build();
    }

    @OPTIONS
    @Path(value="/edit/{uri:.+}")
    public Response handleCorsPreflightEdit(@Context HttpHeaders headers) {
        Response.ResponseBuilder res = Response.ok();
        CorsHelper.enableCORS((ServletContext)this.servletContext, (Response.ResponseBuilder)res, (HttpHeaders)headers, (String[])new String[0]);
        return res.build();
    }

    @OPTIONS
    @Path(value="/{uri:.+}")
    public Response handleCorsPreflightURI(@Context HttpHeaders headers) {
        Response.ResponseBuilder res = Response.ok();
        CorsHelper.enableCORS((ServletContext)this.servletContext, (Response.ResponseBuilder)res, (HttpHeaders)headers, (String[])new String[0]);
        return res.build();
    }

    @OPTIONS
    @Path(value="/update")
    public Response handleCorsPreflightUpdate(@Context HttpHeaders headers) {
        Response.ResponseBuilder res = Response.ok();
        CorsHelper.enableCORS((ServletContext)this.servletContext, (Response.ResponseBuilder)res, (HttpHeaders)headers, (String[])new String[0]);
        return res.build();
    }

    @GET
    @Path(value="/content/{uri:.+}")
    public Response getContent(@PathParam(value="uri") String contentURI, @Context HttpHeaders headers) throws StoreException {
        SolrContentItem ci = this.solrStore.get(contentURI, this.indexName);
        if (ci == null) {
            throw new WebApplicationException(404);
        }
        for (MediaType mt : headers.getAcceptableMediaTypes()) {
            if (!mt.toString().startsWith("text/html")) continue;
            URI pageUri = this.uriInfo.getBaseUriBuilder().path("/contenthub").path(this.indexName).path("store/page").path(contentURI).build(new Object[0]);
            Response.ResponseBuilder rb = Response.temporaryRedirect((URI)pageUri);
            CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
            return rb.build();
        }
        for (MediaType mt : headers.getAcceptableMediaTypes()) {
            if (!RDF_MEDIA_TYPES.contains(mt.toString())) continue;
            URI metadataUri = this.uriInfo.getBaseUriBuilder().path("/contenthub").path(this.indexName).path("store/metadata").path(contentURI).build(new Object[0]);
            Response.ResponseBuilder rb = Response.temporaryRedirect((URI)metadataUri);
            CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
            return rb.build();
        }
        URI rawUri = this.uriInfo.getBaseUriBuilder().path("/contenthub").path(this.indexName).path("store/raw").path(contentURI).build(new Object[0]);
        Response.ResponseBuilder rb = Response.temporaryRedirect((URI)rawUri);
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        return rb.build();
    }

    @GET
    @Path(value="/download/{type}/{uri:.+}")
    public Response downloadContentItem(@PathParam(value="type") String type, @PathParam(value="uri") String contentURI, @Context HttpHeaders headers) throws IOException, StoreException {
        SolrContentItem ci = this.solrStore.get(contentURI, this.indexName);
        if (ci == null) {
            throw new WebApplicationException(404);
        }
        if (type.equals("metadata")) {
            boolean success;
            String fileName = contentURI + "-metadata";
            File file = new File(fileName);
            if (file.exists()) {
                file.delete();
            }
            if (success = file.createNewFile()) {
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
                this.serializer.serialize((OutputStream)bos, (TripleCollection)ci.getMetadata(), "application/rdf+xml");
                bos.close();
            } else {
                log.error("Failed to create file: {}", (Object)fileName);
            }
            Response.ResponseBuilder response = Response.ok((Object)file);
            response.header("Content-Disposition", (Object)("attachment; filename=\"" + fileName + "\""));
            response.type("text/plain");
            CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)response, (HttpHeaders)headers);
            return response.build();
        }
        if (type.equals("raw")) {
            boolean success;
            String fileName = URLEncoder.encode(contentURI, "utf-8") + "-raw";
            File file = new File(fileName);
            if (file.exists()) {
                file.delete();
            }
            if (success = file.createNewFile()) {
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
                bos.write(IOUtils.toByteArray((InputStream)ci.getStream()));
                bos.close();
            } else {
                log.error("Failed to create file: {}", (Object)fileName);
            }
            Response.ResponseBuilder response = Response.ok((Object)file);
            response.header("Content-Disposition", (Object)("attachment; filename=\"" + fileName + "\""));
            response.type(ci.getMimeType());
            CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)response, (HttpHeaders)headers);
            return response.build();
        }
        throw new WebApplicationException(404);
    }

    @GET
    @Path(value="/metadata/{uri:.+}")
    public Response getContentItemMetaData(@PathParam(value="uri") String contentURI, @Context HttpHeaders headers) throws IOException, StoreException {
        SolrContentItem ci = this.solrStore.get(contentURI, this.indexName);
        if (ci == null) {
            throw new WebApplicationException(404);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.serializer.serialize((OutputStream)out, (TripleCollection)ci.getMetadata(), "application/rdf+xml");
        Response.ResponseBuilder rb = Response.ok((Object)out.toString(), (String)"text/plain");
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        return rb.build();
    }

    @GET
    @Path(value="/raw/{uri:.+}")
    public Response getRawContent(@PathParam(value="uri") String contentURI, @Context HttpHeaders headers) throws IOException, StoreException {
        SolrContentItem ci = this.solrStore.get(contentURI, this.indexName);
        if (ci == null) {
            throw new WebApplicationException(404);
        }
        Response.ResponseBuilder rb = Response.ok((Object)ci.getStream(), (String)ci.getMimeType());
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        return rb.build();
    }

    @GET
    @Path(value="/edit/{uri:.+}")
    public Response editContentItem(@PathParam(value="uri") String contentURI, @Context HttpHeaders headers) throws StoreException {
        String jsonString;
        SolrContentItem sci = this.solrStore.get(contentURI, this.indexName);
        if (sci == null) {
            throw new WebApplicationException(404);
        }
        try {
            jsonString = JSONUtils.createJSONString(sci);
        }
        catch (JSONException e) {
            throw new StoreException(e.getMessage(), (Throwable)e);
        }
        Response.ResponseBuilder rb = Response.ok((Object)jsonString);
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        return rb.build();
    }

    @POST
    @Consumes(value={"*/*;qs=0.5"})
    public Response createContentItem(byte[] data, @Context HttpHeaders headers) throws URISyntaxException, EngineException, StoreException {
        String contentURI = ContentItemHelper.makeDefaultUrn((byte[])data).getUnicodeString();
        return this.createEnhanceAndRedirect(data, headers.getMediaType(), contentURI, headers);
    }

    @POST
    @Path(value="/{uri:.+}")
    @Consumes(value={"*/*"})
    public Response createContentItemWithId(@PathParam(value="uri") String contentURI, byte[] data, @Context HttpHeaders headers) throws URISyntaxException, EngineException, StoreException {
        return this.createEnhanceAndRedirect(data, headers.getMediaType(), contentURI, headers);
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response createContentItemFromForm(@FormParam(value="content") String content, @FormParam(value="url") String url, @FormParam(value="constraints") String jsonCons, @FormParam(value="title") String title, @Context HttpHeaders headers) throws URISyntaxException, EngineException, MalformedURLException, IOException, StoreException {
        HashMap<String, List<Object>> constraints = new HashMap();
        if (jsonCons != null) {
            constraints = JSONUtils.convertToMap(jsonCons);
        }
        return this.createContentItemFromForm(content, url, null, null, null, headers, constraints, title);
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    public Response createContentItemFromForm(@FormDataParam(value="file") File file, @FormDataParam(value="file") FormDataContentDisposition disposition, @FormDataParam(value="file") FormDataBodyPart body, @FormDataParam(value="constraints") String jsonCons, @FormDataParam(value="title") String title, @Context HttpHeaders headers) throws URISyntaxException, EngineException, MalformedURLException, IOException, StoreException {
        HashMap<String, List<Object>> constraints = new HashMap();
        if (jsonCons != null) {
            constraints = JSONUtils.convertToMap(jsonCons);
        }
        return this.createContentItemFromForm(null, null, file, disposition, body, headers, constraints, title);
    }

    private Response createContentItemFromForm(String content, String url, File file, FormDataContentDisposition disposition, FormDataBodyPart body, HttpHeaders headers, Map<String, List<Object>> constraints, String title) throws URISyntaxException, EngineException, MalformedURLException, IOException, StoreException {
        byte[] data = null;
        MediaType mt = null;
        if (content != null && !content.trim().isEmpty()) {
            data = content.getBytes();
            mt = MediaType.TEXT_PLAIN_TYPE;
        } else if (url != null && !url.trim().isEmpty()) {
            try {
                URLConnection uc = new URL(url).openConnection();
                data = IOUtils.toByteArray((InputStream)uc.getInputStream());
                mt = MediaType.valueOf((String)uc.getContentType());
            }
            catch (IOException e) {}
        } else if (file != null) {
            mt = body.getMediaType();
            data = FileUtils.readFileToByteArray((File)file);
            if (title == null || title.isEmpty()) {
                title = disposition.getFileName();
            }
        }
        if (data != null && mt != null) {
            String uri = ContentItemHelper.makeDefaultUrn((byte[])data).getUnicodeString();
            return this.createEnhanceAndRedirect(data, mt, uri, true, constraints, title, headers);
        }
        Response.ResponseBuilder rb = Response.seeOther((URI)new URI("/contenthub/" + this.indexName + "/store"));
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        return rb.build();
    }

    private Response createEnhanceAndRedirect(byte[] content, MediaType mediaType, String contentURI, boolean useExplicitRedirect, Map<String, List<Object>> constraints, String title, HttpHeaders headers) throws EngineException, URISyntaxException, StoreException {
        SolrContentItem sci = this.solrStore.create(content, contentURI, title, mediaType.toString(), constraints);
        this.solrStore.enhanceAndPut(sci, this.indexName);
        if (useExplicitRedirect) {
            Response.ResponseBuilder rb = Response.seeOther((URI)this.makeRedirectionURI(sci.getUri().getUnicodeString()));
            CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
            return rb.build();
        }
        Response.ResponseBuilder rb = Response.created((URI)this.makeRedirectionURI(sci.getUri().getUnicodeString()));
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        return rb.build();
    }

    private URI makeRedirectionURI(String contentURI) throws URISyntaxException {
        return new URI(this.uriInfo.getBaseUri() + "contenthub/" + this.indexName + "/store/content/" + contentURI);
    }

    @POST
    @Path(value="/update")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response updateContentItemFromForm(@FormParam(value="uri") String contentURI, @FormParam(value="content") String content, @FormParam(value="url") String url, @FormParam(value="constraints") String jsonCons, @FormParam(value="title") String title, @Context HttpHeaders headers) throws URISyntaxException, EngineException, MalformedURLException, IOException, StoreException {
        if (contentURI != null && !contentURI.isEmpty()) {
            this.deleteContentItem(contentURI, headers);
        }
        return this.createContentItemFromForm(content, url, jsonCons, title, headers);
    }

    @POST
    @Path(value="/update")
    @Consumes(value={"multipart/form-data"})
    public Response updateContentItemFromForm(@FormDataParam(value="uri") String contentURI, @FormDataParam(value="file") File file, @FormDataParam(value="file") FormDataContentDisposition disposition, @FormDataParam(value="file") FormDataBodyPart body, @FormDataParam(value="constraints") String jsonCons, @FormDataParam(value="title") String title, @Context HttpHeaders headers) throws URISyntaxException, EngineException, MalformedURLException, IOException, StoreException {
        if (contentURI != null && !contentURI.isEmpty()) {
            this.deleteContentItem(contentURI, headers);
        }
        return this.createContentItemFromForm(file, disposition, body, jsonCons, title, headers);
    }

    @DELETE
    @Path(value="/{uri:.+}")
    public Response deleteContentItem(@PathParam(value="uri") String contentURI, @Context HttpHeaders headers) throws StoreException {
        this.solrStore.deleteById(contentURI, this.indexName);
        Response.ResponseBuilder rb = Response.ok();
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        return rb.build();
    }

    private Response createEnhanceAndRedirect(byte[] data, MediaType mediaType, String contentURI, HttpHeaders headers) throws EngineException, URISyntaxException, StoreException {
        return this.createEnhanceAndRedirect(data, mediaType, contentURI, false, null, null, headers);
    }

    @GET
    @Produces(value={"text/html;qs=2"})
    public Viewable getView(@Context ServletContext context, @QueryParam(value="offset") int offset, @QueryParam(value="pageSize") @DefaultValue(value="5") int pageSize) throws IllegalArgumentException, IOException, InvalidSyntaxException {
        QueryResponse res;
        this.offset = offset;
        this.pageSize = pageSize;
        this.recentlyEnhanced = new ArrayList<DocumentResult>();
        if (!(this.solrSearch instanceof SolrSearchImpl)) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Failed to obtain default implementation for SolrSearch").build());
        }
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("q", new String[]{"*:*"});
        params.set("sort", new String[]{SolrVocabulary.SolrFieldName.CREATIONDATE.toString() + " desc"});
        params.set("start", offset);
        params.set("rows", pageSize + 1);
        try {
            res = this.solrSearch.search((SolrParams)params, this.indexName);
        }
        catch (SearchException e) {
            log.error("Failed to retrieve submitted documents", (Throwable)e);
            return new Viewable("index", (Object)this);
        }
        for (SolrDocument result : res.getResults()) {
            this.recentlyEnhanced.add(SolrContentItemConverter.solrDocument2solrContentItem((SolrDocument)result, (String)this.uriInfo.getBaseUri().toString(), (String)this.indexName));
        }
        return new Viewable("index", (Object)this);
    }

    @Path(value="/page/{uri:.+}")
    @Produces(value={"text/html"})
    public ContentItemResource getContentItemView(@PathParam(value="uri") String contentURI) throws IOException, StoreException {
        SolrContentItem ci = this.solrStore.get(contentURI, this.indexName);
        if (ci == null) {
            throw new WebApplicationException(404);
        }
        return new ContentItemResource(contentURI, (ContentItem)ci, this.uriInfo, "/contenthub/" + this.indexName + "/store/download", this.tcManager, this.serializer, this.servletContext);
    }

    public List<DocumentResult> getRecentlyEnhancedItems() throws ParseException {
        if (this.recentlyEnhanced.size() > this.pageSize) {
            return this.recentlyEnhanced.subList(0, this.pageSize);
        }
        return this.recentlyEnhanced;
    }

    public URI getMoreRecentItemsUri() {
        if (this.offset >= this.pageSize) {
            return this.uriInfo.getBaseUriBuilder().path("contenthub").path(this.indexName).path("store").queryParam("offset", new Object[]{this.offset - this.pageSize}).build(new Object[0]);
        }
        return null;
    }

    public URI getOlderItemsUri() {
        if (this.recentlyEnhanced.size() <= this.pageSize) {
            return null;
        }
        return this.uriInfo.getBaseUriBuilder().path("contenthub").path(this.indexName).path("store").queryParam("offset", new Object[]{this.offset + this.pageSize}).build(new Object[0]);
    }

    public String getIndexName() {
        return this.indexName;
    }
}

