/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.contenthub.web.resources;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.stanbol.commons.viewable.Viewable;
import org.apache.stanbol.commons.web.base.ContextHelper;
import org.apache.stanbol.commons.web.base.CorsHelper;
import org.apache.stanbol.commons.web.base.resource.BaseStanbolResource;
import org.apache.stanbol.contenthub.servicesapi.ldpath.LDPathException;
import org.apache.stanbol.contenthub.servicesapi.ldpath.LDProgram;
import org.apache.stanbol.contenthub.servicesapi.ldpath.LDProgramCollection;
import org.apache.stanbol.contenthub.servicesapi.ldpath.SemanticIndexManager;
import org.apache.stanbol.contenthub.web.util.RestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/contenthub/ldpath")
public class SemanticIndexManagerResource
extends BaseStanbolResource {
    private static final Logger logger = LoggerFactory.getLogger(SemanticIndexManagerResource.class);
    private SemanticIndexManager programManager;

    public SemanticIndexManagerResource(@Context ServletContext context) {
        this.programManager = (SemanticIndexManager)ContextHelper.getServiceFromContext(SemanticIndexManager.class, (ServletContext)context);
        if (this.programManager == null) {
            logger.error("Missing SemanticIndexManager service");
            throw new IllegalStateException("Missing SemanticIndexManager service");
        }
    }

    @OPTIONS
    public Response handleCorsPreflight(@Context HttpHeaders headers) {
        Response.ResponseBuilder res = Response.ok();
        CorsHelper.enableCORS((ServletContext)this.servletContext, (Response.ResponseBuilder)res, (HttpHeaders)headers, (String[])new String[0]);
        return res.build();
    }

    @OPTIONS
    @Path(value="/program")
    public Response handleCorsPreflightProgram(@Context HttpHeaders headers) {
        Response.ResponseBuilder res = Response.ok();
        CorsHelper.enableCORS((ServletContext)this.servletContext, (Response.ResponseBuilder)res, (HttpHeaders)headers, (String[])new String[]{"GET", "DELETE", "OPTIONS", "POST"});
        return res.build();
    }

    @OPTIONS
    @Path(value="/program/{name}")
    public Response handleCorsPreflightDeleteProgram(@Context HttpHeaders headers) {
        Response.ResponseBuilder res = Response.ok();
        CorsHelper.enableCORS((ServletContext)this.servletContext, (Response.ResponseBuilder)res, (HttpHeaders)headers, (String[])new String[]{"GET", "DELETE", "OPTIONS"});
        return res.build();
    }

    @OPTIONS
    @Path(value="/exists")
    public Response handleCorsPreflightExists(@Context HttpHeaders headers) {
        Response.ResponseBuilder res = Response.ok();
        CorsHelper.enableCORS((ServletContext)this.servletContext, (Response.ResponseBuilder)res, (HttpHeaders)headers, (String[])new String[0]);
        return res.build();
    }

    @OPTIONS
    @Path(value="/exists/{name}")
    public Response handleCorsPreflightExistsPath(@Context HttpHeaders headers) {
        Response.ResponseBuilder res = Response.ok();
        CorsHelper.enableCORS((ServletContext)this.servletContext, (Response.ResponseBuilder)res, (HttpHeaders)headers, (String[])new String[0]);
        return res.build();
    }

    @GET
    @Produces(value={"text/html", "application/json"})
    public Response retrieveAllPrograms(@Context HttpHeaders headers) {
        MediaType acceptedHeader = RestUtil.getAcceptedMediaType(headers, MediaType.APPLICATION_JSON_TYPE);
        if (acceptedHeader.isCompatible(MediaType.TEXT_HTML_TYPE)) {
            return Response.ok((Object)new Viewable("index", (Object)this), (String)"text/html").build();
        }
        LDProgramCollection ldProgramCollection = this.programManager.retrieveAllPrograms();
        Response.ResponseBuilder rb = Response.ok((Object)ldProgramCollection, (String)"application/json");
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        return rb.build();
    }

    @POST
    @Path(value="/program")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response submitProgram(@FormParam(value="name") String programName, @FormParam(value="program") String program, @Context HttpHeaders headers) throws LDPathException, URISyntaxException {
        programName = RestUtil.nullify(programName);
        program = RestUtil.nullify(program);
        if (programName == null) {
            return RestUtil.createResponse(this.servletContext, Response.Status.BAD_REQUEST, "Missing 'name' parameter", headers);
        }
        if (program == null) {
            return RestUtil.createResponse(this.servletContext, Response.Status.BAD_REQUEST, "Missing 'program' parameter", headers);
        }
        this.programManager.submitProgram(programName, program);
        Response.ResponseBuilder rb = Response.created((URI)new URI(this.uriInfo.getBaseUri() + "contenthub/" + programName + "/store"));
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        return rb.build();
    }

    @GET
    @Path(value="/program")
    public Response getProgramByName(@QueryParam(value="name") String programName, @Context HttpHeaders headers) {
        if ((programName = RestUtil.nullify(programName)) == null) {
            return RestUtil.createResponse(this.servletContext, Response.Status.BAD_REQUEST, "Missing 'name' parameter", headers);
        }
        String ldPathProgram = this.programManager.getProgramByName(programName);
        if (ldPathProgram == null) {
            return RestUtil.createResponse(this.servletContext, Response.Status.NOT_FOUND, null, headers);
        }
        return RestUtil.createResponse(this.servletContext, Response.Status.OK, ldPathProgram, headers);
    }

    @GET
    @Path(value="/program/{name}")
    public Response getProgramByNamePath(@PathParam(value="name") String programName, @Context HttpHeaders headers) {
        return this.getProgramByName(programName, headers);
    }

    @DELETE
    @Path(value="/program")
    public Response deleteProgram(@QueryParam(value="name") String programName, @Context HttpHeaders headers) {
        return this.deleteProgramPath(programName, headers);
    }

    @DELETE
    @Path(value="/program/{name}")
    public Response deleteProgramPath(@PathParam(value="name") String programName, @Context HttpHeaders headers) {
        if ((programName = RestUtil.nullify(programName)) == null) {
            return RestUtil.createResponse(this.servletContext, Response.Status.BAD_REQUEST, "Missing 'name' parameter", headers);
        }
        if (!this.programManager.isManagedProgram(programName)) {
            return RestUtil.createResponse(this.servletContext, Response.Status.NOT_FOUND, null, headers);
        }
        this.programManager.deleteProgram(programName);
        return RestUtil.createResponse(this.servletContext, Response.Status.OK, null, headers);
    }

    @GET
    @Path(value="/exists")
    public Response isManagedProgram(@QueryParam(value="name") String programName, @Context HttpHeaders headers) {
        if ((programName = RestUtil.nullify(programName)) == null) {
            return RestUtil.createResponse(this.servletContext, Response.Status.BAD_REQUEST, "Missing 'name' parameter", headers);
        }
        if (this.programManager.isManagedProgram(programName)) {
            return RestUtil.createResponse(this.servletContext, Response.Status.OK, null, headers);
        }
        return RestUtil.createResponse(this.servletContext, Response.Status.NOT_FOUND, null, headers);
    }

    @GET
    @Path(value="/exists/{name}")
    public Response isManagedProgramPath(@PathParam(value="name") String programName, @Context HttpHeaders headers) {
        return this.isManagedProgram(programName, headers);
    }

    public List<LDProgram> getLdPrograms() {
        return this.programManager.retrieveAllPrograms().asList();
    }
}

