/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.contenthub.web.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.stanbol.commons.web.base.CorsHelper;

public class RestUtil {
    public static final Set<String> supportedMediaTypes;

    public static String nullify(String parameter) {
        if (parameter != null && ((parameter = parameter.trim()).isEmpty() || parameter.equals("null"))) {
            parameter = null;
        }
        return parameter;
    }

    public static boolean isJSONaccepted(HttpHeaders headers) {
        if (!headers.getAcceptableMediaTypes().isEmpty()) {
            for (MediaType accepted : headers.getAcceptableMediaTypes()) {
                if (accepted.isWildcardType() || !accepted.isCompatible(MediaType.APPLICATION_JSON_TYPE)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isHTMLaccepted(HttpHeaders headers) {
        if (!headers.getAcceptableMediaTypes().isEmpty()) {
            for (MediaType accepted : headers.getAcceptableMediaTypes()) {
                if (accepted.isWildcardType() || !accepted.isCompatible(MediaType.TEXT_HTML_TYPE)) continue;
                return true;
            }
        }
        return false;
    }

    public static MediaType getAcceptedMediaType(HttpHeaders headers, MediaType defaultMediaType) {
        MediaType acceptedMediaType = defaultMediaType;
        if (!headers.getAcceptableMediaTypes().isEmpty()) {
            for (MediaType accepted : headers.getAcceptableMediaTypes()) {
                if (accepted.isWildcardType()) continue;
                if (accepted.isCompatible(MediaType.TEXT_HTML_TYPE)) {
                    acceptedMediaType = MediaType.TEXT_HTML_TYPE;
                    break;
                }
                if (!accepted.isCompatible(MediaType.APPLICATION_JSON_TYPE)) continue;
                acceptedMediaType = MediaType.APPLICATION_JSON_TYPE;
                break;
            }
        }
        return acceptedMediaType;
    }

    public static Response createResponse(ServletContext servletContext, Response.Status status, Object entity, HttpHeaders headers) {
        Response.ResponseBuilder rb = Response.status((Response.Status)status);
        CorsHelper.addCORSOrigin((ServletContext)servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        if (entity != null) {
            return rb.entity(entity).build();
        }
        return rb.build();
    }

    static {
        HashSet<String> types = new HashSet<String>();
        types.add("application/json");
        supportedMediaTypes = Collections.unmodifiableSet(types);
    }
}

