/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.contenthub.web.resources;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.clerezza.rdf.core.TripleCollection;
import org.apache.clerezza.rdf.core.access.TcManager;
import org.apache.clerezza.rdf.core.serializedform.Serializer;
import org.apache.clerezza.rdf.core.sparql.ParseException;
import org.apache.commons.io.IOUtils;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.stanbol.commons.viewable.Viewable;
import org.apache.stanbol.commons.web.base.ContextHelper;
import org.apache.stanbol.commons.web.base.CorsHelper;
import org.apache.stanbol.commons.web.base.resource.BaseStanbolResource;
import org.apache.stanbol.contenthub.search.featured.util.SolrContentItemConverter;
import org.apache.stanbol.contenthub.servicesapi.search.SearchException;
import org.apache.stanbol.contenthub.servicesapi.search.featured.DocumentResult;
import org.apache.stanbol.contenthub.servicesapi.search.solr.SolrSearch;
import org.apache.stanbol.contenthub.servicesapi.store.StoreException;
import org.apache.stanbol.contenthub.servicesapi.store.solr.SolrStore;
import org.apache.stanbol.contenthub.servicesapi.store.vocabulary.SolrVocabulary;
import org.apache.stanbol.contenthub.web.resources.ContentItemResource;
import org.apache.stanbol.contenthub.web.util.RestUtil;
import org.apache.stanbol.enhancer.servicesapi.ContentItem;
import org.apache.stanbol.enhancer.servicesapi.EngineException;
import org.apache.stanbol.enhancer.servicesapi.helper.ContentItemHelper;
import org.osgi.framework.InvalidSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/contenthub/{index}/store")
public class StoreResource
extends BaseStanbolResource {
    public static final Set<String> RDF_MEDIA_TYPES = new TreeSet<String>(Arrays.asList("text/rdf+n3", "text/rdf+nt", "application/rdf+xml", "text/turtle", "application/x-turtle", "application/rdf+json"));
    private static final Logger log = LoggerFactory.getLogger(StoreResource.class);
    private TcManager tcManager;
    private SolrStore solrStore;
    private SolrSearch solrSearch;
    private Serializer serializer;
    private UriInfo uriInfo;
    private int offset = 0;
    private int pageSize = 5;
    private List<DocumentResult> recentlyEnhanced;
    private String indexName;

    public StoreResource(@Context ServletContext context, @Context UriInfo uriInfo, @PathParam(value="index") String indexName) {
        this.indexName = indexName;
        this.solrStore = (SolrStore)ContextHelper.getServiceFromContext(SolrStore.class, (ServletContext)context);
        this.solrSearch = (SolrSearch)ContextHelper.getServiceFromContext(SolrSearch.class, (ServletContext)context);
        this.tcManager = (TcManager)ContextHelper.getServiceFromContext(TcManager.class, (ServletContext)context);
        this.serializer = (Serializer)ContextHelper.getServiceFromContext(Serializer.class, (ServletContext)context);
        this.uriInfo = uriInfo;
        if (indexName == null) {
            log.error("Missing 'index' parameter");
            throw new IllegalArgumentException("Missing 'index' parameter");
        }
        if (this.solrStore == null) {
            log.error("Missing SolrStore service");
            throw new IllegalStateException("Missing SolrStore service");
        }
        if (this.solrSearch == null) {
            log.error("Missing SolrSearch service");
            throw new IllegalStateException("Missing SolrSearch service");
        }
        if (this.tcManager == null) {
            log.error("Missing TcManager service");
            throw new IllegalStateException("Missing TcManager service");
        }
    }

    @OPTIONS
    public Response handleCorsPreflight(@Context HttpHeaders headers) {
        Response.ResponseBuilder res = Response.ok();
        CorsHelper.enableCORS((ServletContext)this.servletContext, (Response.ResponseBuilder)res, (HttpHeaders)headers, (String[])new String[]{"DELETE", "GET", "OPTIONS", "POST"});
        return res.build();
    }

    @OPTIONS
    @Path(value="/content/{uri:.+}")
    public Response handleCorsPreflightContent(@Context HttpHeaders headers) {
        Response.ResponseBuilder res = Response.ok();
        CorsHelper.enableCORS((ServletContext)this.servletContext, (Response.ResponseBuilder)res, (HttpHeaders)headers, (String[])new String[0]);
        return res.build();
    }

    @OPTIONS
    @Path(value="/download/{type}/{uri:.+}")
    public Response handleCorsPreflightDownload(@Context HttpHeaders headers) {
        Response.ResponseBuilder res = Response.ok();
        CorsHelper.enableCORS((ServletContext)this.servletContext, (Response.ResponseBuilder)res, (HttpHeaders)headers, (String[])new String[0]);
        return res.build();
    }

    @OPTIONS
    @Path(value="/metadata/{uri:.+}")
    public Response handleCorsPreflightMetadata(@Context HttpHeaders headers) {
        Response.ResponseBuilder res = Response.ok();
        CorsHelper.enableCORS((ServletContext)this.servletContext, (Response.ResponseBuilder)res, (HttpHeaders)headers, (String[])new String[0]);
        return res.build();
    }

    @OPTIONS
    @Path(value="/raw/{uri:.+}")
    public Response handleCorsPreflightRaw(@Context HttpHeaders headers) {
        Response.ResponseBuilder res = Response.ok();
        CorsHelper.enableCORS((ServletContext)this.servletContext, (Response.ResponseBuilder)res, (HttpHeaders)headers, (String[])new String[0]);
        return res.build();
    }

    @OPTIONS
    @Path(value="/{uri:.+}")
    public Response handleCorsPreflightURI(@Context HttpHeaders headers) {
        Response.ResponseBuilder res = Response.ok();
        CorsHelper.enableCORS((ServletContext)this.servletContext, (Response.ResponseBuilder)res, (HttpHeaders)headers, (String[])new String[]{"DELETE", "OPTIONS"});
        return res.build();
    }

    @GET
    @Path(value="/content/{uri:.+}")
    public Response getContent(@PathParam(value="uri") String uri, @Context HttpHeaders headers) throws StoreException {
        if ((uri = RestUtil.nullify(uri)) == null) {
            return RestUtil.createResponse(this.servletContext, Response.Status.BAD_REQUEST, "Missing 'uri' parameter", headers);
        }
        ContentItem ci = this.solrStore.get(uri, this.indexName);
        if (ci == null) {
            return RestUtil.createResponse(this.servletContext, Response.Status.NOT_FOUND, null, headers);
        }
        for (MediaType mt : headers.getAcceptableMediaTypes()) {
            if (!mt.toString().startsWith("text/html")) continue;
            URI pageUri = this.uriInfo.getBaseUriBuilder().path("/contenthub").path(this.indexName).path("store/page").path(uri).build(new Object[0]);
            Response.ResponseBuilder rb = Response.temporaryRedirect((URI)pageUri);
            CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
            return rb.build();
        }
        for (MediaType mt : headers.getAcceptableMediaTypes()) {
            if (!RDF_MEDIA_TYPES.contains(mt.toString())) continue;
            URI metadataUri = this.uriInfo.getBaseUriBuilder().path("/contenthub").path(this.indexName).path("store/metadata").path(uri).queryParam("format", new Object[]{mt.toString()}).build(new Object[0]);
            Response.ResponseBuilder rb = Response.temporaryRedirect((URI)metadataUri);
            CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
            return rb.build();
        }
        URI rawUri = this.uriInfo.getBaseUriBuilder().path("/contenthub").path(this.indexName).path("store/raw").path(uri).build(new Object[0]);
        Response.ResponseBuilder rb = Response.temporaryRedirect((URI)rawUri);
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        return rb.build();
    }

    @GET
    @Path(value="/download/{type}/{uri:.+}")
    public Response downloadContentItem(@PathParam(value="type") String type, @PathParam(value="uri") String uri, @QueryParam(value="format") @DefaultValue(value="application/rdf+xml") String format, @Context HttpHeaders headers) throws IOException, StoreException {
        type = RestUtil.nullify(type);
        uri = RestUtil.nullify(uri);
        format = RestUtil.nullify(format);
        if (type == null) {
            return RestUtil.createResponse(this.servletContext, Response.Status.BAD_REQUEST, "Missing 'type' parameter", headers);
        }
        if (uri == null) {
            return RestUtil.createResponse(this.servletContext, Response.Status.BAD_REQUEST, "Missing 'uri' parameter", headers);
        }
        ContentItem ci = this.solrStore.get(uri, this.indexName);
        if (ci == null) {
            return RestUtil.createResponse(this.servletContext, Response.Status.NOT_FOUND, null, headers);
        }
        if (type.equals("metadata")) {
            String fileName = URLEncoder.encode(uri, "utf-8") + "-metadata";
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.serializer.serialize((OutputStream)baos, (TripleCollection)ci.getMetadata(), format);
            ByteArrayInputStream is = new ByteArrayInputStream(baos.toByteArray());
            Response.ResponseBuilder response = Response.ok((Object)is);
            response.header("Content-Disposition", (Object)("attachment; filename=\"" + fileName + "\""));
            response.type("text/plain");
            CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)response, (HttpHeaders)headers);
            return response.build();
        }
        if (type.equals("raw")) {
            String fileName = URLEncoder.encode(uri, "utf-8") + "-raw";
            Response.ResponseBuilder response = Response.ok((Object)ci.getStream());
            response.header("Content-Disposition", (Object)("attachment; filename=\"" + fileName + "\""));
            response.type(ci.getMimeType());
            CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)response, (HttpHeaders)headers);
            return response.build();
        }
        throw new WebApplicationException(404);
    }

    @GET
    @Path(value="/metadata/{uri:.+}")
    public Response getContentItemMetaData(@PathParam(value="uri") String uri, @QueryParam(value="format") @DefaultValue(value="application/rdf+xml") String format, @Context HttpHeaders headers) throws IOException, StoreException {
        if ((uri = RestUtil.nullify(uri)) == null) {
            return RestUtil.createResponse(this.servletContext, Response.Status.BAD_REQUEST, "Missing 'uri' parameter", headers);
        }
        ContentItem ci = this.solrStore.get(uri, this.indexName);
        if (ci == null) {
            return RestUtil.createResponse(this.servletContext, Response.Status.NOT_FOUND, null, headers);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.serializer.serialize((OutputStream)out, (TripleCollection)ci.getMetadata(), format);
        Response.ResponseBuilder rb = Response.ok((Object)out.toString(), (String)"text/plain");
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        return rb.build();
    }

    @GET
    @Path(value="/raw/{uri:.+}")
    public Response getRawContent(@PathParam(value="uri") String uri, @Context HttpHeaders headers) throws IOException, StoreException {
        if ((uri = RestUtil.nullify(uri)) == null) {
            return RestUtil.createResponse(this.servletContext, Response.Status.BAD_REQUEST, "Missing 'uri' parameter", headers);
        }
        ContentItem ci = this.solrStore.get(uri, this.indexName);
        if (ci == null) {
            return RestUtil.createResponse(this.servletContext, Response.Status.NOT_FOUND, null, headers);
        }
        Response.ResponseBuilder rb = Response.ok((Object)ci.getStream(), (String)ci.getMimeType());
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        return rb.build();
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    public Response createContentItem(ContentItem ci, @QueryParam(value="title") String title, @QueryParam(value="chain") String chain, @Context HttpHeaders headers) throws StoreException, URISyntaxException {
        title = RestUtil.nullify(title);
        chain = RestUtil.nullify(chain);
        MediaType acceptedHeader = RestUtil.getAcceptedMediaType(headers, null);
        if (title != null) {
            ci.addPart(SolrStore.TITLE_URI, (Object)title);
        }
        if (ci.getMetadata() == null || ci.getMetadata().isEmpty()) {
            this.solrStore.enhanceAndPut(ci, this.indexName, chain);
        } else {
            this.solrStore.put(ci, this.indexName);
        }
        Response.ResponseBuilder rb = null;
        rb = acceptedHeader != null && acceptedHeader.isCompatible(MediaType.TEXT_HTML_TYPE) ? Response.seeOther((URI)this.makeRedirectionURI(ci.getUri().getUnicodeString())) : Response.created((URI)this.makeRedirectionURI(ci.getUri().getUnicodeString()));
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        return rb.build();
    }

    @POST
    @Consumes(value={"*/*"})
    public Response createContentItemWithRawData(byte[] data, @QueryParam(value="uri") String uri, @QueryParam(value="title") String title, @QueryParam(value="chain") String chain, @Context HttpHeaders headers) throws URISyntaxException, EngineException, StoreException {
        uri = RestUtil.nullify(uri);
        title = RestUtil.nullify(title);
        chain = RestUtil.nullify(chain);
        if (uri == null) {
            uri = ContentItemHelper.makeDefaultUrn((byte[])data).getUnicodeString();
        }
        return this.createEnhanceAndRedirect(data, headers.getMediaType(), uri, false, title, chain, headers);
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response createContentItemFromForm(@FormParam(value="uri") String uri, @FormParam(value="content") String content, @FormParam(value="url") String url, @FormParam(value="title") String title, @FormParam(value="chain") String chain, @Context HttpHeaders headers) throws URISyntaxException, EngineException, MalformedURLException, IOException, StoreException {
        uri = RestUtil.nullify(uri);
        url = RestUtil.nullify(url);
        title = RestUtil.nullify(title);
        chain = RestUtil.nullify(chain);
        return this.createContentItemFromForm(uri, content, url, headers, title, chain);
    }

    private Response createContentItemFromForm(String uri, String content, String url, HttpHeaders headers, String title, String chain) throws URISyntaxException, EngineException, MalformedURLException, IOException, StoreException {
        byte[] data = null;
        MediaType mt = null;
        if (content != null && !content.trim().isEmpty()) {
            data = content.getBytes();
            mt = MediaType.TEXT_PLAIN_TYPE;
        } else if (url != null && !url.trim().isEmpty()) {
            try {
                URLConnection uc = new URL(url).openConnection();
                data = IOUtils.toByteArray((InputStream)uc.getInputStream());
                mt = MediaType.valueOf((String)uc.getContentType());
            }
            catch (IOException e) {
                log.error("Failed to obtain content from the remote URL: {}", (Object)url, (Object)e);
                throw e;
            }
        }
        if (data != null && mt != null) {
            if (uri == null || uri.trim().equals("")) {
                uri = ContentItemHelper.makeDefaultUrn((byte[])data).getUnicodeString();
            }
            return this.createEnhanceAndRedirect(data, mt, uri, true, title, chain, headers);
        }
        log.error(String.format("There should be valid values for the media type and content. Media type: %s, content==null: %b", mt, content == null));
        throw new IllegalStateException(String.format("There should be valid values for the media type and content. Media type: %s, content==null: %b", mt, content == null));
    }

    private Response createEnhanceAndRedirect(byte[] content, MediaType mediaType, String uri, boolean useExplicitRedirect, String title, String chain, HttpHeaders headers) throws EngineException, URISyntaxException, StoreException {
        ContentItem ci = this.solrStore.create(content, uri, title, mediaType.toString());
        this.solrStore.enhanceAndPut(ci, this.indexName, chain);
        if (useExplicitRedirect) {
            Response.ResponseBuilder rb = Response.seeOther((URI)this.makeRedirectionURI(ci.getUri().getUnicodeString()));
            CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
            return rb.build();
        }
        Response.ResponseBuilder rb = Response.created((URI)this.makeRedirectionURI(ci.getUri().getUnicodeString()));
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        return rb.build();
    }

    private URI makeRedirectionURI(String uri) throws URISyntaxException {
        return new URI(this.uriInfo.getBaseUri() + "contenthub/" + this.indexName + "/store/content/" + uri);
    }

    @DELETE
    public Response deleteContentItemByForm(@QueryParam(value="uri") String uri, @Context HttpHeaders headers) throws StoreException {
        return this.deleteContentItem(uri, headers);
    }

    @DELETE
    @Path(value="/{uri:.+}")
    public Response deleteContentItem(@PathParam(value="uri") String uri, @Context HttpHeaders headers) throws StoreException {
        if ((uri = RestUtil.nullify(uri)) == null) {
            return RestUtil.createResponse(this.servletContext, Response.Status.BAD_REQUEST, "Missing 'uri' parameter", headers);
        }
        ContentItem ci = this.solrStore.get(uri, this.indexName);
        if (ci == null) {
            return RestUtil.createResponse(this.servletContext, Response.Status.NOT_FOUND, null, headers);
        }
        this.solrStore.deleteById(uri, this.indexName);
        return RestUtil.createResponse(this.servletContext, Response.Status.OK, null, headers);
    }

    @GET
    @Produces(value={"text/html;qs=2"})
    public Viewable getView(@Context ServletContext context, @QueryParam(value="offset") int offset, @QueryParam(value="pageSize") @DefaultValue(value="5") int pageSize) throws IllegalArgumentException, IOException, InvalidSyntaxException {
        QueryResponse res;
        this.offset = offset;
        this.pageSize = pageSize;
        this.recentlyEnhanced = new ArrayList<DocumentResult>();
        if (!(this.solrSearch instanceof SolrSearch)) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Failed to obtain default implementation for SolrSearch").build());
        }
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("q", new String[]{"*:*"});
        params.set("sort", new String[]{SolrVocabulary.SolrFieldName.CREATIONDATE.toString() + " desc"});
        params.set("start", offset);
        params.set("rows", pageSize + 1);
        try {
            res = this.solrSearch.search((SolrParams)params, this.indexName);
        }
        catch (SearchException e) {
            log.error("Failed to retrieve submitted documents", (Throwable)e);
            return new Viewable("index", (Object)this);
        }
        for (SolrDocument result : res.getResults()) {
            this.recentlyEnhanced.add(SolrContentItemConverter.solrDocument2solrContentItem((SolrDocument)result, (String)this.uriInfo.getBaseUri().toString(), (String)this.indexName));
        }
        return new Viewable("index", (Object)this);
    }

    @Path(value="/page/{uri:.+}")
    @Produces(value={"text/html"})
    public ContentItemResource getContentItemView(@PathParam(value="uri") String uri) throws IOException, StoreException {
        ContentItem ci = this.solrStore.get(uri, this.indexName);
        if (ci == null) {
            throw new WebApplicationException(404);
        }
        return new ContentItemResource(uri, ci, this.uriInfo, "/contenthub/" + this.indexName + "/store/download", this.tcManager, this.serializer, this.servletContext);
    }

    public List<DocumentResult> getRecentlyEnhancedItems() throws ParseException {
        if (this.recentlyEnhanced.size() > this.pageSize) {
            return this.recentlyEnhanced.subList(0, this.pageSize);
        }
        return this.recentlyEnhanced;
    }

    public URI getMoreRecentItemsUri() {
        if (this.offset >= this.pageSize) {
            return this.uriInfo.getBaseUriBuilder().path("contenthub").path(this.indexName).path("store").queryParam("offset", new Object[]{this.offset - this.pageSize}).build(new Object[0]);
        }
        return null;
    }

    public URI getOlderItemsUri() {
        if (this.recentlyEnhanced.size() <= this.pageSize) {
            return null;
        }
        return this.uriInfo.getBaseUriBuilder().path("contenthub").path(this.indexName).path("store").queryParam("offset", new Object[]{this.offset + this.pageSize}).build(new Object[0]);
    }

    public String getIndexName() {
        return this.indexName;
    }
}

