/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.contenthub.search.related.referencedsite;

import com.hp.hpl.jena.rdf.model.impl.Util;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.clerezza.rdf.ontologies.RDFS;
import org.apache.stanbol.contenthub.search.related.RelatedKeywordImpl;
import org.apache.stanbol.contenthub.servicesapi.search.SearchException;
import org.apache.stanbol.contenthub.servicesapi.search.related.RelatedKeyword;
import org.apache.stanbol.contenthub.servicesapi.search.related.RelatedKeywordSearch;
import org.apache.stanbol.entityhub.core.query.DefaultQueryFactory;
import org.apache.stanbol.entityhub.servicesapi.Entityhub;
import org.apache.stanbol.entityhub.servicesapi.EntityhubException;
import org.apache.stanbol.entityhub.servicesapi.model.Entity;
import org.apache.stanbol.entityhub.servicesapi.model.Representation;
import org.apache.stanbol.entityhub.servicesapi.query.Constraint;
import org.apache.stanbol.entityhub.servicesapi.query.FieldQuery;
import org.apache.stanbol.entityhub.servicesapi.query.FieldQueryFactory;
import org.apache.stanbol.entityhub.servicesapi.query.QueryResultList;
import org.apache.stanbol.entityhub.servicesapi.query.TextConstraint;
import org.apache.stanbol.entityhub.servicesapi.site.ReferencedSiteManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferencedSiteSearch
implements RelatedKeywordSearch {
    private static String DBPEDIA_ONT_NAMESPACE = "http://dbpedia.org/ontology/";
    public static final List<String> placeTypedProperties = Arrays.asList(DBPEDIA_ONT_NAMESPACE + DBPEDIA_ONT_NAMESPACE + "country", DBPEDIA_ONT_NAMESPACE + "largestCity", DBPEDIA_ONT_NAMESPACE + "city", DBPEDIA_ONT_NAMESPACE + "state", DBPEDIA_ONT_NAMESPACE + "capital", DBPEDIA_ONT_NAMESPACE + "isPartOf", DBPEDIA_ONT_NAMESPACE + "part", DBPEDIA_ONT_NAMESPACE + "deathPlace", DBPEDIA_ONT_NAMESPACE + "birthPlace", DBPEDIA_ONT_NAMESPACE + "location");
    public static final List<String> personTypedProperties = Arrays.asList(DBPEDIA_ONT_NAMESPACE + "leader", DBPEDIA_ONT_NAMESPACE + "leaderName", DBPEDIA_ONT_NAMESPACE + "child", DBPEDIA_ONT_NAMESPACE + "spouse", DBPEDIA_ONT_NAMESPACE + "partner", DBPEDIA_ONT_NAMESPACE + "president");
    public static final List<String> organizationTypedProperties = Arrays.asList(DBPEDIA_ONT_NAMESPACE + "leaderParty", DBPEDIA_ONT_NAMESPACE + "affiliation", DBPEDIA_ONT_NAMESPACE + "team", DBPEDIA_ONT_NAMESPACE + "party", DBPEDIA_ONT_NAMESPACE + "otherParty", DBPEDIA_ONT_NAMESPACE + "associatedBand");
    private static final Logger logger = LoggerFactory.getLogger(ReferencedSiteSearch.class);
    private Entityhub entityhub;
    private ReferencedSiteManager referencedSiteManager;

    public Map<String, List<RelatedKeyword>> search(String keyword) throws SearchException {
        Map<String, List<RelatedKeyword>> results = new HashMap<String, List<RelatedKeyword>>();
        FieldQuery fieldQuery = this.getFieldQuery(keyword);
        QueryResultList externalEnties = this.referencedSiteManager.find(fieldQuery);
        String entityId = null;
        if (externalEnties != null && externalEnties.size() > 0) {
            entityId = ((Representation)externalEnties.iterator().next()).getId();
            try {
                Entity entity = this.entityhub.lookupLocalEntity(entityId, true);
                if (entity != null) {
                    results = this.getRelatedKeywordsFromEntity(entity);
                } else {
                    logger.warn("There is no obtained external entity having id: {}", (Object)entityId);
                }
            }
            catch (EntityhubException e) {
                logger.error("Got entityhub exception while looking up for entity: {}", (Object)entityId);
            }
        }
        return results;
    }

    public Map<String, List<RelatedKeyword>> search(String keyword, String ontologyURI) throws SearchException {
        return this.search(keyword);
    }

    private FieldQuery getFieldQuery(String keyword) {
        FieldQueryFactory qf = DefaultQueryFactory.getInstance();
        FieldQuery fieldQuery = qf.createFieldQuery();
        ArrayList<String> selectedFields = new ArrayList<String>();
        selectedFields.add(RDFS.label.getUnicodeString());
        fieldQuery.addSelectedFields(selectedFields);
        fieldQuery.setConstraint(RDFS.label.getUnicodeString(), (Constraint)new TextConstraint(keyword, TextConstraint.PatternType.wildcard, false, new String[]{"en"}));
        fieldQuery.setLimit(Integer.valueOf(1));
        fieldQuery.setOffset(0);
        return fieldQuery;
    }

    private Map<String, List<RelatedKeyword>> getRelatedKeywordsFromEntity(Entity entity) {
        HashMap<String, List<RelatedKeyword>> results = new HashMap<String, List<RelatedKeyword>>();
        Representation entityRep = entity.getRepresentation();
        Iterator fields = entityRep.getFieldNames();
        while (fields.hasNext()) {
            String field = (String)fields.next();
            this.processProperties(organizationTypedProperties, entity.getRepresentation(), entity.getSite() + "#Organization", field, results);
            this.processProperties(personTypedProperties, entity.getRepresentation(), entity.getSite() + "#Person", field, results);
            this.processProperties(placeTypedProperties, entity.getRepresentation(), entity.getSite() + "#Place", field, results);
        }
        return results;
    }

    private void processProperties(List<String> semanticProperties, Representation entityRep, String source, String field, Map<String, List<RelatedKeyword>> results) {
        if (semanticProperties.contains(field)) {
            Iterator fieldValues = entityRep.get(field);
            while (fieldValues.hasNext()) {
                String fieldValueStr;
                Object fieldValue = fieldValues.next();
                try {
                    fieldValueStr = URLDecoder.decode(fieldValue.toString(), "UTF-8");
                    fieldValueStr = fieldValueStr.substring(Util.splitNamespace((String)fieldValueStr));
                }
                catch (UnsupportedEncodingException e) {
                    logger.warn("Unsupported encoding while trying to decode to related entity URI", (Throwable)e);
                    continue;
                }
                RelatedKeywordImpl rkw = new RelatedKeywordImpl(fieldValueStr, 0.0, source);
                if (results.containsKey(source)) {
                    results.get(source).add(rkw);
                    continue;
                }
                ArrayList<RelatedKeywordImpl> rkwList = new ArrayList<RelatedKeywordImpl>();
                rkwList.add(rkw);
                results.put(source, rkwList);
            }
        }
    }

    protected void bindEntityhub(Entityhub entityhub) {
        this.entityhub = entityhub;
    }

    protected void unbindEntityhub(Entityhub entityhub) {
        if (this.entityhub == entityhub) {
            this.entityhub = null;
        }
    }

    protected void bindReferencedSiteManager(ReferencedSiteManager referencedSiteManager) {
        this.referencedSiteManager = referencedSiteManager;
    }

    protected void unbindReferencedSiteManager(ReferencedSiteManager referencedSiteManager) {
        if (this.referencedSiteManager == referencedSiteManager) {
            this.referencedSiteManager = null;
        }
    }
}

