/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.contenthub.search.related.ontologyresource;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.larq.IndexBuilderString;
import com.hp.hpl.jena.query.larq.IndexLARQ;
import com.hp.hpl.jena.query.larq.LARQ;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.sparql.util.Context;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.clerezza.rdf.core.TripleCollection;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.access.LockableMGraph;
import org.apache.clerezza.rdf.core.access.TcManager;
import org.apache.clerezza.rdf.jena.facade.JenaGraph;
import org.apache.stanbol.contenthub.search.related.RelatedKeywordImpl;
import org.apache.stanbol.contenthub.search.related.ontologyresource.ClosureHelper;
import org.apache.stanbol.contenthub.search.related.ontologyresource.IndexingHelper;
import org.apache.stanbol.contenthub.search.related.ontologyresource.QueryFactory;
import org.apache.stanbol.contenthub.servicesapi.search.SearchException;
import org.apache.stanbol.contenthub.servicesapi.search.related.RelatedKeyword;
import org.apache.stanbol.contenthub.servicesapi.search.related.RelatedKeywordSearch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OntologyResourceSearch
implements RelatedKeywordSearch {
    private static final Logger logger = LoggerFactory.getLogger(OntologyResourceSearch.class);
    private IndexBuilderString userGraphIndexBuilder;
    private OntModel userOntology;
    private TcManager tcManager;

    public Map<String, List<RelatedKeyword>> search(String keyword, String ontologyURI) throws SearchException {
        HashMap<String, List<RelatedKeyword>> relatedKeywordsMap = new HashMap<String, List<RelatedKeyword>>();
        if (ontologyURI != null && !ontologyURI.trim().isEmpty()) {
            ArrayList<RelatedKeyword> relatedKeywords = new ArrayList<RelatedKeyword>();
            this.indexOntology(ontologyURI);
            IndexLARQ index = this.userGraphIndexBuilder.getIndex();
            logger.debug("Processing classes for related keywords");
            Query query = QueryFactory.getClassQuery(keyword);
            QueryExecution classQExec = QueryExecutionFactory.create((Query)query, (Model)this.userOntology);
            LARQ.setDefaultIndex((Context)classQExec.getContext(), (IndexLARQ)index);
            ResultSet result = classQExec.execSelect();
            this.processClassResultSet(result, keyword, relatedKeywords);
            logger.debug("Processing individuals for related keywords");
            query = QueryFactory.getIndividualQuery(keyword);
            QueryExecution individualQExec = QueryExecutionFactory.create((Query)query, (Model)this.userOntology);
            LARQ.setDefaultIndex((Context)individualQExec.getContext(), (IndexLARQ)index);
            result = individualQExec.execSelect();
            this.processIndividualResultSet(result, keyword, relatedKeywords);
            logger.debug("Processing CMS objects for related keywords");
            query = QueryFactory.getCMSObjectQuery(keyword);
            QueryExecution cmsObjectQueryExec = QueryExecutionFactory.create((Query)query, (Model)this.userOntology);
            LARQ.setDefaultIndex((Context)cmsObjectQueryExec.getContext(), (IndexLARQ)index);
            result = cmsObjectQueryExec.execSelect();
            this.processCMSObjectResultSet(result, keyword, relatedKeywords);
            relatedKeywordsMap.put(RelatedKeyword.Source.ONTOLOGY.toString(), relatedKeywords);
        }
        return relatedKeywordsMap;
    }

    private void indexOntology(String userOntologyURI) throws SearchException {
        OntModel userGraph = null;
        LockableMGraph mgraph = this.tcManager.getMGraph(new UriRef(userOntologyURI));
        if (mgraph == null) {
            throw new SearchException(String.format("MGraph having URI %s could obtained through TcManager", userOntologyURI));
        }
        JenaGraph jenaGraph = new JenaGraph((TripleCollection)mgraph);
        Model model = ModelFactory.createModelForGraph((Graph)jenaGraph);
        userGraph = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM_RDFS_INF);
        userGraph.add(model);
        IndexingHelper.addIndexPropertyToOntResources(userGraph);
        this.userOntology = userGraph;
        this.userGraphIndexBuilder = new IndexBuilderString(IndexingHelper.HAS_LOCAL_NAME);
        this.userGraphIndexBuilder.indexStatements(userGraph.listStatements());
    }

    private void processClassResultSet(ResultSet result, String keyword, List<RelatedKeyword> relatedKeywords) {
        double score;
        HashMap<String, Double> results = new HashMap<String, Double>();
        while (result.hasNext()) {
            QuerySolution resultBinding = result.nextSolution();
            RDFNode rdfNode = resultBinding.get("class");
            score = resultBinding.getLiteral("score").getDouble();
            if (!rdfNode.isURIResource()) continue;
            String uri = rdfNode.asResource().getURI();
            results.put(uri, score);
        }
        for (String uri : results.keySet()) {
            score = (Double)results.get(uri);
            ClosureHelper.getInstance(this.userOntology).computeClassClosure(uri, 6, score, 1.5, keyword, relatedKeywords);
        }
    }

    private void processIndividualResultSet(ResultSet result, String keyword, List<RelatedKeyword> relatedKeywords) {
        double score;
        HashMap<String, Double> results = new HashMap<String, Double>();
        while (result.hasNext()) {
            QuerySolution resultBinding = result.nextSolution();
            RDFNode rdfNode = resultBinding.get("individual");
            score = resultBinding.getLiteral("score").getDouble();
            if (!rdfNode.isURIResource()) continue;
            String uri = rdfNode.asResource().getURI();
            results.put(uri, score);
        }
        for (String uri : results.keySet()) {
            score = (Double)results.get(uri);
            ClosureHelper.getInstance(this.userOntology).computeIndividualClosure(uri, 6, score, 1.5, keyword, relatedKeywords);
        }
    }

    private void processCMSObjectResultSet(ResultSet result, String keyword, List<RelatedKeyword> relatedKeywords) {
        HashMap<String, Double> results = new HashMap<String, Double>();
        while (result.hasNext()) {
            QuerySolution resultBinding = result.nextSolution();
            RDFNode rdfNode = resultBinding.get("cmsobject");
            double score = resultBinding.getLiteral("score").getDouble();
            if (!rdfNode.isURIResource()) continue;
            String uri = rdfNode.asResource().getURI();
            results.put(uri, score);
        }
        Property subsumptionProp = ResourceFactory.createProperty((String)"http://www.apache.org/stanbol/cms#parentRef");
        Property nameProp = ResourceFactory.createProperty((String)"http://www.apache.org/stanbol/cms#name");
        for (String uri : results.keySet()) {
            Resource keywordResource = ResourceFactory.createResource((String)uri);
            List nameStatements = this.userOntology.listStatements(keywordResource, nameProp, (RDFNode)null).toList();
            if (nameStatements.size() <= 0) continue;
            String matchedResourceName = ((Statement)nameStatements.get(0)).getString();
            double initialScore = (Double)results.get(uri);
            relatedKeywords.add(new RelatedKeywordImpl(matchedResourceName, initialScore, RelatedKeyword.Source.ONTOLOGY));
            ClosureHelper.getInstance(this.userOntology).computeClosureWithProperty(keywordResource, subsumptionProp, 2, initialScore, 1.5, keyword, relatedKeywords);
        }
    }

    public Map<String, List<RelatedKeyword>> search(String keyword) throws SearchException {
        return new HashMap<String, List<RelatedKeyword>>();
    }

    protected void bindTcManager(TcManager tcManager) {
        this.tcManager = tcManager;
    }

    protected void unbindTcManager(TcManager tcManager) {
        if (this.tcManager == tcManager) {
            this.tcManager = null;
        }
    }
}

