/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.contenthub.search.related.ontologyresource;

import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.OWL2;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.stanbol.contenthub.search.related.RelatedKeywordImpl;
import org.apache.stanbol.contenthub.search.related.ontologyresource.IndexingHelper;
import org.apache.stanbol.contenthub.servicesapi.search.related.RelatedKeyword;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClosureHelper {
    private static final Logger log = LoggerFactory.getLogger(ClosureHelper.class);
    private OntModel model;

    private ClosureHelper(OntModel userOntology) {
        this.model = userOntology;
    }

    public static ClosureHelper getInstance(OntModel userOntology) {
        return new ClosureHelper(userOntology);
    }

    public List<RelatedKeyword> computeClassClosure(String classURI, int maxDepth, double initialScore, double degradingCoefficient, String keyword, List<RelatedKeyword> relatedKeywords) {
        long t1 = System.currentTimeMillis();
        ArrayList relatedClassURIs = new ArrayList();
        this.computeSuperClassClosure(classURI, maxDepth, initialScore, degradingCoefficient, keyword, relatedKeywords);
        this.computeSubClassClosure(classURI, maxDepth, initialScore, degradingCoefficient, keyword, relatedKeywords);
        for (String relatedClassURI : relatedClassURIs) {
            this.computeInstanceClosure(relatedClassURI, initialScore, degradingCoefficient, keyword, relatedKeywords);
        }
        log.debug("Computed class closure of {} in {} miliseconds", (Object)classURI, (Object)(System.currentTimeMillis() - t1));
        return relatedKeywords;
    }

    public final void computeIndividualClosure(String individualURI, int maxDepth, double initialScore, double degradingCoefficient, String keyword, List<RelatedKeyword> relatedKeywords) {
        long t1 = System.currentTimeMillis();
        Individual ind = this.model.getIndividual(individualURI);
        if (ind != null && ind.isURIResource()) {
            for (OntClass ontClass : ind.listOntClasses(true).toSet()) {
                if (ontClass == null || !ontClass.isURIResource()) continue;
                this.computeClassClosure(ontClass.getURI(), 6, initialScore, 1.5, keyword, relatedKeywords);
            }
        }
        log.debug("Computed individual closure of {} in {} miliseconds", (Object)individualURI, (Object)(System.currentTimeMillis() - t1));
    }

    private void computeSuperClassClosure(String classURI, int maxDepth, double initialScore, double degradingCoefficient, String keyword, List<RelatedKeyword> relatedKeywords) {
        OntClass ontClass = this.model.getOntClass(classURI);
        if (ontClass == null || ontClass.isAnon() || this.isClassNotValid(ontClass)) {
            log.warn("Can not find class with uri {}, skipping ...", (Object)classURI);
        } else {
            if (maxDepth == 0) {
                log.debug("Max depth reached not examining the resource {}", (Object)classURI);
                return;
            }
            String rkw = ontClass.getLocalName();
            relatedKeywords.add(new RelatedKeywordImpl(rkw, initialScore, "Ontology"));
            log.debug("Added {} as a related keyword to {} by super class relation", (Object)rkw, (Object)keyword);
            log.debug("Computing super class closure of {} ", (Object)classURI);
            List superClasses = ontClass.listSuperClasses(true).toList();
            for (OntClass superClass : superClasses) {
                this.computeSuperClassClosure(superClass.getURI(), maxDepth - 1, initialScore / degradingCoefficient, degradingCoefficient, keyword, relatedKeywords);
            }
        }
    }

    private void computeSubClassClosure(String classURI, int maxDepth, double initialScore, double degradingCoefficient, String keyword, List<RelatedKeyword> relatedKeywords) {
        OntClass ontClass = this.model.getOntClass(classURI);
        if (ontClass == null || ontClass.isAnon() || this.isClassNotValid(ontClass)) {
            log.warn("Can not find class with uri {}, skipping ...", (Object)classURI);
        } else {
            if (maxDepth == 0) {
                log.debug("Max depth reached not examining the resource {}", (Object)classURI);
                return;
            }
            String rkw = ontClass.getLocalName();
            relatedKeywords.add(new RelatedKeywordImpl(rkw, initialScore, "Ontology"));
            log.debug("Added {} as related keyword to {} by sub class relation", (Object)classURI, (Object)keyword);
            log.debug("Computing sub class closure of {} ", (Object)classURI);
            List subClasses = ontClass.listSubClasses(true).toList();
            for (OntClass subClass : subClasses) {
                this.computeSubClassClosure(subClass.getURI(), maxDepth - 1, initialScore / degradingCoefficient, degradingCoefficient, keyword, relatedKeywords);
            }
        }
    }

    private void computeInstanceClosure(String classURI, double initialScore, double degradingCoefficient, String keyword, List<RelatedKeyword> relatedKeywords) {
        OntClass ontClass = this.model.getOntClass(classURI);
        if (ontClass == null || ontClass.isAnon() || this.isClassNotValid(ontClass)) {
            log.warn("Can not find class with uri {}, skipping ...", (Object)classURI);
        } else {
            log.debug("Computing instance closure of class {} ", (Object)classURI);
            List instances = ontClass.listInstances(true).toList();
            for (OntResource instance : instances) {
                if (instance == null || instance.isAnon() || !instance.isIndividual()) continue;
                Individual individual = instance.asIndividual();
                String rkw = individual.getLocalName();
                relatedKeywords.add(new RelatedKeywordImpl(rkw, initialScore / degradingCoefficient, "Ontology"));
                log.debug("Added {} as a relate keyword to {} ", (Object)rkw, (Object)keyword);
            }
        }
    }

    private boolean isClassNotValid(OntClass klass) {
        String uri = klass.getURI();
        return uri.contains(RDF.getURI()) || uri.contains(RDFS.getURI()) || uri.contains(OWL.getURI()) || uri.contains(OWL2.getURI());
    }

    public void computeClosureWithProperty(Resource sourceURI, Property subsumptionProperty, int maxDepth, double initialScore, double degradingCoefficient, String keyword, List<RelatedKeyword> relatedKeywords) {
        this.computeSubclosureWithProperty(sourceURI, subsumptionProperty, maxDepth, initialScore, degradingCoefficient, keyword, relatedKeywords);
        this.computeSuperclosureWithProperty(sourceURI, subsumptionProperty, maxDepth, initialScore, degradingCoefficient, keyword, relatedKeywords);
    }

    private void computeSubclosureWithProperty(Resource uri, Property subsumptionProperty, int depth, double initialScore, double degradingCoefficient, String keyword, List<RelatedKeyword> relatedKeywords) {
        if (depth == 0) {
            log.debug("Max depth reached not examining the resource {}", (Object)uri.getURI());
            return;
        }
        log.debug("Computing sub concepts of {} ", (Object)uri);
        Set children = this.model.listStatements(null, subsumptionProperty, (RDFNode)uri).toSet();
        double score = initialScore / degradingCoefficient;
        for (Statement childStatement : children) {
            Resource subject = childStatement.getSubject();
            String childName = IndexingHelper.getCMSObjectName(subject);
            if (childName.equals("")) continue;
            childName = ClosureHelper.cropFileExtensionFromKeyword(childName);
            relatedKeywords.add(new RelatedKeywordImpl(childName, score, "Ontology"));
            log.debug("Added {} as a related keyword", (Object)childName);
            this.computeSubclosureWithProperty(subject, subsumptionProperty, depth - 1, score, degradingCoefficient, keyword, relatedKeywords);
        }
    }

    private void computeSuperclosureWithProperty(Resource uri, Property subsumptionProperty, int depth, double initialScore, double degradingCoefficient, String keyword, List<RelatedKeyword> relatedKeywords) {
        if (depth == 0) {
            log.debug("Max depth reached not examining the resource {}", (Object)uri.getURI());
            return;
        }
        log.debug("Computing parent concepts of {} ", (Object)uri);
        Set parents = this.model.listStatements(uri, subsumptionProperty, (RDFNode)null).toSet();
        double score = initialScore / degradingCoefficient;
        for (Statement parentStatement : parents) {
            Resource object = parentStatement.getResource();
            String parentName = IndexingHelper.getCMSObjectName(object);
            if (parentName.equals("")) continue;
            parentName = ClosureHelper.cropFileExtensionFromKeyword(parentName);
            relatedKeywords.add(new RelatedKeywordImpl(parentName, score, "Ontology"));
            log.debug("Added {} as related keyword to ", (Object)parentName, (Object)keyword);
            this.computeSuperclosureWithProperty(object, subsumptionProperty, depth - 1, score, degradingCoefficient, keyword, relatedKeywords);
        }
    }

    public static String cropFileExtensionFromKeyword(String keyword) {
        return FilenameUtils.removeExtension((String)keyword);
    }
}

