/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.commons.opennlp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import opennlp.tools.util.Span;
import org.apache.stanbol.commons.opennlp.PosTagsCollectionEnum;
import org.apache.stanbol.commons.opennlp.PosTypeCollectionType;

public class PosTypeChunker {
    private final double minPosProb;
    private final Set<String> followTypes;
    private final Set<String> buildTypes;

    public static PosTypeChunker getInstance(String lang, double minPosTagProbaility) {
        Set<String> nounPosTagCollection = PosTagsCollectionEnum.getPosTagCollection(lang, PosTypeCollectionType.NOUN);
        if (nounPosTagCollection != null && !nounPosTagCollection.isEmpty()) {
            return new PosTypeChunker(nounPosTagCollection, PosTagsCollectionEnum.getPosTagCollection(lang, PosTypeCollectionType.FOLLOW), minPosTagProbaility);
        }
        return null;
    }

    public PosTypeChunker(Set<String> buildPosTypes, Set<String> followPosTypes, double minPosProb) {
        if (buildPosTypes == null || buildPosTypes.isEmpty()) {
            throw new IllegalArgumentException("The set of POS types used tobuild Chunks MUST NOT be NULL nor empty!");
        }
        this.buildTypes = Collections.unmodifiableSet(new TreeSet<String>(buildPosTypes));
        TreeSet<String> follow = new TreeSet<String>();
        follow.addAll(this.buildTypes);
        if (followPosTypes != null) {
            follow.addAll(followPosTypes);
        }
        this.followTypes = Collections.unmodifiableSet(follow);
        if (minPosProb > 1.0) {
            throw new IllegalArgumentException("The minimum POS tag probalility MUST BE set to a value [0..1] or values < 0 to deactivate this feature (parsed=" + minPosProb + ")!");
        }
        this.minPosProb = minPosProb;
    }

    private boolean followPOS(double[] props, String ... pos) {
        boolean reject = false;
        for (int i = 0; i < pos.length; ++i) {
            if (props != null && !(props[i] >= this.minPosProb)) continue;
            if (this.followTypes.contains(pos[i])) {
                return true;
            }
            reject = true;
        }
        return !reject;
    }

    private boolean includePOS(double[] props, String ... pos) {
        boolean reject = false;
        for (int i = 0; i < pos.length; ++i) {
            if (props != null && !(props[i] >= this.minPosProb)) continue;
            if (this.buildTypes.contains(pos[i])) {
                return true;
            }
            reject = true;
        }
        return !reject;
    }

    public final Set<String> getFollowedPosTypes() {
        return this.followTypes;
    }

    public final Set<String> getChunkPosTypes() {
        return this.buildTypes;
    }

    public Span[] chunkAsSpans(String[] tokens, String[] tags) {
        int consumed = -1;
        ArrayList<Span> chunks = new ArrayList<Span>();
        for (int i = 0; i < tokens.length; ++i) {
            if (!this.includePOS(null, tags[i])) continue;
            int start = i;
            while (start - 1 > consumed && this.followPOS(null, tags[start - 1])) {
                --start;
            }
            int followEnd = i;
            int end = i;
            while (followEnd + 1 < tokens.length && this.followPOS(null, tags[followEnd + 1])) {
                if (!this.includePOS(null, tags[++followEnd])) continue;
                end = followEnd;
            }
            chunks.add(new Span(start, end));
            i = followEnd;
        }
        return chunks.toArray(new Span[chunks.size()]);
    }

    public Span[] chunkAsSpans(String[] tokens, String[][] tags, double[][] props) {
        int consumed = -1;
        ArrayList<Span> chunks = new ArrayList<Span>();
        for (int i = 0; i < tokens.length; ++i) {
            if (!this.includePOS(props[i], tags[i])) continue;
            int start = i;
            while (start - 1 > consumed && this.followPOS(props[start - 1], tags[start - 1])) {
                --start;
            }
            int followEnd = i;
            int end = i;
            while (followEnd + 1 < tokens.length && this.followPOS(props[followEnd + 1], tags[followEnd + 1])) {
                if (!this.includePOS(props[++followEnd], tags[followEnd])) continue;
                end = followEnd;
            }
            chunks.add(new Span(start, end));
            i = followEnd;
        }
        return chunks.toArray(new Span[chunks.size()]);
    }
}

