/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.sshd.common.forward;

import org.apache.sshd.common.session.ConnectionService;

/**
 * A factory for creating forwarder objects for client port forwarding
 * 
 * @author <a href="mailto:dev@mina.apache.org">Apache MINA SSHD Project</a>
 */
@FunctionalInterface
public interface ForwardingFilterFactory {

    /**
     * Creates the forwarder to be used for TCP/IP port forwards for this session.
     *
     * @param  service the {@link ConnectionService} the connections are forwarded through
     * @return         the {@link ForwardingFilter} that will listen for connections and set up forwarding
     */
    ForwardingFilter create(ConnectionService service);
}
