/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.io.IoAcceptor;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoServiceEventListener;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.netty.NettyIoService;
import org.apache.sshd.netty.NettyIoServiceFactory;
import org.apache.sshd.netty.NettyIoSession;

public class NettyIoAcceptor
extends NettyIoService
implements IoAcceptor {
    protected final ServerBootstrap bootstrap = new ServerBootstrap();
    protected final Map<SocketAddress, Channel> boundAddresses = new ConcurrentHashMap<SocketAddress, Channel>();

    public NettyIoAcceptor(NettyIoServiceFactory factory, final IoHandler handler) {
        super(factory, handler);
        this.channelGroup = new DefaultChannelGroup("sshd-acceptor-channels", (EventExecutor)GlobalEventExecutor.INSTANCE);
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)this.bootstrap.group(factory.eventLoopGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)100)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                IoServiceEventListener listener = NettyIoAcceptor.this.getIoServiceEventListener();
                InetSocketAddress local = ch.localAddress();
                InetSocketAddress remote = ch.remoteAddress();
                SocketAddress service = (SocketAddress)GenericUtils.head(NettyIoAcceptor.this.boundAddresses.keySet());
                try {
                    if (listener != null) {
                        try {
                            listener.connectionAccepted((IoAcceptor)NettyIoAcceptor.this, (SocketAddress)local, (SocketAddress)remote, service);
                        }
                        catch (Exception e) {
                            ch.close();
                            throw e;
                        }
                    }
                    ChannelPipeline p = ch.pipeline();
                    NettyIoSession nettyIoSession = new NettyIoSession(NettyIoAcceptor.this, handler, service);
                    p.addLast(new ChannelHandler[]{nettyIoSession.adapter});
                }
                catch (Exception e) {
                    block8: {
                        if (listener != null) {
                            try {
                                listener.abortAcceptedConnection((IoAcceptor)NettyIoAcceptor.this, (SocketAddress)local, (SocketAddress)remote, service, (Throwable)e);
                            }
                            catch (Exception exc) {
                                if (!NettyIoAcceptor.this.log.isDebugEnabled()) break block8;
                                NettyIoAcceptor.this.log.debug("initChannel(" + ch + ") listener=" + listener + " ignoring abort event exception", (Throwable)exc);
                            }
                        }
                    }
                    throw e;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(Collection<? extends SocketAddress> addresses) throws IOException {
        if (GenericUtils.isEmpty(addresses)) {
            return;
        }
        ArrayList<Channel> bound = new ArrayList<Channel>(addresses.size());
        try {
            for (SocketAddress socketAddress : addresses) {
                Channel channel = this.bindInternal(socketAddress);
                bound.add(channel);
            }
            bound.clear();
        }
        finally {
            for (Channel channel : bound) {
                this.closeChannel(channel);
            }
        }
    }

    public void bind(SocketAddress address) throws IOException {
        this.bindInternal(address);
    }

    protected Channel bindInternal(SocketAddress address) throws IOException {
        InetSocketAddress inetAddress = (InetSocketAddress)address;
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("bindInternal({}) binding", (Object)address);
        }
        ChannelFuture f = this.bootstrap.bind((SocketAddress)inetAddress);
        Channel channel = f.channel();
        this.channelGroup.add((Object)channel);
        try {
            Channel prev;
            f.sync();
            SocketAddress bound = channel.localAddress();
            if (debugEnabled) {
                this.log.debug("bindInternal({}) bound to {}", (Object)address, (Object)bound);
            }
            if ((prev = this.boundAddresses.put(bound, channel)) != null && debugEnabled) {
                this.log.debug("bindInternal({}) replaced entry of {} - previous={}", new Object[]{address, bound, prev.localAddress()});
            }
            channel.closeFuture().addListener(fut -> this.boundAddresses.remove(bound));
            Channel returnValue = channel;
            channel = null;
            Channel channel2 = returnValue;
            return channel2;
        }
        catch (InterruptedException e) {
            this.error("bindInternal({}) interrupted ({}): {}", address, e.getClass().getSimpleName(), e.getMessage(), e);
            throw (InterruptedIOException)new InterruptedIOException(e.getMessage()).initCause(e);
        }
        finally {
            this.closeChannel(channel);
        }
    }

    protected void closeChannel(Channel channel) {
        if (channel != null) {
            this.channelGroup.remove((Object)channel);
            channel.close();
        }
    }

    public void unbind(Collection<? extends SocketAddress> addresses) {
        CountDownLatch latch = new CountDownLatch(addresses.size());
        for (SocketAddress socketAddress : addresses) {
            Channel channel = this.boundAddresses.remove(socketAddress);
            if (channel != null) {
                ChannelFuture fut = channel.isOpen() ? channel.close() : channel.closeFuture();
                fut.addListener(f -> latch.countDown());
                continue;
            }
            latch.countDown();
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void unbind(SocketAddress address) {
        Channel channel = this.boundAddresses.remove(address);
        if (channel != null) {
            ChannelFuture fut = channel.isOpen() ? channel.close() : channel.closeFuture();
            try {
                fut.sync();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void unbind() {
        Set<SocketAddress> addresses = this.getBoundAddresses();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Unbinding {}", addresses);
        }
        this.unbind(addresses);
    }

    public Set<SocketAddress> getBoundAddresses() {
        return new HashSet<SocketAddress>(this.boundAddresses.keySet());
    }

    protected CloseFuture doCloseGracefully() {
        this.channelGroup.close().addListener(fut -> this.closeFuture.setClosed());
        return this.closeFuture;
    }

    protected void doCloseImmediately() {
        this.doCloseGracefully();
        super.doCloseImmediately();
    }
}

