/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.io.Serializable;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.yarn.FailureTracker;
import org.apache.spark.deploy.yarn.config.package$;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.HealthTracker$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Ee!\u0002\u0011\"\u0001\u0015Z\u0003\u0002\u0003\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\t\u0011y\u0002!\u0011!Q\u0001\n}B\u0001\u0002\u0019\u0001\u0003\u0002\u0003\u0006I!\u0019\u0005\u0006K\u0002!\tA\u001a\u0005\bW\u0002\u0011\r\u0011\"\u0003m\u0011\u0019\u0001\b\u0001)A\u0005[\"9\u0011\u000f\u0001b\u0001\n\u0013\u0011\bB\u0002<\u0001A\u0003%1\u000fC\u0004x\u0001\t\u0007I\u0011\u0002=\t\rq\u0004\u0001\u0015!\u0003z\u0011\u001di\bA1A\u0005\nyDq!a\b\u0001A\u0003%q\u0010C\u0005\u0002\"\u0001\u0011\r\u0011\"\u0003\u0002$!A\u0011\u0011\u0007\u0001!\u0002\u0013\t)\u0003\u0003\u0005\u00024\u0001\u0001\r\u0011\"\u0003\u007f\u0011%\t)\u0004\u0001a\u0001\n\u0013\t9\u0004C\u0004\u0002D\u0001\u0001\u000b\u0015B@\t\u0011\u0005\u0015\u0003\u00011A\u0005\nyD\u0011\"a\u0012\u0001\u0001\u0004%I!!\u0013\t\u000f\u00055\u0003\u0001)Q\u0005\u007f\"A\u0011q\n\u0001A\u0002\u0013%\u0001\u0010C\u0005\u0002R\u0001\u0001\r\u0011\"\u0003\u0002T!9\u0011q\u000b\u0001!B\u0013I\bbBA-\u0001\u0011\u0005\u00111\f\u0005\b\u0003?\u0002A\u0011AA1\u0011\u001d\ti\u0007\u0001C\u0005\u0003_Bq!!\u001e\u0001\t\u0003\t9\b\u0003\u0004\u0002\u0002\u0002!\tA\u001d\u0005\b\u0003\u0007\u0003A\u0011BAC\u0011\u001d\t9\t\u0001C\u0005\u0003\u0013Cq!a$\u0001\t\u0013\t)I\u0001\u0010ZCJt\u0017\t\u001c7pG\u0006$xN\u001d(pI\u0016DU-\u00197uQR\u0013\u0018mY6fe*\u0011!eI\u0001\u0005s\u0006\u0014hN\u0003\u0002%K\u00051A-\u001a9m_fT!AJ\u0014\u0002\u000bM\u0004\u0018M]6\u000b\u0005!J\u0013AB1qC\u000eDWMC\u0001+\u0003\ry'oZ\n\u0004\u00011\u0012\u0004CA\u00171\u001b\u0005q#\"A\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Er#AB!osJ+g\r\u0005\u00024m5\tAG\u0003\u00026K\u0005A\u0011N\u001c;fe:\fG.\u0003\u00028i\t9Aj\\4hS:<\u0017!C:qCJ\\7i\u001c8g\u0007\u0001\u0001\"a\u000f\u001f\u000e\u0003\u0015J!!P\u0013\u0003\u0013M\u0003\u0018M]6D_:4\u0017\u0001C1n\u00072LWM\u001c;\u0011\u0007\u0001C%*D\u0001B\u0015\t\u00115)A\u0002ba&T!\u0001R#\u0002\r\rd\u0017.\u001a8u\u0015\t\u0011cI\u0003\u0002HO\u00051\u0001.\u00193p_BL!!S!\u0003\u0015\u0005k%+T\"mS\u0016tG\u000f\u0005\u0002L;:\u0011Aj\u0017\b\u0003\u001bjs!AT-\u000f\u0005=CfB\u0001)X\u001d\t\tfK\u0004\u0002S+6\t1K\u0003\u0002Us\u00051AH]8pizJ\u0011AK\u0005\u0003Q%J!aR\u0014\n\u0005\t2\u0015B\u0001#F\u0013\t\u00115)\u0003\u0002]\u0003\u0006Q\u0011)\u0014*N\u00072LWM\u001c;\n\u0005y{&\u0001E\"p]R\f\u0017N\\3s%\u0016\fX/Z:u\u0015\ta\u0016)\u0001\bgC&dWO]3Ue\u0006\u001c7.\u001a:\u0011\u0005\t\u001cW\"A\u0011\n\u0005\u0011\f#A\u0004$bS2,(/\u001a+sC\u000e\\WM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\u001dD\u0017N\u001b\t\u0003E\u0002AQ\u0001\u000f\u0003A\u0002iBQA\u0010\u0003A\u0002}BQ\u0001\u0019\u0003A\u0002\u0005\fQ$\u001a=dYV$Wm\u00148GC&dWO]3US6,w.\u001e;NS2d\u0017n]\u000b\u0002[B\u0011QF\\\u0005\u0003_:\u0012A\u0001T8oO\u0006qR\r_2mk\u0012,wJ\u001c$bS2,(/\u001a+j[\u0016|W\u000f^'jY2L7\u000fI\u0001\u001eY\u0006,hn\u00195Fq\u000edW\u000fZ3P]\u001a\u000b\u0017\u000e\\;sK\u0016s\u0017M\u00197fIV\t1\u000f\u0005\u0002.i&\u0011QO\f\u0002\b\u0005>|G.Z1o\u0003ya\u0017-\u001e8dQ\u0016C8\r\\;eK>sg)Y5mkJ,WI\\1cY\u0016$\u0007%\u0001\nnCb4\u0015-\u001b7ve\u0016\u001c\b+\u001a:I_N$X#A=\u0011\u00055R\u0018BA>/\u0005\rIe\u000e^\u0001\u0014[\u0006Dh)Y5mkJ,7\u000fU3s\u0011>\u001cH\u000fI\u0001\rKb\u001cG.\u001e3f\u001d>$Wm]\u000b\u0002\u007fB1\u0011\u0011AA\u0006\u0003\u001fi!!a\u0001\u000b\t\u0005\u0015\u0011qA\u0001\nS6lW\u000f^1cY\u0016T1!!\u0003/\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u001b\t\u0019AA\u0002TKR\u0004B!!\u0005\u0002\u001a9!\u00111CA\u000b!\t\u0011f&C\u0002\u0002\u00189\na\u0001\u0015:fI\u00164\u0017\u0002BA\u000e\u0003;\u0011aa\u0015;sS:<'bAA\f]\u0005iQ\r_2mk\u0012,gj\u001c3fg\u0002\n\u0011$\u00197m_\u000e\fGo\u001c:Fq\u000edW\u000fZ3e\u001d>$W\rT5tiV\u0011\u0011Q\u0005\t\b\u0003O\ti#a\u0004n\u001b\t\tIC\u0003\u0003\u0002,\u0005\u001d\u0011aB7vi\u0006\u0014G.Z\u0005\u0005\u0003_\tICA\u0004ICNDW*\u00199\u00025\u0005dGn\\2bi>\u0014X\t_2mk\u0012,GMT8eK2K7\u000f\u001e\u0011\u00025\r,(O]3oi\u0016C8\r\\;eK\u0012,G-W1s]:{G-Z:\u0002=\r,(O]3oi\u0016C8\r\\;eK\u0012,G-W1s]:{G-Z:`I\u0015\fH\u0003BA\u001d\u0003\u007f\u00012!LA\u001e\u0013\r\tiD\f\u0002\u0005+:LG\u000f\u0003\u0005\u0002BA\t\t\u00111\u0001\u0000\u0003\rAH%M\u0001\u001cGV\u0014(/\u001a8u\u000bb\u001cG.\u001e3fI\u0016$\u0017,\u0019:o\u001d>$Wm\u001d\u0011\u00023M\u001c\u0007.\u001a3vY\u0016\u0014X\t_2mk\u0012,GMT8eK2K7\u000f^\u0001\u001eg\u000eDW\rZ;mKJ,\u0005p\u00197vI\u0016$gj\u001c3f\u0019&\u001cHo\u0018\u0013fcR!\u0011\u0011HA&\u0011!\t\teEA\u0001\u0002\u0004y\u0018AG:dQ\u0016$W\u000f\\3s\u000bb\u001cG.\u001e3fI:{G-\u001a'jgR\u0004\u0013a\u00048v[\u000ecWo\u001d;fe:{G-Z:\u0002'9,Xn\u00117vgR,'OT8eKN|F%Z9\u0015\t\u0005e\u0012Q\u000b\u0005\t\u0003\u00032\u0012\u0011!a\u0001s\u0006\u0001b.^7DYV\u001cH/\u001a:O_\u0012,7\u000fI\u0001\u0013g\u0016$h*^7DYV\u001cH/\u001a:O_\u0012,7\u000f\u0006\u0003\u0002:\u0005u\u0003BBA(1\u0001\u0007\u00110A\u0010iC:$G.\u001a*fg>,(oY3BY2|7-\u0019;j_:4\u0015-\u001b7ve\u0016$B!!\u000f\u0002d!9\u0011QM\rA\u0002\u0005\u001d\u0014a\u00025pgR|\u0005\u000f\u001e\t\u0006[\u0005%\u0014qB\u0005\u0004\u0003Wr#AB(qi&|g.A\u000fva\u0012\fG/Z!mY>\u001c\u0017\r^5p]\u0016C8\r\\;eK\u0012tu\u000eZ3t)\u0011\tI$!\u001d\t\u000f\u0005M$\u00041\u0001\u0002\u0010\u0005A\u0001n\\:u]\u0006lW-A\rtKR\u001c6\r[3ek2,'/\u0012=dYV$W\r\u001a(pI\u0016\u001cH\u0003BA\u001d\u0003sBq!a\u001f\u001c\u0001\u0004\ti(\u0001\u0011tG\",G-\u001e7fe\u0016C8\r\\;eK\u0012tu\u000eZ3t/&$\b.\u0012=qSJL\bCBA\t\u0003\u007f\ny!\u0003\u0003\u0002\u000e\u0005u\u0011!E5t\u00032dgj\u001c3f\u000bb\u001cG.\u001e3fI\u0006!\"/\u001a4sKNDW\t_2mk\u0012,GMT8eKN$\"!!\u000f\u0002AMLhn\u00195s_:L'0Z#yG2,H-\u001a3O_\u0012,7oV5uQf\u000b'O\u001c\u000b\u0005\u0003s\tY\tC\u0004\u0002\u000ez\u0001\r!! \u0002\u001d9|G-Z:U_\u0016C8\r\\;eK\u0006q\"/Z7pm\u0016,\u0005\u0010]5sK\u0012L\u0016M\u001d8Fq\u000edW\u000fZ3e\u001d>$Wm\u001d")
public class YarnAllocatorNodeHealthTracker
implements Logging {
    private final AMRMClient<AMRMClient.ContainerRequest> amClient;
    private final FailureTracker failureTracker;
    private final long excludeOnFailureTimeoutMillis;
    private final boolean launchExcludeOnFailureEnabled;
    private final int maxFailuresPerHost;
    private final Set<String> excludeNodes;
    private final HashMap<String, Object> allocatorExcludedNodeList;
    private Set<String> currentExcludededYarnNodes;
    private Set<String> schedulerExcludedNodeList;
    private int numClusterNodes;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private long excludeOnFailureTimeoutMillis() {
        return this.excludeOnFailureTimeoutMillis;
    }

    private boolean launchExcludeOnFailureEnabled() {
        return this.launchExcludeOnFailureEnabled;
    }

    private int maxFailuresPerHost() {
        return this.maxFailuresPerHost;
    }

    private Set<String> excludeNodes() {
        return this.excludeNodes;
    }

    private HashMap<String, Object> allocatorExcludedNodeList() {
        return this.allocatorExcludedNodeList;
    }

    private Set<String> currentExcludededYarnNodes() {
        return this.currentExcludededYarnNodes;
    }

    private void currentExcludededYarnNodes_$eq(Set<String> x$1) {
        this.currentExcludededYarnNodes = x$1;
    }

    private Set<String> schedulerExcludedNodeList() {
        return this.schedulerExcludedNodeList;
    }

    private void schedulerExcludedNodeList_$eq(Set<String> x$1) {
        this.schedulerExcludedNodeList = x$1;
    }

    private int numClusterNodes() {
        return this.numClusterNodes;
    }

    private void numClusterNodes_$eq(int x$1) {
        this.numClusterNodes = x$1;
    }

    public void setNumClusterNodes(int numClusterNodes) {
        this.numClusterNodes_$eq(numClusterNodes);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void handleResourceAllocationFailure(Option<String> hostOpt) {
        Option<String> option = hostOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            String hostname = (String)some.value();
            if (this.launchExcludeOnFailureEnabled()) {
                BoxedUnit boxedUnit;
                if (!this.schedulerExcludedNodeList().contains((Object)hostname) && !this.allocatorExcludedNodeList().contains((Object)hostname)) {
                    this.failureTracker.registerFailureOnHost(hostname);
                    this.updateAllocationExcludedNodes(hostname);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
                return;
            }
        }
        this.failureTracker.registerExecutorFailure();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void updateAllocationExcludedNodes(String hostname) {
        block0: {
            int failuresOnHost = this.failureTracker.numFailuresOnHost(hostname);
            if (failuresOnHost <= this.maxFailuresPerHost()) break block0;
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(43).append("excluding ").append(hostname).append(" as YARN allocation failed ").append(failuresOnHost).append(" times").toString());
            this.allocatorExcludedNodeList().put((Object)hostname, (Object)BoxesRunTime.boxToLong((long)(this.failureTracker.clock().getTimeMillis() + this.excludeOnFailureTimeoutMillis())));
            this.refreshExcludedNodes();
        }
    }

    public void setSchedulerExcludedNodes(Set<String> schedulerExcludedNodesWithExpiry) {
        this.schedulerExcludedNodeList_$eq(schedulerExcludedNodesWithExpiry);
        this.refreshExcludedNodes();
    }

    public boolean isAllNodeExcluded() {
        boolean bl;
        if (this.numClusterNodes() <= 0) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "No available nodes reported, please check Resource Manager.");
            bl = false;
        } else {
            bl = this.currentExcludededYarnNodes().size() >= this.numClusterNodes();
        }
        return bl;
    }

    private void refreshExcludedNodes() {
        this.removeExpiredYarnExcludedNodes();
        Set allExcludedNodes = (Set)this.excludeNodes().$plus$plus(this.schedulerExcludedNodeList()).$plus$plus((IterableOnce)this.allocatorExcludedNodeList().keySet());
        this.synchronizeExcludedNodesWithYarn((Set<String>)allExcludedNodes);
    }

    private void synchronizeExcludedNodesWithYarn(Set<String> nodesToExclude) {
        List additions = (List)nodesToExclude.$minus$minus(this.currentExcludededYarnNodes()).toList().sorted((Ordering)Ordering.String$.MODULE$);
        List removals = (List)this.currentExcludededYarnNodes().$minus$minus(nodesToExclude).toList().sorted((Ordering)Ordering.String$.MODULE$);
        if (additions.nonEmpty()) {
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(62).append("adding nodes to YARN application master's excluded node list: ").append(additions).toString());
        }
        if (removals.nonEmpty()) {
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(66).append("removing nodes from YARN application master's excluded node list: ").append(removals).toString());
        }
        if (additions.nonEmpty() || removals.nonEmpty()) {
            this.amClient.updateBlacklist((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)additions).asJava(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)removals).asJava());
        }
        this.currentExcludededYarnNodes_$eq(nodesToExclude);
    }

    private void removeExpiredYarnExcludedNodes() {
        long now = this.failureTracker.clock().getTimeMillis();
        this.allocatorExcludedNodeList().retain((Function2 & Serializable)(x$1, expiryTime) -> BoxesRunTime.boxToBoolean((boolean)YarnAllocatorNodeHealthTracker.$anonfun$removeExpiredYarnExcludedNodes$1(now, x$1, BoxesRunTime.unboxToLong((Object)expiryTime))));
    }

    public static final /* synthetic */ boolean $anonfun$removeExpiredYarnExcludedNodes$1(long now$1, String x$1, long expiryTime) {
        return expiryTime > now$1;
    }

    public YarnAllocatorNodeHealthTracker(SparkConf sparkConf, AMRMClient<AMRMClient.ContainerRequest> amClient, FailureTracker failureTracker) {
        this.amClient = amClient;
        this.failureTracker = failureTracker;
        Logging.$init$((Logging)this);
        this.excludeOnFailureTimeoutMillis = HealthTracker$.MODULE$.getExludeOnFailureTimeout(sparkConf);
        this.launchExcludeOnFailureEnabled = BoxesRunTime.unboxToBoolean((Object)sparkConf.get(package$.MODULE$.YARN_EXECUTOR_LAUNCH_EXCLUDE_ON_FAILURE_ENABLED()));
        this.maxFailuresPerHost = BoxesRunTime.unboxToInt((Object)sparkConf.get(org.apache.spark.internal.config.package$.MODULE$.MAX_FAILED_EXEC_PER_NODE()));
        this.excludeNodes = ((IterableOnceOps)sparkConf.get(package$.MODULE$.YARN_EXCLUDE_NODES())).toSet();
        this.allocatorExcludedNodeList = new HashMap();
        this.currentExcludededYarnNodes = Predef$.MODULE$.Set().empty();
        this.schedulerExcludedNodeList = Predef$.MODULE$.Set().empty();
        this.numClusterNodes = Integer.MAX_VALUE;
    }
}

