/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.io.Serializable;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.launcher.YarnCommandBuilderUtils$;
import org.apache.spark.resource.ExecutorResourceRequest;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;
import scala.util.matching.Regex$;

public final class YarnSparkHadoopUtil$ {
    public static YarnSparkHadoopUtil$ MODULE$;
    private final double AM_MEMORY_OVERHEAD_FACTOR;
    private final String ANY_HOST;
    private final Priority RM_REQUEST_PRIORITY;
    private final String envVarNameRegex;

    static {
        new YarnSparkHadoopUtil$();
    }

    public double AM_MEMORY_OVERHEAD_FACTOR() {
        return this.AM_MEMORY_OVERHEAD_FACTOR;
    }

    public String ANY_HOST() {
        return this.ANY_HOST;
    }

    public Priority RM_REQUEST_PRIORITY() {
        return this.RM_REQUEST_PRIORITY;
    }

    public void addPathToEnvironment(HashMap<String, String> env, String key, String value) {
        String newValue = env.contains((Object)key) ? new StringBuilder(5).append((String)env.apply((Object)key)).append("<CPS>").append(value).toString() : value;
        env.put((Object)key, (Object)newValue);
    }

    private String envVarNameRegex() {
        return this.envVarNameRegex;
    }

    public String replaceEnvVars(String unresolvedString, Map<String, String> env, boolean isWindows) {
        String string;
        if (isWindows) {
            Regex windowsPattern = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(24).append("(?i)(?:\\^\\^|\\^%|%%|%(").append(this.envVarNameRegex()).append(")%)").toString())).r();
            string = windowsPattern.replaceAllIn((CharSequence)unresolvedString, (Function1 & Serializable & scala.Serializable)m -> {
                String string = m.matched();
                return Regex$.MODULE$.quoteReplacement("^^".equals(string) ? "^" : ("^%".equals(string) ? "%" : ("%%".equals(string) ? "%" : (String)env.getOrElse((Object)m.group(1), (Function0 & Serializable & scala.Serializable)() -> ""))));
            });
        } else {
            Regex unixPattern = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(30).append("(?i)(?:\\\\\\\\|\\\\\\$|\\$(").append(this.envVarNameRegex()).append(")|\\$\\{(").append(this.envVarNameRegex()).append(")})").toString())).r();
            string = unixPattern.replaceAllIn((CharSequence)unresolvedString, (Function1 & Serializable & scala.Serializable)m -> {
                String string = m.matched();
                return Regex$.MODULE$.quoteReplacement("\\\\".equals(string) ? "\\" : ("\\$".equals(string) ? "$" : (string.startsWith("${") ? (String)env.getOrElse((Object)m.group(2), (Function0 & Serializable & scala.Serializable)() -> "") : (String)env.getOrElse((Object)m.group(1), (Function0 & Serializable & scala.Serializable)() -> ""))));
            });
        }
        String osResolvedString = string;
        Regex yarnPattern = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(12).append("(?i)\\{\\{(").append(this.envVarNameRegex()).append(")}}").toString())).r();
        return yarnPattern.replaceAllIn((CharSequence)osResolvedString, (Function1 & Serializable & scala.Serializable)m -> Regex$.MODULE$.quoteReplacement((String)env.getOrElse((Object)m.group(1), (Function0 & Serializable & scala.Serializable)() -> "")));
    }

    public boolean replaceEnvVars$default$3() {
        return Utils$.MODULE$.isWindows();
    }

    public void addOutOfMemoryErrorArgument(ListBuffer<String> javaOpts) {
        if (!javaOpts.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.contains("-XX:OnOutOfMemoryError")))) {
            if (Utils$.MODULE$.isWindows()) {
                javaOpts.$plus$eq((Object)this.escapeForShell("-XX:OnOutOfMemoryError=taskkill /F /PID %%%%p"));
                return;
            }
            javaOpts.$plus$eq((Object)"-XX:OnOutOfMemoryError='kill %p'");
            return;
        }
    }

    public String escapeForShell(String arg) {
        if (arg != null) {
            if (Utils$.MODULE$.isWindows()) {
                return YarnCommandBuilderUtils$.MODULE$.quoteForBatchScript(arg);
            }
            scala.collection.mutable.StringBuilder escaped = new scala.collection.mutable.StringBuilder("'");
            new StringOps(Predef$.MODULE$.augmentString(arg)).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> YarnSparkHadoopUtil$.$anonfun$escapeForShell$1(escaped, BoxesRunTime.unboxToChar((Object)x0$1)));
            return escaped.append("'").toString();
        }
        return arg;
    }

    public Map<ApplicationAccessType, String> getApplicationAclsForYarn(SecurityManager securityMgr) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationAccessType.VIEW_APP), (Object)new StringBuilder(1).append(securityMgr.getViewAcls()).append(" ").append(securityMgr.getViewAclsGroups()).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationAccessType.MODIFY_APP), (Object)new StringBuilder(1).append(securityMgr.getModifyAcls()).append(" ").append(securityMgr.getModifyAclsGroups()).toString())}));
    }

    public ContainerId getContainerId() {
        String containerIdString = System.getenv(ApplicationConstants.Environment.CONTAINER_ID.name());
        return ContainerId.fromString((String)containerIdString);
    }

    public long executorOffHeapMemorySizeAsMb(SparkConf sparkConf, ExecutorResourceRequest execRequest) {
        return Utils$.MODULE$.checkOffHeapEnabled(sparkConf, execRequest.amount());
    }

    public static final /* synthetic */ scala.collection.mutable.StringBuilder $anonfun$escapeForShell$1(scala.collection.mutable.StringBuilder escaped$1, char x0$1) {
        char c = x0$1;
        switch (c) {
            case '$': {
                return escaped$1.append("\\$");
            }
            case '\"': {
                return escaped$1.append("\\\"");
            }
            case '\'': {
                return escaped$1.append("'\\''");
            }
        }
        return escaped$1.append(c);
    }

    private YarnSparkHadoopUtil$() {
        MODULE$ = this;
        this.AM_MEMORY_OVERHEAD_FACTOR = 0.1;
        this.ANY_HOST = "*";
        this.RM_REQUEST_PRIORITY = Priority.newInstance((int)1);
        this.envVarNameRegex = "[A-Za-z_][A-Za-z0-9_]*";
    }
}

