/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.yarn.ContainerLocalityPreferences;
import org.apache.spark.deploy.yarn.SparkRackResolver;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Set;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005ec!B\u0007\u000f\u00019A\u0002\u0002C\u0010\u0001\u0005\u000b\u0007I\u0011A\u0011\t\u0011\u0019\u0002!\u0011!Q\u0001\n\tB\u0001b\n\u0001\u0003\u0006\u0004%\t\u0001\u000b\u0005\tc\u0001\u0011\t\u0011)A\u0005S!A!\u0007\u0001BC\u0002\u0013\u00051\u0007\u0003\u0005>\u0001\t\u0005\t\u0015!\u00035\u0011!q\u0004A!A!\u0002\u0013y\u0004\"B\"\u0001\t\u0003!\u0005\"\u0002&\u0001\t\u0003Y\u0005bBA\u001b\u0001\u0011%\u0011q\u0007\u0005\b\u0003{\u0001A\u0011BA \u0011\u001d\tY\u0005\u0001C\u0005\u0003\u001b\u00121\u0006T8dC2LG/\u001f)sK\u001a,'O]3e\u0007>tG/Y5oKJ\u0004F.Y2f[\u0016tGo\u0015;sCR,w-\u001f\u0006\u0003\u001fA\tA!_1s]*\u0011\u0011CE\u0001\u0007I\u0016\u0004Hn\\=\u000b\u0005M!\u0012!B:qCJ\\'BA\u000b\u0017\u0003\u0019\t\u0007/Y2iK*\tq#A\u0002pe\u001e\u001c\"\u0001A\r\u0011\u0005iiR\"A\u000e\u000b\u0003q\tQa]2bY\u0006L!AH\u000e\u0003\r\u0005s\u0017PU3g\u0003%\u0019\b/\u0019:l\u0007>tgm\u0001\u0001\u0016\u0003\t\u0002\"a\t\u0013\u000e\u0003II!!\n\n\u0003\u0013M\u0003\u0018M]6D_:4\u0017AC:qCJ\\7i\u001c8gA\u0005A\u00110\u0019:o\u0007>tg-F\u0001*!\tQs&D\u0001,\u0015\taS&\u0001\u0003d_:4'B\u0001\u0018\u0015\u0003\u0019A\u0017\rZ8pa&\u0011\u0001g\u000b\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\u0013e\f'O\\\"p]\u001a\u0004\u0013\u0001\u0003:fg>,(oY3\u0016\u0003Q\u0002\"!N\u001e\u000e\u0003YR!a\u000e\u001d\u0002\u000fI,7m\u001c:eg*\u0011\u0011HO\u0001\u0004CBL'BA\b.\u0013\tadG\u0001\u0005SKN|WO]2f\u0003%\u0011Xm]8ve\u000e,\u0007%\u0001\u0005sKN|GN^3s!\t\u0001\u0015)D\u0001\u000f\u0013\t\u0011eBA\tTa\u0006\u00148NU1dWJ+7o\u001c7wKJ\fa\u0001P5oSRtD#B#G\u000f\"K\u0005C\u0001!\u0001\u0011\u0015y\u0002\u00021\u0001#\u0011\u00159\u0003\u00021\u0001*\u0011\u0015\u0011\u0004\u00021\u00015\u0011\u0015q\u0004\u00021\u0001@\u0003uawnY1mSRLxJ\u001a*fcV,7\u000f^3e\u0007>tG/Y5oKJ\u001cHC\u0002'S/fK\u0017\u0010E\u0002\u001b\u001b>K!AT\u000e\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\u0001\u0003\u0016BA)\u000f\u0005q\u0019uN\u001c;bS:,'\u000fT8dC2LG/\u001f)sK\u001a,'/\u001a8dKNDQaU\u0005A\u0002Q\u000bAB\\;n\u0007>tG/Y5oKJ\u0004\"AG+\n\u0005Y[\"aA%oi\")\u0001,\u0003a\u0001)\u0006)b.^7M_\u000e\fG.\u001b;z\u0003^\f'/\u001a+bg.\u001c\b\"\u0002.\n\u0001\u0004Y\u0016\u0001\u00065pgR$v\u000eT8dC2$\u0016m]6D_VtG\u000f\u0005\u0003]G\u001a$fBA/b!\tq6$D\u0001`\u0015\t\u0001\u0007%\u0001\u0004=e>|GOP\u0005\u0003En\ta\u0001\u0015:fI\u00164\u0017B\u00013f\u0005\ri\u0015\r\u001d\u0006\u0003En\u0001\"\u0001X4\n\u0005!,'AB*ue&tw\rC\u0003k\u0013\u0001\u00071.\u0001\u000fbY2|7-\u0019;fI\"{7\u000f\u001e+p\u0007>tG/Y5oKJ\u001cX*\u00199\u0011\t1\fhm]\u0007\u0002[*\u0011an\\\u0001\b[V$\u0018M\u00197f\u0015\t\u00018$\u0001\u0006d_2dWm\u0019;j_:L!A]7\u0003\u000f!\u000b7\u000f['baB\u0019A\u000e\u001e<\n\u0005Ul'aA*fiB\u0011Qg^\u0005\u0003qZ\u00121bQ8oi\u0006Lg.\u001a:JI\")!0\u0003a\u0001w\u0006\tCn\\2bY&$\u00180T1uG\",G\rU3oI&tw-\u00117m_\u000e\fG/[8ogB)A0a\u0001\u0002\n9\u0011Qp \b\u0003=zL\u0011\u0001H\u0005\u0004\u0003\u0003Y\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003\u000b\t9AA\u0002TKFT1!!\u0001\u001c!\u0011\tY!a\f\u000f\t\u00055\u0011\u0011\u0006\b\u0005\u0003\u001f\t)C\u0004\u0003\u0002\u0012\u0005\u0005b\u0002BA\n\u0003?qA!!\u0006\u0002\u001e9!\u0011qCA\u000e\u001d\rq\u0016\u0011D\u0005\u0002/%\u0011QCF\u0005\u0003]QI!aD\u0017\n\u0007\u0005\r\"(\u0001\u0004dY&,g\u000e^\u0005\u0004s\u0005\u001d\"bAA\u0012u%!\u00111FA\u0017\u0003)\tUJU'DY&,g\u000e\u001e\u0006\u0004s\u0005\u001d\u0012\u0002BA\u0019\u0003g\u0011\u0001cQ8oi\u0006Lg.\u001a:SKF,Xm\u001d;\u000b\t\u0005-\u0012QF\u0001\u0014]VlW\t_3dkR|'o\u001d)f]\u0012Lgn\u001a\u000b\u0004)\u0006e\u0002BBA\u001e\u0015\u0001\u0007A+A\bok6$\u0016m]6t!\u0016tG-\u001b8h\u0003q)\u0007\u0010]3di\u0016$\u0007j\\:u)>\u001cuN\u001c;bS:,'oQ8v]R$\u0012bWA!\u0003\u000b\n9%!\u0013\t\r\u0005\r3\u00021\u0001U\u0003IawnY1mSRL\u0018i^1sKR\u000b7o[:\t\u000bi[\u0001\u0019A.\t\u000b)\\\u0001\u0019A6\t\u000bi\\\u0001\u0019A>\u00027A,g\u000eZ5oO\"{7\u000f\u001e+p\u0007>tG/Y5oKJ\u001cu.\u001e8u)\u0011\ty%a\u0016\u0011\u000bq\u001bg-!\u0015\u0011\u0007i\t\u0019&C\u0002\u0002Vm\u0011a\u0001R8vE2,\u0007\"\u0002>\r\u0001\u0004Y\b")
public class LocalityPreferredContainerPlacementStrategy {
    private final SparkConf sparkConf;
    private final Configuration yarnConf;
    private final Resource resource;
    private final SparkRackResolver resolver;

    public SparkConf sparkConf() {
        return this.sparkConf;
    }

    public Configuration yarnConf() {
        return this.yarnConf;
    }

    public Resource resource() {
        return this.resource;
    }

    public ContainerLocalityPreferences[] localityOfRequestedContainers(int numContainer, int numLocalityAwareTasks, Map<String, Object> hostToLocalTaskCount, HashMap<String, Set<ContainerId>> allocatedHostToContainersMap, Seq<AMRMClient.ContainerRequest> localityMatchedPendingAllocations) {
        ArrayBuffer containerLocalityPreferences;
        block1: {
            Map<String, Object> updatedHostToContainerCount = this.expectedHostToContainerCount(numLocalityAwareTasks, hostToLocalTaskCount, allocatedHostToContainersMap, localityMatchedPendingAllocations);
            int updatedLocalityAwareContainerNum = BoxesRunTime.unboxToInt((Object)updatedHostToContainerCount.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            int requiredLocalityFreeContainerNum = package$.MODULE$.max(0, numContainer - updatedLocalityAwareContainerNum);
            int requiredLocalityAwareContainerNum = numContainer - requiredLocalityFreeContainerNum;
            containerLocalityPreferences = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            if (requiredLocalityFreeContainerNum > 0) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), requiredLocalityFreeContainerNum).foreach((Function1 & Serializable & scala.Serializable)i -> containerLocalityPreferences.$plus$eq((Object)new ContainerLocalityPreferences(null, null)));
            }
            if (requiredLocalityAwareContainerNum <= 0) break block1;
            int largestRatio = BoxesRunTime.unboxToInt((Object)updatedHostToContainerCount.values().max((Ordering)Ordering.Int$.MODULE$));
            ObjectRef preferredLocalityRatio = ObjectRef.create((Object)((Map)updatedHostToContainerCount.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                int ratio = tuple2._2$mcI$sp();
                double adjustedRatio = (double)ratio * (double)requiredLocalityAwareContainerNum / (double)largestRatio;
                Tuple2 tuple22 = new Tuple2((Object)k, (Object)BoxesRunTime.boxToInteger((int)((int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(adjustedRatio)))));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom())));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), requiredLocalityAwareContainerNum).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                String[] hosts = (String[])((MapLike)((Map)preferredLocalityRatio$1.elem).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)LocalityPreferredContainerPlacementStrategy.$anonfun$localityOfRequestedContainers$4(x$1)))).keys().toArray(ClassTag$.MODULE$.apply(String.class));
                scala.collection.immutable.Set racks = ((TraversableOnce)((TraversableLike)$this.resolver.resolve((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])hosts)).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getNetworkLocation(), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)LocalityPreferredContainerPlacementStrategy.$anonfun$localityOfRequestedContainers$6(x$3)))).toSet();
                containerLocalityPreferences.$plus$eq((Object)new ContainerLocalityPreferences(hosts, (String[])racks.toArray(ClassTag$.MODULE$.apply(String.class))));
                preferredLocalityRatio$1.elem = (Map)((Map)preferredLocalityRatio$1.elem).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String k = (String)tuple2._1();
                    int v = tuple2._2$mcI$sp();
                    Tuple2 tuple22 = new Tuple2((Object)k, (Object)BoxesRunTime.boxToInteger((int)(v - 1)));
                    return tuple22;
                }, Map$.MODULE$.canBuildFrom());
            });
        }
        return (ContainerLocalityPreferences[])containerLocalityPreferences.toArray(ClassTag$.MODULE$.apply(ContainerLocalityPreferences.class));
    }

    private int numExecutorsPending(int numTasksPending) {
        int coresPerExecutor = this.resource().getVirtualCores();
        return (numTasksPending * BoxesRunTime.unboxToInt((Object)this.sparkConf().get(org.apache.spark.internal.config.package$.MODULE$.CPUS_PER_TASK())) + coresPerExecutor - 1) / coresPerExecutor;
    }

    private Map<String, Object> expectedHostToContainerCount(int localityAwareTasks, Map<String, Object> hostToLocalTaskCount, HashMap<String, Set<ContainerId>> allocatedHostToContainersMap, Seq<AMRMClient.ContainerRequest> localityMatchedPendingAllocations) {
        int totalLocalTaskNum = BoxesRunTime.unboxToInt((Object)hostToLocalTaskCount.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Map<String, Object> pendingHostToContainersMap = this.pendingHostToContainerCount(localityMatchedPendingAllocations);
        return (Map)hostToLocalTaskCount.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String host = (String)tuple2._1();
            int count = tuple2._2$mcI$sp();
            double expectedCount = (double)count * (double)this.numExecutorsPending(localityAwareTasks) / (double)totalLocalTaskNum;
            double existedCount = (double)BoxesRunTime.unboxToInt((Object)allocatedHostToContainersMap.get((Object)host).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.size())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)) + BoxesRunTime.unboxToDouble((Object)pendingHostToContainersMap.getOrElse((Object)host, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0));
            Tuple2 tuple22 = new Tuple2((Object)host, (Object)BoxesRunTime.boxToInteger((int)package$.MODULE$.max(0, (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(expectedCount - existedCount)))));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
    }

    private Map<String, Object> pendingHostToContainerCount(Seq<AMRMClient.ContainerRequest> localityMatchedPendingAllocations) {
        HashMap pendingHostToContainerCount = new HashMap();
        localityMatchedPendingAllocations.foreach((Function1 & Serializable & scala.Serializable)cr -> {
            LocalityPreferredContainerPlacementStrategy.$anonfun$pendingHostToContainerCount$1(pendingHostToContainerCount, cr);
            return BoxedUnit.UNIT;
        });
        int possibleTotalContainerNum = BoxesRunTime.unboxToInt((Object)pendingHostToContainerCount.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        double localityMatchedPendingNum = localityMatchedPendingAllocations.size();
        return ((TraversableOnce)pendingHostToContainerCount.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            int v = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)k, (Object)BoxesRunTime.boxToDouble((double)((double)v * localityMatchedPendingNum / (double)possibleTotalContainerNum)));
            return tuple22;
        }, HashMap$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ boolean $anonfun$localityOfRequestedContainers$4(Tuple2 x$1) {
        return x$1._2$mcI$sp() > 0;
    }

    public static final /* synthetic */ boolean $anonfun$localityOfRequestedContainers$6(String x$3) {
        return x$3 != null;
    }

    public static final /* synthetic */ void $anonfun$pendingHostToContainerCount$2(HashMap pendingHostToContainerCount$1, String n) {
        int count = BoxesRunTime.unboxToInt((Object)pendingHostToContainerCount$1.getOrElse((Object)n, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)) + 1;
        pendingHostToContainerCount$1.update((Object)n, (Object)BoxesRunTime.boxToInteger((int)count));
    }

    public static final /* synthetic */ void $anonfun$pendingHostToContainerCount$1(HashMap pendingHostToContainerCount$1, AMRMClient.ContainerRequest cr) {
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(cr.getNodes()).asScala()).foreach((Function1 & Serializable & scala.Serializable)n -> {
            LocalityPreferredContainerPlacementStrategy.$anonfun$pendingHostToContainerCount$2(pendingHostToContainerCount$1, n);
            return BoxedUnit.UNIT;
        });
    }

    public LocalityPreferredContainerPlacementStrategy(SparkConf sparkConf, Configuration yarnConf, Resource resource, SparkRackResolver resolver) {
        this.sparkConf = sparkConf;
        this.yarnConf = yarnConf;
        this.resource = resource;
        this.resolver = resolver;
    }
}

