/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.io.Serializable;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.yarn.FailureTracker;
import org.apache.spark.deploy.yarn.config.package$;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.BlacklistTracker$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ee!\u0002\u0011\"\u0001\u0015Z\u0003\u0002\u0003\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\t\u0011y\u0002!\u0011!Q\u0001\n}B\u0001\u0002\u0019\u0001\u0003\u0002\u0003\u0006I!\u0019\u0005\u0006K\u0002!\tA\u001a\u0005\bW\u0002\u0011\r\u0011\"\u0003m\u0011\u0019\u0001\b\u0001)A\u0005[\"9\u0011\u000f\u0001b\u0001\n\u0013\u0011\bB\u0002<\u0001A\u0003%1\u000fC\u0004x\u0001\t\u0007I\u0011\u0002=\t\rq\u0004\u0001\u0015!\u0003z\u0011\u001di\bA1A\u0005\nyDq!a\b\u0001A\u0003%q\u0010C\u0005\u0002\"\u0001\u0011\r\u0011\"\u0003\u0002$!A\u0011\u0011\u0007\u0001!\u0002\u0013\t)\u0003\u0003\u0005\u00024\u0001\u0001\r\u0011\"\u0003\u007f\u0011%\t)\u0004\u0001a\u0001\n\u0013\t9\u0004C\u0004\u0002D\u0001\u0001\u000b\u0015B@\t\u0011\u0005\u0015\u0003\u00011A\u0005\nyD\u0011\"a\u0012\u0001\u0001\u0004%I!!\u0013\t\u000f\u00055\u0003\u0001)Q\u0005\u007f\"A\u0011q\n\u0001A\u0002\u0013%\u0001\u0010C\u0005\u0002R\u0001\u0001\r\u0011\"\u0003\u0002T!9\u0011q\u000b\u0001!B\u0013I\bbBA-\u0001\u0011\u0005\u00111\f\u0005\b\u0003?\u0002A\u0011AA1\u0011\u001d\ti\u0007\u0001C\u0005\u0003_Bq!!\u001e\u0001\t\u0003\t9\b\u0003\u0004\u0002\u0002\u0002!\tA\u001d\u0005\b\u0003\u0007\u0003A\u0011BAC\u0011\u001d\t9\t\u0001C\u0005\u0003\u0013Cq!a$\u0001\t\u0013\t)IA\u000fZCJt\u0017\t\u001c7pG\u0006$xN\u001d\"mC\u000e\\G.[:u)J\f7m[3s\u0015\t\u00113%\u0001\u0003zCJt'B\u0001\u0013&\u0003\u0019!W\r\u001d7ps*\u0011aeJ\u0001\u0006gB\f'o\u001b\u0006\u0003Q%\na!\u00199bG\",'\"\u0001\u0016\u0002\u0007=\u0014xmE\u0002\u0001YI\u0002\"!\f\u0019\u000e\u00039R\u0011aL\u0001\u0006g\u000e\fG.Y\u0005\u0003c9\u0012a!\u00118z%\u00164\u0007CA\u001a7\u001b\u0005!$BA\u001b&\u0003!Ig\u000e^3s]\u0006d\u0017BA\u001c5\u0005\u001daunZ4j]\u001e\f\u0011b\u001d9be.\u001cuN\u001c4\u0004\u0001A\u00111\bP\u0007\u0002K%\u0011Q(\n\u0002\n'B\f'o[\"p]\u001a\f\u0001\"Y7DY&,g\u000e\u001e\t\u0004\u0001\"SU\"A!\u000b\u0005\t\u001b\u0015aA1qS*\u0011A)R\u0001\u0007G2LWM\u001c;\u000b\u0005\t2%BA$(\u0003\u0019A\u0017\rZ8pa&\u0011\u0011*\u0011\u0002\u000b\u00036\u0013Vj\u00117jK:$\bCA&^\u001d\ta5L\u0004\u0002N5:\u0011a*\u0017\b\u0003\u001fbs!\u0001U,\u000f\u0005E3fB\u0001*V\u001b\u0005\u0019&B\u0001+:\u0003\u0019a$o\\8u}%\t!&\u0003\u0002)S%\u0011qiJ\u0005\u0003E\u0019K!\u0001R#\n\u0005\t\u001b\u0015B\u0001/B\u0003)\tUJU'DY&,g\u000e^\u0005\u0003=~\u0013\u0001cQ8oi\u0006Lg.\u001a:SKF,Xm\u001d;\u000b\u0005q\u000b\u0015A\u00044bS2,(/\u001a+sC\u000e\\WM\u001d\t\u0003E\u000el\u0011!I\u0005\u0003I\u0006\u0012aBR1jYV\u0014X\r\u0016:bG.,'/\u0001\u0004=S:LGO\u0010\u000b\u0005O\"L'\u000e\u0005\u0002c\u0001!)\u0001\b\u0002a\u0001u!)a\b\u0002a\u0001\u007f!)\u0001\r\u0002a\u0001C\u00061\"\r\\1dW2L7\u000f\u001e+j[\u0016|W\u000f^'jY2L7/F\u0001n!\tic.\u0003\u0002p]\t!Aj\u001c8h\u0003]\u0011G.Y2lY&\u001cH\u000fV5nK>,H/T5mY&\u001c\b%\u0001\fmCVt7\r\u001b\"mC\u000e\\G.[:u\u000b:\f'\r\\3e+\u0005\u0019\bCA\u0017u\u0013\t)hFA\u0004C_>dW-\u00198\u0002/1\fWO\\2i\u00052\f7m\u001b7jgR,e.\u00192mK\u0012\u0004\u0013AE7bq\u001a\u000b\u0017\u000e\\;sKN\u0004VM\u001d%pgR,\u0012!\u001f\t\u0003[iL!a\u001f\u0018\u0003\u0007%sG/A\nnCb4\u0015-\u001b7ve\u0016\u001c\b+\u001a:I_N$\b%\u0001\u0007fq\u000edW\u000fZ3O_\u0012,7/F\u0001\u0000!\u0019\t\t!a\u0003\u0002\u00105\u0011\u00111\u0001\u0006\u0005\u0003\u000b\t9!A\u0005j[6,H/\u00192mK*\u0019\u0011\u0011\u0002\u0018\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u000e\u0005\r!aA*fiB!\u0011\u0011CA\r\u001d\u0011\t\u0019\"!\u0006\u0011\u0005Is\u0013bAA\f]\u00051\u0001K]3eK\u001aLA!a\u0007\u0002\u001e\t11\u000b\u001e:j]\u001eT1!a\u0006/\u00035)\u0007p\u00197vI\u0016tu\u000eZ3tA\u0005\u0011\u0012\r\u001c7pG\u0006$xN\u001d\"mC\u000e\\G.[:u+\t\t)\u0003E\u0004\u0002(\u00055\u0012qB7\u000e\u0005\u0005%\"\u0002BA\u0016\u0003\u000f\tq!\\;uC\ndW-\u0003\u0003\u00020\u0005%\"a\u0002%bg\"l\u0015\r]\u0001\u0014C2dwnY1u_J\u0014E.Y2lY&\u001cH\u000fI\u0001\u001cGV\u0014(/\u001a8u\u00052\f7m\u001b7jgR,G-W1s]:{G-Z:\u0002?\r,(O]3oi\nc\u0017mY6mSN$X\rZ-be:tu\u000eZ3t?\u0012*\u0017\u000f\u0006\u0003\u0002:\u0005}\u0002cA\u0017\u0002<%\u0019\u0011Q\b\u0018\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003\u0003\u0002\u0012\u0011!a\u0001\u007f\u0006\u0019\u0001\u0010J\u0019\u00029\r,(O]3oi\nc\u0017mY6mSN$X\rZ-be:tu\u000eZ3tA\u0005\u00112o\u00195fIVdWM\u001d\"mC\u000e\\G.[:u\u0003Y\u00198\r[3ek2,'O\u00117bG.d\u0017n\u001d;`I\u0015\fH\u0003BA\u001d\u0003\u0017B\u0001\"!\u0011\u0014\u0003\u0003\u0005\ra`\u0001\u0014g\u000eDW\rZ;mKJ\u0014E.Y2lY&\u001cH\u000fI\u0001\u0010]Vl7\t\\;ti\u0016\u0014hj\u001c3fg\u0006\u0019b.^7DYV\u001cH/\u001a:O_\u0012,7o\u0018\u0013fcR!\u0011\u0011HA+\u0011!\t\tEFA\u0001\u0002\u0004I\u0018\u0001\u00058v[\u000ecWo\u001d;fe:{G-Z:!\u0003I\u0019X\r\u001e(v[\u000ecWo\u001d;fe:{G-Z:\u0015\t\u0005e\u0012Q\f\u0005\u0007\u0003\u001fB\u0002\u0019A=\u0002?!\fg\u000e\u001a7f%\u0016\u001cx.\u001e:dK\u0006cGn\\2bi&|gNR1jYV\u0014X\r\u0006\u0003\u0002:\u0005\r\u0004bBA33\u0001\u0007\u0011qM\u0001\bQ>\u001cHo\u00149u!\u0015i\u0013\u0011NA\b\u0013\r\tYG\f\u0002\u0007\u001fB$\u0018n\u001c8\u0002AU\u0004H-\u0019;f\u00032dwnY1uS>t'\t\\1dW2L7\u000f^3e\u001d>$Wm\u001d\u000b\u0005\u0003s\t\t\bC\u0004\u0002ti\u0001\r!a\u0004\u0002\u0011!|7\u000f\u001e8b[\u0016\fAd]3u'\u000eDW\rZ;mKJ\u0014E.Y2lY&\u001cH/\u001a3O_\u0012,7\u000f\u0006\u0003\u0002:\u0005e\u0004bBA>7\u0001\u0007\u0011QP\u0001$g\u000eDW\rZ;mKJ\u0014E.Y2lY&\u001cH/\u001a3O_\u0012,7oV5uQ\u0016C\b/\u001b:z!\u0019\t\t\"a \u0002\u0010%!\u0011QBA\u000f\u0003QI7/\u00117m\u001d>$WM\u00117bG.d\u0017n\u001d;fI\u00069\"/\u001a4sKND'\t\\1dW2L7\u000f^3e\u001d>$Wm\u001d\u000b\u0003\u0003s\t!e]=oG\"\u0014xN\\5{K\nc\u0017mY6mSN$X\r\u001a(pI\u0016<\u0016\u000e\u001e5ZCJtG\u0003BA\u001d\u0003\u0017Cq!!$\u001f\u0001\u0004\ti(\u0001\to_\u0012,7\u000fV8CY\u0006\u001c7\u000e\\5ti\u0006\t#/Z7pm\u0016,\u0005\u0010]5sK\u0012L\u0016M\u001d8CY\u0006\u001c7\u000e\\5ti\u0016$gj\u001c3fg\u0002")
public class YarnAllocatorBlacklistTracker
implements Logging {
    private final AMRMClient<AMRMClient.ContainerRequest> amClient;
    private final FailureTracker failureTracker;
    private final long blacklistTimeoutMillis;
    private final boolean launchBlacklistEnabled;
    private final int maxFailuresPerHost;
    private final Set<String> excludeNodes;
    private final HashMap<String, Object> allocatorBlacklist;
    private Set<String> currentBlacklistedYarnNodes;
    private Set<String> schedulerBlacklist;
    private int numClusterNodes;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private long blacklistTimeoutMillis() {
        return this.blacklistTimeoutMillis;
    }

    private boolean launchBlacklistEnabled() {
        return this.launchBlacklistEnabled;
    }

    private int maxFailuresPerHost() {
        return this.maxFailuresPerHost;
    }

    private Set<String> excludeNodes() {
        return this.excludeNodes;
    }

    private HashMap<String, Object> allocatorBlacklist() {
        return this.allocatorBlacklist;
    }

    private Set<String> currentBlacklistedYarnNodes() {
        return this.currentBlacklistedYarnNodes;
    }

    private void currentBlacklistedYarnNodes_$eq(Set<String> x$1) {
        this.currentBlacklistedYarnNodes = x$1;
    }

    private Set<String> schedulerBlacklist() {
        return this.schedulerBlacklist;
    }

    private void schedulerBlacklist_$eq(Set<String> x$1) {
        this.schedulerBlacklist = x$1;
    }

    private int numClusterNodes() {
        return this.numClusterNodes;
    }

    private void numClusterNodes_$eq(int x$1) {
        this.numClusterNodes = x$1;
    }

    public void setNumClusterNodes(int numClusterNodes) {
        this.numClusterNodes_$eq(numClusterNodes);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void handleResourceAllocationFailure(Option<String> hostOpt) {
        Option<String> option = hostOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            String hostname = (String)some.value();
            if (this.launchBlacklistEnabled()) {
                BoxedUnit boxedUnit;
                if (!this.schedulerBlacklist().contains((Object)hostname) && !this.allocatorBlacklist().contains((Object)hostname)) {
                    this.failureTracker.registerFailureOnHost(hostname);
                    this.updateAllocationBlacklistedNodes(hostname);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
                return;
            }
        }
        this.failureTracker.registerExecutorFailure();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void updateAllocationBlacklistedNodes(String hostname) {
        block0: {
            int failuresOnHost = this.failureTracker.numFailuresOnHost(hostname);
            if (failuresOnHost <= this.maxFailuresPerHost()) break block0;
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("blacklisting ").append(hostname).append(" as YARN allocation failed ").append(failuresOnHost).append(" times").toString());
            this.allocatorBlacklist().put((Object)hostname, (Object)BoxesRunTime.boxToLong((long)(this.failureTracker.clock().getTimeMillis() + this.blacklistTimeoutMillis())));
            this.refreshBlacklistedNodes();
        }
    }

    public void setSchedulerBlacklistedNodes(Set<String> schedulerBlacklistedNodesWithExpiry) {
        this.schedulerBlacklist_$eq(schedulerBlacklistedNodesWithExpiry);
        this.refreshBlacklistedNodes();
    }

    public boolean isAllNodeBlacklisted() {
        return this.currentBlacklistedYarnNodes().size() >= this.numClusterNodes();
    }

    private void refreshBlacklistedNodes() {
        this.removeExpiredYarnBlacklistedNodes();
        Set allBlacklistedNodes = (Set)this.excludeNodes().$plus$plus(this.schedulerBlacklist()).$plus$plus((GenTraversableOnce)this.allocatorBlacklist().keySet());
        this.synchronizeBlacklistedNodeWithYarn((Set<String>)allBlacklistedNodes);
    }

    private void synchronizeBlacklistedNodeWithYarn(Set<String> nodesToBlacklist) {
        List additions = (List)((TraversableOnce)nodesToBlacklist.$minus$minus(this.currentBlacklistedYarnNodes())).toList().sorted((Ordering)Ordering.String$.MODULE$);
        List removals = (List)((TraversableOnce)this.currentBlacklistedYarnNodes().$minus$minus(nodesToBlacklist)).toList().sorted((Ordering)Ordering.String$.MODULE$);
        if (additions.nonEmpty()) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("adding nodes to YARN application master's blacklist: ").append(additions).toString());
        }
        if (removals.nonEmpty()) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("removing nodes from YARN application master's blacklist: ").append(removals).toString());
        }
        if (additions.nonEmpty() || removals.nonEmpty()) {
            this.amClient.updateBlacklist((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)additions).asJava(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)removals).asJava());
        }
        this.currentBlacklistedYarnNodes_$eq(nodesToBlacklist);
    }

    private void removeExpiredYarnBlacklistedNodes() {
        long now = this.failureTracker.clock().getTimeMillis();
        this.allocatorBlacklist().retain((Function2 & Serializable & scala.Serializable)(x$1, expiryTime) -> BoxesRunTime.boxToBoolean((boolean)YarnAllocatorBlacklistTracker.$anonfun$removeExpiredYarnBlacklistedNodes$1(now, x$1, BoxesRunTime.unboxToLong((Object)expiryTime))));
    }

    public static final /* synthetic */ boolean $anonfun$removeExpiredYarnBlacklistedNodes$1(long now$1, String x$1, long expiryTime) {
        return expiryTime > now$1;
    }

    public YarnAllocatorBlacklistTracker(SparkConf sparkConf, AMRMClient<AMRMClient.ContainerRequest> amClient, FailureTracker failureTracker) {
        this.amClient = amClient;
        this.failureTracker = failureTracker;
        Logging.$init$((Logging)this);
        this.blacklistTimeoutMillis = BlacklistTracker$.MODULE$.getBlacklistTimeout(sparkConf);
        this.launchBlacklistEnabled = BoxesRunTime.unboxToBoolean((Object)sparkConf.get(package$.MODULE$.YARN_EXECUTOR_LAUNCH_BLACKLIST_ENABLED()));
        this.maxFailuresPerHost = BoxesRunTime.unboxToInt((Object)sparkConf.get(org.apache.spark.internal.config.package$.MODULE$.MAX_FAILED_EXEC_PER_NODE()));
        this.excludeNodes = ((TraversableOnce)sparkConf.get(package$.MODULE$.YARN_EXCLUDE_NODES())).toSet();
        this.allocatorBlacklist = new HashMap();
        this.currentBlacklistedYarnNodes = Predef$.MODULE$.Set().empty();
        this.schedulerBlacklist = Predef$.MODULE$.Set().empty();
        this.numClusterNodes = Integer.MAX_VALUE;
    }
}

