/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.RpcCallContext;
import org.apache.spark.rpc.RpcEndpoint;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.rpc.RpcTimeout;
import org.apache.spark.rpc.ThreadSafeRpcEndpoint;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.SchedulerBackend;
import org.apache.spark.scheduler.SlaveLost;
import org.apache.spark.scheduler.SlaveLost$;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend;
import org.apache.spark.scheduler.cluster.SchedulerExtensionServiceBinding;
import org.apache.spark.scheduler.cluster.SchedulerExtensionServices;
import org.apache.spark.scheduler.cluster.YarnSchedulerBackend$;
import org.apache.spark.scheduler.cluster.YarnSchedulerBackend$YarnSchedulerEndpoint$;
import org.apache.spark.ui.JettyUtils$;
import org.apache.spark.util.RpcUtils$;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\tMgAB\u001e=\u0003\u0003\u0001e\t\u0003\u0005@\u0001\t\u0005\t\u0015!\u0003M\u0011!\u0001\u0006A!A!\u0002\u0013\t\u0006\"B+\u0001\t\u00031\u0006b\u0002.\u0001\u0005\u0004%Ia\u0017\u0005\u0007Q\u0002\u0001\u000b\u0011\u0002/\t\u000f%\u0004!\u0019!C!U\"1\u0011\u000f\u0001Q\u0001\n-DqA\u001d\u0001A\u0002\u0013E1\u000fC\u0004x\u0001\u0001\u0007I\u0011\u0003=\t\ry\u0004\u0001\u0015)\u0003u\u0011!y\bA1A\u0005\n\u0005\u0005\u0001\u0002CAP\u0001\u0001\u0006I!a\u0001\t\u0013\u0005\u0005\u0006A1A\u0005\n\u0005\r\u0006\u0002CAS\u0001\u0001\u0006I!a\u0011\t\u0013\u0005\u001d\u0006A1A\u0005\f\u0005%\u0006\u0002CAY\u0001\u0001\u0006I!a+\t\u0013\u0005M\u0006\u00011A\u0005\u0012\u0005U\u0006\"CAi\u0001\u0001\u0007I\u0011CAj\u0011!\t9\u000e\u0001Q!\n\u0005]\u0006\"CAm\u0001\u0001\u0007I\u0011BAn\u0011%\t)\u000f\u0001a\u0001\n\u0013\t9\u000f\u0003\u0005\u0002l\u0002\u0001\u000b\u0015BAo\u0011%\ti\u000f\u0001b\u0001\n\u0013\ty\u000f\u0003\u0005\u0002x\u0002\u0001\u000b\u0011BAy\u0011\u001d\tI\u0010\u0001C\t\u0003wDqA!\u0001\u0001\t\u0003\u0012\u0019\u0001C\u0004\u0003\u0006\u0001!\tEa\u0001\t\u000f\t\u001d\u0001\u0001\"\u0011\u0003\n!9!Q\u0002\u0001\u0005B\t=\u0001\u0002\u0003B\t\u0001\u0011\u0005AHa\u0005\t\u000f\tm\u0002\u0001\"\u0011\u0003>!9!\u0011\u000b\u0001\u0005B\tM\u0003b\u0002B6\u0001\u0011\u0005#Q\u000e\u0005\b\u0005_\u0002A\u0011\u0002B9\u0011\u001d\u0011)\t\u0001C!\u0005\u000fCqAa'\u0001\t#\u0012\u0019A\u0002\u0004\u0003\u001e\u0002!!q\u0014\u0005\r\u0003S)#\u0011!Q\u0001\n\u00055\"\u0011\u0015\u0005\u000b\u0005G+#\u0011!Q\u0001\n\tM\u0005BB+&\t\u0003\u0011)\u000bC\u0004\u0002p\u0015\"\tE!,\u0007\r\u0005\u001d\u0001\u0001BA\u0005\u0011)\tIC\u000bBC\u0002\u0013\u0005\u00131\u0006\u0005\u000b\u0003gQ#\u0011!Q\u0001\n\u00055\u0002BB++\t\u0003\t)\u0004C\u0005\u0002:)\u0002\r\u0011\"\u0003\u0002<!I\u0011\u0011\n\u0016A\u0002\u0013%\u00111\n\u0005\t\u0003\u001fR\u0003\u0015)\u0003\u0002>!9\u0011\u0011\u000b\u0016\u0005B\u0005M\u0003bBA1U\u0011\u0005\u00131\r\u0005\b\u0003_RC\u0011IA9\u00111\tiH\u000bB\u0001\u0002\u0003%\t\u0001AA@\u00119\u0011\u0019\f\u0001I\u0001\u0004\u0003\u0005I\u0011\u0002B\b\u0005k;\u0001Ba/=\u0011\u0003\u0001%Q\u0018\u0004\bwqB\t\u0001\u0011B`\u0011\u0019)v\u0007\"\u0001\u0003B\"I!1Y\u001cC\u0002\u0013\u0005!Q\u0019\u0005\t\u0005#<\u0004\u0015!\u0003\u0003H\n!\u0012,\u0019:o'\u000eDW\rZ;mKJ\u0014\u0015mY6f]\u0012T!!\u0010 \u0002\u000f\rdWo\u001d;fe*\u0011q\bQ\u0001\ng\u000eDW\rZ;mKJT!!\u0011\"\u0002\u000bM\u0004\u0018M]6\u000b\u0005\r#\u0015AB1qC\u000eDWMC\u0001F\u0003\ry'oZ\n\u0003\u0001\u001d\u0003\"\u0001S%\u000e\u0003qJ!A\u0013\u001f\u0003;\r{\u0017M]:f\u000fJ\f\u0017N\\3e'\u000eDW\rZ;mKJ\u0014\u0015mY6f]\u0012\u001c\u0001\u0001\u0005\u0002N\u001d6\ta(\u0003\u0002P}\t\tB+Y:l'\u000eDW\rZ;mKJLU\u000e\u001d7\u0002\u0005M\u001c\u0007C\u0001*T\u001b\u0005\u0001\u0015B\u0001+A\u00051\u0019\u0006/\u0019:l\u0007>tG/\u001a=u\u0003\u0019a\u0014N\\5u}Q\u0019q\u000bW-\u0011\u0005!\u0003\u0001\"B \u0004\u0001\u0004a\u0005\"\u0002)\u0004\u0001\u0004\t\u0016aB:u_B\u0004X\rZ\u000b\u00029B\u0011QLZ\u0007\u0002=*\u0011q\fY\u0001\u0007CR|W.[2\u000b\u0005\u0005\u0014\u0017AC2p]\u000e,(O]3oi*\u00111\rZ\u0001\u0005kRLGNC\u0001f\u0003\u0011Q\u0017M^1\n\u0005\u001dt&!D!u_6L7MQ8pY\u0016\fg.\u0001\u0005ti>\u0004\b/\u001a3!\u0003Ii\u0017N\u001c*fO&\u001cH/\u001a:fIJ\u000bG/[8\u0016\u0003-\u0004\"\u0001\\8\u000e\u00035T\u0011A\\\u0001\u0006g\u000e\fG.Y\u0005\u0003a6\u0014a\u0001R8vE2,\u0017aE7j]J+w-[:uKJ,GMU1uS>\u0004\u0013A\u0006;pi\u0006dW\t\u001f9fGR,G-\u0012=fGV$xN]:\u0016\u0003Q\u0004\"\u0001\\;\n\u0005Yl'aA%oi\u0006QBo\u001c;bY\u0016C\b/Z2uK\u0012,\u00050Z2vi>\u00148o\u0018\u0013fcR\u0011\u0011\u0010 \t\u0003YjL!a_7\u0003\tUs\u0017\u000e\u001e\u0005\b{&\t\t\u00111\u0001u\u0003\rAH%M\u0001\u0018i>$\u0018\r\\#ya\u0016\u001cG/\u001a3Fq\u0016\u001cW\u000f^8sg\u0002\nQ#_1s]N\u001b\u0007.\u001a3vY\u0016\u0014XI\u001c3q_&tG/\u0006\u0002\u0002\u0004A\u0019\u0011Q\u0001\u0016\u000e\u0003\u0001\u0011Q#W1s]N\u001b\u0007.\u001a3vY\u0016\u0014XI\u001c3q_&tGoE\u0004+\u0003\u0017\t\t\"!\b\u0011\u00071\fi!C\u0002\u0002\u00105\u0014a!\u00118z%\u00164\u0007\u0003BA\n\u00033i!!!\u0006\u000b\u0007\u0005]\u0001)A\u0002sa\u000eLA!a\u0007\u0002\u0016\t)B\u000b\u001b:fC\u0012\u001c\u0016MZ3Sa\u000e,e\u000e\u001a9pS:$\b\u0003BA\u0010\u0003Ki!!!\t\u000b\u0007\u0005\r\u0002)\u0001\u0005j]R,'O\\1m\u0013\u0011\t9#!\t\u0003\u000f1{wmZ5oO\u00061!\u000f]2F]Z,\"!!\f\u0011\t\u0005M\u0011qF\u0005\u0005\u0003c\t)B\u0001\u0004Sa\u000e,eN^\u0001\beB\u001cWI\u001c<!)\u0011\t\u0019!a\u000e\t\u000f\u0005%R\u00061\u0001\u0002.\u0005Q\u0011-\\#oIB|\u0017N\u001c;\u0016\u0005\u0005u\u0002#\u00027\u0002@\u0005\r\u0013bAA![\n1q\n\u001d;j_:\u0004B!a\u0005\u0002F%!\u0011qIA\u000b\u00059\u0011\u0006oY#oIB|\u0017N\u001c;SK\u001a\fa\"Y7F]\u0012\u0004x.\u001b8u?\u0012*\u0017\u000fF\u0002z\u0003\u001bB\u0001\"`\u0018\u0002\u0002\u0003\u0007\u0011QH\u0001\fC6,e\u000e\u001a9pS:$\b%A\u0004sK\u000e,\u0017N^3\u0016\u0005\u0005U\u0003C\u00027\u0002X\u0005m\u00130C\u0002\u0002Z5\u0014q\u0002U1si&\fGNR;oGRLwN\u001c\t\u0004Y\u0006u\u0013bAA0[\n\u0019\u0011I\\=\u0002\u001fI,7-Z5wK\u0006sGMU3qYf$B!!\u0016\u0002f!9\u0011q\r\u001aA\u0002\u0005%\u0014aB2p]R,\u0007\u0010\u001e\t\u0005\u0003'\tY'\u0003\u0003\u0002n\u0005U!A\u0004*qG\u000e\u000bG\u000e\\\"p]R,\u0007\u0010^\u0001\u000f_:$\u0015n]2p]:,7\r^3e)\rI\u00181\u000f\u0005\b\u0003k\u001a\u0004\u0019AA<\u00035\u0011X-\\8uK\u0006#GM]3tgB!\u00111CA=\u0013\u0011\tY(!\u0006\u0003\u0015I\u00038-\u00113ee\u0016\u001c8/A/pe\u001e$\u0013\r]1dQ\u0016$3\u000f]1sW\u0012\u001a8\r[3ek2,'\u000fJ2mkN$XM\u001d\u0013ZCJt7k\u00195fIVdWM\u001d\"bG.,g\u000e\u001a\u0013%Q\u0006tG\r\\3Fq\u0016\u001cW\u000f^8s\t&\u001c8m\u001c8oK\u000e$X\r\u001a$s_6$%/\u001b<feR)\u00110!!\u0002\u001c\"9\u00111\u0011\u001bA\u0002\u0005\u0015\u0015AC3yK\u000e,Ho\u001c:JIB!\u0011qQAK\u001d\u0011\tI)!%\u0011\u0007\u0005-U.\u0004\u0002\u0002\u000e*\u0019\u0011qR&\u0002\rq\u0012xn\u001c;?\u0013\r\t\u0019*\\\u0001\u0007!J,G-\u001a4\n\t\u0005]\u0015\u0011\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005MU\u000eC\u0004\u0002\u001eR\u0002\r!a\u001e\u0002%\u0015DXmY;u_J\u0014\u0006oY!eIJ,7o]\u0001\u0017s\u0006\u0014hnU2iK\u0012,H.\u001a:F]\u0012\u0004x.\u001b8uA\u0005A\u00120\u0019:o'\u000eDW\rZ;mKJ,e\u000e\u001a9pS:$(+\u001a4\u0016\u0005\u0005\r\u0013!G=be:\u001c6\r[3ek2,'/\u00128ea>Lg\u000e\u001e*fM\u0002\n!\"Y:l)&lWm\\;u+\t\tY\u000b\u0005\u0003\u0002\u0014\u00055\u0016\u0002BAX\u0003+\u0011!B\u00159d)&lWm\\;u\u0003-\t7o\u001b+j[\u0016|W\u000f\u001e\u0011\u0002\u000b\u0005\u0004\b/\u00133\u0016\u0005\u0005]\u0006#\u00027\u0002@\u0005e\u0006\u0003BA^\u0003\u001bl!!!0\u000b\t\u0005}\u0016\u0011Y\u0001\be\u0016\u001cwN\u001d3t\u0015\u0011\t\u0019-!2\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002H\u0006%\u0017\u0001B=be:T1!a3C\u0003\u0019A\u0017\rZ8pa&!\u0011qZA_\u00055\t\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8JI\u0006I\u0011\r\u001d9JI~#S-\u001d\u000b\u0004s\u0006U\u0007\u0002C?\u0013\u0003\u0003\u0005\r!a.\u0002\r\u0005\u0004\b/\u00133!\u0003%\tG\u000f^3naRLE-\u0006\u0002\u0002^B)A.a\u0010\u0002`B!\u00111XAq\u0013\u0011\t\u0019/!0\u0003)\u0005\u0003\b\u000f\\5dCRLwN\\!ui\u0016l\u0007\u000f^%e\u00035\tG\u000f^3naRLEm\u0018\u0013fcR\u0019\u00110!;\t\u0011u,\u0012\u0011!a\u0001\u0003;\f!\"\u0019;uK6\u0004H/\u00133!\u0003!\u0019XM\u001d<jG\u0016\u001cXCAAy!\rA\u00151_\u0005\u0004\u0003kd$AG*dQ\u0016$W\u000f\\3s\u000bb$XM\\:j_:\u001cVM\u001d<jG\u0016\u001c\u0018!C:feZL7-Z:!\u0003)\u0011\u0017N\u001c3U_f\u000b'O\u001c\u000b\u0006s\u0006u\u0018q \u0005\b\u0003gK\u0002\u0019AA]\u0011\u001d\tI.\u0007a\u0001\u0003;\fQa\u001d;beR$\u0012!_\u0001\u0005gR|\u0007/\u0001\u000bbaBd\u0017nY1uS>t\u0017\t\u001e;f[B$\u0018\n\u001a\u000b\u0003\u0005\u0017\u0001R\u0001\\A \u0003\u000b\u000bQ\"\u00199qY&\u001c\u0017\r^5p]&#GCAAC\u0003]\u0001(/\u001a9be\u0016\u0014V-];fgR,\u00050Z2vi>\u00148\u000f\u0006\u0003\u0003\u0016\t]\u0002\u0003\u0002B\f\u0005cqAA!\u0007\u0003.9!!1\u0004B\u0016\u001d\u0011\u0011iB!\u000b\u000f\t\t}!q\u0005\b\u0005\u0005C\u0011)C\u0004\u0003\u0002\f\n\r\u0012\"A#\n\u0005\r#\u0015BA!C\u0013\ty\u0004)\u0003\u0002>}%\u0019!q\u0006\u001f\u00029\r{\u0017M]:f\u000fJ\f\u0017N\\3e\u00072,8\u000f^3s\u001b\u0016\u001c8/Y4fg&!!1\u0007B\u001b\u0005A\u0011V-];fgR,\u00050Z2vi>\u00148OC\u0002\u00030qBaA!\u000f\u001f\u0001\u0004!\u0018A\u0004:fcV,7\u000f^3e)>$\u0018\r\\\u0001\u0018I>\u0014V-];fgR$v\u000e^1m\u000bb,7-\u001e;peN$BAa\u0010\u0003PA1!\u0011\tB#\u0005\u0013j!Aa\u0011\u000b\u0005\u0005l\u0017\u0002\u0002B$\u0005\u0007\u0012aAR;ukJ,\u0007c\u00017\u0003L%\u0019!QJ7\u0003\u000f\t{w\u000e\\3b]\"1!\u0011H\u0010A\u0002Q\fq\u0002Z8LS2dW\t_3dkR|'o\u001d\u000b\u0005\u0005\u007f\u0011)\u0006C\u0004\u0003X\u0001\u0002\rA!\u0017\u0002\u0017\u0015DXmY;u_JLEm\u001d\t\u0007\u00057\u0012)'!\"\u000f\t\tu#\u0011\r\b\u0005\u0003\u0017\u0013y&C\u0001o\u0013\r\u0011\u0019'\\\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u00119G!\u001b\u0003\u0007M+\u0017OC\u0002\u0003d5\fQd];gM&\u001c\u0017.\u001a8u%\u0016\u001cx.\u001e:dKN\u0014VmZ5ti\u0016\u0014X\r\u001a\u000b\u0003\u0005\u0013\na\"\u00193e/\u0016\u0014W+\u0013$jYR,'\u000fF\u0004z\u0005g\u00129H!!\t\u000f\tU$\u00051\u0001\u0002\u0006\u0006Qa-\u001b7uKJt\u0015-\\3\t\u000f\te$\u00051\u0001\u0003|\u0005aa-\u001b7uKJ\u0004\u0016M]1ngBA\u0011q\u0011B?\u0003\u000b\u000b))\u0003\u0003\u0003\u0000\u0005e%aA'ba\"9!1\u0011\u0012A\u0002\u0005\u0015\u0015!\u00039s_bL()Y:f\u0003Q\u0019'/Z1uK\u0012\u0013\u0018N^3s\u000b:$\u0007o\\5oiR!!\u0011\u0012BH!\u0011\t)Aa#\n\u0007\t5\u0015J\u0001\bEe&4XM]#oIB|\u0017N\u001c;\t\u000f\tE5\u00051\u0001\u0003\u0014\u0006Q\u0001O]8qKJ$\u0018.Z:\u0011\r\tm#Q\rBK!\u001da'qSAC\u0003\u000bK1A!'n\u0005\u0019!V\u000f\u001d7fe\u0005)!/Z:fi\n\u0011\u0012,\u0019:o\tJLg/\u001a:F]\u0012\u0004x.\u001b8u'\r)#\u0011R\u0005\u0005\u0003S\u0011Y)A\bta\u0006\u00148\u000e\u0015:pa\u0016\u0014H/[3t)\u0019\u00119K!+\u0003,B\u0019\u0011QA\u0013\t\u000f\u0005%\u0002\u00061\u0001\u0002.!9!1\u0015\u0015A\u0002\tMEcA=\u00030\"9!\u0011W\u0015A\u0002\u0005]\u0014A\u0003:qG\u0006#GM]3tg\u0006\u00192/\u001e9fe\u0012\n\u0007\u000f\u001d7jG\u0006$\u0018n\u001c8JI&!!Q\u0002B\\\u0013\r\u0011IL\u0010\u0002\u0011'\u000eDW\rZ;mKJ\u0014\u0015mY6f]\u0012\fA#W1s]N\u001b\u0007.\u001a3vY\u0016\u0014()Y2lK:$\u0007C\u0001%8'\r9\u00141\u0002\u000b\u0003\u0005{\u000bQ\"\u0012(E!>Ke\nV0O\u00036+UC\u0001Bd!\u0011\u0011IMa4\u000e\u0005\t-'b\u0001BgI\u0006!A.\u00198h\u0013\u0011\t9Ja3\u0002\u001d\u0015sE\tU(J\u001dR{f*Q'FA\u0001")
public abstract class YarnSchedulerBackend
extends CoarseGrainedSchedulerBackend {
    private final TaskSchedulerImpl scheduler;
    public final SparkContext org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$sc;
    private final AtomicBoolean org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$stopped;
    private final double minRegisteredRatio;
    private int totalExpectedExecutors;
    private final YarnSchedulerEndpoint org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$yarnSchedulerEndpoint;
    private final RpcEndpointRef yarnSchedulerEndpointRef;
    private final RpcTimeout org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$askTimeout;
    private Option<ApplicationId> appId;
    private Option<ApplicationAttemptId> attemptId;
    private final SchedulerExtensionServices services;

    public static String ENDPOINT_NAME() {
        return YarnSchedulerBackend$.MODULE$.ENDPOINT_NAME();
    }

    private /* synthetic */ String super$applicationId() {
        return SchedulerBackend.applicationId$((SchedulerBackend)this);
    }

    public AtomicBoolean org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$stopped() {
        return this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$stopped;
    }

    public double minRegisteredRatio() {
        return this.minRegisteredRatio;
    }

    public int totalExpectedExecutors() {
        return this.totalExpectedExecutors;
    }

    public void totalExpectedExecutors_$eq(int x$1) {
        this.totalExpectedExecutors = x$1;
    }

    public YarnSchedulerEndpoint org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$yarnSchedulerEndpoint() {
        return this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$yarnSchedulerEndpoint;
    }

    private RpcEndpointRef yarnSchedulerEndpointRef() {
        return this.yarnSchedulerEndpointRef;
    }

    public RpcTimeout org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$askTimeout() {
        return this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$askTimeout;
    }

    public Option<ApplicationId> appId() {
        return this.appId;
    }

    public void appId_$eq(Option<ApplicationId> x$1) {
        this.appId = x$1;
    }

    private Option<ApplicationAttemptId> attemptId() {
        return this.attemptId;
    }

    private void attemptId_$eq(Option<ApplicationAttemptId> x$1) {
        this.attemptId = x$1;
    }

    private SchedulerExtensionServices services() {
        return this.services;
    }

    public void bindToYarn(ApplicationId appId, Option<ApplicationAttemptId> attemptId) {
        this.appId_$eq((Option<ApplicationId>)new Some((Object)appId));
        this.attemptId_$eq(attemptId);
    }

    public void start() {
        Predef$.MODULE$.require(this.appId().isDefined(), (Function0 & Serializable & scala.Serializable)() -> "application ID unset");
        SchedulerExtensionServiceBinding binding = new SchedulerExtensionServiceBinding(this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$sc, (ApplicationId)this.appId().get(), this.attemptId());
        this.services().start(binding);
        super.start();
    }

    public void stop() {
        try {
            this.requestTotalExecutors(0, 0, Predef$.MODULE$.Map().empty());
            super.stop();
        }
        finally {
            this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$stopped().set(true);
            this.services().stop();
        }
    }

    public Option<String> applicationAttemptId() {
        return this.attemptId().map((Function1 & Serializable & scala.Serializable)x$1 -> ((Object)BoxesRunTime.boxToInteger((int)x$1.getAttemptId())).toString());
    }

    public String applicationId() {
        return (String)this.appId().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            this.logWarning((Function0 & Serializable & scala.Serializable)() -> "Application ID is not initialized yet.");
            return this.super$applicationId();
        });
    }

    public CoarseGrainedClusterMessages.RequestExecutors prepareRequestExecutors(int requestedTotal) {
        Set nodeBlacklist = this.scheduler.nodeBlacklist();
        Map filteredHostToLocalTaskCount = (Map)this.hostToLocalTaskCount().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)YarnSchedulerBackend.$anonfun$prepareRequestExecutors$1(nodeBlacklist, x0$1)));
        return new CoarseGrainedClusterMessages.RequestExecutors(requestedTotal, this.localityAwareTasks(), filteredHostToLocalTaskCount, nodeBlacklist);
    }

    public Future<Object> doRequestTotalExecutors(int requestedTotal) {
        return this.yarnSchedulerEndpointRef().ask((Object)this.prepareRequestExecutors(requestedTotal), ClassTag$.MODULE$.Boolean());
    }

    public Future<Object> doKillExecutors(Seq<String> executorIds) {
        return this.yarnSchedulerEndpointRef().ask((Object)new CoarseGrainedClusterMessages.KillExecutors(executorIds), ClassTag$.MODULE$.Boolean());
    }

    public boolean sufficientResourcesRegistered() {
        return (double)this.totalRegisteredExecutors().get() >= (double)this.totalExpectedExecutors() * this.minRegisteredRatio();
    }

    public void org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$addWebUIFilter(String filterName, Map<String, String> filterParams, String proxyBase) {
        block0: {
            boolean hasFilter;
            Object object = proxyBase != null && new StringOps(Predef$.MODULE$.augmentString(proxyBase)).nonEmpty() ? System.setProperty("spark.ui.proxyBase", proxyBase) : BoxedUnit.UNIT;
            boolean bl = hasFilter = filterName != null && new StringOps(Predef$.MODULE$.augmentString(filterName)).nonEmpty() && filterParams != null && filterParams.nonEmpty();
            if (!hasFilter) break block0;
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Add WebUI Filter. ").append(filterName).append(", ").append(filterParams).append(", ").append(proxyBase).toString());
            this.conf().set("spark.ui.filters", filterName);
            filterParams.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                SparkConf sparkConf = this.conf().set(new StringBuilder(13).append("spark.").append(filterName).append(".param.").append(k).toString(), v);
                return sparkConf;
            });
            this.scheduler.sc().ui().foreach((Function1 & Serializable & scala.Serializable)ui -> {
                JettyUtils$.MODULE$.addFilters(ui.getHandlers(), this.conf());
                return BoxedUnit.UNIT;
            });
        }
    }

    public CoarseGrainedSchedulerBackend.DriverEndpoint createDriverEndpoint(Seq<Tuple2<String, String>> properties) {
        return new YarnDriverEndpoint(this, this.rpcEnv(), properties);
    }

    public void reset() {
        super.reset();
        this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$sc.executorAllocationManager().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.reset();
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$prepareRequestExecutors$1(Set nodeBlacklist$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        boolean bl = !nodeBlacklist$1.contains((Object)k);
        return bl;
    }

    public YarnSchedulerBackend(TaskSchedulerImpl scheduler, SparkContext sc) {
        this.scheduler = scheduler;
        this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$sc = sc;
        super(scheduler, sc.env().rpcEnv());
        this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$stopped = new AtomicBoolean(false);
        this.minRegisteredRatio = this.conf().getOption("spark.scheduler.minRegisteredResourcesRatio").isEmpty() ? 0.8 : super.minRegisteredRatio();
        this.totalExpectedExecutors = 0;
        this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$yarnSchedulerEndpoint = new YarnSchedulerEndpoint(this, this.rpcEnv());
        this.yarnSchedulerEndpointRef = this.rpcEnv().setupEndpoint(YarnSchedulerBackend$.MODULE$.ENDPOINT_NAME(), (RpcEndpoint)this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$yarnSchedulerEndpoint());
        this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$askTimeout = RpcUtils$.MODULE$.askRpcTimeout(sc.conf());
        this.appId = None$.MODULE$;
        this.attemptId = None$.MODULE$;
        this.services = new SchedulerExtensionServices();
    }

    public class YarnDriverEndpoint
    extends CoarseGrainedSchedulerBackend.DriverEndpoint {
        public void onDisconnected(RpcAddress rpcAddress) {
            this.addressToExecutorId().get((Object)rpcAddress).foreach((Function1 & Serializable & scala.Serializable)executorId -> {
                YarnDriverEndpoint.$anonfun$onDisconnected$1(this, rpcAddress, executorId);
                return BoxedUnit.UNIT;
            });
        }

        public /* synthetic */ YarnSchedulerBackend org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnDriverEndpoint$$$outer() {
            return (YarnSchedulerBackend)this.$outer;
        }

        public static final /* synthetic */ void $anonfun$onDisconnected$1(YarnDriverEndpoint $this, RpcAddress rpcAddress$1, String executorId) {
            block0: {
                if ($this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnDriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$stopped().get() || !$this.disableExecutor(executorId)) break block0;
                $this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnDriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$yarnSchedulerEndpoint().org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$handleExecutorDisconnectedFromDriver(executorId, rpcAddress$1);
            }
        }

        public YarnDriverEndpoint(YarnSchedulerBackend $outer, RpcEnv rpcEnv, Seq<Tuple2<String, String>> sparkProperties) {
            super((CoarseGrainedSchedulerBackend)$outer, rpcEnv, sparkProperties);
        }
    }

    public class YarnSchedulerEndpoint
    implements ThreadSafeRpcEndpoint,
    Logging {
        private final RpcEnv rpcEnv;
        private Option<RpcEndpointRef> org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$amEndpoint;
        private transient Logger org$apache$spark$internal$Logging$$log_;
        public final /* synthetic */ YarnSchedulerBackend $outer;

        public String logName() {
            return Logging.logName$((Logging)this);
        }

        public Logger log() {
            return Logging.log$((Logging)this);
        }

        public void logInfo(Function0<String> msg) {
            Logging.logInfo$((Logging)this, msg);
        }

        public void logDebug(Function0<String> msg) {
            Logging.logDebug$((Logging)this, msg);
        }

        public void logTrace(Function0<String> msg) {
            Logging.logTrace$((Logging)this, msg);
        }

        public void logWarning(Function0<String> msg) {
            Logging.logWarning$((Logging)this, msg);
        }

        public void logError(Function0<String> msg) {
            Logging.logError$((Logging)this, msg);
        }

        public void logInfo(Function0<String> msg, Throwable throwable) {
            Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
        }

        public void logDebug(Function0<String> msg, Throwable throwable) {
            Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
        }

        public void logTrace(Function0<String> msg, Throwable throwable) {
            Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
        }

        public void logWarning(Function0<String> msg, Throwable throwable) {
            Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
        }

        public void logError(Function0<String> msg, Throwable throwable) {
            Logging.logError$((Logging)this, msg, (Throwable)throwable);
        }

        public boolean isTraceEnabled() {
            return Logging.isTraceEnabled$((Logging)this);
        }

        public void initializeLogIfNecessary(boolean isInterpreter) {
            Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
        }

        public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
            return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
        }

        public boolean initializeLogIfNecessary$default$2() {
            return Logging.initializeLogIfNecessary$default$2$((Logging)this);
        }

        public final RpcEndpointRef self() {
            return RpcEndpoint.self$((RpcEndpoint)this);
        }

        public void onError(Throwable cause) {
            RpcEndpoint.onError$((RpcEndpoint)this, (Throwable)cause);
        }

        public void onConnected(RpcAddress remoteAddress) {
            RpcEndpoint.onConnected$((RpcEndpoint)this, (RpcAddress)remoteAddress);
        }

        public void onNetworkError(Throwable cause, RpcAddress remoteAddress) {
            RpcEndpoint.onNetworkError$((RpcEndpoint)this, (Throwable)cause, (RpcAddress)remoteAddress);
        }

        public void onStart() {
            RpcEndpoint.onStart$((RpcEndpoint)this);
        }

        public void onStop() {
            RpcEndpoint.onStop$((RpcEndpoint)this);
        }

        public final void stop() {
            RpcEndpoint.stop$((RpcEndpoint)this);
        }

        public Logger org$apache$spark$internal$Logging$$log_() {
            return this.org$apache$spark$internal$Logging$$log_;
        }

        public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
            this.org$apache$spark$internal$Logging$$log_ = x$1;
        }

        public RpcEnv rpcEnv() {
            return this.rpcEnv;
        }

        public Option<RpcEndpointRef> org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$amEndpoint() {
            return this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$amEndpoint;
        }

        public void org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$amEndpoint_$eq(Option<RpcEndpointRef> x$1) {
            this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$amEndpoint = x$1;
        }

        public void org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$handleExecutorDisconnectedFromDriver(String executorId, RpcAddress executorRpcAddress) {
            Future future;
            Option<RpcEndpointRef> option = this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$amEndpoint();
            if (option instanceof Some) {
                Some some = (Some)option;
                RpcEndpointRef am = (RpcEndpointRef)some.value();
                CoarseGrainedClusterMessages.GetExecutorLossReason lossReasonRequest = new CoarseGrainedClusterMessages.GetExecutorLossReason(executorId);
                future = am.ask((Object)lossReasonRequest, this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$askTimeout(), ClassTag$.MODULE$.apply(ExecutorLossReason.class)).map((Function1 & Serializable & scala.Serializable)reason -> new CoarseGrainedClusterMessages.RemoveExecutor(executorId, reason), (ExecutionContext)ThreadUtils$.MODULE$.sameThread()).recover((PartialFunction)new scala.Serializable(this, executorId, executorRpcAddress){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ YarnSchedulerEndpoint $outer;
                    private final String executorId$1;
                    private final RpcAddress executorRpcAddress$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        Option option = NonFatal$.MODULE$.unapply(A1);
                        if (!option.isEmpty()) {
                            Throwable e = (Throwable)option.get();
                            this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(81).append("Attempted to get executor loss reason").append(new StringBuilder(34).append(" for executor id ").append($this.executorId$1).append(" at RPC address ").append($this.executorRpcAddress$1).append(",").toString()).append(" but got no response. Marking as slave lost.").toString(), e);
                            object = new CoarseGrainedClusterMessages.RemoveExecutor(this.executorId$1, (ExecutorLossReason)new SlaveLost(SlaveLost$.MODULE$.apply$default$1(), SlaveLost$.MODULE$.apply$default$2()));
                        } else {
                            object = function1.apply(x1);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        Option option = NonFatal$.MODULE$.unapply(throwable);
                        boolean bl = !option.isEmpty();
                        return bl;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executorId$1 = executorId$1;
                        this.executorRpcAddress$1 = executorRpcAddress$1;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.scheduler.cluster.YarnSchedulerBackend$YarnSchedulerEndpoint$$anonfun$1 )}, serializedLambda);
                    }
                }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
            } else if (None$.MODULE$.equals(option)) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Attempted to check for an executor loss reason before the AM has registered!");
                future = Future$.MODULE$.successful((Object)new CoarseGrainedClusterMessages.RemoveExecutor(executorId, (ExecutorLossReason)new SlaveLost("AM is not yet registered.", SlaveLost$.MODULE$.apply$default$2())));
            } else {
                throw new MatchError(option);
            }
            Future removeExecutorMessage = future;
            removeExecutorMessage.foreach((Function1 & Serializable & scala.Serializable)message -> {
                YarnSchedulerEndpoint.$anonfun$org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$handleExecutorDisconnectedFromDriver$3(this, message);
                return BoxedUnit.UNIT;
            }, ExecutionContext.Implicits$.MODULE$.global());
        }

        public PartialFunction<Object, BoxedUnit> receive() {
            return new scala.Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ YarnSchedulerEndpoint $outer;

                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof CoarseGrainedClusterMessages.RegisterClusterManager) {
                        CoarseGrainedClusterMessages.RegisterClusterManager registerClusterManager = (CoarseGrainedClusterMessages.RegisterClusterManager)A1;
                        RpcEndpointRef am = registerClusterManager.am();
                        this.$outer.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("ApplicationMaster registered as ").append(am).toString());
                        this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$amEndpoint_$eq((Option<RpcEndpointRef>)Option$.MODULE$.apply((Object)am));
                        this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().reset();
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof CoarseGrainedClusterMessages.AddWebUIFilter) {
                        CoarseGrainedClusterMessages.AddWebUIFilter addWebUIFilter = (CoarseGrainedClusterMessages.AddWebUIFilter)A1;
                        String filterName = addWebUIFilter.filterName();
                        Map filterParams = addWebUIFilter.filterParams();
                        String proxyBase = addWebUIFilter.proxyBase();
                        this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$addWebUIFilter(filterName, (Map<String, String>)filterParams, proxyBase);
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof CoarseGrainedClusterMessages.RemoveExecutor) {
                        BoxedUnit boxedUnit;
                        CoarseGrainedClusterMessages.RemoveExecutor removeExecutor = (CoarseGrainedClusterMessages.RemoveExecutor)A1;
                        String executorId = removeExecutor.executorId();
                        ExecutorLossReason reason = removeExecutor.reason();
                        if (!this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$stopped().get()) {
                            this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Requesting driver to remove executor ").append(executorId).append(" for reason ").append(reason).toString());
                            this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().driverEndpoint().send((Object)removeExecutor);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        object = boxedUnit;
                    } else if (A1 instanceof CoarseGrainedClusterMessages.UpdateDelegationTokens) {
                        CoarseGrainedClusterMessages.UpdateDelegationTokens updateDelegationTokens = (CoarseGrainedClusterMessages.UpdateDelegationTokens)A1;
                        byte[] tokens = updateDelegationTokens.tokens();
                        SparkHadoopUtil$.MODULE$.get().addDelegationTokens(tokens, this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$sc.conf());
                        this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().driverEndpoint().send((Object)updateDelegationTokens);
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Object x1) {
                    Object object = x1;
                    boolean bl = object instanceof CoarseGrainedClusterMessages.RegisterClusterManager ? true : (object instanceof CoarseGrainedClusterMessages.AddWebUIFilter ? true : (object instanceof CoarseGrainedClusterMessages.RemoveExecutor ? true : object instanceof CoarseGrainedClusterMessages.UpdateDelegationTokens));
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$2(org.apache.spark.rpc.RpcEndpointRef ), $anonfun$applyOrElse$3(java.lang.String org.apache.spark.scheduler.ExecutorLossReason )}, serializedLambda);
                }
            };
        }

        public PartialFunction<Object, BoxedUnit> receiveAndReply(RpcCallContext context) {
            return new scala.Serializable(this, context){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ YarnSchedulerEndpoint $outer;
                public final RpcCallContext context$1;

                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof CoarseGrainedClusterMessages.RequestExecutors) {
                        CoarseGrainedClusterMessages.RequestExecutors requestExecutors = (CoarseGrainedClusterMessages.RequestExecutors)A1;
                        Option<RpcEndpointRef> option = this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$amEndpoint();
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            RpcEndpointRef am = (RpcEndpointRef)some.value();
                            am.ask((Object)requestExecutors, ClassTag$.MODULE$.Boolean()).andThen((PartialFunction)new scala.Serializable(this, requestExecutors){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ YarnSchedulerEndpoint$$anonfun$receiveAndReply$1 $outer;
                                private final CoarseGrainedClusterMessages.RequestExecutors x2$1;

                                public final <A1 extends Try<Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                    Failure failure;
                                    Throwable throwable;
                                    Option option;
                                    Object object;
                                    A1 A1 = x1;
                                    if (A1 instanceof Success) {
                                        Success success = (Success)A1;
                                        boolean b = BoxesRunTime.unboxToBoolean((Object)success.value());
                                        this.$outer.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)b));
                                        object = BoxedUnit.UNIT;
                                    } else if (A1 instanceof Failure && !(option = NonFatal$.MODULE$.unapply(throwable = (failure = (Failure)A1).exception())).isEmpty()) {
                                        Throwable e = (Throwable)option.get();
                                        this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$anonfun$$$outer().logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Sending ").append($this.x2$1).append(" to AM was unsuccessful").toString(), e);
                                        this.$outer.context$1.sendFailure(e);
                                        object = BoxedUnit.UNIT;
                                    } else {
                                        object = function1.apply(x1);
                                    }
                                    return (B1)object;
                                }

                                public final boolean isDefinedAt(Try<Object> x1) {
                                    Failure failure;
                                    Throwable throwable;
                                    Option option;
                                    Try<Object> try_ = x1;
                                    boolean bl = try_ instanceof Success ? true : try_ instanceof Failure && !(option = NonFatal$.MODULE$.unapply(throwable = (failure = (Failure)try_).exception())).isEmpty();
                                    return bl;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.x2$1 = x2$1;
                                }

                                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$5(org.apache.spark.scheduler.cluster.YarnSchedulerBackend$YarnSchedulerEndpoint$$anonfun$receiveAndReply$1$$anonfun$applyOrElse$4 )}, serializedLambda);
                                }
                            }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else if (None$.MODULE$.equals(option)) {
                            this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Attempted to request executors before the AM has registered!");
                            this.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)false));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            throw new MatchError(option);
                        }
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof CoarseGrainedClusterMessages.KillExecutors) {
                        CoarseGrainedClusterMessages.KillExecutors killExecutors = (CoarseGrainedClusterMessages.KillExecutors)A1;
                        Option<RpcEndpointRef> option = this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$amEndpoint();
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            RpcEndpointRef am = (RpcEndpointRef)some.value();
                            am.ask((Object)killExecutors, ClassTag$.MODULE$.Boolean()).andThen((PartialFunction)new scala.Serializable(this, killExecutors){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ YarnSchedulerEndpoint$$anonfun$receiveAndReply$1 $outer;
                                private final CoarseGrainedClusterMessages.KillExecutors x3$1;

                                public final <A1 extends Try<Object>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                                    Failure failure;
                                    Throwable throwable;
                                    Option option;
                                    Object object;
                                    A1 A1 = x2;
                                    if (A1 instanceof Success) {
                                        Success success = (Success)A1;
                                        boolean b = BoxesRunTime.unboxToBoolean((Object)success.value());
                                        this.$outer.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)b));
                                        object = BoxedUnit.UNIT;
                                    } else if (A1 instanceof Failure && !(option = NonFatal$.MODULE$.unapply(throwable = (failure = (Failure)A1).exception())).isEmpty()) {
                                        Throwable e = (Throwable)option.get();
                                        this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$anonfun$$$outer().logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Sending ").append($this.x3$1).append(" to AM was unsuccessful").toString(), e);
                                        this.$outer.context$1.sendFailure(e);
                                        object = BoxedUnit.UNIT;
                                    } else {
                                        object = function1.apply(x2);
                                    }
                                    return (B1)object;
                                }

                                public final boolean isDefinedAt(Try<Object> x2) {
                                    Failure failure;
                                    Throwable throwable;
                                    Option option;
                                    Try<Object> try_ = x2;
                                    boolean bl = try_ instanceof Success ? true : try_ instanceof Failure && !(option = NonFatal$.MODULE$.unapply(throwable = (failure = (Failure)try_).exception())).isEmpty();
                                    return bl;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.x3$1 = x3$1;
                                }

                                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$8(org.apache.spark.scheduler.cluster.YarnSchedulerBackend$YarnSchedulerEndpoint$$anonfun$receiveAndReply$1$$anonfun$applyOrElse$7 )}, serializedLambda);
                                }
                            }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else if (None$.MODULE$.equals(option)) {
                            this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Attempted to kill executors before the AM has registered!");
                            this.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)false));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            throw new MatchError(option);
                        }
                        object = BoxedUnit.UNIT;
                    } else if (CoarseGrainedClusterMessages.RetrieveLastAllocatedExecutorId$.MODULE$.equals(A1)) {
                        this.context$1.reply((Object)BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().currentExecutorIdCounter()));
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Object x1) {
                    Object object = x1;
                    boolean bl = object instanceof CoarseGrainedClusterMessages.RequestExecutors ? true : (object instanceof CoarseGrainedClusterMessages.KillExecutors ? true : CoarseGrainedClusterMessages.RetrieveLastAllocatedExecutorId$.MODULE$.equals(object));
                    return bl;
                }

                public /* synthetic */ YarnSchedulerEndpoint org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.context$1 = context$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$6(), $anonfun$applyOrElse$9()}, serializedLambda);
                }
            };
        }

        public void onDisconnected(RpcAddress remoteAddress) {
            block0: {
                if (!this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$amEndpoint().exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)YarnSchedulerEndpoint.$anonfun$onDisconnected$2(remoteAddress, x$4)))) break block0;
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("ApplicationMaster has disassociated: ").append(remoteAddress).toString());
                this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$amEndpoint_$eq((Option<RpcEndpointRef>)None$.MODULE$);
            }
        }

        public /* synthetic */ YarnSchedulerBackend org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$handleExecutorDisconnectedFromDriver$3(YarnSchedulerEndpoint $this, CoarseGrainedClusterMessages.RemoveExecutor message) {
            $this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().driverEndpoint().send((Object)message);
        }

        public static final /* synthetic */ boolean $anonfun$onDisconnected$2(RpcAddress remoteAddress$1, RpcEndpointRef x$4) {
            RpcAddress rpcAddress = x$4.address();
            RpcAddress rpcAddress2 = remoteAddress$1;
            return !(rpcAddress != null ? !rpcAddress.equals(rpcAddress2) : rpcAddress2 != null);
        }

        public YarnSchedulerEndpoint(YarnSchedulerBackend $outer, RpcEnv rpcEnv) {
            this.rpcEnv = rpcEnv;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            RpcEndpoint.$init$((RpcEndpoint)this);
            Logging.$init$((Logging)this);
            this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$amEndpoint = None$.MODULE$;
        }
    }
}

