/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.spark.SparkContext;
import org.apache.spark.deploy.yarn.config.package$;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.cluster.SchedulerExtensionService;
import org.apache.spark.scheduler.cluster.SchedulerExtensionServiceBinding;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001a4Q!\u0005\n\u0001-qAQ!\f\u0001\u0005\u0002=Bq!\r\u0001A\u0002\u0013%!\u0007C\u0004B\u0001\u0001\u0007I\u0011\u0002\"\t\r!\u0003\u0001\u0015)\u00034\u0011\u001dI\u0005\u00011A\u0005\n)Cq\u0001\u0016\u0001A\u0002\u0013%Q\u000b\u0003\u0004X\u0001\u0001\u0006Ka\u0013\u0005\b1\u0002\u0011\r\u0011\"\u0003Z\u0011\u00191\u0007\u0001)A\u00055\"Iq\r\u0001a\u0001\u0002\u0004%I\u0001\u001b\u0005\nY\u0002\u0001\r\u00111A\u0005\n5D\u0011b\u001c\u0001A\u0002\u0003\u0005\u000b\u0015B5\t\u000bA\u0004A\u0011A9\t\u000bM\u0004A\u0011\u0001&\t\u000bQ\u0004A\u0011I;\t\u000bY\u0004A\u0011I<\u00035M\u001b\u0007.\u001a3vY\u0016\u0014X\t\u001f;f]NLwN\\*feZL7-Z:\u000b\u0005M!\u0012aB2mkN$XM\u001d\u0006\u0003+Y\t\u0011b]2iK\u0012,H.\u001a:\u000b\u0005]A\u0012!B:qCJ\\'BA\r\u001b\u0003\u0019\t\u0007/Y2iK*\t1$A\u0002pe\u001e\u001cB\u0001A\u000f$OA\u0011a$I\u0007\u0002?)\t\u0001%A\u0003tG\u0006d\u0017-\u0003\u0002#?\t1\u0011I\\=SK\u001a\u0004\"\u0001J\u0013\u000e\u0003II!A\n\n\u00033M\u001b\u0007.\u001a3vY\u0016\u0014X\t\u001f;f]NLwN\\*feZL7-\u001a\t\u0003Q-j\u0011!\u000b\u0006\u0003UY\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003Y%\u0012q\u0001T8hO&tw-\u0001\u0004=S:LGOP\u0002\u0001)\u0005\u0001\u0004C\u0001\u0013\u0001\u00035\u0019XM\u001d<jG\u0016|\u0005\u000f^5p]V\t1\u0007E\u0002\u001fiYJ!!N\u0010\u0003\r=\u0003H/[8o!\t9dH\u0004\u00029yA\u0011\u0011hH\u0007\u0002u)\u00111HL\u0001\u0007yI|w\u000e\u001e \n\u0005uz\u0012A\u0002)sK\u0012,g-\u0003\u0002@\u0001\n11\u000b\u001e:j]\u001eT!!P\u0010\u0002#M,'O^5dK>\u0003H/[8o?\u0012*\u0017\u000f\u0006\u0002D\rB\u0011a\u0004R\u0005\u0003\u000b~\u0011A!\u00168ji\"9qiAA\u0001\u0002\u0004\u0019\u0014a\u0001=%c\u0005q1/\u001a:wS\u000e,w\n\u001d;j_:\u0004\u0013\u0001C:feZL7-Z:\u0016\u0003-\u00032\u0001T)$\u001d\tiuJ\u0004\u0002:\u001d&\t\u0001%\u0003\u0002Q?\u00059\u0001/Y2lC\u001e,\u0017B\u0001*T\u0005\u0011a\u0015n\u001d;\u000b\u0005A{\u0012\u0001D:feZL7-Z:`I\u0015\fHCA\"W\u0011\u001d9e!!AA\u0002-\u000b\u0011b]3sm&\u001cWm\u001d\u0011\u0002\u000fM$\u0018M\u001d;fIV\t!\f\u0005\u0002\\I6\tAL\u0003\u0002^=\u00061\u0011\r^8nS\u000eT!a\u00181\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002bE\u0006!Q\u000f^5m\u0015\u0005\u0019\u0017\u0001\u00026bm\u0006L!!\u001a/\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u0003!\u0019H/\u0019:uK\u0012\u0004\u0013a\u00022j]\u0012LgnZ\u000b\u0002SB\u0011AE[\u0005\u0003WJ\u0011\u0001eU2iK\u0012,H.\u001a:FqR,gn]5p]N+'O^5dK\nKg\u000eZ5oO\u0006Y!-\u001b8eS:<w\fJ3r)\t\u0019e\u000eC\u0004H\u0017\u0005\u0005\t\u0019A5\u0002\u0011\tLg\u000eZ5oO\u0002\nQa\u001d;beR$\"a\u0011:\t\u000b\u001dl\u0001\u0019A5\u0002\u0017\u001d,GoU3sm&\u001cWm]\u0001\u0005gR|\u0007\u000fF\u0001D\u0003!!xn\u0015;sS:<G#\u0001\u001c")
public class SchedulerExtensionServices
implements SchedulerExtensionService,
Logging {
    private Option<String> serviceOption;
    private List<SchedulerExtensionService> services;
    private final AtomicBoolean started;
    private SchedulerExtensionServiceBinding binding;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Option<String> serviceOption() {
        return this.serviceOption;
    }

    private void serviceOption_$eq(Option<String> x$1) {
        this.serviceOption = x$1;
    }

    private List<SchedulerExtensionService> services() {
        return this.services;
    }

    private void services_$eq(List<SchedulerExtensionService> x$1) {
        this.services = x$1;
    }

    private AtomicBoolean started() {
        return this.started;
    }

    private SchedulerExtensionServiceBinding binding() {
        return this.binding;
    }

    private void binding_$eq(SchedulerExtensionServiceBinding x$1) {
        this.binding = x$1;
    }

    @Override
    public void start(SchedulerExtensionServiceBinding binding) {
        if (this.started().getAndSet(true)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Ignoring re-entrant start operation");
            return;
        }
        Predef$.MODULE$.require(binding.sparkContext() != null, (Function0 & Serializable & scala.Serializable)() -> "Null context parameter");
        Predef$.MODULE$.require(binding.applicationId() != null, (Function0 & Serializable & scala.Serializable)() -> "Null appId parameter");
        this.binding_$eq(binding);
        SparkContext sparkContext = binding.sparkContext();
        ApplicationId appId = binding.applicationId();
        Option<ApplicationAttemptId> attemptId = binding.attemptId();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Starting Yarn extension services with app ").append(appId).append(" and attemptId ").append(attemptId).toString());
        this.services_$eq((List<SchedulerExtensionService>)((TraversableOnce)((TraversableLike)sparkContext.conf().get(package$.MODULE$.SCHEDULER_SERVICES())).map((Function1 & Serializable & scala.Serializable)sClass -> {
            void var3_3;
            SchedulerExtensionService instance = (SchedulerExtensionService)Utils$.MODULE$.classForName(sClass).newInstance();
            instance.start(binding);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Service ").append((String)sClass).append(" started").toString());
            return var3_3;
        }, Seq$.MODULE$.canBuildFrom())).toList());
    }

    public List<SchedulerExtensionService> getServices() {
        return this.services();
    }

    @Override
    public void stop() {
        block0: {
            if (!this.started().getAndSet(false)) break block0;
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(9).append("Stopping ").append(this).toString());
            this.services().foreach((Function1 & Serializable & scala.Serializable)s -> {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> s.stop());
                return BoxedUnit.UNIT;
            });
        }
    }

    public String toString() {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(81).append("SchedulerExtensionServices\n    |(serviceOption=").append(this.serviceOption()).append(",\n    | services=").append(this.services()).append(",\n    | started=").append(this.started()).append(")").toString())).stripMargin();
    }

    public SchedulerExtensionServices() {
        Logging.$init$((Logging)this);
        this.serviceOption = None$.MODULE$;
        this.services = Nil$.MODULE$;
        this.started = new AtomicBoolean(false);
    }
}

