/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.yarn.CacheEntry;
import org.apache.spark.deploy.yarn.config.package$;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}d!\u0002\u0007\u000e\u0001E9\u0002\"\u0002\u0013\u0001\t\u00031\u0003bB\u0015\u0001\u0005\u0004%IA\u000b\u0005\u0007m\u0001\u0001\u000b\u0011B\u0016\t\u000b]\u0002A\u0011\u0001\u001d\t\u0013\u00055\u0001!%A\u0005\u0002\u0005=\u0001bBA\u0013\u0001\u0011\u0005\u0011q\u0005\u0005\t\u0003g\u0001A\u0011A\u0007\u00026!9\u0011Q\t\u0001\u0005\n\u0005\u001d\u0003bBA(\u0001\u0011%\u0011\u0011\u000b\u0005\b\u00037\u0002A\u0011BA/\u0011!\t)\b\u0001C\u0001\u001b\u0005]$!H\"mS\u0016tG\u000fR5tiJL'-\u001e;fI\u000e\u000b7\r[3NC:\fw-\u001a:\u000b\u00059y\u0011\u0001B=be:T!\u0001E\t\u0002\r\u0011,\u0007\u000f\\8z\u0015\t\u00112#A\u0003ta\u0006\u00148N\u0003\u0002\u0015+\u00051\u0011\r]1dQ\u0016T\u0011AF\u0001\u0004_J<7c\u0001\u0001\u0019=A\u0011\u0011\u0004H\u0007\u00025)\t1$A\u0003tG\u0006d\u0017-\u0003\u0002\u001e5\t1\u0011I\\=SK\u001a\u0004\"a\b\u0012\u000e\u0003\u0001R!!I\t\u0002\u0011%tG/\u001a:oC2L!a\t\u0011\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\u001a\u0001\u0001F\u0001(!\tA\u0003!D\u0001\u000e\u0003A!\u0017n\u001d;DC\u000eDW-\u00128ue&,7/F\u0001,!\ra\u0013gM\u0007\u0002[)\u0011afL\u0001\b[V$\u0018M\u00197f\u0015\t\u0001$$\u0001\u0006d_2dWm\u0019;j_:L!AM\u0017\u0003\u00151K7\u000f\u001e\"vM\u001a,'\u000f\u0005\u0002)i%\u0011Q'\u0004\u0002\u000b\u0007\u0006\u001c\u0007.Z#oiJL\u0018!\u00053jgR\u001c\u0015m\u00195f\u000b:$(/[3tA\u0005Y\u0011\r\u001a3SKN|WO]2f))ID(\u0012'RU>\f\u00181\u0001\t\u00033iJ!a\u000f\u000e\u0003\tUs\u0017\u000e\u001e\u0005\u0006{\u0011\u0001\rAP\u0001\u0003MN\u0004\"aP\"\u000e\u0003\u0001S!!P!\u000b\u0005\t\u001b\u0012A\u00025bI>|\u0007/\u0003\u0002E\u0001\nQa)\u001b7f'f\u001cH/Z7\t\u000b\u0019#\u0001\u0019A$\u0002\t\r|gN\u001a\t\u0003\u0011*k\u0011!\u0013\u0006\u0003\r\u0006K!aS%\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011\u0015iE\u00011\u0001O\u0003!!Wm\u001d;QCRD\u0007CA P\u0013\t\u0001\u0006I\u0001\u0003QCRD\u0007\"\u0002*\u0005\u0001\u0004\u0019\u0016A\u00047pG\u0006d'+Z:pkJ\u001cWm\u001d\t\u0005YQ3\u0016-\u0003\u0002V[\t9\u0001*Y:i\u001b\u0006\u0004\bCA,_\u001d\tAF\f\u0005\u0002Z55\t!L\u0003\u0002\\K\u00051AH]8pizJ!!\u0018\u000e\u0002\rA\u0013X\rZ3g\u0013\ty\u0006M\u0001\u0004TiJLgn\u001a\u0006\u0003;j\u0001\"A\u00195\u000e\u0003\rT!\u0001Z3\u0002\u000fI,7m\u001c:eg*\u0011amZ\u0001\u0004CBL'B\u0001\bB\u0013\tI7MA\u0007M_\u000e\fGNU3t_V\u00148-\u001a\u0005\u0006W\u0012\u0001\r\u0001\\\u0001\re\u0016\u001cx.\u001e:dKRK\b/\u001a\t\u0003E6L!A\\2\u0003#1{7-\u00197SKN|WO]2f)f\u0004X\rC\u0003q\t\u0001\u0007a+\u0001\u0003mS:\\\u0007\"\u0002:\u0005\u0001\u0004\u0019\u0018!C:uCR\u001c\u0015m\u00195f!\u0011aCO\u001e@\n\u0005Ul#aA'baB\u0011q\u000f`\u0007\u0002q*\u0011\u0011P_\u0001\u0004]\u0016$(\"A>\u0002\t)\fg/Y\u0005\u0003{b\u00141!\u0016*J!\tyt0C\u0002\u0002\u0002\u0001\u0013!BR5mKN#\u0018\r^;t\u0011%\t)\u0001\u0002I\u0001\u0002\u0004\t9!A\u0007baBl\u0015m\u001d;fe>sG.\u001f\t\u00043\u0005%\u0011bAA\u00065\t9!i\\8mK\u0006t\u0017!F1eIJ+7o\\;sG\u0016$C-\u001a4bk2$H\u0005O\u000b\u0003\u0003#QC!a\u0002\u0002\u0014-\u0012\u0011Q\u0003\t\u0005\u0003/\t\t#\u0004\u0002\u0002\u001a)!\u00111DA\u000f\u0003%)hn\u00195fG.,GMC\u0002\u0002 i\t!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019#!\u0007\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\nva\u0012\fG/Z\"p]\u001aLw-\u001e:bi&|g\u000eF\u0002:\u0003SAaA\u0012\u0004A\u0002\u0005-\u0002\u0003BA\u0017\u0003_i\u0011!E\u0005\u0004\u0003c\t\"!C*qCJ\\7i\u001c8g\u000359W\r\u001e,jg&\u0014\u0017\u000e\\5usRA\u0011qGA\u001f\u0003\u007f\t\u0019\u0005E\u0002c\u0003sI1!a\u000fd\u0005]aunY1m%\u0016\u001cx.\u001e:dKZK7/\u001b2jY&$\u0018\u0010C\u0003G\u000f\u0001\u0007q\t\u0003\u0004\u0002B\u001d\u0001\rA^\u0001\u0004kJL\u0007\"\u0002:\b\u0001\u0004\u0019\u0018\u0001C5t!V\u0014G.[2\u0015\u0011\u0005\u001d\u0011\u0011JA&\u0003\u001bBQA\u0012\u0005A\u0002\u001dCa!!\u0011\t\u0001\u00041\b\"\u0002:\t\u0001\u0004\u0019\u0018aH1oG\u0016\u001cHo\u001c:t\u0011\u00064X-\u0012=fGV$X\rU3s[&\u001c8/[8ogRA\u0011qAA*\u0003+\nI\u0006C\u0003>\u0013\u0001\u0007a\b\u0003\u0004\u0002X%\u0001\rAT\u0001\u0005a\u0006$\b\u000eC\u0003s\u0013\u0001\u00071/\u0001\fdQ\u0016\u001c7\u000eU3s[&\u001c8/[8o\u001f\u001a|E\u000f[3s))\t9!a\u0018\u0002b\u0005\r\u00141\u000f\u0005\u0006{)\u0001\rA\u0010\u0005\u0007\u0003/R\u0001\u0019\u0001(\t\u000f\u0005\u0015$\u00021\u0001\u0002h\u00051\u0011m\u0019;j_:\u0004B!!\u001b\u0002p5\u0011\u00111\u000e\u0006\u0004\u0003[\u0002\u0015A\u00039fe6L7o]5p]&!\u0011\u0011OA6\u0005!15/Q2uS>t\u0007\"\u0002:\u000b\u0001\u0004\u0019\u0018!D4fi\u001aKG.Z*uCR,8\u000fF\u0004\u007f\u0003s\nY(! \t\u000buZ\u0001\u0019\u0001 \t\r\u0005\u00053\u00021\u0001w\u0011\u0015\u00118\u00021\u0001t\u0001")
public class ClientDistributedCacheManager
implements Logging {
    private final ListBuffer<CacheEntry> distCacheEntries;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ListBuffer<CacheEntry> distCacheEntries() {
        return this.distCacheEntries;
    }

    public void addResource(FileSystem fs, Configuration conf, Path destPath, HashMap<String, LocalResource> localResources, LocalResourceType resourceType, String link, Map<URI, FileStatus> statCache, boolean appMasterOnly) {
        block0: {
            FileStatus destStatus = (FileStatus)statCache.getOrElse((Object)destPath.toUri(), (Function0 & Serializable & scala.Serializable)() -> fs.getFileStatus(destPath));
            LocalResource amJarRsrc = (LocalResource)Records.newRecord(LocalResource.class);
            amJarRsrc.setType(resourceType);
            LocalResourceVisibility visibility = this.getVisibility(conf, destPath.toUri(), statCache);
            amJarRsrc.setVisibility(visibility);
            amJarRsrc.setResource(ConverterUtils.getYarnUrlFromPath((Path)destPath));
            amJarRsrc.setTimestamp(destStatus.getModificationTime());
            amJarRsrc.setSize(destStatus.getLen());
            Predef$.MODULE$.require(link != null && new StringOps(Predef$.MODULE$.augmentString(link)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "You must specify a valid link name.");
            localResources.update((Object)link, (Object)amJarRsrc);
            if (appMasterOnly) break block0;
            URI uri = destPath.toUri();
            URI pathURI = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), null, link);
            this.distCacheEntries().$plus$eq((Object)new CacheEntry(pathURI, destStatus.getLen(), destStatus.getModificationTime(), visibility, resourceType));
        }
    }

    public boolean addResource$default$8() {
        return false;
    }

    public void updateConfiguration(SparkConf conf) {
        conf.set(package$.MODULE$.CACHED_FILES(), this.distCacheEntries().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.uri().toString(), ListBuffer$.MODULE$.canBuildFrom()));
        conf.set(package$.MODULE$.CACHED_FILES_SIZES(), this.distCacheEntries().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.size()), ListBuffer$.MODULE$.canBuildFrom()));
        conf.set(package$.MODULE$.CACHED_FILES_TIMESTAMPS(), this.distCacheEntries().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.modTime()), ListBuffer$.MODULE$.canBuildFrom()));
        conf.set(package$.MODULE$.CACHED_FILES_VISIBILITIES(), this.distCacheEntries().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.visibility().name(), ListBuffer$.MODULE$.canBuildFrom()));
        conf.set(package$.MODULE$.CACHED_FILES_TYPES(), this.distCacheEntries().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.resType().name(), ListBuffer$.MODULE$.canBuildFrom()));
    }

    public LocalResourceVisibility getVisibility(Configuration conf, URI uri, Map<URI, FileStatus> statCache) {
        return this.isPublic(conf, uri, statCache) ? LocalResourceVisibility.PUBLIC : LocalResourceVisibility.PRIVATE;
    }

    private boolean isPublic(Configuration conf, URI uri, Map<URI, FileStatus> statCache) {
        Path current;
        FileSystem fs = FileSystem.get((URI)uri, (Configuration)conf);
        if (!this.checkPermissionOfOther(fs, current = new Path(uri.getPath()), FsAction.READ, statCache)) {
            return false;
        }
        return this.ancestorsHaveExecutePermissions(fs, current.getParent(), statCache);
    }

    private boolean ancestorsHaveExecutePermissions(FileSystem fs, Path path, Map<URI, FileStatus> statCache) {
        for (Path current = path; current != null; current = current.getParent()) {
            if (this.checkPermissionOfOther(fs, current, FsAction.EXECUTE, statCache)) continue;
            return false;
        }
        return true;
    }

    private boolean checkPermissionOfOther(FileSystem fs, Path path, FsAction action, Map<URI, FileStatus> statCache) {
        FileStatus status = this.getFileStatus(fs, path.toUri(), statCache);
        FsPermission perms = status.getPermission();
        FsAction otherAction = perms.getOtherAction();
        return otherAction.implies(action);
    }

    public FileStatus getFileStatus(FileSystem fs, URI uri, Map<URI, FileStatus> statCache) {
        FileStatus fileStatus;
        Option option = statCache.get((Object)uri);
        if (option instanceof Some) {
            FileStatus existstat;
            Some some = (Some)option;
            fileStatus = existstat = (FileStatus)some.value();
        } else if (None$.MODULE$.equals(option)) {
            FileStatus newStat = fs.getFileStatus(new Path(uri));
            statCache.put((Object)uri, (Object)newStat);
            fileStatus = newStat;
        } else {
            throw new MatchError((Object)option);
        }
        FileStatus stat = fileStatus;
        return stat;
    }

    public ClientDistributedCacheManager() {
        Logging.$init$((Logging)this);
        this.distCacheEntries = new ListBuffer();
    }
}

