/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.spark.Logging;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.deploy.yarn.ApplicationMasterArguments;
import org.apache.spark.deploy.yarn.ExecutorRunnable;
import org.apache.spark.deploy.yarn.YarnAllocator$;
import org.apache.spark.deploy.yarn.YarnSparkHadoopUtil$;
import org.apache.spark.scheduler.SplitInfo;
import org.apache.spark.scheduler.TaskSchedulerImpl$;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\t%fAB\u0001\u0003\u0003\u0003\u0011ABA\u0007ZCJt\u0017\t\u001c7pG\u0006$xN\u001d\u0006\u0003\u0007\u0011\tA!_1s]*\u0011QAB\u0001\u0007I\u0016\u0004Hn\\=\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c2\u0001A\u0007\u0014!\tq\u0011#D\u0001\u0010\u0015\u0005\u0001\u0012!B:dC2\f\u0017B\u0001\n\u0010\u0005\u0019\te.\u001f*fMB\u0011A#F\u0007\u0002\r%\u0011aC\u0002\u0002\b\u0019><w-\u001b8h\u0011!A\u0002A!A!\u0002\u0013Q\u0012\u0001B2p]\u001a\u001c\u0001\u0001\u0005\u0002\u001c?5\tAD\u0003\u0002\u0019;)\u0011a\u0004C\u0001\u0007Q\u0006$wn\u001c9\n\u0005\u0001b\"!D\"p]\u001aLw-\u001e:bi&|g\u000e\u0003\u0005#\u0001\t\u0005\t\u0015!\u0003$\u0003%\u0019\b/\u0019:l\u0007>tg\r\u0005\u0002\u0015I%\u0011QE\u0002\u0002\n'B\f'o[\"p]\u001aD\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001K\u0001\rCB\u0004\u0018\t\u001e;f[B$\u0018\n\u001a\t\u0003S=j\u0011A\u000b\u0006\u0003W1\nqA]3d_J$7O\u0003\u0002.]\u0005\u0019\u0011\r]5\u000b\u0005\ri\u0012B\u0001\u0019+\u0005Q\t\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8BiR,W\u000e\u001d;JI\"A!\u0007\u0001B\u0001B\u0003%1'\u0001\u0003be\u001e\u001c\bC\u0001\u001b6\u001b\u0005\u0011\u0011B\u0001\u001c\u0003\u0005i\t\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8NCN$XM]!sOVlWM\u001c;t\u0011!A\u0004A!A!\u0002\u0013I\u0014A\u00049sK\u001a,'O]3e\u001d>$Wm\u001d\t\u0005uuzd)D\u0001<\u0015\tat\"\u0001\u0006d_2dWm\u0019;j_:L!AP\u001e\u0003\u00075\u000b\u0007\u000f\u0005\u0002A\u0007:\u0011a\"Q\u0005\u0003\u0005>\ta\u0001\u0015:fI\u00164\u0017B\u0001#F\u0005\u0019\u0019FO]5oO*\u0011!i\u0004\t\u0004u\u001dK\u0015B\u0001%<\u0005\r\u0019V\r\u001e\t\u0003\u00156k\u0011a\u0013\u0006\u0003\u0019\u001a\t\u0011b]2iK\u0012,H.\u001a:\n\u00059[%!C*qY&$\u0018J\u001c4p\u0011!\u0001\u0006A!A!\u0002\u0013\t\u0016aC:fGV\u0014\u0018\u000e^=NOJ\u0004\"\u0001\u0006*\n\u0005M3!aD*fGV\u0014\u0018\u000e^=NC:\fw-\u001a:\t\u000bU\u0003A\u0011\u0001,\u0002\rqJg.\u001b;?)\u001d9\u0006,\u0017.\\9v\u0003\"\u0001\u000e\u0001\t\u000ba!\u0006\u0019\u0001\u000e\t\u000b\t\"\u0006\u0019A\u0012\t\u000b\u001d\"\u0006\u0019\u0001\u0015\t\u000bI\"\u0006\u0019A\u001a\t\u000ba\"\u0006\u0019A\u001d\t\u000bA#\u0006\u0019A)\t\u000f}\u0003!\u0019!C\u0005A\u0006a\u0012\r\u001c7pG\u0006$X\r\u001a%pgR$vnQ8oi\u0006Lg.\u001a:t\u001b\u0006\u0004X#A1\u0011\t\t,whZ\u0007\u0002G*\u0011AmO\u0001\b[V$\u0018M\u00197f\u0013\t17MA\u0004ICNDW*\u00199\u0011\u0007\tD\u0017.\u0003\u0002IGB\u0011\u0011F[\u0005\u0003W*\u00121bQ8oi\u0006Lg.\u001a:JI\"1Q\u000e\u0001Q\u0001\n\u0005\fQ$\u00197m_\u000e\fG/\u001a3I_N$Hk\\\"p]R\f\u0017N\\3sg6\u000b\u0007\u000f\t\u0005\b_\u0002\u0011\r\u0011\"\u0003q\u0003m\tG\u000e\\8dCR,GmQ8oi\u0006Lg.\u001a:U_\"{7\u000f^'baV\t\u0011\u000f\u0005\u0003cK&|\u0004BB:\u0001A\u0003%\u0011/\u0001\u000fbY2|7-\u0019;fI\u000e{g\u000e^1j]\u0016\u0014Hk\u001c%pgRl\u0015\r\u001d\u0011\t\u000fU\u0004!\u0019!C\u0005m\u0006\u0011\u0012\r\u001c7pG\u0006$X\r\u001a*bG.\u001cu.\u001e8u+\u00059\b\u0003\u00022f\u007fa\u0004\"AD=\n\u0005i|!aA%oi\"1A\u0010\u0001Q\u0001\n]\f1#\u00197m_\u000e\fG/\u001a3SC\u000e\\7i\\;oi\u0002BqA \u0001C\u0002\u0013%q0\u0001\nsK2,\u0017m]3e\u0007>tG/Y5oKJ\u001cXCAA\u0001!\u001d\t\u0019!!\u0005j\u0003+i!!!\u0002\u000b\t\u0005\u001d\u0011\u0011B\u0001\u000bG>t7-\u001e:sK:$(\u0002BA\u0006\u0003\u001b\tA!\u001e;jY*\u0011\u0011qB\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0014\u0005\u0015!!E\"p]\u000e,(O]3oi\"\u000b7\u000f['baB\u0019a\"a\u0006\n\u0007\u0005eqBA\u0004C_>dW-\u00198\t\u0011\u0005u\u0001\u0001)A\u0005\u0003\u0003\t1C]3mK\u0006\u001cX\rZ\"p]R\f\u0017N\\3sg\u0002B\u0011\"!\t\u0001\u0005\u0004%I!a\t\u0002%9,X\u000eU3oI&tw-\u00117m_\u000e\fG/Z\u000b\u0003\u0003K\u0001B!a\n\u0002.5\u0011\u0011\u0011\u0006\u0006\u0005\u0003W\t)!\u0001\u0004bi>l\u0017nY\u0005\u0005\u0003_\tICA\u0007Bi>l\u0017nY%oi\u0016<WM\u001d\u0005\t\u0003g\u0001\u0001\u0015!\u0003\u0002&\u0005\u0019b.^7QK:$\u0017N\\4BY2|7-\u0019;fA!I\u0011q\u0007\u0001C\u0002\u0013%\u00111E\u0001\u0014]VlW\t_3dkR|'o\u001d*v]:Lgn\u001a\u0005\t\u0003w\u0001\u0001\u0015!\u0003\u0002&\u0005!b.^7Fq\u0016\u001cW\u000f^8sgJ+hN\\5oO\u0002B\u0011\"a\u0010\u0001\u0005\u0004%I!a\t\u0002#\u0015DXmY;u_JLEmQ8v]R,'\u000f\u0003\u0005\u0002D\u0001\u0001\u000b\u0011BA\u0013\u0003I)\u00070Z2vi>\u0014\u0018\nZ\"pk:$XM\u001d\u0011\t\u0013\u0005\u001d\u0003A1A\u0005\n\u0005\r\u0012A\u00058v[\u0016CXmY;u_J\u001ch)Y5mK\u0012D\u0001\"a\u0013\u0001A\u0003%\u0011QE\u0001\u0014]VlW\t_3dkR|'o\u001d$bS2,G\r\t\u0005\n\u0003\u001f\u0002\u0001\u0019!C\u0005\u0003#\nA\"\\1y\u000bb,7-\u001e;peN,\u0012\u0001\u001f\u0005\n\u0003+\u0002\u0001\u0019!C\u0005\u0003/\n\u0001#\\1y\u000bb,7-\u001e;peN|F%Z9\u0015\t\u0005e\u0013q\f\t\u0004\u001d\u0005m\u0013bAA/\u001f\t!QK\\5u\u0011%\t\t'a\u0015\u0002\u0002\u0003\u0007\u00010A\u0002yIEBq!!\u001a\u0001A\u0003&\u00010A\u0007nCb,\u00050Z2vi>\u00148\u000f\t\u0005\n\u0003S\u0002!\u0019!C\u0005\u0003W\nQ#\u001a=fGV$xN]%e)>\u001cuN\u001c;bS:,'/\u0006\u0002\u0002nA)!-Z \u0002pA\u0019\u0011&!\u001d\n\u0007\u0005M$FA\u0005D_:$\u0018-\u001b8fe\"A\u0011q\u000f\u0001!\u0002\u0013\ti'\u0001\ffq\u0016\u001cW\u000f^8s\u0013\u0012$vnQ8oi\u0006Lg.\u001a:!\u0011%\tY\b\u0001b\u0001\n#\t\t&\u0001\bfq\u0016\u001cW\u000f^8s\u001b\u0016lwN]=\t\u000f\u0005}\u0004\u0001)A\u0005q\u0006yQ\r_3dkR|'/T3n_JL\b\u0005C\u0005\u0002\u0004\u0002\u0011\r\u0011\"\u0005\u0002R\u0005iQ\r_3dkR|'oQ8sKNDq!a\"\u0001A\u0003%\u00010\u0001\bfq\u0016\u001cW\u000f^8s\u0007>\u0014Xm\u001d\u0011\t\u0013\u0005\u0005\u0004!!Q\u0001\n\u0005-\u0005c\u0002\b\u0002\u000e\u0006E\u0015\u0011S\u0005\u0004\u0003\u001f{!A\u0002+va2,'\u0007E\u0003A\u0003'{\u00040\u0003\u0002?\u000b\"I\u0011q\u0013\u0001C\u0002\u0013E\u0011\u0011T\u0001\u0015aJ,g-\u001a:sK\u0012Dun\u001d;U_\u000e{WO\u001c;\u0016\u0005\u0005E\u0005\u0002CAO\u0001\u0001\u0006I!!%\u0002+A\u0014XMZ3se\u0016$\u0007j\\:u)>\u001cu.\u001e8uA!I\u0011\u0011\u0015\u0001C\u0002\u0013E\u0011\u0011T\u0001\u0015aJ,g-\u001a:sK\u0012\u0014\u0016mY6U_\u000e{WO\u001c;\t\u0011\u0005\u0015\u0006\u0001)A\u0005\u0003#\u000bQ\u0003\u001d:fM\u0016\u0014(/\u001a3SC\u000e\\Gk\\\"pk:$\b\u0005C\u0005\u0002*\u0002\u0011\r\u0011\"\u0005\u0002R\u0005qQ.Z7pef|e/\u001a:iK\u0006$\u0007bBAW\u0001\u0001\u0006I\u0001_\u0001\u0010[\u0016lwN]=Pm\u0016\u0014\b.Z1eA!I\u0011\u0011\u0017\u0001C\u0002\u0013%\u00111W\u0001\rY\u0006,hn\u00195feB{w\u000e\\\u000b\u0003\u0003k\u0003B!a\u0001\u00028&!\u0011\u0011XA\u0003\u0005I!\u0006N]3bIB{w\u000e\\#yK\u000e,Ho\u001c:\t\u0011\u0005u\u0006\u0001)A\u0005\u0003k\u000bQ\u0002\\1v]\u000eDWM\u001d)p_2\u0004\u0003bBAa\u0001\u0011\u0005\u0011\u0011K\u0001\u0017O\u0016$h*^7Fq\u0016\u001cW\u000f^8sgJ+hN\\5oO\"9\u0011Q\u0019\u0001\u0005\u0002\u0005E\u0013!F4fi:+X.\u0012=fGV$xN]:GC&dW\r\u001a\u0005\b\u0003\u0013\u0004A\u0011AAf\u0003U\u0011X-];fgR$v\u000e^1m\u000bb,7-\u001e;peN$B!!\u0017\u0002N\"9\u0011qZAd\u0001\u0004A\u0018A\u0004:fcV,7\u000f^3e)>$\u0018\r\u001c\u0005\b\u0003'\u0004A\u0011AAk\u00031Y\u0017\u000e\u001c7Fq\u0016\u001cW\u000f^8s)\u0011\tI&a6\t\u000f\u0005e\u0017\u0011\u001ba\u0001\u007f\u0005QQ\r_3dkR|'/\u00133\t\u000f\u0005u\u0007\u0001\"\u0001\u0002`\u0006\t\u0012\r\u001c7pG\u0006$XMU3t_V\u00148-Z:\u0015\u0005\u0005e\u0003bBAr\u0001\u0011E\u0011Q]\u0001\u001aC2dwnY1uK\u0012\u001cuN\u001c;bS:,'o](o\u0011>\u001cH\u000fF\u0002y\u0003ODq!!;\u0002b\u0002\u0007q(\u0001\u0003i_N$\bbBAw\u0001\u0011E\u0011q^\u0001\u001aC2dwnY1uK\u0012\u001cuN\u001c;bS:,'o](o%\u0006\u001c7\u000eF\u0002y\u0003cDq!a=\u0002l\u0002\u0007q(\u0001\u0003sC\u000e\\\u0007bBA|\u0001\u0011%\u0011\u0011`\u0001\u001eSN\u0014Vm]8ve\u000e,7i\u001c8tiJ\f\u0017N\u001c;TCRL7OZ5fIR!\u0011QCA~\u0011!\ti0!>A\u0002\u0005=\u0014!C2p]R\f\u0017N\\3s\u0011\u001d\u0011\t\u0001\u0001C\u0005\u0005\u0007\tAcZ3oKJ\fG/\u001a(pI\u0016$vnV3jO\"$HCBAF\u0005\u000b\u00119\u0001\u0003\u0004\u0019\u0003\u007f\u0004\rA\u0007\u0005\b\u0005\u0013\ty\u00101\u0001:\u0003\u0015Ig\u000e];u\u0011\u001d\u0011i\u0001\u0001C\u0005\u0005\u001f\t\u0001$\u001b8uKJt\u0017\r\u001c*fY\u0016\f7/Z\"p]R\f\u0017N\\3s)\u0011\tIF!\u0005\t\u0011\u0005u(1\u0002a\u0001\u0003_BqA!\u0006\u0001\r#\u00119\"\u0001\nbY2|7-\u0019;f\u0007>tG/Y5oKJ\u001cHC\u0002B\r\u0005\u0017\u0012y\u0005\u0005\u0003\u0003\u001c\tuQ\"\u0001\u0001\u0007\u0013\t}\u0001\u0001%A\u0012\u0012\t\u0005\"\u0001F-be:\fE\u000e\\8dCR,'+Z:q_:\u001cXmE\u0002\u0003\u001e5A\u0001B!\n\u0003\u001e\u0019\u0005!qE\u0001\u0017O\u0016$\u0018\t\u001c7pG\u0006$X\rZ\"p]R\f\u0017N\\3sgR\u0011!\u0011\u0006\t\u0007\u0005W\u0011i#a\u001c\u000e\u0005\u0005%\u0011\u0002\u0002B\u0018\u0003\u0013\u0011A\u0001T5ti\"A!1\u0007B\u000f\r\u0003\u0011)$A\u000bhKR\fe/Y5mC\ndWMU3t_V\u00148-Z:\u0015\u0005\t]\u0002cA\u0015\u0003:%\u0019!1\b\u0016\u0003\u0011I+7o\\;sG\u0016D\u0001Ba\u0010\u0003\u001e\u0019\u0005!\u0011I\u0001\u001fO\u0016$8i\\7qY\u0016$X\rZ\"p]R\f\u0017N\\3sgN#\u0018\r^;tKN$\"Aa\u0011\u0011\r\t-\"Q\u0006B#!\rI#qI\u0005\u0004\u0005\u0013R#aD\"p]R\f\u0017N\\3s'R\fG/^:\t\u000f\t5#1\u0003a\u0001q\u0006)1m\\;oi\"9!\u0011\u000bB\n\u0001\u0004A\u0018a\u00029f]\u0012Lgn\u001a\u0005\b\u0005+\u0002a\u0011\u0003B,\u0003A\u0011X\r\\3bg\u0016\u001cuN\u001c;bS:,'\u000f\u0006\u0003\u0002Z\te\u0003\u0002CA\u007f\u0005'\u0002\r!a\u001c\b\u000f\tu#\u0001#\u0003\u0003`\u0005i\u0011,\u0019:o\u00032dwnY1u_J\u00042\u0001\u000eB1\r\u0019\t!\u0001#\u0003\u0003dM\u0019!\u0011M\u0007\t\u000fU\u0013\t\u0007\"\u0001\u0003hQ\u0011!q\f\u0005\u000b\u0005W\u0012\tG1A\u0005\u0002\t5\u0014!C'F\u001b~\u0013ViR#Y+\t\u0011y\u0007\u0005\u0003\u0003r\t]TB\u0001B:\u0015\u0011\u0011)(!\u0004\u0002\t1\fgnZ\u0005\u0004\t\nM\u0004\"\u0003B>\u0005C\u0002\u000b\u0011\u0002B8\u0003)iU)T0S\u000b\u001e+\u0005\f\t\u0005\u000b\u0005\u007f\u0012\tG1A\u0005\u0002\t\u0005\u0015!\u0006)N\u000b6{V\tW\"F\u000b\u0012+Ei\u0018)B)R+%KT\u000b\u0003\u0005\u0007\u0003BA!\"\u0003\f6\u0011!q\u0011\u0006\u0005\u0005\u0013\u000bI!A\u0003sK\u001e,\u00070\u0003\u0003\u0003\u000e\n\u001d%a\u0002)biR,'O\u001c\u0005\n\u0005#\u0013\t\u0007)A\u0005\u0005\u0007\u000ba\u0003U'F\u001b~+\u0005lQ#F\t\u0016#u\fU!U)\u0016\u0013f\n\t\u0005\u000b\u0005+\u0013\tG1A\u0005\u0002\t\u0005\u0015!\u0006,N\u000b6{V\tW\"F\u000b\u0012+Ei\u0018)B)R+%K\u0014\u0005\n\u00053\u0013\t\u0007)A\u0005\u0005\u0007\u000baCV'F\u001b~+\u0005lQ#F\t\u0016#u\fU!U)\u0016\u0013f\n\t\u0005\t\u0005;\u0013\t\u0007\"\u0001\u0003 \u0006QR.Z7MS6LG/\u0012=dK\u0016$W\r\u001a'pO6+7o]1hKR)qH!)\u0003&\"9!1\u0015BN\u0001\u0004y\u0014a\u00033jC\u001etwn\u001d;jGND\u0001Ba*\u0003\u001c\u0002\u0007!1Q\u0001\ba\u0006$H/\u001a:o\u0001")
public abstract class YarnAllocator
implements Logging {
    public final Configuration org$apache$spark$deploy$yarn$YarnAllocator$$conf;
    public final SparkConf org$apache$spark$deploy$yarn$YarnAllocator$$sparkConf;
    public final ApplicationAttemptId org$apache$spark$deploy$yarn$YarnAllocator$$appAttemptId;
    public final SecurityManager org$apache$spark$deploy$yarn$YarnAllocator$$securityMgr;
    private final HashMap<String, scala.collection.mutable.Set<ContainerId>> org$apache$spark$deploy$yarn$YarnAllocator$$allocatedHostToContainersMap;
    private final HashMap<ContainerId, String> org$apache$spark$deploy$yarn$YarnAllocator$$allocatedContainerToHostMap;
    private final HashMap<String, Object> org$apache$spark$deploy$yarn$YarnAllocator$$allocatedRackCount;
    private final ConcurrentHashMap<ContainerId, Object> org$apache$spark$deploy$yarn$YarnAllocator$$releasedContainers;
    private final AtomicInteger numPendingAllocate;
    private final AtomicInteger org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsRunning;
    private final AtomicInteger org$apache$spark$deploy$yarn$YarnAllocator$$executorIdCounter;
    private final AtomicInteger org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsFailed;
    private int org$apache$spark$deploy$yarn$YarnAllocator$$maxExecutors;
    private final HashMap<String, Container> org$apache$spark$deploy$yarn$YarnAllocator$$executorIdToContainer;
    private final int executorMemory;
    private final int executorCores;
    private final Tuple2<scala.collection.immutable.Map<String, Object>, scala.collection.immutable.Map<String, Object>> x$1;
    private final scala.collection.immutable.Map<String, Object> preferredHostToCount;
    private final scala.collection.immutable.Map<String, Object> preferredRackToCount;
    private final int memoryOverhead;
    private final ThreadPoolExecutor org$apache$spark$deploy$yarn$YarnAllocator$$launcherPool;
    private transient Logger org$apache$spark$Logging$$log_;

    public static String memLimitExceededLogMessage(String string, Pattern pattern) {
        return YarnAllocator$.MODULE$.memLimitExceededLogMessage(string, pattern);
    }

    public static Pattern VMEM_EXCEEDED_PATTERN() {
        return YarnAllocator$.MODULE$.VMEM_EXCEEDED_PATTERN();
    }

    public static Pattern PMEM_EXCEEDED_PATTERN() {
        return YarnAllocator$.MODULE$.PMEM_EXCEEDED_PATTERN();
    }

    public static String MEM_REGEX() {
        return YarnAllocator$.MODULE$.MEM_REGEX();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public HashMap<String, scala.collection.mutable.Set<ContainerId>> org$apache$spark$deploy$yarn$YarnAllocator$$allocatedHostToContainersMap() {
        return this.org$apache$spark$deploy$yarn$YarnAllocator$$allocatedHostToContainersMap;
    }

    public HashMap<ContainerId, String> org$apache$spark$deploy$yarn$YarnAllocator$$allocatedContainerToHostMap() {
        return this.org$apache$spark$deploy$yarn$YarnAllocator$$allocatedContainerToHostMap;
    }

    public HashMap<String, Object> org$apache$spark$deploy$yarn$YarnAllocator$$allocatedRackCount() {
        return this.org$apache$spark$deploy$yarn$YarnAllocator$$allocatedRackCount;
    }

    public ConcurrentHashMap<ContainerId, Object> org$apache$spark$deploy$yarn$YarnAllocator$$releasedContainers() {
        return this.org$apache$spark$deploy$yarn$YarnAllocator$$releasedContainers;
    }

    private AtomicInteger numPendingAllocate() {
        return this.numPendingAllocate;
    }

    public AtomicInteger org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsRunning() {
        return this.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsRunning;
    }

    public AtomicInteger org$apache$spark$deploy$yarn$YarnAllocator$$executorIdCounter() {
        return this.org$apache$spark$deploy$yarn$YarnAllocator$$executorIdCounter;
    }

    public AtomicInteger org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsFailed() {
        return this.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsFailed;
    }

    public int org$apache$spark$deploy$yarn$YarnAllocator$$maxExecutors() {
        return this.org$apache$spark$deploy$yarn$YarnAllocator$$maxExecutors;
    }

    private void org$apache$spark$deploy$yarn$YarnAllocator$$maxExecutors_$eq(int x$1) {
        this.org$apache$spark$deploy$yarn$YarnAllocator$$maxExecutors = x$1;
    }

    public HashMap<String, Container> org$apache$spark$deploy$yarn$YarnAllocator$$executorIdToContainer() {
        return this.org$apache$spark$deploy$yarn$YarnAllocator$$executorIdToContainer;
    }

    public int executorMemory() {
        return this.executorMemory;
    }

    public int executorCores() {
        return this.executorCores;
    }

    public scala.collection.immutable.Map<String, Object> preferredHostToCount() {
        return this.preferredHostToCount;
    }

    public scala.collection.immutable.Map<String, Object> preferredRackToCount() {
        return this.preferredRackToCount;
    }

    public int memoryOverhead() {
        return this.memoryOverhead;
    }

    public ThreadPoolExecutor org$apache$spark$deploy$yarn$YarnAllocator$$launcherPool() {
        return this.org$apache$spark$deploy$yarn$YarnAllocator$$launcherPool;
    }

    public int getNumExecutorsRunning() {
        return this.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsRunning().intValue();
    }

    public int getNumExecutorsFailed() {
        return this.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsFailed().intValue();
    }

    public synchronized void requestTotalExecutors(int requestedTotal) {
        int currentTotal = this.numPendingAllocate().get() + this.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsRunning().get();
        if (requestedTotal > currentTotal) {
            this.org$apache$spark$deploy$yarn$YarnAllocator$$maxExecutors_$eq(this.org$apache$spark$deploy$yarn$YarnAllocator$$maxExecutors() + (requestedTotal - currentTotal));
            this.allocateResources();
        } else {
            this.logInfo((Function0<String>)new Serializable(this, requestedTotal, currentTotal){
                public static final long serialVersionUID = 0L;
                private final int requestedTotal$1;
                private final int currentTotal$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Not allocating more executors because there are already ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.currentTotal$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(application requested ", " total)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.requestedTotal$1)}))).toString();
                }
                {
                    this.requestedTotal$1 = requestedTotal$1;
                    this.currentTotal$1 = currentTotal$1;
                }
            });
        }
    }

    public synchronized void killExecutor(String executorId) {
        if (this.org$apache$spark$deploy$yarn$YarnAllocator$$executorIdToContainer().contains((Object)executorId)) {
            Container container = (Container)this.org$apache$spark$deploy$yarn$YarnAllocator$$executorIdToContainer().remove((Object)executorId).get();
            this.org$apache$spark$deploy$yarn$YarnAllocator$$internalReleaseContainer(container);
            this.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsRunning().decrementAndGet();
            this.org$apache$spark$deploy$yarn$YarnAllocator$$maxExecutors_$eq(this.org$apache$spark$deploy$yarn$YarnAllocator$$maxExecutors() - 1);
            Predef$.MODULE$.assert(this.org$apache$spark$deploy$yarn$YarnAllocator$$maxExecutors() >= 0, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Allocator killed more executors than are allocated!";
                }
            });
        } else {
            this.logWarning((Function0<String>)new Serializable(this, executorId){
                public static final long serialVersionUID = 0L;
                private final String executorId$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempted to kill unknown executor ", "!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.executorId$1}));
                }
                {
                    this.executorId$1 = executorId$1;
                }
            });
        }
    }

    public synchronized void allocateResources() {
        java.util.List<ContainerStatus> completedContainers;
        int missing = this.org$apache$spark$deploy$yarn$YarnAllocator$$maxExecutors() - this.numPendingAllocate().get() - this.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsRunning().get();
        int executorsPending = this.numPendingAllocate().get();
        if (missing > 0) {
            int totalExecutorMemory = this.executorMemory() + this.memoryOverhead();
            this.numPendingAllocate().addAndGet(missing);
            this.logInfo((Function0<String>)new Serializable(this, missing, totalExecutorMemory){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ YarnAllocator $outer;
                private final int missing$1;
                private final int totalExecutorMemory$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Will allocate ", " executor containers, each with ", " MB "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.missing$1), BoxesRunTime.boxToInteger((int)this.totalExecutorMemory$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"memory including ", " MB overhead"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.memoryOverhead())}))).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.missing$1 = missing$1;
                    this.totalExecutorMemory$1 = totalExecutorMemory$1;
                }
            });
        } else {
            this.logDebug((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Empty allocation request ...";
                }
            });
        }
        YarnAllocateResponse allocateResponse = this.allocateContainers(missing, executorsPending);
        java.util.List<Container> allocatedContainers = allocateResponse.getAllocatedContainers();
        if (allocatedContainers.size() > 0) {
            int numPendingAllocateNow = this.numPendingAllocate().addAndGet(-1 * allocatedContainers.size());
            if (numPendingAllocateNow < 0) {
                numPendingAllocateNow = this.numPendingAllocate().addAndGet(-1 * numPendingAllocateNow);
            }
            this.logDebug((Function0<String>)new Serializable(this, allocateResponse, allocatedContainers){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ YarnAllocator $outer;
                private final YarnAllocateResponse allocateResponse$1;
                private final java.util.List allocatedContainers$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("\n        Allocated containers: %d\n        Current executor count: %d\n        Containers released: %s\n        Cluster resources: %s\n        ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.allocatedContainers$1.size()), BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsRunning().get()), this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$releasedContainers(), this.allocateResponse$1.getAvailableResources()}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.allocateResponse$1 = allocateResponse$1;
                    this.allocatedContainers$1 = allocatedContainers$1;
                }
            });
            HashMap hostToContainers = new HashMap();
            JavaConversions$.MODULE$.asScalaBuffer(allocatedContainers).foreach((Function1)new Serializable(this, hostToContainers){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ YarnAllocator $outer;
                private final HashMap hostToContainers$1;

                public final Object apply(Container container) {
                    BoxedUnit boxedUnit;
                    if (this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$isResourceConstraintSatisfied(container)) {
                        String host = container.getNodeId().getHost();
                        ArrayBuffer containersForHost = (ArrayBuffer)this.hostToContainers$1.getOrElseUpdate((Object)host, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final ArrayBuffer<Container> apply() {
                                return new ArrayBuffer();
                            }
                        });
                        boxedUnit = containersForHost.$plus$eq((Object)container);
                    } else {
                        this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$internalReleaseContainer(container);
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return boxedUnit;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.hostToContainers$1 = hostToContainers$1;
                }
            });
            HashMap dataLocalContainers = new HashMap();
            HashMap rackLocalContainers = new HashMap();
            HashMap offRackContainers = new HashMap();
            hostToContainers.keySet().foreach((Function1)new Serializable(this, hostToContainers, dataLocalContainers, rackLocalContainers, offRackContainers){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ YarnAllocator $outer;
                private final HashMap hostToContainers$1;
                private final HashMap dataLocalContainers$1;
                private final HashMap rackLocalContainers$1;
                private final HashMap offRackContainers$1;

                public final Object apply(String candidateHost) {
                    String rack;
                    int maxExpectedHostCount = BoxesRunTime.unboxToInt((Object)this.$outer.preferredHostToCount().getOrElse((Object)candidateHost, (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply() {
                            return this.apply$mcI$sp();
                        }

                        public int apply$mcI$sp() {
                            return 0;
                        }
                    }));
                    int requiredHostCount = maxExpectedHostCount - this.$outer.allocatedContainersOnHost(candidateHost);
                    Option remainingContainersOpt = this.hostToContainers$1.get((Object)candidateHost);
                    Predef$.MODULE$.assert(remainingContainersOpt.isDefined());
                    ArrayBuffer remainingContainers = (ArrayBuffer)remainingContainersOpt.get();
                    if (requiredHostCount >= remainingContainers.size()) {
                        this.dataLocalContainers$1.put((Object)candidateHost, (Object)remainingContainers);
                        remainingContainers = null;
                    } else if (requiredHostCount > 0) {
                        Tuple2 tuple2 = remainingContainers.splitAt(remainingContainers.size() - requiredHostCount);
                        if (tuple2 != null) {
                            Tuple2 tuple22;
                            ArrayBuffer dataLocal = (ArrayBuffer)tuple2._1();
                            ArrayBuffer remaining = (ArrayBuffer)tuple2._2();
                            Tuple2 tuple23 = tuple22 = new Tuple2((Object)dataLocal, (Object)remaining);
                            ArrayBuffer dataLocal2 = (ArrayBuffer)tuple23._1();
                            ArrayBuffer remaining2 = (ArrayBuffer)tuple23._2();
                            this.dataLocalContainers$1.put((Object)candidateHost, (Object)dataLocal2);
                            remaining2.foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$allocateResources$5 $outer;

                                public final void apply(Container container) {
                                    this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$anonfun$$$outer().org$apache$spark$deploy$yarn$YarnAllocator$$internalReleaseContainer(container);
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            });
                            remainingContainers = null;
                        } else {
                            throw new MatchError((Object)tuple2);
                        }
                    }
                    if (remainingContainers != null && (rack = YarnSparkHadoopUtil$.MODULE$.lookupRack(this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$conf, candidateHost)) != null) {
                        int maxExpectedRackCount = BoxesRunTime.unboxToInt((Object)this.$outer.preferredRackToCount().getOrElse((Object)rack, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply() {
                                return this.apply$mcI$sp();
                            }

                            public int apply$mcI$sp() {
                                return 0;
                            }
                        }));
                        int requiredRackCount = maxExpectedRackCount - this.$outer.allocatedContainersOnRack(rack) - ((SeqLike)this.rackLocalContainers$1.getOrElse((Object)rack, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final List<Nothing$> apply() {
                                return Nil$.MODULE$;
                            }
                        })).size();
                        if (requiredRackCount >= remainingContainers.size()) {
                            this.dataLocalContainers$1.put((Object)rack, (Object)remainingContainers);
                            remainingContainers = null;
                        } else if (requiredRackCount > 0) {
                            Tuple2 tuple2 = remainingContainers.splitAt(remainingContainers.size() - requiredRackCount);
                            if (tuple2 != null) {
                                Tuple2 tuple24;
                                ArrayBuffer rackLocal = (ArrayBuffer)tuple2._1();
                                ArrayBuffer remaining = (ArrayBuffer)tuple2._2();
                                Tuple2 tuple25 = tuple24 = new Tuple2((Object)rackLocal, (Object)remaining);
                                ArrayBuffer rackLocal2 = (ArrayBuffer)tuple25._1();
                                ArrayBuffer remaining3 = (ArrayBuffer)tuple25._2();
                                ArrayBuffer existingRackLocal = (ArrayBuffer)this.rackLocalContainers$1.getOrElseUpdate((Object)rack, (Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final ArrayBuffer<Container> apply() {
                                        return new ArrayBuffer();
                                    }
                                });
                                existingRackLocal.$plus$plus$eq((TraversableOnce)rackLocal2);
                                remainingContainers = remaining3;
                            } else {
                                throw new MatchError((Object)tuple2);
                            }
                        }
                    }
                    return remainingContainers == null ? BoxedUnit.UNIT : this.offRackContainers$1.put((Object)candidateHost, (Object)remainingContainers);
                }

                public /* synthetic */ YarnAllocator org$apache$spark$deploy$yarn$YarnAllocator$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.hostToContainers$1 = hostToContainers$1;
                    this.dataLocalContainers$1 = dataLocalContainers$1;
                    this.rackLocalContainers$1 = rackLocalContainers$1;
                    this.offRackContainers$1 = offRackContainers$1;
                }
            });
            ArrayBuffer allocatedContainersToProcess = new ArrayBuffer(allocatedContainers.size());
            allocatedContainersToProcess.$plus$plus$eq((TraversableOnce)TaskSchedulerImpl$.MODULE$.prioritizeContainers(dataLocalContainers));
            allocatedContainersToProcess.$plus$plus$eq((TraversableOnce)TaskSchedulerImpl$.MODULE$.prioritizeContainers(rackLocalContainers));
            allocatedContainersToProcess.$plus$plus$eq((TraversableOnce)TaskSchedulerImpl$.MODULE$.prioritizeContainers(offRackContainers));
            allocatedContainersToProcess.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ YarnAllocator $outer;

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public final Object apply(Container container) {
                    Integer n;
                    int numExecutorsRunningNow = this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsRunning().incrementAndGet();
                    String executorHostname = container.getNodeId().getHost();
                    ContainerId containerId = container.getId();
                    int executorMemoryOverhead = this.$outer.executorMemory() + this.$outer.memoryOverhead();
                    Predef$.MODULE$.assert(container.getResource().getMemory() >= executorMemoryOverhead);
                    if (numExecutorsRunningNow > this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$maxExecutors()) {
                        this.$outer.logInfo((Function0<String>)new Serializable(this, executorHostname, containerId){
                            public static final long serialVersionUID = 0L;
                            private final String executorHostname$1;
                            private final ContainerId containerId$1;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString("Ignoring container %s at host %s, since we already have the required number of\n            containers for it.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.containerId$1, this.executorHostname$1}));
                            }
                            {
                                this.executorHostname$1 = executorHostname$1;
                                this.containerId$1 = containerId$1;
                            }
                        });
                        this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$internalReleaseContainer(container);
                        n = BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsRunning().decrementAndGet());
                        return n;
                    }
                    String executorId = ((Object)BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$executorIdCounter().incrementAndGet())).toString();
                    String driverUrl = new StringOps(Predef$.MODULE$.augmentString("akka.tcp://%s@%s:%s/user/%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SparkEnv$.MODULE$.driverActorSystemName(), this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$sparkConf.get("spark.driver.host"), this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$sparkConf.get("spark.driver.port"), CoarseGrainedSchedulerBackend$.MODULE$.ACTOR_NAME()}));
                    this.$outer.logInfo((Function0<String>)new Serializable(this, executorHostname, containerId){
                        public static final long serialVersionUID = 0L;
                        private final String executorHostname$1;
                        private final ContainerId containerId$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Launching container %s for on host %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.containerId$1, this.executorHostname$1}));
                        }
                        {
                            this.executorHostname$1 = executorHostname$1;
                            this.containerId$1 = containerId$1;
                        }
                    });
                    this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$executorIdToContainer().update((Object)executorId, (Object)container);
                    this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$releasedContainers().remove(containerId);
                    String rack = YarnSparkHadoopUtil$.MODULE$.lookupRack(this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$conf, executorHostname);
                    HashMap<String, scala.collection.mutable.Set<ContainerId>> hashMap = this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$allocatedHostToContainersMap();
                    synchronized (hashMap) {
                        scala.collection.mutable.Set containerSet = (scala.collection.mutable.Set)this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$allocatedHostToContainersMap().getOrElseUpdate((Object)executorHostname, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final HashSet<ContainerId> apply() {
                                return new HashSet();
                            }
                        });
                        containerSet.$plus$eq((Object)containerId);
                        this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$allocatedContainerToHostMap().put((Object)containerId, (Object)executorHostname);
                        Object object = rack == null ? BoxedUnit.UNIT : this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$allocatedRackCount().put((Object)rack, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$allocatedRackCount().getOrElse((Object)rack, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply() {
                                return this.apply$mcI$sp();
                            }

                            public int apply$mcI$sp() {
                                return 0;
                            }
                        })) + 1)));
                        // MONITOREXIT @DISABLED, blocks:[0, 1] lbl27 : MonitorExitStatement: MONITOREXIT : hashMap
                        this.$outer.logInfo((Function0<String>)new Serializable(this, executorHostname, driverUrl){
                            public static final long serialVersionUID = 0L;
                            private final String executorHostname$1;
                            private final String driverUrl$1;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString("Launching ExecutorRunnable. driverUrl: %s,  executorHostname: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.driverUrl$1, this.executorHostname$1}));
                            }
                            {
                                this.executorHostname$1 = executorHostname$1;
                                this.driverUrl$1 = driverUrl$1;
                            }
                        });
                        ExecutorRunnable executorRunnable = new ExecutorRunnable(container, this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$conf, this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$sparkConf, driverUrl, executorId, executorHostname, this.$outer.executorMemory(), this.$outer.executorCores(), this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$appAttemptId.getApplicationId().toString(), this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$securityMgr);
                        this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$launcherPool().execute(executorRunnable);
                        n = BoxedUnit.UNIT;
                        return n;
                    }
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            this.logDebug((Function0<String>)new Serializable(this, allocatedContainers, allocatedContainersToProcess){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ YarnAllocator $outer;
                private final java.util.List allocatedContainers$1;
                private final ArrayBuffer allocatedContainersToProcess$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("\n        Finished allocating %s containers (from %s originally).\n        Current number of executors running: %d,\n        Released containers: %s\n        ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.allocatedContainersToProcess$1, this.allocatedContainers$1, BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsRunning().get()), this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$releasedContainers()}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.allocatedContainers$1 = allocatedContainers$1;
                    this.allocatedContainersToProcess$1 = allocatedContainersToProcess$1;
                }
            });
        }
        if ((completedContainers = allocateResponse.getCompletedContainersStatuses()).size() > 0) {
            this.logDebug((Function0<String>)new Serializable(this, completedContainers){
                public static final long serialVersionUID = 0L;
                private final java.util.List completedContainers$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Completed %d containers")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.completedContainers$1.size())}));
                }
                {
                    this.completedContainers$1 = completedContainers$1;
                }
            });
            JavaConversions$.MODULE$.asScalaBuffer(completedContainers).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ YarnAllocator $outer;

                public final Object apply(ContainerStatus completedContainer) {
                    Object object;
                    ContainerId containerId = completedContainer.getContainerId();
                    if (this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$releasedContainers().containsKey(containerId)) {
                        object = this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$releasedContainers().remove(containerId);
                    } else {
                        this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsRunning().decrementAndGet();
                        this.$outer.logInfo((Function0<String>)new Serializable(this, completedContainer, containerId){
                            public static final long serialVersionUID = 0L;
                            private final ContainerStatus completedContainer$1;
                            private final ContainerId containerId$2;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString("Completed container %s (state: %s, exit status: %s)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.containerId$2, this.completedContainer$1.getState(), BoxesRunTime.boxToInteger((int)this.completedContainer$1.getExitStatus())}));
                            }
                            {
                                this.completedContainer$1 = completedContainer$1;
                                this.containerId$2 = containerId$2;
                            }
                        });
                        if (completedContainer.getExitStatus() == -103) {
                            this.$outer.logWarning((Function0<String>)new Serializable(this, completedContainer){
                                public static final long serialVersionUID = 0L;
                                private final ContainerStatus completedContainer$1;

                                public final String apply() {
                                    return YarnAllocator$.MODULE$.memLimitExceededLogMessage(this.completedContainer$1.getDiagnostics(), YarnAllocator$.MODULE$.VMEM_EXCEEDED_PATTERN());
                                }
                                {
                                    this.completedContainer$1 = completedContainer$1;
                                }
                            });
                            object = BoxedUnit.UNIT;
                        } else if (completedContainer.getExitStatus() == -104) {
                            this.$outer.logWarning((Function0<String>)new Serializable(this, completedContainer){
                                public static final long serialVersionUID = 0L;
                                private final ContainerStatus completedContainer$1;

                                public final String apply() {
                                    return YarnAllocator$.MODULE$.memLimitExceededLogMessage(this.completedContainer$1.getDiagnostics(), YarnAllocator$.MODULE$.PMEM_EXCEEDED_PATTERN());
                                }
                                {
                                    this.completedContainer$1 = completedContainer$1;
                                }
                            });
                            object = BoxedUnit.UNIT;
                        } else if (completedContainer.getExitStatus() != 0) {
                            this.$outer.logInfo((Function0<String>)new Serializable(this, completedContainer, containerId){
                                public static final long serialVersionUID = 0L;
                                private final ContainerStatus completedContainer$1;
                                private final ContainerId containerId$2;

                                public final String apply() {
                                    return new StringBuilder().append((Object)"Container marked as failed: ").append((Object)this.containerId$2).append((Object)". Exit status: ").append((Object)BoxesRunTime.boxToInteger((int)this.completedContainer$1.getExitStatus())).append((Object)". Diagnostics: ").append((Object)this.completedContainer$1.getDiagnostics()).toString();
                                }
                                {
                                    this.completedContainer$1 = completedContainer$1;
                                    this.containerId$2 = containerId$2;
                                }
                            });
                            object = BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsFailed().incrementAndGet());
                        } else {
                            object = BoxedUnit.UNIT;
                        }
                    }
                    HashMap<String, scala.collection.mutable.Set<ContainerId>> hashMap = this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$allocatedHostToContainersMap();
                    synchronized (hashMap) {
                        Object object2;
                        if (JavaConversions$.MODULE$.mutableMapAsJavaMap(this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$allocatedContainerToHostMap()).containsKey(containerId)) {
                            int rackCount;
                            Option option;
                            Option hostOpt = this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$allocatedContainerToHostMap().get((Object)containerId);
                            Predef$.MODULE$.assert(hostOpt.isDefined());
                            String host = (String)hostOpt.get();
                            Option containerSetOpt = this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$allocatedHostToContainersMap().get((Object)host);
                            Predef$.MODULE$.assert(containerSetOpt.isDefined());
                            scala.collection.mutable.Set containerSet = (scala.collection.mutable.Set)containerSetOpt.get();
                            containerSet.remove((Object)containerId);
                            if (containerSet.isEmpty()) {
                                option = this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$allocatedHostToContainersMap().remove((Object)host);
                            } else {
                                this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$allocatedHostToContainersMap().update((Object)host, (Object)containerSet);
                                option = BoxedUnit.UNIT;
                            }
                            this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$allocatedContainerToHostMap().remove((Object)containerId);
                            String rack = YarnSparkHadoopUtil$.MODULE$.lookupRack(this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$conf, host);
                            object2 = rack == null ? BoxedUnit.UNIT : ((rackCount = BoxesRunTime.unboxToInt((Object)this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$allocatedRackCount().getOrElse((Object)rack, (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final int apply() {
                                    return this.apply$mcI$sp();
                                }

                                public int apply$mcI$sp() {
                                    return 0;
                                }
                            })) - 1) > 0 ? this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$allocatedRackCount().put((Object)rack, (Object)BoxesRunTime.boxToInteger((int)rackCount)) : this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$allocatedRackCount().remove((Object)rack));
                        } else {
                            object2 = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit = object2;
                        return boxedUnit;
                    }
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            this.logDebug((Function0<String>)new Serializable(this, completedContainers){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ YarnAllocator $outer;
                private final java.util.List completedContainers$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("\n        Finished processing %d completed containers.\n        Current number of executors running: %d,\n        Released containers: %s\n        ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.completedContainers$1.size()), BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsRunning().get()), this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$releasedContainers()}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.completedContainers$1 = completedContainers$1;
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    public int allocatedContainersOnHost(String host) {
        int retval = 0;
        HashMap<String, scala.collection.mutable.Set<ContainerId>> hashMap = this.org$apache$spark$deploy$yarn$YarnAllocator$$allocatedHostToContainersMap();
        synchronized (hashMap) {
            void var2_2;
            retval = ((TraversableOnce)this.org$apache$spark$deploy$yarn$YarnAllocator$$allocatedHostToContainersMap().getOrElse((Object)host, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final scala.collection.immutable.Set<Nothing$> apply() {
                    return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
                }
            })).size();
            return (int)var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int allocatedContainersOnRack(String rack) {
        int retval = 0;
        HashMap<String, scala.collection.mutable.Set<ContainerId>> hashMap = this.org$apache$spark$deploy$yarn$YarnAllocator$$allocatedHostToContainersMap();
        synchronized (hashMap) {
            void var2_2;
            retval = BoxesRunTime.unboxToInt((Object)this.org$apache$spark$deploy$yarn$YarnAllocator$$allocatedRackCount().getOrElse((Object)rack, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply() {
                    return this.apply$mcI$sp();
                }

                public int apply$mcI$sp() {
                    return 0;
                }
            }));
            return (int)var2_2;
        }
    }

    public boolean org$apache$spark$deploy$yarn$YarnAllocator$$isResourceConstraintSatisfied(Container container) {
        return container.getResource().getMemory() >= this.executorMemory() + this.memoryOverhead();
    }

    private Tuple2<scala.collection.immutable.Map<String, Object>, scala.collection.immutable.Map<String, Object>> generateNodeToWeight(Configuration conf, Map<String, Set<SplitInfo>> input) {
        if (input == null) {
            return new Tuple2((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
        }
        HashMap hostToCount = new HashMap();
        HashMap rackToCount = new HashMap();
        input.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Set<SplitInfo>> check$ifrefutable$1) {
                Tuple2<String, Set<SplitInfo>> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, conf, hostToCount, rackToCount){
            public static final long serialVersionUID = 0L;
            private final Configuration conf$1;
            private final HashMap hostToCount$1;
            private final HashMap rackToCount$1;

            public final Object apply(Tuple2<String, Set<SplitInfo>> x$4) {
                Tuple2<String, Set<SplitInfo>> tuple2 = x$4;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    String host = (String)tuple2._1();
                    Set splits = (Set)tuple2._2();
                    int hostCount = BoxesRunTime.unboxToInt((Object)this.hostToCount$1.getOrElse((Object)host, (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply() {
                            return this.apply$mcI$sp();
                        }

                        public int apply$mcI$sp() {
                            return 0;
                        }
                    }));
                    this.hostToCount$1.put((Object)host, (Object)BoxesRunTime.boxToInteger((int)(hostCount + splits.size())));
                    String rack = YarnSparkHadoopUtil$.MODULE$.lookupRack(this.conf$1, host);
                    if (rack == null) {
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        int rackCount = BoxesRunTime.unboxToInt((Object)this.rackToCount$1.getOrElse((Object)host, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply() {
                                return this.apply$mcI$sp();
                            }

                            public int apply$mcI$sp() {
                                return 0;
                            }
                        }));
                        boxedUnit = this.rackToCount$1.put((Object)host, (Object)BoxesRunTime.boxToInteger((int)(rackCount + splits.size())));
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return boxedUnit2;
                }
                throw new MatchError(tuple2);
            }
            {
                this.conf$1 = conf$1;
                this.hostToCount$1 = hostToCount$1;
                this.rackToCount$1 = rackToCount$1;
            }
        });
        return new Tuple2((Object)hostToCount.toMap(Predef$.MODULE$.conforms()), (Object)rackToCount.toMap(Predef$.MODULE$.conforms()));
    }

    public void org$apache$spark$deploy$yarn$YarnAllocator$$internalReleaseContainer(Container container) {
        this.org$apache$spark$deploy$yarn$YarnAllocator$$releasedContainers().put(container.getId(), BoxesRunTime.boxToBoolean((boolean)true));
        this.releaseContainer(container);
    }

    public abstract YarnAllocateResponse allocateContainers(int var1, int var2);

    public abstract void releaseContainer(Container var1);

    public YarnAllocator(Configuration conf, SparkConf sparkConf, ApplicationAttemptId appAttemptId, ApplicationMasterArguments args, Map<String, Set<SplitInfo>> preferredNodes, SecurityManager securityMgr) {
        this.org$apache$spark$deploy$yarn$YarnAllocator$$conf = conf;
        this.org$apache$spark$deploy$yarn$YarnAllocator$$sparkConf = sparkConf;
        this.org$apache$spark$deploy$yarn$YarnAllocator$$appAttemptId = appAttemptId;
        this.org$apache$spark$deploy$yarn$YarnAllocator$$securityMgr = securityMgr;
        Logging.class.$init$((Logging)this);
        this.org$apache$spark$deploy$yarn$YarnAllocator$$allocatedHostToContainersMap = new HashMap();
        this.org$apache$spark$deploy$yarn$YarnAllocator$$allocatedContainerToHostMap = new HashMap();
        this.org$apache$spark$deploy$yarn$YarnAllocator$$allocatedRackCount = new HashMap();
        this.org$apache$spark$deploy$yarn$YarnAllocator$$releasedContainers = new ConcurrentHashMap();
        this.numPendingAllocate = new AtomicInteger();
        this.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsRunning = new AtomicInteger();
        this.org$apache$spark$deploy$yarn$YarnAllocator$$executorIdCounter = new AtomicInteger();
        this.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsFailed = new AtomicInteger();
        this.org$apache$spark$deploy$yarn$YarnAllocator$$maxExecutors = args.numExecutors();
        this.org$apache$spark$deploy$yarn$YarnAllocator$$executorIdToContainer = new HashMap();
        this.executorMemory = args.executorMemory();
        this.executorCores = args.executorCores();
        Tuple2<scala.collection.immutable.Map<String, Object>, scala.collection.immutable.Map<String, Object>> tuple2 = this.generateNodeToWeight(conf, preferredNodes);
        if (tuple2 != null) {
            Tuple2 tuple22;
            scala.collection.immutable.Map preferredHostToCount = (scala.collection.immutable.Map)tuple2._1();
            scala.collection.immutable.Map preferredRackToCount = (scala.collection.immutable.Map)tuple2._2();
            this.x$1 = tuple22 = new Tuple2((Object)preferredHostToCount, (Object)preferredRackToCount);
            this.preferredHostToCount = (scala.collection.immutable.Map)this.x$1._1();
            this.preferredRackToCount = (scala.collection.immutable.Map)this.x$1._2();
            this.memoryOverhead = sparkConf.getInt("spark.yarn.executor.memoryOverhead", package$.MODULE$.max((int)(YarnSparkHadoopUtil$.MODULE$.MEMORY_OVERHEAD_FACTOR() * (double)this.executorMemory()), YarnSparkHadoopUtil$.MODULE$.MEMORY_OVERHEAD_MIN()));
            this.org$apache$spark$deploy$yarn$YarnAllocator$$launcherPool = new ThreadPoolExecutor(sparkConf.getInt("spark.yarn.containerLauncherMaxThreads", 25), Integer.MAX_VALUE, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("ContainerLauncher #%d").setDaemon(true).build());
            this.org$apache$spark$deploy$yarn$YarnAllocator$$launcherPool().allowCoreThreadTimeOut(true);
            return;
        }
        throw new MatchError(tuple2);
    }

    public interface YarnAllocateResponse {
        public java.util.List<Container> getAllocatedContainers();

        public Resource getAvailableResources();

        public java.util.List<ContainerStatus> getCompletedContainersStatuses();
    }
}

