/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.util.Records;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.yarn.ClientBase;
import org.apache.spark.deploy.yarn.ClientBase$;
import org.apache.spark.deploy.yarn.ClientDistributedCacheManager;
import org.apache.spark.deploy.yarn.YarnSparkHadoopUtil$;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.sys.package$;

public abstract class ClientBase$class {
    public static void verifyClusterResources(ClientBase $this, GetNewApplicationResponse newAppResponse) {
        int maxMem = newAppResponse.getMaximumResourceCapability().getMemory();
        $this.logInfo((Function0)new Serializable($this, maxMem){
            public static final long serialVersionUID = 0L;
            private final int maxMem$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Verifying our application has not requested more than the maximum ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"memory capability of the cluster (", " MB per container)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.maxMem$1)}))).toString();
            }
            {
                this.maxMem$1 = maxMem$1;
            }
        });
        int executorMem = $this.args().executorMemory() + $this.executorMemoryOverhead();
        if (executorMem > maxMem) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Required executor memory (", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)$this.args().executorMemory())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"+", " MB) is above the max threshold (", " MB) of this cluster!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)$this.executorMemoryOverhead()), BoxesRunTime.boxToInteger((int)maxMem)}))).toString());
        }
        int amMem = $this.args().amMemory() + $this.amMemoryOverhead();
        if (amMem > maxMem) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Required AM memory (", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)$this.args().amMemory())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"+", " MB) is above the max threshold (", " MB) of this cluster!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)$this.amMemoryOverhead()), BoxesRunTime.boxToInteger((int)maxMem)}))).toString());
        }
        $this.logInfo((Function0)new Serializable($this, amMem){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientBase $outer;
            private final int amMem$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Will allocate AM container, with %d MB memory including %d MB overhead")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.amMem$1), BoxesRunTime.boxToInteger((int)this.$outer.amMemoryOverhead())}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.amMem$1 = amMem$1;
            }
        });
    }

    public static Path copyFileToRemote(ClientBase $this, Path destDir, Path srcPath, short replication, boolean setPerms) {
        FileSystem destFs = destDir.getFileSystem($this.hadoopConf());
        FileSystem srcFs = srcPath.getFileSystem($this.hadoopConf());
        ObjectRef destPath = new ObjectRef((Object)srcPath);
        if (ClientBase$.MODULE$.org$apache$spark$deploy$yarn$ClientBase$$compareFs(srcFs, destFs)) {
            $this.logInfo((Function0)new Serializable($this, srcPath){
                public static final long serialVersionUID = 0L;
                private final Path srcPath$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Source and destination file systems are the same. Not copying ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.srcPath$1}));
                }
                {
                    this.srcPath$1 = srcPath$1;
                }
            });
        } else {
            destPath.elem = new Path(destDir, srcPath.getName());
            $this.logInfo((Function0)new Serializable($this, destPath, srcPath){
                public static final long serialVersionUID = 0L;
                private final ObjectRef destPath$1;
                private final Path srcPath$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Uploading resource ", " -> ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.srcPath$1, (Path)this.destPath$1.elem}));
                }
                {
                    this.destPath$1 = destPath$1;
                    this.srcPath$1 = srcPath$1;
                }
            });
            FileUtil.copy((FileSystem)srcFs, (Path)srcPath, (FileSystem)destFs, (Path)((Path)destPath.elem), (boolean)false, (Configuration)$this.hadoopConf());
            destFs.setReplication((Path)destPath.elem, replication);
            if (setPerms) {
                destFs.setPermission((Path)destPath.elem, new FsPermission(ClientBase$.MODULE$.APP_FILE_PERMISSION()));
            }
        }
        Path qualifiedDestPath = destFs.makeQualified((Path)destPath.elem);
        FileContext fc = FileContext.getFileContext((URI)qualifiedDestPath.toUri(), (Configuration)$this.hadoopConf());
        return fc.resolvePath(qualifiedDestPath);
    }

    public static boolean copyFileToRemote$default$4(ClientBase $this) {
        return false;
    }

    public static Path org$apache$spark$deploy$yarn$ClientBase$$getQualifiedLocalPath(ClientBase $this, URI localURI) {
        URI qualifiedURI = localURI.getScheme() == null ? new URI(FileSystem.getLocal((Configuration)$this.hadoopConf()).makeQualified(new Path(localURI)).toString()) : localURI;
        return new Path(qualifiedURI);
    }

    public static HashMap prepareLocalResources(ClientBase $this, String appStagingDir) {
        $this.logInfo((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Preparing resources for our AM container";
            }
        });
        FileSystem fs = FileSystem.get((Configuration)$this.hadoopConf());
        Path dst = new Path(fs.getHomeDirectory(), appStagingDir);
        Set nns = (Set)ClientBase$.MODULE$.getNameNodesToAccess($this.sparkConf()).$plus((Object)dst);
        ClientBase$.MODULE$.obtainTokensForNamenodes((Set<Path>)nns, $this.hadoopConf(), $this.credentials());
        short replication = (short)$this.sparkConf().getInt("spark.yarn.submit.file.replication", (int)fs.getDefaultReplication(dst));
        HashMap localResources = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        FileSystem.mkdirs((FileSystem)fs, (Path)dst, (FsPermission)new FsPermission(ClientBase$.MODULE$.STAGING_DIR_PERMISSION()));
        Map statCache = (Map)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        Option oldLog4jConf = Option$.MODULE$.apply((Object)System.getenv("SPARK_LOG4J_CONF"));
        if (oldLog4jConf.isDefined()) {
            $this.logWarning((Function0)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "SPARK_LOG4J_CONF detected in the system environment. This variable has been deprecated. Please refer to the \"Launching Spark on YARN\" documentation for alternatives.";
                }
            });
        }
        Tuple4[] tuple4Array = new Tuple4[3];
        tuple4Array[0] = new Tuple4((Object)ClientBase$.MODULE$.SPARK_JAR(), (Object)ClientBase$.MODULE$.org$apache$spark$deploy$yarn$ClientBase$$sparkJar($this.sparkConf()), (Object)ClientBase$.MODULE$.CONF_SPARK_JAR(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        tuple4Array[1] = new Tuple4((Object)ClientBase$.MODULE$.APP_JAR(), (Object)$this.args().userJar(), (Object)ClientBase$.MODULE$.CONF_SPARK_USER_JAR(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        tuple4Array[2] = new Tuple4((Object)"log4j.properties", oldLog4jConf.orNull(Predef$.MODULE$.conforms()), null, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple4Array)).foreach((Function1)new Serializable($this, dst, replication, localResources, statCache){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientBase $outer;
            private final Path dst$1;
            private final short replication$1;
            private final HashMap localResources$1;
            private final Map statCache$1;

            public final Object apply(Tuple4<String, String, String, Object> x0$1) {
                Tuple4<String, String, String, Object> tuple4 = x0$1;
                if (tuple4 != null) {
                    Object object;
                    String localPath;
                    String destName = (String)tuple4._1();
                    String _localPath = (String)tuple4._2();
                    String confKey = (String)tuple4._3();
                    boolean setPermissions = BoxesRunTime.unboxToBoolean((Object)tuple4._4());
                    String string = localPath = _localPath == null ? "" : _localPath.trim();
                    if (localPath.isEmpty()) {
                        object = BoxedUnit.UNIT;
                    } else {
                        URI localURI = new URI(localPath);
                        String string2 = localURI.getScheme();
                        String string3 = ClientBase$.MODULE$.LOCAL_SCHEME();
                        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                            object = confKey == null ? BoxedUnit.UNIT : this.$outer.sparkConf().set(confKey, localPath);
                        } else {
                            Path src = ClientBase$class.org$apache$spark$deploy$yarn$ClientBase$$getQualifiedLocalPath(this.$outer, localURI);
                            Path destPath = this.$outer.copyFileToRemote(this.dst$1, src, this.replication$1, setPermissions);
                            FileSystem destFs = FileSystem.get((URI)destPath.toUri(), (Configuration)this.$outer.hadoopConf());
                            this.$outer.org$apache$spark$deploy$yarn$ClientBase$$distCacheMgr().addResource(destFs, this.$outer.hadoopConf(), destPath, (HashMap<String, LocalResource>)this.localResources$1, LocalResourceType.FILE, destName, (Map<URI, FileStatus>)this.statCache$1, this.$outer.org$apache$spark$deploy$yarn$ClientBase$$distCacheMgr().addResource$default$8());
                            object = BoxedUnit.UNIT;
                        }
                    }
                    BoxedUnit boxedUnit = object;
                    return boxedUnit;
                }
                throw new MatchError(tuple4);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.dst$1 = dst$1;
                this.replication$1 = replication$1;
                this.localResources$1 = localResources$1;
                this.statCache$1 = statCache$1;
            }
        });
        ListBuffer cachedSecondaryJarLinks = (ListBuffer)ListBuffer$.MODULE$.empty();
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)$this.args().addJars(), (Object)LocalResourceType.FILE, (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple3((Object)$this.args().files(), (Object)LocalResourceType.FILE, (Object)BoxesRunTime.boxToBoolean((boolean)false)), new Tuple3((Object)$this.args().archives(), (Object)LocalResourceType.ARCHIVE, (Object)BoxesRunTime.boxToBoolean((boolean)false))})).foreach((Function1)new Serializable($this, fs, dst, replication, localResources, statCache, cachedSecondaryJarLinks){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientBase $outer;
            public final FileSystem fs$1;
            public final Path dst$1;
            public final short replication$1;
            public final HashMap localResources$1;
            public final Map statCache$1;
            public final ListBuffer cachedSecondaryJarLinks$1;

            public final void apply(Tuple3<String, LocalResourceType, Object> x0$2) {
                Tuple3<String, LocalResourceType, Object> tuple3 = x0$2;
                if (tuple3 != null) {
                    BoxedUnit boxedUnit;
                    String flist = (String)tuple3._1();
                    LocalResourceType resType = (LocalResourceType)tuple3._2();
                    boolean addToClasspath = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
                    if (flist == null || flist.isEmpty()) {
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(flist)).split(',')).foreach((Function1)new Serializable(this, resType, addToClasspath){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ ClientBase$.anonfun.prepareLocalResources.4 $outer;
                            private final LocalResourceType resType$1;
                            private final boolean addToClasspath$1;

                            public final Object apply(String file) {
                                Object object;
                                URI localURI = new URI(file.trim());
                                String string = localURI.getScheme();
                                String string2 = ClientBase$.MODULE$.LOCAL_SCHEME();
                                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                    object = this.addToClasspath$1 ? this.$outer.cachedSecondaryJarLinks$1.$plus$eq((Object)file.trim()) : BoxedUnit.UNIT;
                                } else {
                                    Path localPath = new Path(localURI);
                                    String linkname = (String)Option$.MODULE$.apply((Object)localURI.getFragment()).getOrElse((Function0)new Serializable(this, localPath){
                                        public static final long serialVersionUID = 0L;
                                        private final Path localPath$1;

                                        public final String apply() {
                                            return this.localPath$1.getName();
                                        }
                                        {
                                            this.localPath$1 = localPath$1;
                                        }
                                    });
                                    Path destPath = this.$outer.org$apache$spark$deploy$yarn$ClientBase$$anonfun$$$outer().copyFileToRemote(this.$outer.dst$1, localPath, this.$outer.replication$1, this.$outer.org$apache$spark$deploy$yarn$ClientBase$$anonfun$$$outer().copyFileToRemote$default$4());
                                    this.$outer.org$apache$spark$deploy$yarn$ClientBase$$anonfun$$$outer().org$apache$spark$deploy$yarn$ClientBase$$distCacheMgr().addResource(this.$outer.fs$1, this.$outer.org$apache$spark$deploy$yarn$ClientBase$$anonfun$$$outer().hadoopConf(), destPath, (HashMap<String, LocalResource>)this.$outer.localResources$1, this.resType$1, linkname, (Map<URI, FileStatus>)this.$outer.statCache$1, this.$outer.org$apache$spark$deploy$yarn$ClientBase$$anonfun$$$outer().org$apache$spark$deploy$yarn$ClientBase$$distCacheMgr().addResource$default$8());
                                    object = this.addToClasspath$1 ? this.$outer.cachedSecondaryJarLinks$1.$plus$eq((Object)linkname) : BoxedUnit.UNIT;
                                }
                                return object;
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.resType$1 = resType$1;
                                this.addToClasspath$1 = addToClasspath$1;
                            }
                        });
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return;
                }
                throw new MatchError(tuple3);
            }

            public /* synthetic */ ClientBase org$apache$spark$deploy$yarn$ClientBase$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.fs$1 = fs$1;
                this.dst$1 = dst$1;
                this.replication$1 = replication$1;
                this.localResources$1 = localResources$1;
                this.statCache$1 = statCache$1;
                this.cachedSecondaryJarLinks$1 = cachedSecondaryJarLinks$1;
            }
        });
        Object object = cachedSecondaryJarLinks.nonEmpty() ? $this.sparkConf().set(ClientBase$.MODULE$.CONF_SPARK_YARN_SECONDARY_JARS(), cachedSecondaryJarLinks.mkString(",")) : BoxedUnit.UNIT;
        return localResources;
    }

    /*
     * WARNING - void declaration
     */
    private static HashMap setupLaunchEnv(ClientBase $this, String stagingDir) {
        void var2_2;
        $this.logInfo((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Setting up the launch environment for our AM container";
            }
        });
        HashMap env = new HashMap();
        Option extraCp = $this.sparkConf().getOption("spark.driver.extraClassPath");
        ClientBase$.MODULE$.populateClasspath($this.args(), (Configuration)$this.yarnConf(), $this.sparkConf(), (HashMap<String, String>)env, (Option<String>)extraCp);
        env.update((Object)"SPARK_YARN_MODE", (Object)"true");
        env.update((Object)"SPARK_YARN_STAGING_DIR", (Object)stagingDir);
        env.update((Object)"SPARK_USER", (Object)UserGroupInformation.getCurrentUser().getShortUserName());
        $this.org$apache$spark$deploy$yarn$ClientBase$$distCacheMgr().setDistFilesEnv((Map<String, String>)env);
        $this.org$apache$spark$deploy$yarn$ClientBase$$distCacheMgr().setDistArchivesEnv((Map<String, String>)env);
        String amEnvPrefix = "spark.yarn.appMasterEnv.";
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])$this.sparkConf().getAll()).filter((Function1)new Serializable($this, amEnvPrefix){
            public static final long serialVersionUID = 0L;
            private final String amEnvPrefix$1;

            public final boolean apply(Tuple2<String, String> x0$3) {
                Tuple2<String, String> tuple2 = x0$3;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    boolean bl = k.startsWith(this.amEnvPrefix$1);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                this.amEnvPrefix$1 = amEnvPrefix$1;
            }
        })).map((Function1)new Serializable($this, amEnvPrefix){
            public static final long serialVersionUID = 0L;
            private final String amEnvPrefix$1;

            public final Tuple2<String, String> apply(Tuple2<String, String> x0$4) {
                Tuple2<String, String> tuple2 = x0$4;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)k.substring(this.amEnvPrefix$1.length()), (Object)v);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                this.amEnvPrefix$1 = amEnvPrefix$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable($this, env){
            public static final long serialVersionUID = 0L;
            private final HashMap env$1;

            public final void apply(Tuple2<String, String> x0$5) {
                Tuple2<String, String> tuple2 = x0$5;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    YarnSparkHadoopUtil$.MODULE$.addPathToEnvironment((HashMap<String, String>)this.env$1, k, v);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.env$1 = env$1;
            }
        });
        package$.MODULE$.env().get((Object)"SPARK_YARN_USER_ENV").foreach((Function1)new Serializable($this, env){
            public static final long serialVersionUID = 0L;
            private final HashMap env$1;

            public final void apply(String userEnvs) {
                YarnSparkHadoopUtil$.MODULE$.setEnvFromInputString((HashMap<String, String>)this.env$1, userEnvs);
                this.env$1.update((Object)"SPARK_YARN_USER_ENV", (Object)userEnvs);
            }
            {
                this.env$1 = env$1;
            }
        });
        if ($this.org$apache$spark$deploy$yarn$ClientBase$$isLaunchingDriver()) {
            package$.MODULE$.env().get((Object)"SPARK_JAVA_OPTS").foreach((Function1)new Serializable($this, env){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientBase $outer;
                private final HashMap env$1;

                public final void apply(String value) {
                    String warning = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n            |SPARK_JAVA_OPTS was detected (set to '", "').\n            |This is deprecated in Spark 1.0+.\n            |\n            |Please instead use:\n            | - ./spark-submit with conf/spark-defaults.conf to set defaults for an application\n            | - ./spark-submit with --driver-java-options to set -X options for a driver\n            | - spark.executor.extraJavaOptions to set -X options for executors\n          "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value})))).stripMargin();
                    this.$outer.logWarning((Function0)new Serializable(this, warning){
                        public static final long serialVersionUID = 0L;
                        private final String warning$1;

                        public final String apply() {
                            return this.warning$1;
                        }
                        {
                            this.warning$1 = warning$1;
                        }
                    });
                    ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"driver", "executor"}))).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ ClientBase$.anonfun.setupLaunchEnv.6 $outer;

                        public final void apply(String proc) {
                            String key = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark.", ".extraJavaOptions"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{proc}));
                            if (this.$outer.org$apache$spark$deploy$yarn$ClientBase$$anonfun$$$outer().sparkConf().contains(key)) {
                                throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found both ", " and SPARK_JAVA_OPTS. Use only the former."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key})));
                            }
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                    this.env$1.update((Object)"SPARK_JAVA_OPTS", (Object)value);
                }

                public /* synthetic */ ClientBase org$apache$spark$deploy$yarn$ClientBase$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.env$1 = env$1;
                }
            });
        }
        return var2_2;
    }

    public static ContainerLaunchContext createContainerLaunchContext(ClientBase $this, GetNewApplicationResponse newAppResponse) {
        BoxedUnit boxedUnit;
        $this.logInfo((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Setting up container launch context for our AM";
            }
        });
        ApplicationId appId = newAppResponse.getApplicationId();
        String appStagingDir = ClientBase$.MODULE$.org$apache$spark$deploy$yarn$ClientBase$$getAppStagingDir(appId);
        HashMap<String, LocalResource> localResources = $this.prepareLocalResources(appStagingDir);
        HashMap launchEnv = ClientBase$class.setupLaunchEnv($this, appStagingDir);
        ContainerLaunchContext amContainer = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
        amContainer.setLocalResources(JavaConversions$.MODULE$.mutableMapAsJavaMap(localResources));
        amContainer.setEnvironment(JavaConversions$.MODULE$.mutableMapAsJavaMap((Map)launchEnv));
        ListBuffer javaOpts = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        None$ prefixEnv = None$.MODULE$;
        javaOpts.$plus$eq((Object)new StringBuilder().append((Object)"-Xmx").append((Object)BoxesRunTime.boxToInteger((int)$this.args().amMemory())).append((Object)"m").toString());
        Path tmpDir = new Path(ApplicationConstants.Environment.PWD.$(), "./tmp");
        javaOpts.$plus$eq((Object)new StringBuilder().append((Object)"-Djava.io.tmpdir=").append((Object)tmpDir).toString());
        boolean useConcurrentAndIncrementalGC = launchEnv.get((Object)"SPARK_USE_CONC_INCR_GC").exists((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$1) {
                return new StringOps(Predef$.MODULE$.augmentString(x$1)).toBoolean();
            }
        });
        if (useConcurrentAndIncrementalGC) {
            javaOpts.$plus$eq((Object)"-XX:+UseConcMarkSweepGC");
            javaOpts.$plus$eq((Object)"-XX:+CMSIncrementalMode");
            javaOpts.$plus$eq((Object)"-XX:+CMSIncrementalPacing");
            javaOpts.$plus$eq((Object)"-XX:CMSIncrementalDutyCycleMin=0");
            boxedUnit = javaOpts.$plus$eq((Object)"-XX:CMSIncrementalDutyCycle=10");
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Predef$.MODULE$.refArrayOps((Object[])$this.sparkConf().getAll()).withFilter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> check$ifrefutable$1) {
                Tuple2<String, String> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable($this, javaOpts){
            public static final long serialVersionUID = 0L;
            private final ListBuffer javaOpts$1;

            public final ListBuffer<String> apply(Tuple2<String, String> x$2) {
                Tuple2<String, String> tuple2 = x$2;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    ListBuffer listBuffer = this.javaOpts$1.$plus$eq((Object)YarnSparkHadoopUtil$.MODULE$.escapeForShell(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-D", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{k, v}))));
                    return listBuffer;
                }
                throw new MatchError(tuple2);
            }
            {
                this.javaOpts$1 = javaOpts$1;
            }
        });
        if ($this.org$apache$spark$deploy$yarn$ClientBase$$isLaunchingDriver()) {
            $this.sparkConf().getOption("spark.driver.extraJavaOptions").orElse((Function0)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final Option<String> apply() {
                    return package$.MODULE$.env().get((Object)"SPARK_JAVA_OPTS");
                }
            }).foreach((Function1)new Serializable($this, javaOpts){
                public static final long serialVersionUID = 0L;
                private final ListBuffer javaOpts$1;

                public final ListBuffer<String> apply(String opts) {
                    return this.javaOpts$1.$plus$eq((Object)opts);
                }
                {
                    this.javaOpts$1 = javaOpts$1;
                }
            });
            Seq libraryPaths = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{package$.MODULE$.props().get("spark.driver.extraLibraryPath"), package$.MODULE$.props().get("spark.driver.libraryPath")})).flatten((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final Iterable<String> apply(Option<String> xo) {
                    return Option$.MODULE$.option2Iterable(xo);
                }
            });
            if (libraryPaths.nonEmpty()) {
                prefixEnv = new Some((Object)Utils$.MODULE$.libraryPathEnvPrefix(libraryPaths));
            }
        }
        javaOpts.$plus$eq((Object)"-Dspark.yarn.app.container.log.dir=<LOG_DIR>");
        Nil$ userClass = $this.org$apache$spark$deploy$yarn$ClientBase$$isLaunchingDriver() ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--class", YarnSparkHadoopUtil$.MODULE$.escapeForShell($this.args().userClass())})) : Nil$.MODULE$;
        Nil$ userJar = $this.args().userJar() == null ? Nil$.MODULE$ : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--jar", $this.args().userJar()}));
        String amClass = $this.org$apache$spark$deploy$yarn$ClientBase$$isLaunchingDriver() ? Class.forName("org.apache.spark.deploy.yarn.ApplicationMaster").getName() : Class.forName("org.apache.spark.deploy.yarn.ExecutorLauncher").getName();
        Seq userArgs = (Seq)$this.args().userArgs().flatMap((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(String arg) {
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--arg", YarnSparkHadoopUtil$.MODULE$.escapeForShell(arg)}));
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq amArgs = (Seq)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{amClass}))).$plus$plus((GenTraversableOnce)userClass, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)userJar, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)userArgs, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--executor-memory", new StringBuilder().append((Object)((Object)BoxesRunTime.boxToInteger((int)$this.args().executorMemory())).toString()).append((Object)"m").toString(), "--executor-cores", ((Object)BoxesRunTime.boxToInteger((int)$this.args().executorCores())).toString(), "--num-executors ", ((Object)BoxesRunTime.boxToInteger((int)$this.args().numExecutors())).toString()})), Seq$.MODULE$.canBuildFrom());
        Iterable commands = (Iterable)((TraversableLike)((TraversableLike)((TraversableLike)Option$.MODULE$.option2Iterable((Option)prefixEnv).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)ApplicationConstants.Environment.JAVA_HOME.$()).append((Object)"/bin/java").toString(), "-server"})), Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)javaOpts, Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)amArgs, Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1>", "<LOG_DIR>/stdout", "2>", "<LOG_DIR>/stderr"})), Iterable$.MODULE$.canBuildFrom());
        List printableCommands = ((TraversableOnce)commands.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(String s) {
                return s == null ? "null" : s;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toList();
        amContainer.setCommands(JavaConversions$.MODULE$.seqAsJavaList((Seq)printableCommands));
        $this.logDebug((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "===============================================================================";
            }
        });
        $this.logDebug((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Yarn AM launch context:";
            }
        });
        $this.logDebug((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientBase $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"    user class: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Option$.MODULE$.apply((Object)this.$outer.args().userClass()).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "N/A";
                    }
                })}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        $this.logDebug((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "    env:";
            }
        });
        launchEnv.foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientBase $outer;

            public final void apply(Tuple2<String, String> x0$6) {
                Tuple2<String, String> tuple2 = x0$6;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    this.$outer.logDebug((Function0)new Serializable(this, k, v){
                        public static final long serialVersionUID = 0L;
                        private final String k$1;
                        private final String v$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"        ", " -> ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.k$1, this.v$1}));
                        }
                        {
                            this.k$1 = k$1;
                            this.v$1 = v$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        $this.logDebug((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "    resources:";
            }
        });
        localResources.foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientBase $outer;

            public final void apply(Tuple2<String, LocalResource> x0$7) {
                Tuple2<String, LocalResource> tuple2 = x0$7;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    LocalResource v = (LocalResource)tuple2._2();
                    this.$outer.logDebug((Function0)new Serializable(this, k, v){
                        public static final long serialVersionUID = 0L;
                        private final String k$2;
                        private final LocalResource v$2;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"        ", " -> ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.k$2, this.v$2}));
                        }
                        {
                            this.k$2 = k$2;
                            this.v$2 = v$2;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        $this.logDebug((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "    command:";
            }
        });
        $this.logDebug((Function0)new Serializable($this, printableCommands){
            public static final long serialVersionUID = 0L;
            private final List printableCommands$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"        ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.printableCommands$1.mkString(" ")}));
            }
            {
                this.printableCommands$1 = printableCommands$1;
            }
        });
        $this.logDebug((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "===============================================================================";
            }
        });
        SecurityManager securityManager = new SecurityManager($this.sparkConf());
        amContainer.setApplicationACLs(JavaConversions$.MODULE$.mapAsJavaMap(YarnSparkHadoopUtil$.MODULE$.getApplicationAclsForYarn(securityManager)));
        $this.setupSecurityToken(amContainer);
        UserGroupInformation.getCurrentUser().addCredentials($this.credentials());
        return amContainer;
    }

    public static Tuple2 monitorApplication(ClientBase $this, ApplicationId appId, boolean returnOnRunning, boolean logApplicationReport) {
        long interval = $this.sparkConf().getLong("spark.yarn.report.interval", 1000L);
        YarnApplicationState lastState = null;
        while (true) {
            YarnApplicationState state;
            ApplicationReport report;
            block11: {
                block10: {
                    Thread.sleep(interval);
                    report = $this.getApplicationReport(appId);
                    state = report.getYarnApplicationState();
                    if (logApplicationReport) {
                        $this.logInfo((Function0)new Serializable($this, state, appId){
                            public static final long serialVersionUID = 0L;
                            private final YarnApplicationState state$1;
                            private final ApplicationId appId$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Application report for ", " (state: ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.appId$1, this.state$1}));
                            }
                            {
                                this.state$1 = state$1;
                                this.appId$1 = appId$1;
                            }
                        });
                        Seq details = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"client token", (Object)$this.getClientToken(report)), new Tuple2((Object)"diagnostics", (Object)report.getDiagnostics()), new Tuple2((Object)"ApplicationMaster host", (Object)report.getHost()), new Tuple2((Object)"ApplicationMaster RPC port", (Object)((Object)BoxesRunTime.boxToInteger((int)report.getRpcPort())).toString()), new Tuple2((Object)"queue", (Object)report.getQueue()), new Tuple2((Object)"start time", (Object)((Object)BoxesRunTime.boxToLong((long)report.getStartTime())).toString()), new Tuple2((Object)"final status", (Object)report.getFinalApplicationStatus().toString()), new Tuple2((Object)"tracking URL", (Object)report.getTrackingUrl()), new Tuple2((Object)"user", (Object)report.getUser())}));
                        String formattedDetails = ((TraversableOnce)details.map((Function1)new Serializable($this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(Tuple2<String, String> x0$8) {
                                Tuple2<String, String> tuple2 = x0$8;
                                if (tuple2 != null) {
                                    String k = (String)tuple2._1();
                                    String v = (String)tuple2._2();
                                    String newValue = (String)Option$.MODULE$.apply((Object)v).filter((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final boolean apply(String x$3) {
                                            return new StringOps(Predef$.MODULE$.augmentString(x$3)).nonEmpty();
                                        }
                                    }).getOrElse((Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "N/A";
                                        }
                                    });
                                    String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n\\t ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{k, newValue}));
                                    return string;
                                }
                                throw new MatchError(tuple2);
                            }
                        }, Seq$.MODULE$.canBuildFrom())).mkString("");
                        if ($this.log().isDebugEnabled()) {
                            $this.logDebug((Function0)new Serializable($this, formattedDetails){
                                public static final long serialVersionUID = 0L;
                                private final String formattedDetails$1;

                                public final String apply() {
                                    return this.formattedDetails$1;
                                }
                                {
                                    this.formattedDetails$1 = formattedDetails$1;
                                }
                            });
                        } else {
                            YarnApplicationState yarnApplicationState = lastState;
                            YarnApplicationState yarnApplicationState2 = state;
                            if (yarnApplicationState == null ? yarnApplicationState2 != null : !yarnApplicationState.equals(yarnApplicationState2)) {
                                $this.logInfo((Function0)new Serializable($this, formattedDetails){
                                    public static final long serialVersionUID = 0L;
                                    private final String formattedDetails$1;

                                    public final String apply() {
                                        return this.formattedDetails$1;
                                    }
                                    {
                                        this.formattedDetails$1 = formattedDetails$1;
                                    }
                                });
                            }
                        }
                    }
                    YarnApplicationState yarnApplicationState = state;
                    YarnApplicationState yarnApplicationState3 = YarnApplicationState.FINISHED;
                    if (!(yarnApplicationState == null ? yarnApplicationState3 != null : !yarnApplicationState.equals(yarnApplicationState3))) break block10;
                    YarnApplicationState yarnApplicationState4 = state;
                    YarnApplicationState yarnApplicationState5 = YarnApplicationState.FAILED;
                    if (!(yarnApplicationState4 == null ? yarnApplicationState5 != null : !yarnApplicationState4.equals(yarnApplicationState5))) break block10;
                    YarnApplicationState yarnApplicationState6 = state;
                    YarnApplicationState yarnApplicationState7 = YarnApplicationState.KILLED;
                    if (yarnApplicationState6 != null ? !yarnApplicationState6.equals(yarnApplicationState7) : yarnApplicationState7 != null) break block11;
                }
                return new Tuple2((Object)state, (Object)report.getFinalApplicationStatus());
            }
            if (returnOnRunning) {
                YarnApplicationState yarnApplicationState = state;
                YarnApplicationState yarnApplicationState8 = YarnApplicationState.RUNNING;
                if (!(yarnApplicationState != null ? !yarnApplicationState.equals(yarnApplicationState8) : yarnApplicationState8 != null)) {
                    return new Tuple2((Object)state, (Object)report.getFinalApplicationStatus());
                }
            }
            lastState = state;
        }
    }

    public static boolean monitorApplication$default$2(ClientBase $this) {
        return false;
    }

    public static boolean monitorApplication$default$3(ClientBase $this) {
        return true;
    }

    public static void run(ClientBase $this) {
        Tuple2<YarnApplicationState, FinalApplicationStatus> tuple2;
        block7: {
            FinalApplicationStatus finalApplicationStatus;
            block11: {
                block10: {
                    YarnApplicationState yarnApplicationState;
                    block9: {
                        block8: {
                            Tuple2 tuple22;
                            tuple2 = $this.monitorApplication($this.submitApplication(), $this.monitorApplication$default$2(), $this.monitorApplication$default$3());
                            if (tuple2 == null) break block7;
                            YarnApplicationState yarnApplicationState2 = (YarnApplicationState)tuple2._1();
                            FinalApplicationStatus finalApplicationStatus2 = (FinalApplicationStatus)tuple2._2();
                            Tuple2 tuple23 = tuple22 = new Tuple2((Object)yarnApplicationState2, (Object)finalApplicationStatus2);
                            yarnApplicationState = (YarnApplicationState)tuple23._1();
                            finalApplicationStatus = (FinalApplicationStatus)tuple23._2();
                            YarnApplicationState yarnApplicationState3 = yarnApplicationState;
                            YarnApplicationState yarnApplicationState4 = YarnApplicationState.FAILED;
                            if (!(yarnApplicationState3 == null ? yarnApplicationState4 != null : !yarnApplicationState3.equals(yarnApplicationState4))) break block8;
                            FinalApplicationStatus finalApplicationStatus3 = finalApplicationStatus;
                            FinalApplicationStatus finalApplicationStatus4 = FinalApplicationStatus.FAILED;
                            if (finalApplicationStatus3 != null ? !finalApplicationStatus3.equals(finalApplicationStatus4) : finalApplicationStatus4 != null) break block9;
                        }
                        throw new SparkException("Application finished with failed status");
                    }
                    YarnApplicationState yarnApplicationState5 = yarnApplicationState;
                    YarnApplicationState yarnApplicationState6 = YarnApplicationState.KILLED;
                    if (!(yarnApplicationState5 == null ? yarnApplicationState6 != null : !yarnApplicationState5.equals(yarnApplicationState6))) break block10;
                    FinalApplicationStatus finalApplicationStatus5 = finalApplicationStatus;
                    FinalApplicationStatus finalApplicationStatus6 = FinalApplicationStatus.KILLED;
                    if (finalApplicationStatus5 != null ? !finalApplicationStatus5.equals(finalApplicationStatus6) : finalApplicationStatus6 != null) break block11;
                }
                throw new SparkException("Application is killed");
            }
            FinalApplicationStatus finalApplicationStatus7 = finalApplicationStatus;
            FinalApplicationStatus finalApplicationStatus8 = FinalApplicationStatus.UNDEFINED;
            if (!(finalApplicationStatus7 != null ? !finalApplicationStatus7.equals(finalApplicationStatus8) : finalApplicationStatus8 != null)) {
                throw new SparkException("The final status of application is undefined");
            }
            return;
        }
        throw new MatchError(tuple2);
    }

    public static void $init$(ClientBase $this) {
        $this.org$apache$spark$deploy$yarn$ClientBase$_setter_$credentials_$eq(UserGroupInformation.getCurrentUser().getCredentials());
        $this.org$apache$spark$deploy$yarn$ClientBase$_setter_$amMemoryOverhead_$eq($this.args().amMemoryOverhead());
        $this.org$apache$spark$deploy$yarn$ClientBase$_setter_$executorMemoryOverhead_$eq($this.args().executorMemoryOverhead());
        $this.org$apache$spark$deploy$yarn$ClientBase$_setter_$org$apache$spark$deploy$yarn$ClientBase$$distCacheMgr_$eq(new ClientDistributedCacheManager());
        $this.org$apache$spark$deploy$yarn$ClientBase$_setter_$org$apache$spark$deploy$yarn$ClientBase$$isLaunchingDriver_$eq($this.args().userClass() != null);
    }
}

