/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.util.StringInterner;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.deploy.history.HistoryServer$;
import org.apache.spark.scheduler.EventLoggingListener;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class YarnSparkHadoopUtil$ {
    public static final YarnSparkHadoopUtil$ MODULE$;

    static {
        new YarnSparkHadoopUtil$();
    }

    public Option<String> addToEnvironment(HashMap<String, String> env, String variable, String value, String classPathSeparator) {
        String envVariable = "";
        Option option = env.get((Object)variable);
        None$ none$ = None$.MODULE$;
        envVariable = !(option != null ? !option.equals(none$) : none$ != null) ? value : new StringBuilder().append((Object)((String)env.get((Object)variable).get())).append((Object)classPathSeparator).append((Object)value).toString();
        return env.put((Object)StringInterner.weakIntern((String)variable), (Object)StringInterner.weakIntern((String)envVariable));
    }

    public void setEnvFromInputString(HashMap<String, String> env, String envString, String classPathSeparator) {
        if (envString != null && envString.length() > 0) {
            String[] childEnvs = envString.split(",");
            ObjectRef p = new ObjectRef((Object)Pattern.compile(this.getEnvironmentVariableRegex()));
            Predef$.MODULE$.refArrayOps((Object[])childEnvs).foreach((Function1)new Serializable(env, classPathSeparator, p){
                public static final long serialVersionUID = 0L;
                private final HashMap env$1;
                private final String classPathSeparator$1;
                private final ObjectRef p$1;

                public final Option<String> apply(String cEnv) {
                    String[] parts = cEnv.split("=");
                    Matcher m = ((Pattern)this.p$1.elem).matcher(parts[1]);
                    StringBuffer sb = new StringBuffer();
                    while (m.find()) {
                        String variable = m.group(1);
                        String replace = "";
                        Option option = this.env$1.get((Object)variable);
                        None$ none$ = None$.MODULE$;
                        if (!(option != null ? !option.equals(none$) : none$ != null)) {
                            replace = System.getenv(variable);
                            if (replace == null) {
                                replace = "";
                            }
                        } else {
                            replace = (String)this.env$1.get((Object)variable).get();
                        }
                        m.appendReplacement(sb, Matcher.quoteReplacement(replace));
                    }
                    m.appendTail(sb);
                    return YarnSparkHadoopUtil$.MODULE$.addToEnvironment((HashMap<String, String>)this.env$1, parts[0], sb.toString(), this.classPathSeparator$1);
                }
                {
                    this.env$1 = env$1;
                    this.classPathSeparator$1 = classPathSeparator$1;
                    this.p$1 = p$1;
                }
            });
        }
    }

    private String getEnvironmentVariableRegex() {
        String osName = System.getProperty("os.name");
        return osName.startsWith("Windows") ? "%([A-Za-z_][A-Za-z0-9_]*?)%" : "\\$([A-Za-z_][A-Za-z0-9_]*)";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getUIHistoryAddress(SparkContext sc, SparkConf conf) {
        String historyServerAddress;
        String string;
        Option option = sc.eventLogger();
        if (option instanceof Some) {
            Some some = (Some)option;
            EventLoggingListener logger = (EventLoggingListener)some.x();
            string = logger.getApplicationLogDir();
        } else {
            None$ none$ = None$.MODULE$;
            Option option2 = option;
            if (none$ == null) {
                if (option2 != null) {
                    throw new MatchError((Object)option);
                }
            } else if (!none$.equals(option2)) throw new MatchError((Object)option);
            string = "";
        }
        String eventLogDir = string;
        String string2 = historyServerAddress = conf.get("spark.yarn.historyServer.address", "");
        String string3 = "";
        if (string2 == null) {
            if (string3 == null) return "";
        } else if (string2.equals(string3)) return "";
        String string4 = eventLogDir;
        String string5 = "";
        if (string4 == null) {
            if (string5 == null) return "";
        } else if (string4.equals(string5)) {
            return "";
        }
        String string6 = new StringBuilder().append((Object)historyServerAddress).append((Object)HistoryServer$.MODULE$.UI_PATH_PREFIX()).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eventLogDir}))).toString();
        return string6;
    }

    public String escapeForShell(String arg) {
        String string;
        if (arg == null) {
            string = arg;
        } else {
            StringBuilder escaped = new StringBuilder("'");
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), arg.length() - 1).foreach((Function1)new Serializable(arg, escaped){
                public static final long serialVersionUID = 0L;
                private final String arg$1;
                private final StringBuilder escaped$1;

                public final StringBuilder apply(int i) {
                    StringBuilder stringBuilder;
                    char c = this.arg$1.charAt(i);
                    switch (c) {
                        default: {
                            stringBuilder = this.escaped$1.append(c);
                            break;
                        }
                        case '\'': {
                            stringBuilder = this.escaped$1.append("'\\''");
                            break;
                        }
                        case '\"': {
                            stringBuilder = this.escaped$1.append("\\\"");
                            break;
                        }
                        case '$': {
                            stringBuilder = this.escaped$1.append("\\$");
                        }
                    }
                    return stringBuilder;
                }
                {
                    this.arg$1 = arg$1;
                    this.escaped$1 = escaped$1;
                }
            });
            string = escaped.append("'").toString();
        }
        return string;
    }

    private YarnSparkHadoopUtil$() {
        MODULE$ = this;
    }
}

