/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import com.google.common.base.Objects;
import java.io.File;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.util.Records;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.yarn.ApplicationMaster;
import org.apache.spark.deploy.yarn.ClientArguments;
import org.apache.spark.deploy.yarn.ClientBase;
import org.apache.spark.deploy.yarn.ClientBase$;
import org.apache.spark.deploy.yarn.ClientDistributedCacheManager;
import org.apache.spark.deploy.yarn.YarnAllocationHandler$;
import org.apache.spark.deploy.yarn.YarnSparkHadoopUtil$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;
import scala.sys.package$;

public abstract class ClientBase$class {
    public static int memoryOverhead(ClientBase $this) {
        return $this.sparkConf().getInt("spark.yarn.driver.memoryOverhead", YarnAllocationHandler$.MODULE$.MEMORY_OVERHEAD());
    }

    /*
     * Unable to fully structure code
     */
    public static void validateArgs(ClientBase $this) {
        v0 = new Tuple2[5];
        if ($this.args().userJar() != null) ** GOTO lbl-1000
        v1 = $this.args().amClass();
        var1_1 = ApplicationMaster.class.getName();
        if (!(v1 != null ? v1.equals(var1_1) == false : var1_1 != null)) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        v0[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToBoolean((boolean)v2)), (Object)"Error: You must specify a user jar when running in standalone mode!");
        v0[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToBoolean((boolean)($this.args().userClass() == null))), (Object)"Error: You must specify a user class!");
        v0[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToBoolean((boolean)($this.args().numExecutors() <= 0))), (Object)"Error: You must specify at least 1 executor!");
        v0[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToBoolean((boolean)($this.args().amMemory() <= $this.memoryOverhead()))), (Object)new StringBuilder().append((Object)"Error: AM memory size must begreater than: ").append((Object)BoxesRunTime.boxToInteger((int)$this.memoryOverhead())).toString());
        v0[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToBoolean((boolean)($this.args().executorMemory() <= $this.memoryOverhead()))), (Object)new StringBuilder().append((Object)"Error: Executor memory sizemust be greater than: ").append((Object)BoxesRunTime.boxToInteger((int)$this.memoryOverhead()).toString()).toString());
        ((IterableLike)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])v0))).foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientBase $outer;

            public final void apply(Tuple2<Object, String> x0$1) {
                Tuple2<Object, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    boolean cond = tuple2._1$mcZ$sp();
                    String errStr = (String)tuple2._2();
                    if (cond) {
                        this.$outer.logError((Function0)new Serializable(this, errStr){
                            public static final long serialVersionUID = 0L;
                            private final String errStr$1;

                            public final String apply() {
                                return this.errStr$1;
                            }
                            {
                                this.errStr$1 = errStr$1;
                            }
                        });
                        throw new IllegalArgumentException(this.$outer.args().getUsageMessage(this.$outer.args().getUsageMessage$default$1()));
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public static String getAppStagingDir(ClientBase $this, ApplicationId appId) {
        return new StringBuilder().append((Object)$this.org$apache$spark$deploy$yarn$ClientBase$$SPARK_STAGING()).append((Object)"/").append((Object)appId.toString()).append((Object)"/").toString();
    }

    public static void verifyClusterResources(ClientBase $this, GetNewApplicationResponse app) {
        int maxMem = app.getMaximumResourceCapability().getMemory();
        $this.logInfo((Function0)new Serializable($this, maxMem){
            public static final long serialVersionUID = 0L;
            private final int maxMem$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Max mem capabililty of a single resource in this cluster ").append((Object)BoxesRunTime.boxToInteger((int)this.maxMem$1)).toString();
            }
            {
                this.maxMem$1 = maxMem$1;
            }
        });
        if ($this.args().executorMemory() > maxMem) {
            String errorMessage = new StringOps(Predef$.MODULE$.augmentString("Required executor memory (%d MB), is above the max threshold (%d MB) of this cluster.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)$this.args().executorMemory()), BoxesRunTime.boxToInteger((int)maxMem)}));
            $this.logError((Function0)new Serializable($this, errorMessage){
                public static final long serialVersionUID = 0L;
                private final String errorMessage$1;

                public final String apply() {
                    return this.errorMessage$1;
                }
                {
                    this.errorMessage$1 = errorMessage$1;
                }
            });
            throw new IllegalArgumentException(errorMessage);
        }
        int amMem = $this.args().amMemory() + $this.memoryOverhead();
        if (amMem > maxMem) {
            String errorMessage = new StringOps(Predef$.MODULE$.augmentString("Required AM memory (%d) is above the max threshold (%d) of this cluster.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)amMem), BoxesRunTime.boxToInteger((int)maxMem)}));
            $this.logError((Function0)new Serializable($this, errorMessage){
                public static final long serialVersionUID = 0L;
                private final String errorMessage$2;

                public final String apply() {
                    return this.errorMessage$2;
                }
                {
                    this.errorMessage$2 = errorMessage$2;
                }
            });
            throw new IllegalArgumentException(errorMessage);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean compareFs(ClientBase $this, FileSystem srcFs, FileSystem destFs) {
        URI srcUri = srcFs.getUri();
        URI dstUri = destFs.getUri();
        if (srcUri.getScheme() == null) return false;
        String string = srcUri.getScheme();
        String string2 = dstUri.getScheme();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String srcHost = srcUri.getHost();
        String dstHost = dstUri.getHost();
        if (srcHost != null && dstHost != null) {
            String string3 = srcHost;
            String string4 = dstHost;
            if (string3 == null ? string4 != null : !string3.equals(string4)) {
                try {
                    srcHost = InetAddress.getByName(srcHost).getCanonicalHostName();
                    dstHost = InetAddress.getByName(dstHost).getCanonicalHostName();
                }
                catch (UnknownHostException unknownHostException) {
                    return false;
                }
            }
        }
        if (!Objects.equal((Object)srcHost, (Object)dstHost)) return false;
        if (srcUri.getPort() != dstUri.getPort()) return false;
        return true;
    }

    public static Path copyRemoteFile(ClientBase $this, Path dstDir, Path originalPath, short replication, boolean setPerms) {
        FileSystem fs = FileSystem.get((Configuration)$this.conf());
        FileSystem remoteFs = originalPath.getFileSystem($this.conf());
        ObjectRef newPath = new ObjectRef((Object)originalPath);
        if (!ClientBase$class.compareFs($this, remoteFs, fs)) {
            newPath.elem = new Path(dstDir, originalPath.getName());
            $this.logInfo((Function0)new Serializable($this, newPath, originalPath){
                public static final long serialVersionUID = 0L;
                private final ObjectRef newPath$1;
                private final Path originalPath$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Uploading ").append((Object)this.originalPath$1).append((Object)" to ").append((Object)((Path)this.newPath$1.elem)).toString();
                }
                {
                    this.newPath$1 = newPath$1;
                    this.originalPath$1 = originalPath$1;
                }
            });
            FileUtil.copy((FileSystem)remoteFs, (Path)originalPath, (FileSystem)fs, (Path)((Path)newPath.elem), (boolean)false, (Configuration)$this.conf());
            fs.setReplication((Path)newPath.elem, replication);
            if (setPerms) {
                fs.setPermission((Path)newPath.elem, new FsPermission($this.APP_FILE_PERMISSION()));
            }
        }
        Path qualPath = fs.makeQualified((Path)newPath.elem);
        FileContext fc = FileContext.getFileContext((URI)qualPath.toUri(), (Configuration)$this.conf());
        Path destPath = fc.resolvePath(qualPath);
        return destPath;
    }

    public static boolean copyRemoteFile$default$4(ClientBase $this) {
        return false;
    }

    public static Path org$apache$spark$deploy$yarn$ClientBase$$qualifyForLocal(ClientBase $this, URI localURI) {
        URI qualifiedURI = localURI;
        if (qualifiedURI.getScheme() == null) {
            qualifiedURI = new URI(FileSystem.getLocal((Configuration)$this.conf()).makeQualified(new Path(qualifiedURI)).toString());
        }
        return new Path(qualifiedURI);
    }

    public static HashMap prepareLocalResources(ClientBase $this, String appStagingDir) {
        $this.logInfo((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Preparing Local resources";
            }
        });
        FileSystem fs = FileSystem.get((Configuration)$this.conf());
        Path dst = new Path(fs.getHomeDirectory(), appStagingDir);
        Set nns = (Set)ClientBase$.MODULE$.getNameNodesToAccess($this.sparkConf()).$plus((Object)dst);
        ClientBase$.MODULE$.obtainTokensForNamenodes((Set<Path>)nns, $this.conf(), $this.credentials());
        short replication = (short)$this.sparkConf().getInt("spark.yarn.submit.file.replication", 3);
        HashMap localResources = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        FileSystem.mkdirs((FileSystem)fs, (Path)dst, (FsPermission)new FsPermission($this.STAGING_DIR_PERMISSION()));
        Map statCache = (Map)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        Option oldLog4jConf = Option$.MODULE$.apply((Object)System.getenv("SPARK_LOG4J_CONF"));
        if (oldLog4jConf.isDefined()) {
            $this.logWarning((Function0)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "SPARK_LOG4J_CONF detected in the system environment. This variable has been deprecated. Please refer to the \"Launching Spark on YARN\" documentation for alternatives.";
                }
            });
        }
        Tuple3[] tuple3Array = new Tuple3[3];
        tuple3Array[0] = new Tuple3((Object)ClientBase$.MODULE$.SPARK_JAR(), (Object)ClientBase$.MODULE$.sparkJar($this.sparkConf()), (Object)ClientBase$.MODULE$.CONF_SPARK_JAR());
        tuple3Array[1] = new Tuple3((Object)ClientBase$.MODULE$.APP_JAR(), (Object)$this.args().userJar(), (Object)ClientBase$.MODULE$.CONF_SPARK_USER_JAR());
        tuple3Array[2] = new Tuple3((Object)"log4j.properties", oldLog4jConf.getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Null$ apply() {
                return null;
            }
        }), null);
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple3Array)).foreach((Function1)new Serializable($this, dst, replication, localResources, statCache){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientBase $outer;
            private final Path dst$1;
            private final short replication$1;
            private final HashMap localResources$1;
            private final Map statCache$1;

            public final Object apply(Tuple3<String, String, String> x0$2) {
                Tuple3<String, String, String> tuple3 = x0$2;
                if (tuple3 != null) {
                    Object object;
                    String localPath;
                    String destName = (String)tuple3._1();
                    String _localPath = (String)tuple3._2();
                    String confKey = (String)tuple3._3();
                    String string = localPath = _localPath == null ? "" : _localPath.trim();
                    if (localPath.isEmpty()) {
                        object = BoxedUnit.UNIT;
                    } else {
                        URI localURI = new URI(localPath);
                        if (ClientBase$.MODULE$.LOCAL_SCHEME().equals(localURI.getScheme())) {
                            object = confKey == null ? BoxedUnit.UNIT : this.$outer.sparkConf().set(confKey, localPath);
                        } else {
                            boolean setPermissions = destName.equals(ClientBase$.MODULE$.APP_JAR());
                            Path destPath = this.$outer.copyRemoteFile(this.dst$1, ClientBase$class.org$apache$spark$deploy$yarn$ClientBase$$qualifyForLocal(this.$outer, localURI), this.replication$1, setPermissions);
                            FileSystem destFs = FileSystem.get((URI)destPath.toUri(), (Configuration)this.$outer.conf());
                            this.$outer.org$apache$spark$deploy$yarn$ClientBase$$distCacheMgr().addResource(destFs, this.$outer.conf(), destPath, (HashMap<String, LocalResource>)this.localResources$1, LocalResourceType.FILE, destName, (Map<URI, FileStatus>)this.statCache$1, this.$outer.org$apache$spark$deploy$yarn$ClientBase$$distCacheMgr().addResource$default$8());
                            object = BoxedUnit.UNIT;
                        }
                    }
                    BoxedUnit boxedUnit = object;
                    return boxedUnit;
                }
                throw new MatchError(tuple3);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.dst$1 = dst$1;
                this.replication$1 = replication$1;
                this.localResources$1 = localResources$1;
                this.statCache$1 = statCache$1;
            }
        });
        ListBuffer cachedSecondaryJarLinks = (ListBuffer)ListBuffer$.MODULE$.empty();
        List fileLists = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)$this.args().addJars(), (Object)LocalResourceType.FILE, (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple3((Object)$this.args().files(), (Object)LocalResourceType.FILE, (Object)BoxesRunTime.boxToBoolean((boolean)false)), new Tuple3((Object)$this.args().archives(), (Object)LocalResourceType.ARCHIVE, (Object)BoxesRunTime.boxToBoolean((boolean)false))}));
        fileLists.foreach((Function1)new Serializable($this, fs, dst, replication, localResources, statCache, cachedSecondaryJarLinks){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientBase $outer;
            public final FileSystem fs$1;
            public final Path dst$1;
            public final short replication$1;
            public final HashMap localResources$1;
            public final Map statCache$1;
            public final ListBuffer cachedSecondaryJarLinks$1;

            public final void apply(Tuple3<String, LocalResourceType, Object> x0$3) {
                Tuple3<String, LocalResourceType, Object> tuple3 = x0$3;
                if (tuple3 != null) {
                    BoxedUnit boxedUnit;
                    String flist = (String)tuple3._1();
                    LocalResourceType resType = (LocalResourceType)tuple3._2();
                    boolean addToClasspath = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
                    if (flist == null || flist.isEmpty()) {
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(flist)).split(',')).foreach((Function1)new Serializable(this, resType, addToClasspath){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ ClientBase$.anonfun.prepareLocalResources.5 $outer;
                            private final LocalResourceType resType$1;
                            private final boolean addToClasspath$1;

                            public final Object apply(String x0$4) {
                                String string = x0$4;
                                if (string != null) {
                                    Object object;
                                    String string2 = string;
                                    URI localURI = new URI(string2.trim());
                                    if (ClientBase$.MODULE$.LOCAL_SCHEME().equals(localURI.getScheme())) {
                                        object = this.addToClasspath$1 ? this.$outer.cachedSecondaryJarLinks$1.$plus$eq((Object)string2.trim()) : BoxedUnit.UNIT;
                                    } else {
                                        Path localPath = new Path(localURI);
                                        String linkname = (String)Option$.MODULE$.apply((Object)localURI.getFragment()).getOrElse((Function0)new Serializable(this, localPath){
                                            public static final long serialVersionUID = 0L;
                                            private final Path localPath$1;

                                            public final String apply() {
                                                return this.localPath$1.getName();
                                            }
                                            {
                                                this.localPath$1 = localPath$1;
                                            }
                                        });
                                        Path destPath = this.$outer.org$apache$spark$deploy$yarn$ClientBase$$anonfun$$$outer().copyRemoteFile(this.$outer.dst$1, localPath, this.$outer.replication$1, this.$outer.org$apache$spark$deploy$yarn$ClientBase$$anonfun$$$outer().copyRemoteFile$default$4());
                                        this.$outer.org$apache$spark$deploy$yarn$ClientBase$$anonfun$$$outer().org$apache$spark$deploy$yarn$ClientBase$$distCacheMgr().addResource(this.$outer.fs$1, this.$outer.org$apache$spark$deploy$yarn$ClientBase$$anonfun$$$outer().conf(), destPath, (HashMap<String, LocalResource>)this.$outer.localResources$1, this.resType$1, linkname, (Map<URI, FileStatus>)this.$outer.statCache$1, this.$outer.org$apache$spark$deploy$yarn$ClientBase$$anonfun$$$outer().org$apache$spark$deploy$yarn$ClientBase$$distCacheMgr().addResource$default$8());
                                        object = this.addToClasspath$1 ? this.$outer.cachedSecondaryJarLinks$1.$plus$eq((Object)linkname) : BoxedUnit.UNIT;
                                    }
                                    BoxedUnit boxedUnit = object;
                                    return boxedUnit;
                                }
                                throw new MatchError((Object)string);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.resType$1 = resType$1;
                                this.addToClasspath$1 = addToClasspath$1;
                            }
                        });
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return;
                }
                throw new MatchError(tuple3);
            }

            public /* synthetic */ ClientBase org$apache$spark$deploy$yarn$ClientBase$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.fs$1 = fs$1;
                this.dst$1 = dst$1;
                this.replication$1 = replication$1;
                this.localResources$1 = localResources$1;
                this.statCache$1 = statCache$1;
                this.cachedSecondaryJarLinks$1 = cachedSecondaryJarLinks$1;
            }
        });
        $this.logInfo((Function0)new Serializable($this, localResources){
            public static final long serialVersionUID = 0L;
            private final HashMap localResources$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Prepared Local resources ").append((Object)this.localResources$1).toString();
            }
            {
                this.localResources$1 = localResources$1;
            }
        });
        $this.sparkConf().set(ClientBase$.MODULE$.CONF_SPARK_YARN_SECONDARY_JARS(), cachedSecondaryJarLinks.mkString(","));
        UserGroupInformation.getCurrentUser().addCredentials($this.credentials());
        return localResources;
    }

    public static Seq getAppMasterEnv(ClientBase $this) {
        String prefix = "spark.yarn.appMasterEnv.";
        return (Seq)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])$this.sparkConf().getAll()).filter((Function1)new Serializable($this, prefix){
            public static final long serialVersionUID = 0L;
            private final String prefix$1;

            public final boolean apply(Tuple2<String, String> x0$5) {
                Tuple2<String, String> tuple2 = x0$5;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    boolean bl = k.startsWith(this.prefix$1);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                this.prefix$1 = prefix$1;
            }
        })).map((Function1)new Serializable($this, prefix){
            public static final long serialVersionUID = 0L;
            private final String prefix$1;

            public final Tuple2<String, String> apply(Tuple2<String, String> x0$6) {
                Tuple2<String, String> tuple2 = x0$6;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)k.substring(this.prefix$1.length()), (Object)v);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                this.prefix$1 = prefix$1;
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    /*
     * WARNING - void declaration
     */
    public static HashMap setupLaunchEnv(ClientBase $this, HashMap localResources, String stagingDir) {
        void var3_3;
        $this.logInfo((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Setting up the launch environment";
            }
        });
        HashMap env = new HashMap();
        Option extraCp = $this.sparkConf().getOption("spark.driver.extraClassPath");
        ClientBase$.MODULE$.populateClasspath($this.args(), (Configuration)$this.yarnConf(), $this.sparkConf(), (HashMap<String, String>)env, (Option<String>)extraCp);
        env.update((Object)"SPARK_YARN_MODE", (Object)"true");
        env.update((Object)"SPARK_YARN_STAGING_DIR", (Object)stagingDir);
        env.update((Object)"SPARK_USER", (Object)UserGroupInformation.getCurrentUser().getShortUserName());
        $this.org$apache$spark$deploy$yarn$ClientBase$$distCacheMgr().setDistFilesEnv((Map<String, String>)env);
        $this.org$apache$spark$deploy$yarn$ClientBase$$distCacheMgr().setDistArchivesEnv((Map<String, String>)env);
        $this.getAppMasterEnv().foreach((Function1)new Serializable($this, env){
            public static final long serialVersionUID = 0L;
            private final HashMap env$1;

            public final Option<String> apply(Tuple2<String, String> x0$7) {
                Tuple2<String, String> tuple2 = x0$7;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    Option<String> option = YarnSparkHadoopUtil$.MODULE$.addToEnvironment((HashMap<String, String>)this.env$1, key, value, File.pathSeparator);
                    return option;
                }
                throw new MatchError(tuple2);
            }
            {
                this.env$1 = env$1;
            }
        });
        package$.MODULE$.env().get((Object)"SPARK_YARN_USER_ENV").foreach((Function1)new Serializable($this, env){
            public static final long serialVersionUID = 0L;
            private final HashMap env$1;

            public final void apply(String userEnvs) {
                YarnSparkHadoopUtil$.MODULE$.setEnvFromInputString((HashMap<String, String>)this.env$1, userEnvs, File.pathSeparator);
                this.env$1.update((Object)"SPARK_YARN_USER_ENV", (Object)userEnvs);
            }
            {
                this.env$1 = env$1;
            }
        });
        return var3_3;
    }

    public static String userArgsToString(ClientBase $this, ClientArguments clientArgs) {
        String prefix = " --arg ";
        Seq<String> args = clientArgs.userArgs();
        StringBuilder retval = new StringBuilder();
        args.foreach((Function1)new Serializable($this, prefix, retval){
            public static final long serialVersionUID = 0L;
            private final String prefix$2;
            private final StringBuilder retval$1;

            public final StringBuilder apply(String arg) {
                return this.retval$1.append(this.prefix$2).append(" ").append(YarnSparkHadoopUtil$.MODULE$.escapeForShell(arg));
            }
            {
                this.prefix$2 = prefix$2;
                this.retval$1 = retval$1;
            }
        });
        return retval.toString();
    }

    public static ContainerLaunchContext createContainerLaunchContext(ClientBase $this, GetNewApplicationResponse newApp, HashMap localResources, HashMap env) {
        BoxedUnit boxedUnit;
        boolean useConcurrentAndIncrementalGC;
        $this.logInfo((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Setting up container launch context";
            }
        });
        ContainerLaunchContext amContainer = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
        amContainer.setLocalResources(JavaConversions$.MODULE$.mutableMapAsJavaMap((Map)localResources));
        String string = $this.args().amClass();
        String string2 = ApplicationMaster.class.getName();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            package$.MODULE$.env().get((Object)"SPARK_JAVA_OPTS").foreach((Function1)new Serializable($this, env){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientBase $outer;
                private final HashMap env$6;

                public final void apply(String value) {
                    String warning = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n            |SPARK_JAVA_OPTS was detected (set to '", "').\n            |This is deprecated in Spark 1.0+.\n            |\n            |Please instead use:\n            | - ./spark-submit with conf/spark-defaults.conf to set defaults for an application\n            | - ./spark-submit with --driver-java-options to set -X options for a driver\n            | - spark.executor.extraJavaOptions to set -X options for executors\n          "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value})))).stripMargin();
                    this.$outer.logWarning((Function0)new Serializable(this, warning){
                        public static final long serialVersionUID = 0L;
                        private final String warning$1;

                        public final String apply() {
                            return this.warning$1;
                        }
                        {
                            this.warning$1 = warning$1;
                        }
                    });
                    ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"driver", "executor"}))).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ ClientBase$.anonfun.createContainerLaunchContext.2 $outer;

                        public final void apply(String proc) {
                            String key = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark.", ".extraJavaOptions"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{proc}));
                            if (this.$outer.org$apache$spark$deploy$yarn$ClientBase$$anonfun$$$outer().sparkConf().contains(key)) {
                                throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found both ", " and SPARK_JAVA_OPTS. Use only the former."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key})));
                            }
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                    this.env$6.update((Object)"SPARK_JAVA_OPTS", (Object)value);
                }

                public /* synthetic */ ClientBase org$apache$spark$deploy$yarn$ClientBase$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.env$6 = env$6;
                }
            });
        }
        amContainer.setEnvironment(JavaConversions$.MODULE$.mutableMapAsJavaMap((Map)env));
        int amMemory = $this.args().amMemory();
        ListBuffer javaOpts = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        javaOpts.$plus$eq((Object)new StringBuilder().append((Object)"-Xmx").append((Object)BoxesRunTime.boxToInteger((int)amMemory)).append((Object)"m").toString());
        Path tmpDir = new Path(ApplicationConstants.Environment.PWD.$(), "./tmp");
        javaOpts.$plus$eq((Object)new StringBuilder().append((Object)"-Djava.io.tmpdir=").append((Object)tmpDir).toString());
        boolean bl = useConcurrentAndIncrementalGC = env.isDefinedAt((Object)"SPARK_USE_CONC_INCR_GC") && Boolean.parseBoolean((String)env.apply((Object)"SPARK_USE_CONC_INCR_GC"));
        if (useConcurrentAndIncrementalGC) {
            javaOpts.$plus$eq((Object)"-XX:+UseConcMarkSweepGC");
            javaOpts.$plus$eq((Object)"-XX:+CMSIncrementalMode");
            javaOpts.$plus$eq((Object)"-XX:+CMSIncrementalPacing");
            javaOpts.$plus$eq((Object)"-XX:CMSIncrementalDutyCycleMin=0");
            boxedUnit = javaOpts.$plus$eq((Object)"-XX:CMSIncrementalDutyCycle=10");
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Predef$.MODULE$.refArrayOps((Object[])$this.sparkConf().getAll()).withFilter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> check$ifrefutable$1) {
                Tuple2<String, String> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable($this, javaOpts){
            public static final long serialVersionUID = 0L;
            private final ListBuffer javaOpts$1;

            public final ListBuffer<String> apply(Tuple2<String, String> x$1) {
                Tuple2<String, String> tuple2 = x$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    ListBuffer listBuffer = this.javaOpts$1.$plus$eq((Object)YarnSparkHadoopUtil$.MODULE$.escapeForShell(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-D", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{k, v}))));
                    return listBuffer;
                }
                throw new MatchError(tuple2);
            }
            {
                this.javaOpts$1 = javaOpts$1;
            }
        });
        String string3 = $this.args().amClass();
        String string4 = ApplicationMaster.class.getName();
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            $this.sparkConf().getOption("spark.driver.extraJavaOptions").orElse((Function0)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final Option<String> apply() {
                    return package$.MODULE$.env().get((Object)"SPARK_JAVA_OPTS");
                }
            }).foreach((Function1)new Serializable($this, javaOpts){
                public static final long serialVersionUID = 0L;
                private final ListBuffer javaOpts$1;

                public final ListBuffer<String> apply(String opts) {
                    return this.javaOpts$1.$plus$eq((Object)opts);
                }
                {
                    this.javaOpts$1 = javaOpts$1;
                }
            });
            $this.sparkConf().getOption("spark.driver.libraryPath").foreach((Function1)new Serializable($this, javaOpts){
                public static final long serialVersionUID = 0L;
                private final ListBuffer javaOpts$1;

                public final ListBuffer<String> apply(String p) {
                    return this.javaOpts$1.$plus$eq((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-Djava.library.path=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{p})));
                }
                {
                    this.javaOpts$1 = javaOpts$1;
                }
            });
        }
        Seq commands = (Seq)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)ApplicationConstants.Environment.JAVA_HOME.$()).append((Object)"/bin/java").toString(), "-server"}))).$plus$plus((GenTraversableOnce)javaOpts, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{$this.args().amClass(), "--class", YarnSparkHadoopUtil$.MODULE$.escapeForShell($this.args().userClass()), "--jar ", YarnSparkHadoopUtil$.MODULE$.escapeForShell($this.args().userJar()), $this.userArgsToString($this.args()), "--executor-memory", ((Object)BoxesRunTime.boxToInteger((int)$this.args().executorMemory())).toString(), "--executor-cores", ((Object)BoxesRunTime.boxToInteger((int)$this.args().executorCores())).toString(), "--num-executors ", ((Object)BoxesRunTime.boxToInteger((int)$this.args().numExecutors())).toString(), "1>", "<LOG_DIR>/stdout", "2>", "<LOG_DIR>/stderr"})), Seq$.MODULE$.canBuildFrom());
        $this.logInfo((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Yarn AM launch context:";
            }
        });
        $this.logInfo((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientBase $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  class:   ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.args().amClass()}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        $this.logInfo((Function0)new Serializable($this, env){
            public static final long serialVersionUID = 0L;
            private final HashMap env$6;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  env:     ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.env$6}));
            }
            {
                this.env$6 = env$6;
            }
        });
        $this.logInfo((Function0)new Serializable($this, commands){
            public static final long serialVersionUID = 0L;
            private final Seq commands$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  command: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.commands$1.mkString(" ")}));
            }
            {
                this.commands$1 = commands$1;
            }
        });
        List printableCommands = ((TraversableOnce)commands.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(String s) {
                return s == null ? "null" : s;
            }
        }, Seq$.MODULE$.canBuildFrom())).toList();
        amContainer.setCommands(JavaConversions$.MODULE$.seqAsJavaList((Seq)printableCommands));
        $this.setupSecurityToken(amContainer);
        SecurityManager securityManager = new SecurityManager($this.sparkConf());
        Map acls = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)ApplicationAccessType.VIEW_APP), (Object)securityManager.getViewAcls()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)ApplicationAccessType.MODIFY_APP), (Object)securityManager.getModifyAcls())}));
        amContainer.setApplicationACLs(JavaConversions$.MODULE$.mutableMapAsJavaMap(acls));
        return amContainer;
    }

    public static void $init$(ClientBase $this) {
        $this.org$apache$spark$deploy$yarn$ClientBase$_setter_$credentials_$eq(UserGroupInformation.getCurrentUser().getCredentials());
        $this.org$apache$spark$deploy$yarn$ClientBase$_setter_$org$apache$spark$deploy$yarn$ClientBase$$SPARK_STAGING_$eq(".sparkStaging");
        $this.org$apache$spark$deploy$yarn$ClientBase$_setter_$org$apache$spark$deploy$yarn$ClientBase$$distCacheMgr_$eq(new ClientDistributedCacheManager());
        $this.org$apache$spark$deploy$yarn$ClientBase$_setter_$STAGING_DIR_PERMISSION_$eq(FsPermission.createImmutable((short)((short)Integer.parseInt("700", 8))));
        $this.org$apache$spark$deploy$yarn$ClientBase$_setter_$APP_FILE_PERMISSION_$eq(FsPermission.createImmutable((short)((short)Integer.parseInt("644", 8))));
    }
}

