/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.io.File;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.Master;
import org.apache.hadoop.mapreduce.MRJobConfig;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.spark.Logging;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext$;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.yarn.ClientArguments;
import org.apache.spark.deploy.yarn.YarnSparkHadoopUtil$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.NonLocalReturnControl;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.Exception$;

public final class ClientBase$
implements Logging {
    public static final ClientBase$ MODULE$;
    private final String SPARK_JAR;
    private final String APP_JAR;
    private final String LOCAL_SCHEME;
    private final String CONF_SPARK_JAR;
    private final String CONF_SPARK_USER_JAR;
    private final String CONF_SPARK_YARN_SECONDARY_JARS;
    private final String ENV_SPARK_JAR;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new ClientBase$();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public String SPARK_JAR() {
        return this.SPARK_JAR;
    }

    public String APP_JAR() {
        return this.APP_JAR;
    }

    public String LOCAL_SCHEME() {
        return this.LOCAL_SCHEME;
    }

    public String CONF_SPARK_JAR() {
        return this.CONF_SPARK_JAR;
    }

    public String CONF_SPARK_USER_JAR() {
        return this.CONF_SPARK_USER_JAR;
    }

    public String CONF_SPARK_YARN_SECONDARY_JARS() {
        return this.CONF_SPARK_YARN_SECONDARY_JARS;
    }

    public String ENV_SPARK_JAR() {
        return this.ENV_SPARK_JAR;
    }

    public String sparkJar(SparkConf conf) {
        String string;
        if (conf.contains(this.CONF_SPARK_JAR())) {
            string = conf.get(this.CONF_SPARK_JAR());
        } else if (System.getenv(this.ENV_SPARK_JAR()) == null) {
            string = (String)Option$.MODULE$.option2Iterable(SparkContext$.MODULE$.jarOfClass(this.getClass())).head();
        } else {
            this.logWarning((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " detected in the system environment. This variable has been deprecated "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ClientBase$.MODULE$.ENV_SPARK_JAR()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"in favor of the ", " configuration variable."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ClientBase$.MODULE$.CONF_SPARK_JAR()}))).toString();
                }
            });
            string = System.getenv(this.ENV_SPARK_JAR());
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public Iterable<Seq<String>> populateHadoopClasspath(Configuration conf, HashMap<String, String> env) {
        void var3_3;
        Iterable classPathElementsToAdd = (Iterable)Option$.MODULE$.option2Iterable(this.getYarnAppClasspath(conf)).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.getMRAppClasspath(conf)), Iterable$.MODULE$.canBuildFrom());
        ((IterableLike)classPathElementsToAdd.flatten((Function1)Predef$.MODULE$.conforms())).foreach((Function1)new Serializable(env){
            public static final long serialVersionUID = 0L;
            private final HashMap env$3;

            public final Option<String> apply(String c) {
                return YarnSparkHadoopUtil$.MODULE$.addToEnvironment((HashMap<String, String>)this.env$3, ApplicationConstants.Environment.CLASSPATH.name(), c.trim(), File.pathSeparator);
            }
            {
                this.env$3 = env$3;
            }
        });
        return var3_3;
    }

    private Option<Seq<String>> getYarnAppClasspath(Configuration conf) {
        Option option;
        block4: {
            Some some;
            block3: {
                block2: {
                    option = Option$.MODULE$.apply((Object)conf.getStrings("yarn.application.classpath"));
                    if (!(option instanceof Some)) break block2;
                    Some some2 = (Some)option;
                    String[] s = (String[])some2.x();
                    some = new Some((Object)Predef$.MODULE$.refArrayOps((Object[])s).toSeq());
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                some = this.getDefaultYarnApplicationClasspath();
            }
            return some;
        }
        throw new MatchError((Object)option);
    }

    private Option<Seq<String>> getMRAppClasspath(Configuration conf) {
        Option option;
        block4: {
            Some some;
            block3: {
                block2: {
                    option = Option$.MODULE$.apply((Object)conf.getStrings("mapreduce.application.classpath"));
                    if (!(option instanceof Some)) break block2;
                    Some some2 = (Some)option;
                    String[] s = (String[])some2.x();
                    some = new Some((Object)Predef$.MODULE$.refArrayOps((Object[])s).toSeq());
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                some = this.getDefaultMRApplicationClasspath();
            }
            return some;
        }
        throw new MatchError((Object)option);
    }

    public Option<Seq<String>> getDefaultYarnApplicationClasspath() {
        Try try_;
        block4: {
            Try triedDefault;
            block3: {
                block2: {
                    triedDefault = Try$.MODULE$.apply((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Seq<String> apply() {
                            Field field = YarnConfiguration.class.getField("DEFAULT_YARN_APPLICATION_CLASSPATH");
                            String[] value = (String[])field.get(null);
                            return Predef$.MODULE$.refArrayOps((Object[])value).toSeq();
                        }
                    }).recoverWith((PartialFunction)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            A1 A1 = x1;
                            Object object = A1 instanceof NoSuchFieldException ? new Success((Object)Seq$.MODULE$.empty()) : function1.apply(x1);
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(Throwable x1) {
                            Throwable throwable = x1;
                            boolean bl = throwable instanceof NoSuchFieldException;
                            return bl;
                        }
                    });
                    try_ = triedDefault;
                    if (!(try_ instanceof Failure)) break block2;
                    Failure failure = (Failure)try_;
                    this.logError((Function0<String>)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Unable to obtain the default YARN Application classpath.";
                        }
                    }, failure.exception());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(try_ instanceof Success)) break block4;
                Success success = (Success)try_;
                this.logDebug((Function0<String>)new Serializable(success){
                    public static final long serialVersionUID = 0L;
                    private final Success x3$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Using the default YARN application classpath: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)this.x3$1.get()).mkString(",")}));
                    }
                    {
                        this.x3$1 = x3$1;
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return triedDefault.toOption();
        }
        throw new MatchError((Object)try_);
    }

    public Option<Seq<String>> getDefaultMRApplicationClasspath() {
        Try try_;
        block4: {
            Try triedDefault;
            block3: {
                block2: {
                    triedDefault = Try$.MODULE$.apply((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Seq<String> apply() {
                            Field field = MRJobConfig.class.getField("DEFAULT_MAPREDUCE_APPLICATION_CLASSPATH");
                            Class<?> clazz = field.getType();
                            Class<String> clazz2 = String.class;
                            String[] value = !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null) ? (String[])Predef$.MODULE$.refArrayOps((Object[])StringUtils.getStrings((String)((String)field.get(null)))).toArray(ClassTag$.MODULE$.apply(String.class)) : (String[])field.get(null);
                            return Predef$.MODULE$.refArrayOps((Object[])value).toSeq();
                        }
                    }).recoverWith((PartialFunction)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                            A1 A1 = x2;
                            Object object = A1 instanceof NoSuchFieldException ? new Success((Object)Seq$.MODULE$.empty()) : function1.apply(x2);
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(Throwable x2) {
                            Throwable throwable = x2;
                            boolean bl = throwable instanceof NoSuchFieldException;
                            return bl;
                        }
                    });
                    try_ = triedDefault;
                    if (!(try_ instanceof Failure)) break block2;
                    Failure failure = (Failure)try_;
                    this.logError((Function0<String>)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Unable to obtain the default MR Application classpath.";
                        }
                    }, failure.exception());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(try_ instanceof Success)) break block4;
                Success success = (Success)try_;
                this.logDebug((Function0<String>)new Serializable(success){
                    public static final long serialVersionUID = 0L;
                    private final Success x3$2;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Using the default MR application classpath: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)this.x3$2.get()).mkString(",")}));
                    }
                    {
                        this.x3$2 = x3$2;
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return triedDefault.toOption();
        }
        throw new MatchError((Object)try_);
    }

    public void populateClasspath(ClientArguments args, Configuration conf, SparkConf sparkConf, HashMap<String, String> env, Option<String> extraClassPath) {
        BoxedUnit boxedUnit;
        extraClassPath.foreach((Function1)new Serializable(env){
            public static final long serialVersionUID = 0L;
            private final HashMap env$2;

            public final Option<String> apply(String x$2) {
                return ClientBase$.MODULE$.org$apache$spark$deploy$yarn$ClientBase$$addClasspathEntry(x$2, (HashMap<String, String>)this.env$2);
            }
            {
                this.env$2 = env$2;
            }
        });
        this.org$apache$spark$deploy$yarn$ClientBase$$addClasspathEntry(ApplicationConstants.Environment.PWD.$(), env);
        if (new StringOps(Predef$.MODULE$.augmentString(sparkConf.get("spark.yarn.user.classpath.first", "false"))).toBoolean()) {
            this.addUserClasspath(args, sparkConf, env);
            this.org$apache$spark$deploy$yarn$ClientBase$$addFileToClasspath(this.sparkJar(sparkConf), this.SPARK_JAR(), env);
            boxedUnit = this.populateHadoopClasspath(conf, env);
        } else {
            this.org$apache$spark$deploy$yarn$ClientBase$$addFileToClasspath(this.sparkJar(sparkConf), this.SPARK_JAR(), env);
            this.populateHadoopClasspath(conf, env);
            this.addUserClasspath(args, sparkConf, env);
            boxedUnit = BoxedUnit.UNIT;
        }
        this.org$apache$spark$deploy$yarn$ClientBase$$addClasspathEntry(new StringBuilder().append((Object)ApplicationConstants.Environment.PWD.$()).append((Object)"/").append((Object)"*").toString(), env);
    }

    public Option<String> populateClasspath$default$5() {
        return None$.MODULE$;
    }

    private void addUserClasspath(ClientArguments args, SparkConf conf, HashMap<String, String> env) {
        if (args == null) {
            String userJar = conf.get(this.CONF_SPARK_USER_JAR(), null);
            this.org$apache$spark$deploy$yarn$ClientBase$$addFileToClasspath(userJar, this.APP_JAR(), env);
            String[] cachedSecondaryJarLinks = conf.get(this.CONF_SPARK_YARN_SECONDARY_JARS(), "").split(",");
            Predef$.MODULE$.refArrayOps((Object[])cachedSecondaryJarLinks).foreach((Function1)new Serializable(env){
                public static final long serialVersionUID = 0L;
                private final HashMap env$4;

                public final void apply(String jar) {
                    ClientBase$.MODULE$.org$apache$spark$deploy$yarn$ClientBase$$addFileToClasspath(jar, null, (HashMap<String, String>)this.env$4);
                }
                {
                    this.env$4 = env$4;
                }
            });
        } else {
            this.org$apache$spark$deploy$yarn$ClientBase$$addFileToClasspath(args.userJar(), this.APP_JAR(), env);
            if (args.addJars() != null) {
                Predef$.MODULE$.refArrayOps((Object[])args.addJars().split(",")).foreach((Function1)new Serializable(env){
                    public static final long serialVersionUID = 0L;
                    private final HashMap env$4;

                    public final void apply(String x0$8) {
                        String string = x0$8;
                        if (string != null) {
                            String string2 = string;
                            ClientBase$.MODULE$.org$apache$spark$deploy$yarn$ClientBase$$addFileToClasspath(string2, null, (HashMap<String, String>)this.env$4);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError((Object)string);
                    }
                    {
                        this.env$4 = env$4;
                    }
                });
            }
        }
    }

    public void org$apache$spark$deploy$yarn$ClientBase$$addFileToClasspath(String path, String fileName, HashMap<String, String> env) {
        NonLocalReturnControl nonLocalReturnControl2;
        block3: {
            Object object = new Object();
            try {
                Object object2 = path == null ? BoxedUnit.UNIT : Exception$.MODULE$.ignoring((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{URISyntaxException.class})).apply((Function0)new Serializable(path, env, object){
                    public static final long serialVersionUID = 0L;
                    private final String path$1;
                    private final HashMap env$5;
                    private final Object nonLocalReturnKey1$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        String localPath = ClientBase$.MODULE$.org$apache$spark$deploy$yarn$ClientBase$$getLocalPath(this.path$1);
                        if (localPath == null) {
                            return;
                        }
                        ClientBase$.MODULE$.org$apache$spark$deploy$yarn$ClientBase$$addClasspathEntry(localPath, (HashMap<String, String>)this.env$5);
                        throw new NonLocalReturnControl.mcV.sp(this.nonLocalReturnKey1$1, BoxedUnit.UNIT);
                    }
                    {
                        this.path$1 = path$1;
                        this.env$5 = env$5;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                if (fileName != null) {
                    this.org$apache$spark$deploy$yarn$ClientBase$$addClasspathEntry(new StringBuilder().append((Object)ApplicationConstants.Environment.PWD.$()).append((Object)"/").append((Object)fileName).toString(), env);
                }
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block3;
                nonLocalReturnControl2.value$mcV$sp();
            }
            return;
        }
        throw nonLocalReturnControl2;
    }

    public String org$apache$spark$deploy$yarn$ClientBase$$getLocalPath(String resource) {
        URI uri = new URI(resource);
        if (this.LOCAL_SCHEME().equals(uri.getScheme())) {
            return uri.getPath();
        }
        return null;
    }

    public Option<String> org$apache$spark$deploy$yarn$ClientBase$$addClasspathEntry(String path, HashMap<String, String> env) {
        return YarnSparkHadoopUtil$.MODULE$.addToEnvironment(env, ApplicationConstants.Environment.CLASSPATH.name(), path, File.pathSeparator);
    }

    public Set<Path> getNameNodesToAccess(SparkConf sparkConf) {
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])sparkConf.get("spark.yarn.access.namenodes", "").split(",")).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$3) {
                return x$3.trim();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$4) {
                return !x$4.isEmpty();
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Path apply(String x$5) {
                return new Path(x$5);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class)))).toSet();
    }

    /*
     * WARNING - void declaration
     */
    public String getTokenRenewer(Configuration conf) {
        void var2_2;
        String delegTokenRenewer = Master.getMasterPrincipal((Configuration)conf);
        this.logDebug((Function0<String>)new Serializable(delegTokenRenewer){
            public static final long serialVersionUID = 0L;
            private final String delegTokenRenewer$1;

            public final String apply() {
                return new StringBuilder().append((Object)"delegation token renewer is: ").append((Object)this.delegTokenRenewer$1).toString();
            }
            {
                this.delegTokenRenewer$1 = delegTokenRenewer$1;
            }
        });
        if (delegTokenRenewer == null || delegTokenRenewer.length() == 0) {
            String errorMessage = "Can't get Master Kerberos principal for use as renewer";
            this.logError((Function0<String>)new Serializable(errorMessage){
                public static final long serialVersionUID = 0L;
                private final String errorMessage$3;

                public final String apply() {
                    return this.errorMessage$3;
                }
                {
                    this.errorMessage$3 = errorMessage$3;
                }
            });
            throw new SparkException(errorMessage);
        }
        return var2_2;
    }

    public void obtainTokensForNamenodes(Set<Path> paths, Configuration conf, Credentials creds) {
        if (UserGroupInformation.isSecurityEnabled()) {
            String delegTokenRenewer = this.getTokenRenewer(conf);
            paths.foreach((Function1)new Serializable(conf, creds, delegTokenRenewer){
                public static final long serialVersionUID = 0L;
                private final Configuration conf$1;
                private final Credentials creds$1;
                private final String delegTokenRenewer$2;

                public final Token<?>[] apply(Path dst) {
                    FileSystem dstFs = dst.getFileSystem(this.conf$1);
                    ClientBase$.MODULE$.logDebug((Function0<String>)new Serializable(this, dst){
                        public static final long serialVersionUID = 0L;
                        private final Path dst$2;

                        public final String apply() {
                            return new StringBuilder().append((Object)"getting token for namenode: ").append((Object)this.dst$2).toString();
                        }
                        {
                            this.dst$2 = dst$2;
                        }
                    });
                    return dstFs.addDelegationTokens(this.delegTokenRenewer$2, this.creds$1);
                }
                {
                    this.conf$1 = conf$1;
                    this.creds$1 = creds$1;
                    this.delegTokenRenewer$2 = delegTokenRenewer$2;
                }
            });
        }
    }

    private ClientBase$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.SPARK_JAR = "__spark__.jar";
        this.APP_JAR = "__app__.jar";
        this.LOCAL_SCHEME = "local";
        this.CONF_SPARK_JAR = "spark.yarn.jar";
        this.CONF_SPARK_USER_JAR = "spark.yarn.user.jar";
        this.CONF_SPARK_YARN_SECONDARY_JARS = "spark.yarn.secondary.jars";
        this.ENV_SPARK_JAR = "SPARK_JAR";
    }
}

