/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.YarnClusterMetrics;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.client.api.YarnClientApplication;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.util.Records;
import org.apache.spark.Logging;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.yarn.Client$;
import org.apache.spark.deploy.yarn.ClientArguments;
import org.apache.spark.deploy.yarn.ClientBase;
import org.apache.spark.deploy.yarn.ClientBase$class;
import org.apache.spark.deploy.yarn.ClientDistributedCacheManager;
import org.slf4j.Logger;
import scala.Function0;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ud\u0001B\u0001\u0003\u00015\u0011aa\u00117jK:$(BA\u0002\u0005\u0003\u0011I\u0018M\u001d8\u000b\u0005\u00151\u0011A\u00023fa2|\u0017P\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\b\u00151A\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\u0004\"!\u0006\f\u000e\u0003\tI!a\u0006\u0002\u0003\u0015\rc\u0017.\u001a8u\u0005\u0006\u001cX\r\u0005\u0002\u001a55\ta!\u0003\u0002\u001c\r\t9Aj\\4hS:<\u0007\u0002C\u000f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0010\u0002\u0015\rd\u0017.\u001a8u\u0003J<7\u000f\u0005\u0002\u0016?%\u0011\u0001E\u0001\u0002\u0010\u00072LWM\u001c;Be\u001e,X.\u001a8ug\"A!\u0005\u0001B\u0001B\u0003%1%\u0001\u0006iC\u0012|w\u000e]\"p]\u001a\u0004\"\u0001J\u0015\u000e\u0003\u0015R!AJ\u0014\u0002\t\r|gN\u001a\u0006\u0003Q!\ta\u0001[1e_>\u0004\u0018B\u0001\u0016&\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\"AA\u0006\u0001B\u0001B\u0003%Q&\u0001\u0004ta\u000e{gN\u001a\t\u000339J!a\f\u0004\u0003\u0013M\u0003\u0018M]6D_:4\u0007\"B\u0019\u0001\t\u0003\u0011\u0014A\u0002\u001fj]&$h\b\u0006\u00034iU2\u0004CA\u000b\u0001\u0011\u0015i\u0002\u00071\u0001\u001f\u0011\u0015\u0011\u0003\u00071\u0001$\u0011\u0015a\u0003\u00071\u0001.\u0011\u001dA\u0004A1A\u0005\u0002e\n!\"_1s]\u000ec\u0017.\u001a8u+\u0005Q\u0004CA\u001eB\u001b\u0005a$BA\u001f?\u0003\r\t\u0007/\u001b\u0006\u0003\u007f\u0001\u000baa\u00197jK:$(BA\u0002(\u0013\t\u0011EH\u0001\u0006ZCJt7\t\\5f]RDa\u0001\u0012\u0001!\u0002\u0013Q\u0014aC=be:\u001cE.[3oi\u0002BQ!\r\u0001\u0005\u0002\u0019#2aM$I\u0011\u0015iR\t1\u0001\u001f\u0011\u0015aS\t1\u0001.\u0011\u0015\t\u0004\u0001\"\u0001K)\t\u00194\nC\u0003\u001e\u0013\u0002\u0007a\u0004C\u0004N\u0001\t\u0007I\u0011\u0001(\u0002\t\u0005\u0014xm]\u000b\u0002=!1\u0001\u000b\u0001Q\u0001\ny\tQ!\u0019:hg\u0002BqA\n\u0001C\u0002\u0013\u0005!+F\u0001$\u0011\u0019!\u0006\u0001)A\u0005G\u0005)1m\u001c8gA!9a\u000b\u0001b\u0001\n\u00039\u0016!C:qCJ\\7i\u001c8g+\u0005i\u0003BB-\u0001A\u0003%Q&\u0001\u0006ta\u0006\u00148nQ8oM\u0002Bqa\u0017\u0001A\u0002\u0013\u0005A,A\u0002sa\u000e,\u0012!\u0018\t\u0003=\u0006l\u0011a\u0018\u0006\u0003A\u0002\u000b1!\u001b9d\u0013\t\u0011wLA\u0004ZCJt'\u000bU\"\t\u000f\u0011\u0004\u0001\u0019!C\u0001K\u00069!\u000f]2`I\u0015\fHC\u00014j!\tyq-\u0003\u0002i!\t!QK\\5u\u0011\u001dQ7-!AA\u0002u\u000b1\u0001\u001f\u00132\u0011\u0019a\u0007\u0001)Q\u0005;\u0006!!\u000f]2!\u0011\u001dq\u0007A1A\u0005\u0002=\f\u0001\"_1s]\u000e{gNZ\u000b\u0002aB\u0011\u0011o]\u0007\u0002e*\u0011a\u0005Q\u0005\u0003iJ\u0014\u0011#W1s]\u000e{gNZ5hkJ\fG/[8o\u0011\u00191\b\u0001)A\u0005a\u0006I\u00110\u0019:o\u0007>tg\r\t\u0005\u0006q\u0002!\t!_\u0001\u0007eVt\u0017\t\u001d9\u0015\u0003i\u0004\"a_@\u000e\u0003qT!! @\u0002\u000fI,7m\u001c:eg*\u0011Q\bQ\u0005\u0004\u0003\u0003a(!D!qa2L7-\u0019;j_:LE\rC\u0004\u0002\u0006\u0001!\t!a\u0002\u0002\u0007I,h\u000eF\u0001g\u0011\u001d\tY\u0001\u0001C\u0001\u0003\u000f\t\u0011\u0004\\8h\u00072,8\u000f^3s%\u0016\u001cx.\u001e:dK\u0012+G/Y5mg\"9\u0011q\u0002\u0001\u0005\u0002\u0005E\u0011AE:fiV\u00048+Z2ve&$\u0018\u0010V8lK:$2AZA\n\u0011!\t)\"!\u0004A\u0002\u0005]\u0011aC1n\u0007>tG/Y5oKJ\u00042a_A\r\u0013\r\tY\u0002 \u0002\u0017\u0007>tG/Y5oKJd\u0015-\u001e8dQ\u000e{g\u000e^3yi\"9\u0011q\u0004\u0001\u0005\u0002\u0005\u0005\u0012!C:vE6LG/\u00119q)\rQ\u00181\u0005\u0005\t\u0003K\ti\u00021\u0001\u0002(\u0005Q\u0011\r\u001d9D_:$X\r\u001f;\u0011\u0007m\fI#C\u0002\u0002,q\u0014A$\u00119qY&\u001c\u0017\r^5p]N+(-\\5tg&|gnQ8oi\u0016DH\u000fC\u0004\u00020\u0001!\t!!\r\u0002)\u001d,G/\u00119qY&\u001c\u0017\r^5p]J+\u0007o\u001c:u)\u0011\t\u0019$!\u000f\u0011\u0007m\f)$C\u0002\u00028q\u0014\u0011#\u00119qY&\u001c\u0017\r^5p]J+\u0007o\u001c:u\u0011\u001d\tY$!\fA\u0002i\fQ!\u00199q\u0013\u0012Dq!a\u0010\u0001\t\u0003\t\t%\u0001\u0003ti>\u0004X#\u00014\t\u000f\u0005\u0015\u0003\u0001\"\u0001\u0002H\u0005\u0011Rn\u001c8ji>\u0014\u0018\t\u001d9mS\u000e\fG/[8o)\u0011\tI%a\u0014\u0011\u0007=\tY%C\u0002\u0002NA\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002<\u0005\r\u0003\u0019\u0001>\b\u000f\u0005M#\u0001#\u0001\u0002V\u000511\t\\5f]R\u00042!FA,\r\u0019\t!\u0001#\u0001\u0002ZM\u0019\u0011q\u000b\b\t\u000fE\n9\u0006\"\u0001\u0002^Q\u0011\u0011Q\u000b\u0005\t\u0003C\n9\u0006\"\u0001\u0002d\u0005!Q.Y5o)\r1\u0017Q\r\u0005\t\u0003O\ny\u00061\u0001\u0002j\u0005Q\u0011M]4TiJLgnZ:\u0011\u000b=\tY'a\u001c\n\u0007\u00055\u0004CA\u0003BeJ\f\u0017\u0010\u0005\u0003\u0002r\u0005]dbA\b\u0002t%\u0019\u0011Q\u000f\t\u0002\rA\u0013X\rZ3g\u0013\u0011\tI(a\u001f\u0003\rM#(/\u001b8h\u0015\r\t)\b\u0005")
public class Client
implements ClientBase {
    private final YarnClient yarnClient;
    private final ClientArguments args;
    private final Configuration conf;
    private final SparkConf sparkConf;
    private YarnRPC rpc;
    private final YarnConfiguration yarnConf;
    private final Credentials credentials;
    private final String org$apache$spark$deploy$yarn$ClientBase$$SPARK_STAGING;
    private final ClientDistributedCacheManager org$apache$spark$deploy$yarn$ClientBase$$distCacheMgr;
    private final FsPermission STAGING_DIR_PERMISSION;
    private final FsPermission APP_FILE_PERMISSION;
    private transient Logger org$apache$spark$Logging$$log_;

    public static void main(String[] stringArray) {
        Client$.MODULE$.main(stringArray);
    }

    @Override
    public Credentials credentials() {
        return this.credentials;
    }

    @Override
    public String org$apache$spark$deploy$yarn$ClientBase$$SPARK_STAGING() {
        return this.org$apache$spark$deploy$yarn$ClientBase$$SPARK_STAGING;
    }

    @Override
    public ClientDistributedCacheManager org$apache$spark$deploy$yarn$ClientBase$$distCacheMgr() {
        return this.org$apache$spark$deploy$yarn$ClientBase$$distCacheMgr;
    }

    @Override
    public FsPermission STAGING_DIR_PERMISSION() {
        return this.STAGING_DIR_PERMISSION;
    }

    @Override
    public FsPermission APP_FILE_PERMISSION() {
        return this.APP_FILE_PERMISSION;
    }

    @Override
    public void org$apache$spark$deploy$yarn$ClientBase$_setter_$credentials_$eq(Credentials x$1) {
        this.credentials = x$1;
    }

    @Override
    public void org$apache$spark$deploy$yarn$ClientBase$_setter_$org$apache$spark$deploy$yarn$ClientBase$$SPARK_STAGING_$eq(String x$1) {
        this.org$apache$spark$deploy$yarn$ClientBase$$SPARK_STAGING = x$1;
    }

    @Override
    public void org$apache$spark$deploy$yarn$ClientBase$_setter_$org$apache$spark$deploy$yarn$ClientBase$$distCacheMgr_$eq(ClientDistributedCacheManager x$1) {
        this.org$apache$spark$deploy$yarn$ClientBase$$distCacheMgr = x$1;
    }

    @Override
    public void org$apache$spark$deploy$yarn$ClientBase$_setter_$STAGING_DIR_PERMISSION_$eq(FsPermission x$1) {
        this.STAGING_DIR_PERMISSION = x$1;
    }

    @Override
    public void org$apache$spark$deploy$yarn$ClientBase$_setter_$APP_FILE_PERMISSION_$eq(FsPermission x$1) {
        this.APP_FILE_PERMISSION = x$1;
    }

    @Override
    public int memoryOverhead() {
        return ClientBase$class.memoryOverhead(this);
    }

    @Override
    public void validateArgs() {
        ClientBase$class.validateArgs(this);
    }

    @Override
    public String getAppStagingDir(ApplicationId appId) {
        return ClientBase$class.getAppStagingDir(this, appId);
    }

    @Override
    public void verifyClusterResources(GetNewApplicationResponse app) {
        ClientBase$class.verifyClusterResources(this, app);
    }

    @Override
    public Path copyRemoteFile(Path dstDir, Path originalPath, short replication, boolean setPerms) {
        return ClientBase$class.copyRemoteFile(this, dstDir, originalPath, replication, setPerms);
    }

    @Override
    public HashMap<String, LocalResource> prepareLocalResources(String appStagingDir) {
        return ClientBase$class.prepareLocalResources(this, appStagingDir);
    }

    @Override
    public Seq<Tuple2<String, String>> getAppMasterEnv() {
        return ClientBase$class.getAppMasterEnv(this);
    }

    @Override
    public HashMap<String, String> setupLaunchEnv(HashMap<String, LocalResource> localResources, String stagingDir) {
        return ClientBase$class.setupLaunchEnv(this, localResources, stagingDir);
    }

    @Override
    public String userArgsToString(ClientArguments clientArgs) {
        return ClientBase$class.userArgsToString(this, clientArgs);
    }

    @Override
    public ContainerLaunchContext createContainerLaunchContext(GetNewApplicationResponse newApp, HashMap<String, LocalResource> localResources, HashMap<String, String> env) {
        return ClientBase$class.createContainerLaunchContext(this, newApp, localResources, env);
    }

    @Override
    public boolean copyRemoteFile$default$4() {
        return ClientBase$class.copyRemoteFile$default$4(this);
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public YarnClient yarnClient() {
        return this.yarnClient;
    }

    @Override
    public ClientArguments args() {
        return this.args;
    }

    @Override
    public Configuration conf() {
        return this.conf;
    }

    @Override
    public SparkConf sparkConf() {
        return this.sparkConf;
    }

    public YarnRPC rpc() {
        return this.rpc;
    }

    public void rpc_$eq(YarnRPC x$1) {
        this.rpc = x$1;
    }

    @Override
    public YarnConfiguration yarnConf() {
        return this.yarnConf;
    }

    /*
     * WARNING - void declaration
     */
    public ApplicationId runApp() {
        void var3_3;
        this.validateArgs();
        this.yarnClient().init((Configuration)this.yarnConf());
        this.yarnClient().start();
        this.logClusterResourceDetails();
        YarnClientApplication newApp = this.yarnClient().createApplication();
        GetNewApplicationResponse newAppResponse = newApp.getNewApplicationResponse();
        ApplicationId appId = newAppResponse.getApplicationId();
        this.verifyClusterResources(newAppResponse);
        String appStagingDir = this.getAppStagingDir(appId);
        HashMap<String, LocalResource> localResources = this.prepareLocalResources(appStagingDir);
        HashMap<String, String> launchEnv = this.setupLaunchEnv(localResources, appStagingDir);
        ContainerLaunchContext amContainer = this.createContainerLaunchContext(newAppResponse, localResources, launchEnv);
        ApplicationSubmissionContext appContext = newApp.getApplicationSubmissionContext();
        appContext.setApplicationName(this.args().appName());
        appContext.setQueue(this.args().amQueue());
        appContext.setAMContainerSpec(amContainer);
        appContext.setApplicationType("SPARK");
        Resource memoryResource = (Resource)Records.newRecord(Resource.class);
        memoryResource.setMemory(this.args().amMemory() + this.memoryOverhead());
        appContext.setResource(memoryResource);
        this.submitApp(appContext);
        return var3_3;
    }

    public void run() {
        ApplicationId appId = this.runApp();
        if (this.monitorApplication(appId)) {
            return;
        }
        throw new SparkException("Application is not successful");
    }

    public void logClusterResourceDetails() {
        YarnClusterMetrics clusterMetrics = this.yarnClient().getYarnClusterMetrics();
        this.logInfo((Function0<String>)new Serializable(this, clusterMetrics){
            public static final long serialVersionUID = 0L;
            private final YarnClusterMetrics clusterMetrics$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Got cluster metric info from ResourceManager, number of NodeManagers: ").append((Object)BoxesRunTime.boxToInteger((int)this.clusterMetrics$1.getNumNodeManagers())).toString();
            }
            {
                this.clusterMetrics$1 = clusterMetrics$1;
            }
        });
    }

    @Override
    public void setupSecurityToken(ContainerLaunchContext amContainer) {
        DataOutputBuffer dob = new DataOutputBuffer();
        this.credentials().writeTokenStorageToStream((DataOutputStream)dob);
        amContainer.setTokens(ByteBuffer.wrap(dob.getData()));
    }

    public ApplicationId submitApp(ApplicationSubmissionContext appContext) {
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Submitting application to ResourceManager";
            }
        });
        return this.yarnClient().submitApplication(appContext);
    }

    public ApplicationReport getApplicationReport(ApplicationId appId) {
        return this.yarnClient().getApplicationReport(appId);
    }

    public void stop() {
        this.yarnClient().stop();
    }

    public boolean monitorApplication(ApplicationId appId) {
        YarnApplicationState yarnApplicationState;
        YarnApplicationState yarnApplicationState2;
        long interval = this.sparkConf().getLong("spark.yarn.report.interval", 1000L);
        do {
            YarnApplicationState state;
            Thread.sleep(interval);
            ApplicationReport report = this.yarnClient().getApplicationReport(appId);
            this.logInfo((Function0<String>)new Serializable(this, appId, report){
                public static final long serialVersionUID = 0L;
                private final ApplicationId appId$1;
                private final ApplicationReport report$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Application report from ResourceManager: \n\t application identifier: ").append((Object)this.appId$1.toString()).append((Object)"\n").append((Object)"\t appId: ").append((Object)BoxesRunTime.boxToInteger((int)this.appId$1.getId())).append((Object)"\n").append((Object)"\t clientToAMToken: ").append((Object)this.report$1.getClientToAMToken()).append((Object)"\n").append((Object)"\t appDiagnostics: ").append((Object)this.report$1.getDiagnostics()).append((Object)"\n").append((Object)"\t appMasterHost: ").append((Object)this.report$1.getHost()).append((Object)"\n").append((Object)"\t appQueue: ").append((Object)this.report$1.getQueue()).append((Object)"\n").append((Object)"\t appMasterRpcPort: ").append((Object)BoxesRunTime.boxToInteger((int)this.report$1.getRpcPort())).append((Object)"\n").append((Object)"\t appStartTime: ").append((Object)BoxesRunTime.boxToLong((long)this.report$1.getStartTime())).append((Object)"\n").append((Object)"\t yarnAppState: ").append((Object)this.report$1.getYarnApplicationState()).append((Object)"\n").append((Object)"\t distributedFinalState: ").append((Object)this.report$1.getFinalApplicationStatus()).append((Object)"\n").append((Object)"\t appTrackingUrl: ").append((Object)this.report$1.getTrackingUrl()).append((Object)"\n").append((Object)"\t appUser: ").append((Object)this.report$1.getUser()).toString();
                }
                {
                    this.appId$1 = appId$1;
                    this.report$1 = report$1;
                }
            });
            YarnApplicationState yarnApplicationState3 = state = report.getYarnApplicationState();
            YarnApplicationState yarnApplicationState4 = YarnApplicationState.FINISHED;
            if (!(yarnApplicationState3 != null ? !yarnApplicationState3.equals(yarnApplicationState4) : yarnApplicationState4 != null)) {
                FinalApplicationStatus finalApplicationStatus = report.getFinalApplicationStatus();
                FinalApplicationStatus finalApplicationStatus2 = FinalApplicationStatus.SUCCEEDED;
                return !(finalApplicationStatus != null ? !finalApplicationStatus.equals(finalApplicationStatus2) : finalApplicationStatus2 != null);
            }
            YarnApplicationState yarnApplicationState5 = state;
            YarnApplicationState yarnApplicationState6 = YarnApplicationState.FAILED;
            if (!(yarnApplicationState5 == null ? yarnApplicationState6 != null : !yarnApplicationState5.equals(yarnApplicationState6))) break;
            yarnApplicationState2 = state;
            yarnApplicationState = YarnApplicationState.KILLED;
        } while (yarnApplicationState2 != null ? !yarnApplicationState2.equals(yarnApplicationState) : yarnApplicationState != null);
        return false;
    }

    public Client(ClientArguments clientArgs, Configuration hadoopConf, SparkConf spConf) {
        Logging.class.$init$((Logging)this);
        ClientBase$class.$init$(this);
        this.yarnClient = YarnClient.createYarnClient();
        this.args = clientArgs;
        this.conf = hadoopConf;
        this.sparkConf = spConf;
        this.rpc = YarnRPC.create((Configuration)this.conf());
        this.yarnConf = new YarnConfiguration(this.conf());
    }

    public Client(ClientArguments clientArgs, SparkConf spConf) {
        this(clientArgs, new Configuration(), spConf);
    }

    public Client(ClientArguments clientArgs) {
        this(clientArgs, new SparkConf());
    }
}

