/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster;

import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.yarn.Client;
import org.apache.spark.deploy.yarn.ClientArguments;
import org.apache.spark.deploy.yarn.ExecutorLauncher;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001M4Q!\u0001\u0002\u0001\r1\u0011!$W1s]\u000ec\u0017.\u001a8u'\u000eDW\rZ;mKJ\u0014\u0015mY6f]\u0012T!a\u0001\u0003\u0002\u000f\rdWo\u001d;fe*\u0011QAB\u0001\ng\u000eDW\rZ;mKJT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\n\u0004\u00015\t\u0002C\u0001\b\u0010\u001b\u0005\u0011\u0011B\u0001\t\u0003\u0005u\u0019u.\u0019:tK\u001e\u0013\u0018-\u001b8fIN\u001b\u0007.\u001a3vY\u0016\u0014()Y2lK:$\u0007C\u0001\n\u0014\u001b\u00051\u0011B\u0001\u000b\u0007\u0005\u001daunZ4j]\u001eD\u0001\"\u0002\u0001\u0003\u0002\u0003\u0006IaF\u0002\u0001!\tA\u0012$D\u0001\u0005\u0013\tQBAA\tUCN\\7k\u00195fIVdWM]%na2D\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006I!H\u0001\u0003g\u000e\u0004\"A\u0005\u0010\n\u0005}1!\u0001D*qCJ\\7i\u001c8uKb$\b\"B\u0011\u0001\t\u0003\u0011\u0013A\u0002\u001fj]&$h\bF\u0002$I\u0015\u0002\"A\u0004\u0001\t\u000b\u0015\u0001\u0003\u0019A\f\t\u000bq\u0001\u0003\u0019A\u000f\t\u000f\u001d\u0002\u0001\u0019!C\u0001Q\u000511\r\\5f]R,\u0012!\u000b\t\u0003U=j\u0011a\u000b\u0006\u0003Y5\nA!_1s]*\u0011aFB\u0001\u0007I\u0016\u0004Hn\\=\n\u0005AZ#AB\"mS\u0016tG\u000fC\u00043\u0001\u0001\u0007I\u0011A\u001a\u0002\u0015\rd\u0017.\u001a8u?\u0012*\u0017\u000f\u0006\u00025uA\u0011Q\u0007O\u0007\u0002m)\tq'A\u0003tG\u0006d\u0017-\u0003\u0002:m\t!QK\\5u\u0011\u001dY\u0014'!AA\u0002%\n1\u0001\u001f\u00132\u0011\u0019i\u0004\u0001)Q\u0005S\u000591\r\\5f]R\u0004\u0003bB \u0001\u0001\u0004%\t\u0001Q\u0001\u0006CB\u0004\u0018\nZ\u000b\u0002\u0003B\u0011!IS\u0007\u0002\u0007*\u0011A)R\u0001\be\u0016\u001cwN\u001d3t\u0015\t1u)A\u0002ba&T!\u0001\f%\u000b\u0005%C\u0011A\u00025bI>|\u0007/\u0003\u0002L\u0007\ni\u0011\t\u001d9mS\u000e\fG/[8o\u0013\u0012Dq!\u0014\u0001A\u0002\u0013\u0005a*A\u0005baBLEm\u0018\u0013fcR\u0011Ag\u0014\u0005\bw1\u000b\t\u00111\u0001B\u0011\u0019\t\u0006\u0001)Q\u0005\u0003\u00061\u0011\r\u001d9JI\u0002Baa\u0015\u0001\u0005\u0002\u0019!\u0016AB1eI\u0006\u0013x\rF\u00035+z\u0003'\rC\u0003W%\u0002\u0007q+\u0001\u0006paRLwN\u001c(b[\u0016\u0004\"\u0001W.\u000f\u0005UJ\u0016B\u0001.7\u0003\u0019\u0001&/\u001a3fM&\u0011A,\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005i3\u0004\"B0S\u0001\u00049\u0016AB3omZ\u000b'\u000fC\u0003b%\u0002\u0007q+A\u0004tsN\u0004&o\u001c9\t\u000b\r\u0014\u0006\u0019\u00013\u0002\u0011\u0005\u0014(/Y=Ck\u001a\u00042!\u001a6X\u001b\u00051'BA4i\u0003\u001diW\u000f^1cY\u0016T!!\u001b\u001c\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002lM\nY\u0011I\u001d:bs\n+hMZ3s\u0011\u0015i\u0007\u0001\"\u0011o\u0003\u0015\u0019H/\u0019:u)\u0005!\u0004\"\u00029\u0001\t\u0003q\u0017AC<bSR4uN]!qa\")!\u000f\u0001C!]\u0006!1\u000f^8q\u0001")
public class YarnClientSchedulerBackend
extends CoarseGrainedSchedulerBackend {
    private final SparkContext sc;
    private Client client;
    private ApplicationId appId;

    public Client client() {
        return this.client;
    }

    public void client_$eq(Client x$1) {
        this.client = x$1;
    }

    public ApplicationId appId() {
        return this.appId;
    }

    public void appId_$eq(ApplicationId x$1) {
        this.appId = x$1;
    }

    public void addArg(String optionName, String envVar, String sysProp, ArrayBuffer<String> arrayBuf) {
        if (System.getenv(envVar) == null) {
            if (this.sc.getConf().contains(sysProp)) {
                arrayBuf.$plus$eq((Object)optionName, (Object)this.sc.getConf().get(sysProp), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            }
        } else {
            arrayBuf.$plus$eq((Object)optionName, (Object)System.getenv(envVar), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        }
    }

    public void start() {
        super.start();
        String driverHost = this.conf().get("spark.driver.host");
        String driverPort = this.conf().get("spark.driver.port");
        String hostport = new StringBuilder().append((Object)driverHost).append((Object)":").append((Object)driverPort).toString();
        ArrayBuffer argsArrayBuf = new ArrayBuffer();
        String[] stringArray = new String[6];
        stringArray[0] = "--jar";
        stringArray[1] = null;
        stringArray[2] = "--args";
        stringArray[3] = hostport;
        stringArray[4] = "--am-class";
        stringArray[5] = ExecutorLauncher.class.getName();
        argsArrayBuf.$plus$eq((Object)"--class", (Object)"notused", (Seq)Predef$.MODULE$.wrapRefArray((Object[])stringArray));
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"--driver-memory", (Object)"SPARK_MASTER_MEMORY", (Object)"spark.master.memory"), new Tuple3((Object)"--driver-memory", (Object)"SPARK_DRIVER_MEMORY", (Object)"spark.driver.memory"), new Tuple3((Object)"--num-executors", (Object)"SPARK_WORKER_INSTANCES", (Object)"spark.executor.instances"), new Tuple3((Object)"--num-executors", (Object)"SPARK_EXECUTOR_INSTANCES", (Object)"spark.executor.instances"), new Tuple3((Object)"--executor-memory", (Object)"SPARK_WORKER_MEMORY", (Object)"spark.executor.memory"), new Tuple3((Object)"--executor-memory", (Object)"SPARK_EXECUTOR_MEMORY", (Object)"spark.executor.memory"), new Tuple3((Object)"--executor-cores", (Object)"SPARK_WORKER_CORES", (Object)"spark.executor.cores"), new Tuple3((Object)"--executor-cores", (Object)"SPARK_EXECUTOR_CORES", (Object)"spark.executor.cores"), new Tuple3((Object)"--queue", (Object)"SPARK_YARN_QUEUE", (Object)"spark.yarn.queue"), new Tuple3((Object)"--name", (Object)"SPARK_YARN_APP_NAME", (Object)"spark.app.name"), new Tuple3((Object)"--files", (Object)"SPARK_YARN_DIST_FILES", (Object)"spark.yarn.dist.files"), new Tuple3((Object)"--archives", (Object)"SPARK_YARN_DIST_ARCHIVES", (Object)"spark.yarn.dist.archives")})).foreach((Function1)new Serializable(this, argsArrayBuf){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnClientSchedulerBackend $outer;
            private final ArrayBuffer argsArrayBuf$1;

            public final void apply(Tuple3<String, String, String> x0$1) {
                Tuple3<String, String, String> tuple3 = x0$1;
                if (tuple3 != null) {
                    String optName = (String)tuple3._1();
                    String envVar = (String)tuple3._2();
                    String sysProp = (String)tuple3._3();
                    this.$outer.addArg(optName, envVar, sysProp, (ArrayBuffer<String>)this.argsArrayBuf$1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple3);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.argsArrayBuf$1 = argsArrayBuf$1;
            }
        });
        this.logDebug((Function0)new Serializable(this, argsArrayBuf){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer argsArrayBuf$1;

            public final String apply() {
                return new StringBuilder().append((Object)"ClientArguments called with: ").append((Object)this.argsArrayBuf$1).toString();
            }
            {
                this.argsArrayBuf$1 = argsArrayBuf$1;
            }
        });
        ClientArguments args = new ClientArguments((String[])argsArrayBuf.toArray(ClassTag$.MODULE$.apply(String.class)), this.conf());
        this.client_$eq(new Client(args, this.conf()));
        this.appId_$eq(this.client().runApp());
        this.waitForApp();
    }

    public void waitForApp() {
        while (true) {
            block6: {
                block5: {
                    YarnApplicationState state;
                    ApplicationReport report = this.client().getApplicationReport(this.appId());
                    this.logInfo((Function0)new Serializable(this, report){
                        public static final long serialVersionUID = 0L;
                        private final ApplicationReport report$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Application report from ASM: \n\t appMasterRpcPort: ").append((Object)BoxesRunTime.boxToInteger((int)this.report$1.getRpcPort())).append((Object)"\n").append((Object)"\t appStartTime: ").append((Object)BoxesRunTime.boxToLong((long)this.report$1.getStartTime())).append((Object)"\n").append((Object)"\t yarnAppState: ").append((Object)this.report$1.getYarnApplicationState()).append((Object)"\n").toString();
                        }
                        {
                            this.report$1 = report$1;
                        }
                    });
                    YarnApplicationState yarnApplicationState = state = report.getYarnApplicationState();
                    YarnApplicationState yarnApplicationState2 = YarnApplicationState.RUNNING;
                    if (!(yarnApplicationState != null ? !yarnApplicationState.equals(yarnApplicationState2) : yarnApplicationState2 != null)) {
                        return;
                    }
                    YarnApplicationState yarnApplicationState3 = state;
                    YarnApplicationState yarnApplicationState4 = YarnApplicationState.FINISHED;
                    if (!(yarnApplicationState3 == null ? yarnApplicationState4 != null : !yarnApplicationState3.equals(yarnApplicationState4))) break block5;
                    YarnApplicationState yarnApplicationState5 = state;
                    YarnApplicationState yarnApplicationState6 = YarnApplicationState.FAILED;
                    if (!(yarnApplicationState5 == null ? yarnApplicationState6 != null : !yarnApplicationState5.equals(yarnApplicationState6))) break block5;
                    YarnApplicationState yarnApplicationState7 = state;
                    YarnApplicationState yarnApplicationState8 = YarnApplicationState.KILLED;
                    if (yarnApplicationState7 != null ? !yarnApplicationState7.equals(yarnApplicationState8) : yarnApplicationState8 != null) break block6;
                }
                throw new SparkException("Yarn application already ended,might be killed or not able to launch application master.");
            }
            Thread.sleep(1000L);
        }
    }

    public void stop() {
        super.stop();
        this.client().stop();
        this.logInfo((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Stopped";
            }
        });
    }

    public YarnClientSchedulerBackend(TaskSchedulerImpl scheduler, SparkContext sc) {
        this.sc = sc;
        super(scheduler, sc.env().actorSystem());
        this.client = null;
        this.appId = null;
    }
}

