/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.io.File;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapred.Master;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.util.Records;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.yarn.ApplicationMaster;
import org.apache.spark.deploy.yarn.ClientArguments;
import org.apache.spark.deploy.yarn.ClientBase;
import org.apache.spark.deploy.yarn.ClientBase$;
import org.apache.spark.deploy.yarn.ClientDistributedCacheManager;
import org.apache.spark.deploy.yarn.ExecutorLauncher;
import org.apache.spark.deploy.yarn.YarnAllocationHandler$;
import org.apache.spark.deploy.yarn.YarnSparkHadoopUtil$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.sys.package$;

public abstract class ClientBase$class {
    public static int memoryOverhead(ClientBase $this) {
        return $this.sparkConf().getInt("spark.yarn.driver.memoryOverhead", YarnAllocationHandler$.MODULE$.MEMORY_OVERHEAD());
    }

    /*
     * Unable to fully structure code
     */
    public static void validateArgs(ClientBase $this) {
        v0 = new Tuple2[5];
        if ($this.args().userJar() != null) ** GOTO lbl-1000
        v1 = $this.args().amClass();
        var1_1 = ApplicationMaster.class.getName();
        if (!(v1 != null ? v1.equals(var1_1) == false : var1_1 != null)) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        v0[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToBoolean((boolean)v2)), (Object)"Error: You must specify a user jar when running in standalone mode!");
        v0[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToBoolean((boolean)($this.args().userClass() == null))), (Object)"Error: You must specify a user class!");
        v0[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToBoolean((boolean)($this.args().numExecutors() <= 0))), (Object)"Error: You must specify at least 1 executor!");
        v0[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToBoolean((boolean)($this.args().amMemory() <= $this.memoryOverhead()))), (Object)new StringBuilder().append((Object)"Error: AM memory size must begreater than: ").append((Object)BoxesRunTime.boxToInteger((int)$this.memoryOverhead())).toString());
        v0[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToBoolean((boolean)($this.args().executorMemory() <= $this.memoryOverhead()))), (Object)new StringBuilder().append((Object)"Error: Executor memory sizemust be greater than: ").append((Object)BoxesRunTime.boxToInteger((int)$this.memoryOverhead()).toString()).toString());
        ((IterableLike)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])v0))).foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientBase $outer;

            public final void apply(Tuple2<Object, String> x0$1) {
                Tuple2<Object, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    boolean cond = tuple2._1$mcZ$sp();
                    String errStr = (String)tuple2._2();
                    if (cond) {
                        this.$outer.logError((Function0)new Serializable(this, errStr){
                            public static final long serialVersionUID = 0L;
                            private final String errStr$1;

                            public final String apply() {
                                return this.errStr$1;
                            }
                            {
                                this.errStr$1 = errStr$1;
                            }
                        });
                        this.$outer.args().printUsageAndExit(1, this.$outer.args().printUsageAndExit$default$2());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public static String getAppStagingDir(ClientBase $this, ApplicationId appId) {
        return new StringBuilder().append((Object)$this.org$apache$spark$deploy$yarn$ClientBase$$SPARK_STAGING()).append((Object)"/").append((Object)appId.toString()).append((Object)"/").toString();
    }

    public static void verifyClusterResources(ClientBase $this, GetNewApplicationResponse app) {
        int amMem;
        int maxMem = app.getMaximumResourceCapability().getMemory();
        $this.logInfo((Function0)new Serializable($this, maxMem){
            public static final long serialVersionUID = 0L;
            private final int maxMem$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Max mem capabililty of a single resource in this cluster ").append((Object)BoxesRunTime.boxToInteger((int)this.maxMem$1)).toString();
            }
            {
                this.maxMem$1 = maxMem$1;
            }
        });
        if ($this.args().executorMemory() > maxMem) {
            $this.logError((Function0)new Serializable($this, maxMem){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientBase $outer;
                private final int maxMem$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Required executor memory (%d MB), is above the max threshold (%d MB) of this cluster.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.args().executorMemory()), BoxesRunTime.boxToInteger((int)this.maxMem$1)}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.maxMem$1 = maxMem$1;
                }
            });
            System.exit(1);
        }
        if ((amMem = $this.args().amMemory() + $this.memoryOverhead()) > maxMem) {
            $this.logError((Function0)new Serializable($this, maxMem){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientBase $outer;
                private final int maxMem$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Required AM memory (%d) is above the max threshold (%d) of this cluster")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.args().amMemory()), BoxesRunTime.boxToInteger((int)this.maxMem$1)}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.maxMem$1 = maxMem$1;
                }
            });
            System.exit(1);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean compareFs(ClientBase $this, FileSystem srcFs, FileSystem destFs) {
        URI srcUri = srcFs.getUri();
        URI dstUri = destFs.getUri();
        if (srcUri.getScheme() == null) {
            return false;
        }
        if (!srcUri.getScheme().equals(dstUri.getScheme())) return false;
        String srcHost = srcUri.getHost();
        String dstHost = dstUri.getHost();
        if (srcHost == null || dstHost == null) {
            if (srcHost == null && dstHost != null) {
                return false;
            }
            if (srcHost != null && dstHost == null) {
                return false;
            }
        } else {
            try {
                srcHost = InetAddress.getByName(srcHost).getCanonicalHostName();
                dstHost = InetAddress.getByName(dstHost).getCanonicalHostName();
                if (!srcHost.equals(dstHost)) return false;
            }
            catch (UnknownHostException unknownHostException) {
                return false;
            }
        }
        if (srcUri.getPort() == dstUri.getPort()) return true;
        return false;
    }

    public static Path org$apache$spark$deploy$yarn$ClientBase$$copyRemoteFile(ClientBase $this, Path dstDir, Path originalPath, short replication, boolean setPerms) {
        FileSystem fs = FileSystem.get((Configuration)$this.conf());
        FileSystem remoteFs = originalPath.getFileSystem($this.conf());
        ObjectRef newPath = new ObjectRef((Object)originalPath);
        if (!ClientBase$class.compareFs($this, remoteFs, fs)) {
            newPath.elem = new Path(dstDir, originalPath.getName());
            $this.logInfo((Function0)new Serializable($this, originalPath, newPath){
                public static final long serialVersionUID = 0L;
                private final Path originalPath$1;
                private final ObjectRef newPath$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Uploading ").append((Object)this.originalPath$1).append((Object)" to ").append((Object)((Path)this.newPath$1.elem)).toString();
                }
                {
                    this.originalPath$1 = originalPath$1;
                    this.newPath$1 = newPath$1;
                }
            });
            FileUtil.copy((FileSystem)remoteFs, (Path)originalPath, (FileSystem)fs, (Path)((Path)newPath.elem), (boolean)false, (Configuration)$this.conf());
            fs.setReplication((Path)newPath.elem, replication);
            if (setPerms) {
                fs.setPermission((Path)newPath.elem, new FsPermission($this.APP_FILE_PERMISSION()));
            }
        }
        Path qualPath = fs.makeQualified((Path)newPath.elem);
        FileContext fc = FileContext.getFileContext((URI)qualPath.toUri(), (Configuration)$this.conf());
        Path destPath = fc.resolvePath(qualPath);
        return destPath;
    }

    public static boolean org$apache$spark$deploy$yarn$ClientBase$$copyRemoteFile$default$4(ClientBase $this) {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static Path qualifyForLocal(ClientBase $this, URI localURI) {
        void var3_3;
        URI qualifiedURI = localURI;
        if (qualifiedURI.getScheme() == null) {
            qualifiedURI = new URI(FileSystem.getLocal((Configuration)$this.conf()).makeQualified(new Path(qualifiedURI)).toString());
        }
        Path qualPath = new Path(qualifiedURI);
        return var3_3;
    }

    public static HashMap prepareLocalResources(ClientBase $this, String appStagingDir) {
        Token[] tokenArray;
        $this.logInfo((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Preparing Local resources";
            }
        });
        FileSystem fs = FileSystem.get((Configuration)$this.conf());
        String delegTokenRenewer = Master.getMasterPrincipal((Configuration)$this.conf());
        if (UserGroupInformation.isSecurityEnabled() && (delegTokenRenewer == null || delegTokenRenewer.length() == 0)) {
            $this.logError((Function0)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Can't get Master Kerberos principal for use as renewer";
                }
            });
            System.exit(1);
        }
        Path dst = new Path(fs.getHomeDirectory(), appStagingDir);
        short replication = (short)$this.sparkConf().getInt("spark.yarn.submit.file.replication", 3);
        if (UserGroupInformation.isSecurityEnabled()) {
            FileSystem dstFs = dst.getFileSystem($this.conf());
            tokenArray = dstFs.addDelegationTokens(delegTokenRenewer, $this.credentials());
        } else {
            tokenArray = BoxedUnit.UNIT;
        }
        HashMap localResources = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        FileSystem.mkdirs((FileSystem)fs, (Path)dst, (FsPermission)new FsPermission($this.STAGING_DIR_PERMISSION()));
        Map statCache = (Map)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        ((IterableLike)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)ClientBase$.MODULE$.SPARK_JAR()), (Object)ClientBase$.MODULE$.getSparkJar()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)ClientBase$.MODULE$.APP_JAR()), (Object)$this.args().userJar()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)ClientBase$.MODULE$.LOG4J_PROP()), (Object)System.getenv(ClientBase$.MODULE$.LOG4J_CONF_ENV_KEY()))}))).foreach((Function1)new Serializable($this, fs, dst, replication, localResources, statCache){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientBase $outer;
            private final FileSystem fs$1;
            private final Path dst$1;
            private final short replication$1;
            private final HashMap localResources$1;
            private final Map statCache$1;

            public final void apply(Tuple2<String, String> x0$2) {
                Tuple2<String, String> tuple2 = x0$2;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    String localPath;
                    String destName = (String)tuple2._1();
                    String _localPath = (String)tuple2._2();
                    String string = localPath = _localPath == null ? "" : _localPath.trim();
                    if (localPath.isEmpty()) {
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        URI localURI = new URI(localPath);
                        if (ClientBase$.MODULE$.LOCAL_SCHEME().equals(localURI.getScheme())) {
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boolean setPermissions = destName.equals(ClientBase$.MODULE$.APP_JAR());
                            Path destPath = ClientBase$class.org$apache$spark$deploy$yarn$ClientBase$$copyRemoteFile(this.$outer, this.dst$1, this.$outer.qualifyForLocal(localURI), this.replication$1, setPermissions);
                            this.$outer.org$apache$spark$deploy$yarn$ClientBase$$distCacheMgr().addResource(this.fs$1, this.$outer.conf(), destPath, (HashMap<String, LocalResource>)this.localResources$1, LocalResourceType.FILE, destName, (Map<URI, FileStatus>)this.statCache$1, this.$outer.org$apache$spark$deploy$yarn$ClientBase$$distCacheMgr().addResource$default$8());
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.fs$1 = fs$1;
                this.dst$1 = dst$1;
                this.replication$1 = replication$1;
                this.localResources$1 = localResources$1;
                this.statCache$1 = statCache$1;
            }
        });
        ObjectRef cachedSecondaryJarLinks = new ObjectRef((Object)((ListBuffer)ListBuffer$.MODULE$.empty()));
        List fileLists = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)$this.args().addJars(), (Object)LocalResourceType.FILE, (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple3((Object)$this.args().files(), (Object)LocalResourceType.FILE, (Object)BoxesRunTime.boxToBoolean((boolean)false)), new Tuple3((Object)$this.args().archives(), (Object)LocalResourceType.ARCHIVE, (Object)BoxesRunTime.boxToBoolean((boolean)false))}));
        fileLists.foreach((Function1)new Serializable($this, fs, dst, replication, localResources, statCache, cachedSecondaryJarLinks){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientBase $outer;
            public final FileSystem fs$1;
            public final Path dst$1;
            public final short replication$1;
            public final HashMap localResources$1;
            public final Map statCache$1;
            public final ObjectRef cachedSecondaryJarLinks$1;

            public final void apply(Tuple3<String, LocalResourceType, Object> x0$3) {
                Tuple3<String, LocalResourceType, Object> tuple3 = x0$3;
                if (tuple3 != null) {
                    BoxedUnit boxedUnit;
                    String flist = (String)tuple3._1();
                    LocalResourceType resType = (LocalResourceType)tuple3._2();
                    boolean addToClasspath = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
                    if (flist == null || flist.isEmpty()) {
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(flist)).split(',')).foreach((Function1)new Serializable(this, resType, addToClasspath){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ ClientBase$.anonfun.prepareLocalResources.4 $outer;
                            private final LocalResourceType resType$1;
                            private final boolean addToClasspath$1;

                            public final Object apply(String x0$4) {
                                String string = x0$4;
                                if (string != null) {
                                    Object object;
                                    String string2 = string;
                                    URI localURI = new URI(string2.trim());
                                    if (ClientBase$.MODULE$.LOCAL_SCHEME().equals(localURI.getScheme())) {
                                        object = BoxedUnit.UNIT;
                                    } else {
                                        Path localPath = new Path(localURI);
                                        String linkname = (String)Option$.MODULE$.apply((Object)localURI.getFragment()).getOrElse((Function0)new Serializable(this, localPath){
                                            public static final long serialVersionUID = 0L;
                                            private final Path localPath$1;

                                            public final String apply() {
                                                return this.localPath$1.getName();
                                            }
                                            {
                                                this.localPath$1 = localPath$1;
                                            }
                                        });
                                        Path destPath = ClientBase$class.org$apache$spark$deploy$yarn$ClientBase$$copyRemoteFile(this.$outer.org$apache$spark$deploy$yarn$ClientBase$$anonfun$$$outer(), this.$outer.dst$1, localPath, this.$outer.replication$1, ClientBase$class.org$apache$spark$deploy$yarn$ClientBase$$copyRemoteFile$default$4(this.$outer.org$apache$spark$deploy$yarn$ClientBase$$anonfun$$$outer()));
                                        this.$outer.org$apache$spark$deploy$yarn$ClientBase$$anonfun$$$outer().org$apache$spark$deploy$yarn$ClientBase$$distCacheMgr().addResource(this.$outer.fs$1, this.$outer.org$apache$spark$deploy$yarn$ClientBase$$anonfun$$$outer().conf(), destPath, (HashMap<String, LocalResource>)this.$outer.localResources$1, this.resType$1, linkname, (Map<URI, FileStatus>)this.$outer.statCache$1, this.$outer.org$apache$spark$deploy$yarn$ClientBase$$anonfun$$$outer().org$apache$spark$deploy$yarn$ClientBase$$distCacheMgr().addResource$default$8());
                                        object = this.addToClasspath$1 ? ((ListBuffer)this.$outer.cachedSecondaryJarLinks$1.elem).$plus$eq((Object)linkname) : BoxedUnit.UNIT;
                                    }
                                    BoxedUnit boxedUnit = object;
                                    return boxedUnit;
                                }
                                throw new MatchError((Object)string);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.resType$1 = resType$1;
                                this.addToClasspath$1 = addToClasspath$1;
                            }
                        });
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return;
                }
                throw new MatchError(tuple3);
            }

            public /* synthetic */ ClientBase org$apache$spark$deploy$yarn$ClientBase$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.fs$1 = fs$1;
                this.dst$1 = dst$1;
                this.replication$1 = replication$1;
                this.localResources$1 = localResources$1;
                this.statCache$1 = statCache$1;
                this.cachedSecondaryJarLinks$1 = cachedSecondaryJarLinks$1;
            }
        });
        $this.sparkConf().set(ClientBase$.MODULE$.CONF_SPARK_YARN_SECONDARY_JARS(), ((ListBuffer)cachedSecondaryJarLinks.elem).mkString(","));
        UserGroupInformation.getCurrentUser().addCredentials($this.credentials());
        return localResources;
    }

    /*
     * WARNING - void declaration
     */
    public static HashMap setupLaunchEnv(ClientBase $this, HashMap localResources, String stagingDir) {
        void var3_3;
        $this.logInfo((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Setting up the launch environment";
            }
        });
        HashMap env = new HashMap();
        Option extraCp = $this.sparkConf().getOption("spark.driver.extraClassPath");
        String log4jConf = System.getenv(ClientBase$.MODULE$.LOG4J_CONF_ENV_KEY());
        ClientBase$.MODULE$.populateClasspath((Configuration)$this.yarnConf(), $this.sparkConf(), log4jConf, (HashMap<String, String>)env, (Option<String>)extraCp);
        env.update((Object)"SPARK_YARN_MODE", (Object)"true");
        env.update((Object)"SPARK_YARN_STAGING_DIR", (Object)stagingDir);
        env.update((Object)"SPARK_USER", (Object)UserGroupInformation.getCurrentUser().getShortUserName());
        if (log4jConf != null) {
            env.update((Object)ClientBase$.MODULE$.LOG4J_CONF_ENV_KEY(), (Object)log4jConf);
        }
        $this.org$apache$spark$deploy$yarn$ClientBase$$distCacheMgr().setDistFilesEnv((Map<String, String>)env);
        $this.org$apache$spark$deploy$yarn$ClientBase$$distCacheMgr().setDistArchivesEnv((Map<String, String>)env);
        package$.MODULE$.env().get((Object)"SPARK_YARN_USER_ENV").foreach((Function1)new Serializable($this, env){
            public static final long serialVersionUID = 0L;
            private final HashMap env$1;

            public final void apply(String userEnvs) {
                YarnSparkHadoopUtil$.MODULE$.setEnvFromInputString((HashMap<String, String>)this.env$1, userEnvs, File.pathSeparator);
                this.env$1.update((Object)"SPARK_YARN_USER_ENV", (Object)userEnvs);
            }
            {
                this.env$1 = env$1;
            }
        });
        return var3_3;
    }

    public static String userArgsToString(ClientBase $this, ClientArguments clientArgs) {
        String prefix = " --args ";
        Seq<String> args = clientArgs.userArgs();
        StringBuilder retval = new StringBuilder();
        args.foreach((Function1)new Serializable($this, prefix, retval){
            public static final long serialVersionUID = 0L;
            private final String prefix$1;
            private final StringBuilder retval$1;

            public final StringBuilder apply(String arg) {
                return this.retval$1.append(this.prefix$1).append(" '").append(arg).append("' ");
            }
            {
                this.prefix$1 = prefix$1;
                this.retval$1 = retval$1;
            }
        });
        return retval.toString();
    }

    public static ContainerLaunchContext createContainerLaunchContext(ClientBase $this, GetNewApplicationResponse newApp, HashMap localResources, HashMap env) {
        BoxedUnit boxedUnit;
        boolean useConcurrentAndIncrementalGC;
        $this.logInfo((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Setting up container launch context";
            }
        });
        ContainerLaunchContext amContainer = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
        amContainer.setLocalResources(JavaConversions$.MODULE$.mutableMapAsJavaMap((Map)localResources));
        amContainer.setEnvironment(JavaConversions$.MODULE$.mutableMapAsJavaMap((Map)env));
        int amMemory = $this.calculateAMMemory(newApp);
        ListBuffer JAVA_OPTS = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        JAVA_OPTS.$plus$eq((Object)new StringBuilder().append((Object)"-Xmx").append((Object)BoxesRunTime.boxToInteger((int)amMemory)).append((Object)"m").toString());
        Path tmpDir = new Path(ApplicationConstants.Environment.PWD.$(), "./tmp");
        JAVA_OPTS.$plus$eq((Object)new StringBuilder().append((Object)"-Djava.io.tmpdir=").append((Object)tmpDir).toString());
        boolean bl = useConcurrentAndIncrementalGC = env.isDefinedAt((Object)"SPARK_USE_CONC_INCR_GC") && Boolean.parseBoolean((String)env.apply((Object)"SPARK_USE_CONC_INCR_GC"));
        if (useConcurrentAndIncrementalGC) {
            JAVA_OPTS.$plus$eq((Object)"-XX:+UseConcMarkSweepGC");
            JAVA_OPTS.$plus$eq((Object)"-XX:+CMSIncrementalMode");
            JAVA_OPTS.$plus$eq((Object)"-XX:+CMSIncrementalPacing");
            JAVA_OPTS.$plus$eq((Object)"-XX:CMSIncrementalDutyCycleMin=0");
            boxedUnit = JAVA_OPTS.$plus$eq((Object)"-XX:CMSIncrementalDutyCycle=10");
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        package$.MODULE$.env().get((Object)"SPARK_JAVA_OPTS").foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientBase $outer;

            public final SparkConf apply(String opts) {
                this.$outer.sparkConf().set("spark.executor.extraJavaOptions", opts);
                return this.$outer.sparkConf().set("spark.driver.extraJavaOptions", opts);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        String string = $this.args().amClass();
        String string2 = ExecutorLauncher.class.getName();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            Predef$.MODULE$.refArrayOps((Object[])$this.sparkConf().getAll()).withFilter((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<String, String> check$ifrefutable$1) {
                    Tuple2<String, String> tuple2 = check$ifrefutable$1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable($this, JAVA_OPTS){
                public static final long serialVersionUID = 0L;
                private final ListBuffer JAVA_OPTS$1;

                public final ListBuffer<String> apply(Tuple2<String, String> x$1) {
                    Tuple2<String, String> tuple2 = x$1;
                    if (tuple2 != null) {
                        String k = (String)tuple2._1();
                        String v = (String)tuple2._2();
                        ListBuffer listBuffer = this.JAVA_OPTS$1.$plus$eq((Object)new StringBuilder().append((Object)"-D").append((Object)k).append((Object)"=").append((Object)"\\\"").append((Object)v).append((Object)"\\\"").toString());
                        return listBuffer;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.JAVA_OPTS$1 = JAVA_OPTS$1;
                }
            });
        } else {
            package$.MODULE$.props().filterKeys((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String x$2) {
                    return x$2.startsWith("spark");
                }
            }).withFilter((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<String, String> check$ifrefutable$2) {
                    Tuple2<String, String> tuple2 = check$ifrefutable$2;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable($this, JAVA_OPTS){
                public static final long serialVersionUID = 0L;
                private final ListBuffer JAVA_OPTS$1;

                public final ListBuffer<String> apply(Tuple2<String, String> x$3) {
                    Tuple2<String, String> tuple2 = x$3;
                    if (tuple2 != null) {
                        String k = (String)tuple2._1();
                        String v = (String)tuple2._2();
                        ListBuffer listBuffer = this.JAVA_OPTS$1.$plus$eq((Object)new StringBuilder().append((Object)"-D").append((Object)k).append((Object)"=").append((Object)"\\\"").append((Object)v).append((Object)"\\\"").toString());
                        return listBuffer;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.JAVA_OPTS$1 = JAVA_OPTS$1;
                }
            });
            package$.MODULE$.props().get("spark.driver.extraJavaOptions").foreach((Function1)new Serializable($this, JAVA_OPTS){
                public static final long serialVersionUID = 0L;
                private final ListBuffer JAVA_OPTS$1;

                public final ListBuffer<String> apply(String opts) {
                    return this.JAVA_OPTS$1.$plus$eq((Object)opts);
                }
                {
                    this.JAVA_OPTS$1 = JAVA_OPTS$1;
                }
            });
            package$.MODULE$.props().get("spark.driver.libraryPath").foreach((Function1)new Serializable($this, JAVA_OPTS){
                public static final long serialVersionUID = 0L;
                private final ListBuffer JAVA_OPTS$1;

                public final ListBuffer<String> apply(String p) {
                    return this.JAVA_OPTS$1.$plus$eq((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-Djava.library.path=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{p})));
                }
                {
                    this.JAVA_OPTS$1 = JAVA_OPTS$1;
                }
            });
        }
        JAVA_OPTS.$plus$eq((Object)ClientBase$.MODULE$.getLog4jConfiguration((HashMap<String, LocalResource>)localResources));
        Seq commands = (Seq)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)ApplicationConstants.Environment.JAVA_HOME.$()).append((Object)"/bin/java").toString(), "-server"}))).$plus$plus((GenTraversableOnce)JAVA_OPTS, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{$this.args().amClass(), "--class", $this.args().userClass(), "--jar ", $this.args().userJar(), $this.userArgsToString($this.args()), "--executor-memory", ((Object)BoxesRunTime.boxToInteger((int)$this.args().executorMemory())).toString(), "--executor-cores", ((Object)BoxesRunTime.boxToInteger((int)$this.args().executorCores())).toString(), "--num-executors ", ((Object)BoxesRunTime.boxToInteger((int)$this.args().numExecutors())).toString(), "1>", "<LOG_DIR>/stdout", "2>", "<LOG_DIR>/stderr"})), Seq$.MODULE$.canBuildFrom());
        $this.logInfo((Function0)new Serializable($this, commands){
            public static final long serialVersionUID = 0L;
            private final Seq commands$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Command for starting the Spark ApplicationMaster: ").append((Object)this.commands$1).toString();
            }
            {
                this.commands$1 = commands$1;
            }
        });
        List printableCommands = ((TraversableOnce)commands.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(String s) {
                return s == null ? "null" : s;
            }
        }, Seq$.MODULE$.canBuildFrom())).toList();
        amContainer.setCommands(JavaConversions$.MODULE$.seqAsJavaList((Seq)printableCommands));
        $this.setupSecurityToken(amContainer);
        return amContainer;
    }

    public static void $init$(ClientBase $this) {
        $this.org$apache$spark$deploy$yarn$ClientBase$_setter_$credentials_$eq(UserGroupInformation.getCurrentUser().getCredentials());
        $this.org$apache$spark$deploy$yarn$ClientBase$_setter_$org$apache$spark$deploy$yarn$ClientBase$$SPARK_STAGING_$eq(".sparkStaging");
        $this.org$apache$spark$deploy$yarn$ClientBase$_setter_$org$apache$spark$deploy$yarn$ClientBase$$distCacheMgr_$eq(new ClientDistributedCacheManager());
        $this.org$apache$spark$deploy$yarn$ClientBase$_setter_$STAGING_DIR_PERMISSION_$eq(FsPermission.createImmutable((short)((short)Integer.parseInt("700", 8))));
        $this.org$apache$spark$deploy$yarn$ClientBase$_setter_$APP_FILE_PERMISSION_$eq(FsPermission.createImmutable((short)((short)Integer.parseInt("644", 8))));
    }
}

