/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.util.RackResolver;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.yarn.ApplicationMasterArguments;
import org.apache.spark.deploy.yarn.YarnAllocationHandler;
import org.apache.spark.scheduler.SplitInfo;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class YarnAllocationHandler$ {
    public static final YarnAllocationHandler$ MODULE$;
    private final String ANY_HOST;
    private final int PRIORITY;
    private final int MEMORY_OVERHEAD;
    private final ConcurrentHashMap<String, String> hostToRack;
    private final ConcurrentHashMap<String, java.util.Set<String>> rackToHostSet;

    static {
        new YarnAllocationHandler$();
    }

    public String ANY_HOST() {
        return this.ANY_HOST;
    }

    public int PRIORITY() {
        return this.PRIORITY;
    }

    public int MEMORY_OVERHEAD() {
        return this.MEMORY_OVERHEAD;
    }

    private ConcurrentHashMap<String, String> hostToRack() {
        return this.hostToRack;
    }

    private ConcurrentHashMap<String, java.util.Set<String>> rackToHostSet() {
        return this.rackToHostSet;
    }

    public YarnAllocationHandler newAllocator(Configuration conf, AMRMClient<AMRMClient.ContainerRequest> amClient, ApplicationAttemptId appAttemptId, ApplicationMasterArguments args, SparkConf sparkConf) {
        return new YarnAllocationHandler(conf, amClient, appAttemptId, args.numExecutors(), args.executorMemory(), args.executorCores(), (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)), (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)), sparkConf);
    }

    public YarnAllocationHandler newAllocator(Configuration conf, AMRMClient<AMRMClient.ContainerRequest> amClient, ApplicationAttemptId appAttemptId, ApplicationMasterArguments args, Map<String, Set<SplitInfo>> map, SparkConf sparkConf) {
        Tuple2<scala.collection.immutable.Map<String, Object>, scala.collection.immutable.Map<String, Object>> tuple2 = this.generateNodeToWeight(conf, map);
        if (tuple2 != null) {
            Tuple2 tuple22;
            scala.collection.immutable.Map hostToSplitCount = (scala.collection.immutable.Map)tuple2._1();
            scala.collection.immutable.Map rackToSplitCount = (scala.collection.immutable.Map)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)hostToSplitCount, (Object)rackToSplitCount);
            scala.collection.immutable.Map hostToSplitCount2 = (scala.collection.immutable.Map)tuple23._1();
            scala.collection.immutable.Map rackToSplitCount2 = (scala.collection.immutable.Map)tuple23._2();
            return new YarnAllocationHandler(conf, amClient, appAttemptId, args.numExecutors(), args.executorMemory(), args.executorCores(), (scala.collection.immutable.Map<String, Object>)hostToSplitCount2, (scala.collection.immutable.Map<String, Object>)rackToSplitCount2, sparkConf);
        }
        throw new MatchError(tuple2);
    }

    public YarnAllocationHandler newAllocator(Configuration conf, AMRMClient<AMRMClient.ContainerRequest> amClient, ApplicationAttemptId appAttemptId, int maxExecutors, int executorMemory, int executorCores, Map<String, Set<SplitInfo>> map, SparkConf sparkConf) {
        Tuple2<scala.collection.immutable.Map<String, Object>, scala.collection.immutable.Map<String, Object>> tuple2 = this.generateNodeToWeight(conf, map);
        if (tuple2 != null) {
            Tuple2 tuple22;
            scala.collection.immutable.Map hostToCount = (scala.collection.immutable.Map)tuple2._1();
            scala.collection.immutable.Map rackToCount = (scala.collection.immutable.Map)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)hostToCount, (Object)rackToCount);
            scala.collection.immutable.Map hostToCount2 = (scala.collection.immutable.Map)tuple23._1();
            scala.collection.immutable.Map rackToCount2 = (scala.collection.immutable.Map)tuple23._2();
            return new YarnAllocationHandler(conf, amClient, appAttemptId, maxExecutors, executorMemory, executorCores, (scala.collection.immutable.Map<String, Object>)hostToCount2, (scala.collection.immutable.Map<String, Object>)rackToCount2, sparkConf);
        }
        throw new MatchError(tuple2);
    }

    private Tuple2<scala.collection.immutable.Map<String, Object>, scala.collection.immutable.Map<String, Object>> generateNodeToWeight(Configuration conf, Map<String, Set<SplitInfo>> input) {
        if (input == null) {
            return new Tuple2((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
        }
        HashMap hostToCount = new HashMap();
        HashMap rackToCount = new HashMap();
        input.withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Set<SplitInfo>> check$ifrefutable$3) {
                Tuple2<String, Set<SplitInfo>> tuple2 = check$ifrefutable$3;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(conf, hostToCount, rackToCount){
            public static final long serialVersionUID = 0L;
            private final Configuration conf$1;
            private final HashMap hostToCount$1;
            private final HashMap rackToCount$1;

            public final Object apply(Tuple2<String, Set<SplitInfo>> x$7) {
                Tuple2<String, Set<SplitInfo>> tuple2 = x$7;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    String host = (String)tuple2._1();
                    Set splits = (Set)tuple2._2();
                    int hostCount = BoxesRunTime.unboxToInt((Object)this.hostToCount$1.getOrElse((Object)host, (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply() {
                            return this.apply$mcI$sp();
                        }

                        public int apply$mcI$sp() {
                            return 0;
                        }
                    }));
                    this.hostToCount$1.put((Object)host, (Object)BoxesRunTime.boxToInteger((int)(hostCount + splits.size())));
                    String rack = YarnAllocationHandler$.MODULE$.lookupRack(this.conf$1, host);
                    if (rack == null) {
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        int rackCount = BoxesRunTime.unboxToInt((Object)this.rackToCount$1.getOrElse((Object)host, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply() {
                                return this.apply$mcI$sp();
                            }

                            public int apply$mcI$sp() {
                                return 0;
                            }
                        }));
                        boxedUnit = this.rackToCount$1.put((Object)host, (Object)BoxesRunTime.boxToInteger((int)(rackCount + splits.size())));
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return boxedUnit2;
                }
                throw new MatchError(tuple2);
            }
            {
                this.conf$1 = conf$1;
                this.hostToCount$1 = hostToCount$1;
                this.rackToCount$1 = rackToCount$1;
            }
        });
        return new Tuple2((Object)hostToCount.toMap(Predef$.MODULE$.conforms()), (Object)rackToCount.toMap(Predef$.MODULE$.conforms()));
    }

    public String lookupRack(Configuration conf, String host) {
        if (!this.hostToRack().contains(host)) {
            this.populateRackInfo(conf, host);
        }
        return this.hostToRack().get(host);
    }

    public Option<scala.collection.immutable.Set<String>> fetchCachedHostsForRack(String rack) {
        return Option$.MODULE$.apply(this.rackToHostSet().get(rack)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Set<String> apply(java.util.Set<String> set) {
                scala.collection.mutable.Set convertedSet = JavaConversions$.MODULE$.asScalaSet(set);
                return convertedSet.toSet();
            }
        });
    }

    public void populateRackInfo(Configuration conf, String hostname) {
        Node rackInfo;
        Utils$.MODULE$.checkHost(hostname, Utils$.MODULE$.checkHost$default$2());
        if (!this.hostToRack().containsKey(hostname) && (rackInfo = RackResolver.resolve((Configuration)conf, (String)hostname)) != null && rackInfo.getNetworkLocation() != null) {
            String rack = rackInfo.getNetworkLocation();
            this.hostToRack().put(hostname, rack);
            Object object = this.rackToHostSet().containsKey(rack) ? BoxedUnit.UNIT : this.rackToHostSet().putIfAbsent(rack, Collections.newSetFromMap(new ConcurrentHashMap()));
            this.rackToHostSet().get(rack).add(hostname);
        }
    }

    private YarnAllocationHandler$() {
        MODULE$ = this;
        this.ANY_HOST = "*";
        this.PRIORITY = 1;
        this.MEMORY_OVERHEAD = 384;
        this.hostToRack = new ConcurrentHashMap();
        this.rackToHostSet = new ConcurrentHashMap();
    }
}

