/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.io.DataOutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.YarnClusterMetrics;
import org.apache.hadoop.yarn.client.api.YarnClientApplication;
import org.apache.hadoop.yarn.client.api.impl.YarnClientImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.util.Records;
import org.apache.spark.Logging;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.yarn.Client$;
import org.apache.spark.deploy.yarn.ClientArguments;
import org.apache.spark.deploy.yarn.ClientBase;
import org.apache.spark.deploy.yarn.ClientBase$class;
import org.apache.spark.deploy.yarn.ClientDistributedCacheManager;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}d\u0001B\u0001\u0003\u00015\u0011aa\u00117jK:$(BA\u0002\u0005\u0003\u0011I\u0018M\u001d8\u000b\u0005\u00151\u0011A\u00023fa2|\u0017P\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\b\u001c?A\u0011q\"G\u0007\u0002!)\u0011\u0011CE\u0001\u0005S6\u0004HN\u0003\u0002\u0014)\u0005\u0019\u0011\r]5\u000b\u0005U1\u0012AB2mS\u0016tGO\u0003\u0002\u0004/)\u0011\u0001\u0004C\u0001\u0007Q\u0006$wn\u001c9\n\u0005i\u0001\"AD-be:\u001cE.[3oi&k\u0007\u000f\u001c\t\u00039ui\u0011AA\u0005\u0003=\t\u0011!b\u00117jK:$()Y:f!\t\u0001\u0013%D\u0001\u0007\u0013\t\u0011cAA\u0004M_\u001e<\u0017N\\4\t\u0011\u0011\u0002!\u0011!Q\u0001\n\u0015\n!b\u00197jK:$\u0018I]4t!\tab%\u0003\u0002(\u0005\ty1\t\\5f]R\f%oZ;nK:$8\u000f\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003+\u0003)A\u0017\rZ8pa\u000e{gN\u001a\t\u0003W9j\u0011\u0001\f\u0006\u0003[]\tAaY8oM&\u0011q\u0006\f\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u0011E\u0002!\u0011!Q\u0001\nI\naa\u001d9D_:4\u0007C\u0001\u00114\u0013\t!dAA\u0005Ta\u0006\u00148nQ8oM\")a\u0007\u0001C\u0001o\u00051A(\u001b8jiz\"B\u0001O\u001d;wA\u0011A\u0004\u0001\u0005\u0006IU\u0002\r!\n\u0005\u0006SU\u0002\rA\u000b\u0005\u0006cU\u0002\rA\r\u0005\u0006m\u0001!\t!\u0010\u000b\u0004qyz\u0004\"\u0002\u0013=\u0001\u0004)\u0003\"B\u0019=\u0001\u0004\u0011\u0004\"\u0002\u001c\u0001\t\u0003\tEC\u0001\u001dC\u0011\u0015!\u0003\t1\u0001&\u0011\u001d!\u0005A1A\u0005\u0002\u0015\u000bA!\u0019:hgV\tQ\u0005\u0003\u0004H\u0001\u0001\u0006I!J\u0001\u0006CJ<7\u000f\t\u0005\b[\u0001\u0011\r\u0011\"\u0001J+\u0005Q\u0003BB&\u0001A\u0003%!&A\u0003d_:4\u0007\u0005C\u0004N\u0001\t\u0007I\u0011\u0001(\u0002\u0013M\u0004\u0018M]6D_:4W#\u0001\u001a\t\rA\u0003\u0001\u0015!\u00033\u0003)\u0019\b/\u0019:l\u0007>tg\r\t\u0005\b%\u0002\u0001\r\u0011\"\u0001T\u0003\r\u0011\boY\u000b\u0002)B\u0011Q\u000bW\u0007\u0002-*\u0011qKF\u0001\u0004SB\u001c\u0017BA-W\u0005\u001dI\u0016M\u001d8S!\u000eCqa\u0017\u0001A\u0002\u0013\u0005A,A\u0004sa\u000e|F%Z9\u0015\u0005u\u001b\u0007C\u00010b\u001b\u0005y&\"\u00011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\t|&\u0001B+oSRDq\u0001\u001a.\u0002\u0002\u0003\u0007A+A\u0002yIEBaA\u001a\u0001!B\u0013!\u0016\u0001\u0002:qG\u0002Bq\u0001\u001b\u0001C\u0002\u0013\u0005\u0011.\u0001\u0005zCJt7i\u001c8g+\u0005Q\u0007CA6n\u001b\u0005a'BA\u0017\u0017\u0013\tqGNA\tZCJt7i\u001c8gS\u001e,(/\u0019;j_:Da\u0001\u001d\u0001!\u0002\u0013Q\u0017!C=be:\u001cuN\u001c4!\u0011\u0015\u0011\b\u0001\"\u0001t\u0003\u0019\u0011XO\\!qaR\tA\u000f\u0005\u0002vs6\taO\u0003\u0002xq\u00069!/Z2pe\u0012\u001c(BA\n\u0017\u0013\tQhOA\u0007BaBd\u0017nY1uS>t\u0017\n\u001a\u0005\u0006y\u0002!\t!`\u0001\u0004eVtG#A/\t\u000b}\u0004A\u0011A?\u000231|wm\u00117vgR,'OU3t_V\u00148-\u001a#fi\u0006LGn\u001d\u0005\b\u0003\u0007\u0001A\u0011AA\u0003\u0003E\u0019\u0017\r\\2vY\u0006$X-Q'NK6|'/\u001f\u000b\u0005\u0003\u000f\ti\u0001E\u0002_\u0003\u0013I1!a\u0003`\u0005\rIe\u000e\u001e\u0005\t\u0003\u001f\t\t\u00011\u0001\u0002\u0012\u00051a.Z<BaB\u0004B!a\u0005\u0002\u001a5\u0011\u0011Q\u0003\u0006\u0004\u0003/A\u0018a\u00049s_R|7m\u001c7sK\u000e|'\u000fZ:\n\t\u0005m\u0011Q\u0003\u0002\u001a\u000f\u0016$h*Z<BaBd\u0017nY1uS>t'+Z:q_:\u001cX\rC\u0004\u0002 \u0001!\t!!\t\u0002%M,G/\u001e9TK\u000e,(/\u001b;z)>\\WM\u001c\u000b\u0004;\u0006\r\u0002\u0002CA\u0013\u0003;\u0001\r!a\n\u0002\u0017\u0005l7i\u001c8uC&tWM\u001d\t\u0004k\u0006%\u0012bAA\u0016m\n12i\u001c8uC&tWM\u001d'bk:\u001c\u0007nQ8oi\u0016DH\u000fC\u0004\u00020\u0001!\t!!\r\u0002\u0013M,(-\\5u\u0003B\u0004Hc\u0001;\u00024!A\u0011QGA\u0017\u0001\u0004\t9$\u0001\u0006baB\u001cuN\u001c;fqR\u00042!^A\u001d\u0013\r\tYD\u001e\u0002\u001d\u0003B\u0004H.[2bi&|gnU;c[&\u001c8/[8o\u0007>tG/\u001a=u\u0011\u001d\ty\u0004\u0001C\u0001\u0003\u0003\n!#\\8oSR|'/\u00119qY&\u001c\u0017\r^5p]R!\u00111IA%!\rq\u0016QI\u0005\u0004\u0003\u000fz&a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003\u0017\ni\u00041\u0001u\u0003\u0015\t\u0007\u000f]%e\u000f\u001d\tyE\u0001E\u0001\u0003#\naa\u00117jK:$\bc\u0001\u000f\u0002T\u00191\u0011A\u0001E\u0001\u0003+\u001aB!a\u0015\u0002XA\u0019a,!\u0017\n\u0007\u0005msL\u0001\u0004B]f\u0014VM\u001a\u0005\bm\u0005MC\u0011AA0)\t\t\t\u0006\u0003\u0005\u0002d\u0005MC\u0011AA3\u0003\u0011i\u0017-\u001b8\u0015\u0007u\u000b9\u0007\u0003\u0005\u0002j\u0005\u0005\u0004\u0019AA6\u0003)\t'oZ*ue&twm\u001d\t\u0006=\u00065\u0014\u0011O\u0005\u0004\u0003_z&!B!se\u0006L\b\u0003BA:\u0003sr1AXA;\u0013\r\t9hX\u0001\u0007!J,G-\u001a4\n\t\u0005m\u0014Q\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005]t\f")
public class Client
extends YarnClientImpl
implements ClientBase {
    private final ClientArguments args;
    private final Configuration conf;
    private final SparkConf sparkConf;
    private YarnRPC rpc;
    private final YarnConfiguration yarnConf;
    private final Credentials credentials;
    private final String org$apache$spark$deploy$yarn$ClientBase$$SPARK_STAGING;
    private final ClientDistributedCacheManager org$apache$spark$deploy$yarn$ClientBase$$distCacheMgr;
    private final FsPermission STAGING_DIR_PERMISSION;
    private final FsPermission APP_FILE_PERMISSION;
    private transient Logger org$apache$spark$Logging$$log_;

    public static void main(String[] stringArray) {
        Client$.MODULE$.main(stringArray);
    }

    @Override
    public Credentials credentials() {
        return this.credentials;
    }

    @Override
    public String org$apache$spark$deploy$yarn$ClientBase$$SPARK_STAGING() {
        return this.org$apache$spark$deploy$yarn$ClientBase$$SPARK_STAGING;
    }

    @Override
    public ClientDistributedCacheManager org$apache$spark$deploy$yarn$ClientBase$$distCacheMgr() {
        return this.org$apache$spark$deploy$yarn$ClientBase$$distCacheMgr;
    }

    @Override
    public FsPermission STAGING_DIR_PERMISSION() {
        return this.STAGING_DIR_PERMISSION;
    }

    @Override
    public FsPermission APP_FILE_PERMISSION() {
        return this.APP_FILE_PERMISSION;
    }

    @Override
    public void org$apache$spark$deploy$yarn$ClientBase$_setter_$credentials_$eq(Credentials x$1) {
        this.credentials = x$1;
    }

    @Override
    public void org$apache$spark$deploy$yarn$ClientBase$_setter_$org$apache$spark$deploy$yarn$ClientBase$$SPARK_STAGING_$eq(String x$1) {
        this.org$apache$spark$deploy$yarn$ClientBase$$SPARK_STAGING = x$1;
    }

    @Override
    public void org$apache$spark$deploy$yarn$ClientBase$_setter_$org$apache$spark$deploy$yarn$ClientBase$$distCacheMgr_$eq(ClientDistributedCacheManager x$1) {
        this.org$apache$spark$deploy$yarn$ClientBase$$distCacheMgr = x$1;
    }

    @Override
    public void org$apache$spark$deploy$yarn$ClientBase$_setter_$STAGING_DIR_PERMISSION_$eq(FsPermission x$1) {
        this.STAGING_DIR_PERMISSION = x$1;
    }

    @Override
    public void org$apache$spark$deploy$yarn$ClientBase$_setter_$APP_FILE_PERMISSION_$eq(FsPermission x$1) {
        this.APP_FILE_PERMISSION = x$1;
    }

    @Override
    public int memoryOverhead() {
        return ClientBase$class.memoryOverhead(this);
    }

    @Override
    public void validateArgs() {
        ClientBase$class.validateArgs(this);
    }

    @Override
    public String getAppStagingDir(ApplicationId appId) {
        return ClientBase$class.getAppStagingDir(this, appId);
    }

    @Override
    public void verifyClusterResources(GetNewApplicationResponse app) {
        ClientBase$class.verifyClusterResources(this, app);
    }

    @Override
    public Path qualifyForLocal(URI localURI) {
        return ClientBase$class.qualifyForLocal(this, localURI);
    }

    @Override
    public HashMap<String, LocalResource> prepareLocalResources(String appStagingDir) {
        return ClientBase$class.prepareLocalResources(this, appStagingDir);
    }

    @Override
    public HashMap<String, String> setupLaunchEnv(HashMap<String, LocalResource> localResources, String stagingDir) {
        return ClientBase$class.setupLaunchEnv(this, localResources, stagingDir);
    }

    @Override
    public String userArgsToString(ClientArguments clientArgs) {
        return ClientBase$class.userArgsToString(this, clientArgs);
    }

    @Override
    public ContainerLaunchContext createContainerLaunchContext(GetNewApplicationResponse newApp, HashMap<String, LocalResource> localResources, HashMap<String, String> env) {
        return ClientBase$class.createContainerLaunchContext(this, newApp, localResources, env);
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    @Override
    public ClientArguments args() {
        return this.args;
    }

    @Override
    public Configuration conf() {
        return this.conf;
    }

    @Override
    public SparkConf sparkConf() {
        return this.sparkConf;
    }

    public YarnRPC rpc() {
        return this.rpc;
    }

    public void rpc_$eq(YarnRPC x$1) {
        this.rpc = x$1;
    }

    @Override
    public YarnConfiguration yarnConf() {
        return this.yarnConf;
    }

    /*
     * WARNING - void declaration
     */
    public ApplicationId runApp() {
        void var3_3;
        this.validateArgs();
        this.init((Configuration)this.yarnConf());
        this.start();
        this.logClusterResourceDetails();
        YarnClientApplication newApp = super.createApplication();
        GetNewApplicationResponse newAppResponse = newApp.getNewApplicationResponse();
        ApplicationId appId = newAppResponse.getApplicationId();
        this.verifyClusterResources(newAppResponse);
        String appStagingDir = this.getAppStagingDir(appId);
        HashMap<String, LocalResource> localResources = this.prepareLocalResources(appStagingDir);
        HashMap<String, String> launchEnv = this.setupLaunchEnv(localResources, appStagingDir);
        ContainerLaunchContext amContainer = this.createContainerLaunchContext(newAppResponse, localResources, launchEnv);
        ApplicationSubmissionContext appContext = newApp.getApplicationSubmissionContext();
        appContext.setApplicationName(this.args().appName());
        appContext.setQueue(this.args().amQueue());
        appContext.setAMContainerSpec(amContainer);
        appContext.setApplicationType("SPARK");
        Resource memoryResource = (Resource)Records.newRecord(Resource.class);
        memoryResource.setMemory(this.args().amMemory() + this.memoryOverhead());
        appContext.setResource(memoryResource);
        this.submitApp(appContext);
        return var3_3;
    }

    public void run() {
        ApplicationId appId = this.runApp();
        this.monitorApplication(appId);
        System.exit(0);
    }

    public void logClusterResourceDetails() {
        YarnClusterMetrics clusterMetrics = super.getYarnClusterMetrics();
        this.logInfo((Function0<String>)new Serializable(this, clusterMetrics){
            public static final long serialVersionUID = 0L;
            private final YarnClusterMetrics clusterMetrics$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Got Cluster metric info from ApplicationsManager (ASM), number of NodeManagers: ").append((Object)BoxesRunTime.boxToInteger((int)this.clusterMetrics$1.getNumNodeManagers())).toString();
            }
            {
                this.clusterMetrics$1 = clusterMetrics$1;
            }
        });
        QueueInfo queueInfo = super.getQueueInfo(this.args().amQueue());
        this.logInfo((Function0<String>)new Serializable(this, queueInfo){
            public static final long serialVersionUID = 0L;
            private final QueueInfo queueInfo$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Queue info ... queueName: %s, queueCurrentCapacity: %s, queueMaxCapacity: %s,\n      queueApplicationCount = %s, queueChildQueueCount = %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.queueInfo$1.getQueueName(), BoxesRunTime.boxToFloat((float)this.queueInfo$1.getCurrentCapacity()), BoxesRunTime.boxToFloat((float)this.queueInfo$1.getMaximumCapacity()), BoxesRunTime.boxToInteger((int)this.queueInfo$1.getApplications().size()), BoxesRunTime.boxToInteger((int)this.queueInfo$1.getChildQueues().size())}));
            }
            {
                this.queueInfo$1 = queueInfo$1;
            }
        });
    }

    @Override
    public int calculateAMMemory(GetNewApplicationResponse newApp) {
        return this.args().amMemory();
    }

    @Override
    public void setupSecurityToken(ContainerLaunchContext amContainer) {
        DataOutputBuffer dob = new DataOutputBuffer();
        this.credentials().writeTokenStorageToStream((DataOutputStream)dob);
        amContainer.setTokens(ByteBuffer.wrap(dob.getData()));
    }

    public ApplicationId submitApp(ApplicationSubmissionContext appContext) {
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Submitting application to ASM";
            }
        });
        return super.submitApplication(appContext);
    }

    public boolean monitorApplication(ApplicationId appId) {
        YarnApplicationState yarnApplicationState;
        YarnApplicationState yarnApplicationState2;
        long interval = this.sparkConf().getLong("spark.yarn.report.interval", 1000L);
        do {
            YarnApplicationState state;
            Thread.sleep(interval);
            ApplicationReport report = super.getApplicationReport(appId);
            this.logInfo((Function0<String>)new Serializable(this, appId, report){
                public static final long serialVersionUID = 0L;
                private final ApplicationId appId$1;
                private final ApplicationReport report$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Application report from ASM: \n\t application identifier: ").append((Object)this.appId$1.toString()).append((Object)"\n").append((Object)"\t appId: ").append((Object)BoxesRunTime.boxToInteger((int)this.appId$1.getId())).append((Object)"\n").append((Object)"\t clientToAMToken: ").append((Object)this.report$1.getClientToAMToken()).append((Object)"\n").append((Object)"\t appDiagnostics: ").append((Object)this.report$1.getDiagnostics()).append((Object)"\n").append((Object)"\t appMasterHost: ").append((Object)this.report$1.getHost()).append((Object)"\n").append((Object)"\t appQueue: ").append((Object)this.report$1.getQueue()).append((Object)"\n").append((Object)"\t appMasterRpcPort: ").append((Object)BoxesRunTime.boxToInteger((int)this.report$1.getRpcPort())).append((Object)"\n").append((Object)"\t appStartTime: ").append((Object)BoxesRunTime.boxToLong((long)this.report$1.getStartTime())).append((Object)"\n").append((Object)"\t yarnAppState: ").append((Object)this.report$1.getYarnApplicationState()).append((Object)"\n").append((Object)"\t distributedFinalState: ").append((Object)this.report$1.getFinalApplicationStatus()).append((Object)"\n").append((Object)"\t appTrackingUrl: ").append((Object)this.report$1.getTrackingUrl()).append((Object)"\n").append((Object)"\t appUser: ").append((Object)this.report$1.getUser()).toString();
                }
                {
                    this.appId$1 = appId$1;
                    this.report$1 = report$1;
                }
            });
            YarnApplicationState yarnApplicationState3 = state = report.getYarnApplicationState();
            YarnApplicationState yarnApplicationState4 = YarnApplicationState.FINISHED;
            if (!(yarnApplicationState3 == null ? yarnApplicationState4 != null : !yarnApplicationState3.equals(yarnApplicationState4))) break;
            YarnApplicationState yarnApplicationState5 = state;
            YarnApplicationState yarnApplicationState6 = YarnApplicationState.FAILED;
            if (!(yarnApplicationState5 == null ? yarnApplicationState6 != null : !yarnApplicationState5.equals(yarnApplicationState6))) break;
            yarnApplicationState2 = state;
            yarnApplicationState = YarnApplicationState.KILLED;
        } while (yarnApplicationState2 != null ? !yarnApplicationState2.equals(yarnApplicationState) : yarnApplicationState != null);
        return true;
    }

    public Client(ClientArguments clientArgs, Configuration hadoopConf, SparkConf spConf) {
        Logging.class.$init$((Logging)this);
        ClientBase$class.$init$(this);
        this.args = clientArgs;
        this.conf = hadoopConf;
        this.sparkConf = spConf;
        this.rpc = YarnRPC.create((Configuration)this.conf());
        this.yarnConf = new YarnConfiguration(this.conf());
    }

    public Client(ClientArguments clientArgs, SparkConf spConf) {
        this(clientArgs, new Configuration(), spConf);
    }

    public Client(ClientArguments clientArgs) {
        this(clientArgs, new SparkConf());
    }
}

