/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.io.File;
import java.lang.reflect.Field;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.MRJobConfig;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext$;
import org.apache.spark.deploy.yarn.YarnSparkHadoopUtil$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.sys.package$;

public final class ClientBase$ {
    public static final ClientBase$ MODULE$;
    private final String SPARK_JAR;
    private final String APP_JAR;
    private final String LOG4J_PROP;
    private final String LOG4J_CONF_ENV_KEY;
    private final String LOCAL_SCHEME;
    private final String CONF_SPARK_YARN_SECONDARY_JARS;

    static {
        new ClientBase$();
    }

    public String SPARK_JAR() {
        return this.SPARK_JAR;
    }

    public String APP_JAR() {
        return this.APP_JAR;
    }

    public String LOG4J_PROP() {
        return this.LOG4J_PROP;
    }

    public String LOG4J_CONF_ENV_KEY() {
        return this.LOG4J_CONF_ENV_KEY;
    }

    public String LOCAL_SCHEME() {
        return this.LOCAL_SCHEME;
    }

    public String CONF_SPARK_YARN_SECONDARY_JARS() {
        return this.CONF_SPARK_YARN_SECONDARY_JARS;
    }

    public String getSparkJar() {
        return (String)package$.MODULE$.env().get((Object)"SPARK_JAR").getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return (String)Option$.MODULE$.option2Iterable(SparkContext$.MODULE$.jarOfClass(ClientBase$.MODULE$.getClass())).head();
            }
        });
    }

    public void populateHadoopClasspath(Configuration conf, HashMap<String, String> env) {
        String[] classpathEntries = (String[])Option$.MODULE$.apply((Object)conf.getStrings("yarn.application.classpath")).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String[] apply() {
                return ClientBase$.MODULE$.getDefaultYarnApplicationClasspath();
            }
        });
        if (classpathEntries != null) {
            Predef$.MODULE$.refArrayOps((Object[])classpathEntries).foreach((Function1)new Serializable(env){
                public static final long serialVersionUID = 0L;
                private final HashMap env$3;

                public final Option<String> apply(String c) {
                    return YarnSparkHadoopUtil$.MODULE$.addToEnvironment((HashMap<String, String>)this.env$3, ApplicationConstants.Environment.CLASSPATH.name(), c.trim(), File.pathSeparator);
                }
                {
                    this.env$3 = env$3;
                }
            });
        }
        String[] mrClasspathEntries = (String[])Option$.MODULE$.apply((Object)conf.getStrings("mapreduce.application.classpath")).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String[] apply() {
                return ClientBase$.MODULE$.getDefaultMRApplicationClasspath();
            }
        });
        if (mrClasspathEntries != null) {
            Predef$.MODULE$.refArrayOps((Object[])mrClasspathEntries).foreach((Function1)new Serializable(env){
                public static final long serialVersionUID = 0L;
                private final HashMap env$3;

                public final Option<String> apply(String c) {
                    return YarnSparkHadoopUtil$.MODULE$.addToEnvironment((HashMap<String, String>)this.env$3, ApplicationConstants.Environment.CLASSPATH.name(), c.trim(), File.pathSeparator);
                }
                {
                    this.env$3 = env$3;
                }
            });
        }
    }

    public String[] getDefaultYarnApplicationClasspath() {
        String[] stringArray;
        try {
            Field field = MRJobConfig.class.getField("DEFAULT_YARN_APPLICATION_CLASSPATH");
            stringArray = (String[])field.get(null);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            stringArray = null;
        }
        catch (NoSuchFieldError noSuchFieldError) {
            stringArray = null;
        }
        return stringArray;
    }

    public String[] getDefaultMRApplicationClasspath() {
        String[] stringArray;
        try {
            Field field = MRJobConfig.class.getField("DEFAULT_MAPREDUCE_APPLICATION_CLASSPATH");
            Class<?> clazz = field.getType();
            Class<String> clazz2 = String.class;
            stringArray = !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null) ? StringUtils.getStrings((String)((String)field.get(null))) : (String[])field.get(null);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            stringArray = null;
        }
        catch (NoSuchFieldError noSuchFieldError) {
            stringArray = null;
        }
        return stringArray;
    }

    public String getLog4jConfiguration(HashMap<String, LocalResource> localResources) {
        String string;
        block5: {
            String log4jConf;
            block2: {
                String string2;
                block4: {
                    block3: {
                        log4jConf = this.LOG4J_PROP();
                        if (localResources.contains((Object)log4jConf)) break block2;
                        string = System.getenv(this.LOG4J_CONF_ENV_KEY());
                        if (string == null) break block3;
                        String string3 = string;
                        URI confUri = new URI(string3);
                        string2 = this.LOCAL_SCHEME().equals(confUri.getScheme()) ? new StringBuilder().append((Object)"file://").append((Object)confUri.getPath()).toString() : this.LOG4J_PROP();
                        break block4;
                    }
                    if (string != null) break block5;
                    string2 = "log4j-spark-container.properties";
                }
                log4jConf = string2;
            }
            return new StringBuilder().append((Object)" -Dlog4j.configuration=").append((Object)log4jConf).toString();
        }
        throw new MatchError((Object)string);
    }

    public void populateClasspath(Configuration conf, SparkConf sparkConf, String log4jConf, HashMap<String, String> env, Option<String> extraClassPath) {
        Option<String> option;
        if (log4jConf == null) {
            option = BoxedUnit.UNIT;
        } else {
            String localPath = this.getLocalPath(log4jConf);
            if (localPath == null) {
                option = BoxedUnit.UNIT;
            } else {
                String parentPath = new File(localPath).getParent();
                option = YarnSparkHadoopUtil$.MODULE$.addToEnvironment(env, ApplicationConstants.Environment.CLASSPATH.name(), parentPath, File.pathSeparator);
            }
        }
        extraClassPath.foreach((Function1)new Serializable(env){
            public static final long serialVersionUID = 0L;
            private final HashMap env$2;

            public final Option<String> apply(String path) {
                return ClientBase$.MODULE$.org$apache$spark$deploy$yarn$ClientBase$$addClasspathEntry$1(path, this.env$2);
            }
            {
                this.env$2 = env$2;
            }
        });
        String[] cachedSecondaryJarLinks = ((String)sparkConf.getOption(this.CONF_SPARK_YARN_SECONDARY_JARS()).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        })).split(",");
        if (new StringOps(Predef$.MODULE$.augmentString(sparkConf.get("spark.yarn.user.classpath.first", "false"))).toBoolean()) {
            this.org$apache$spark$deploy$yarn$ClientBase$$addPwdClasspathEntry$1(this.APP_JAR(), env);
            Predef$.MODULE$.refArrayOps((Object[])cachedSecondaryJarLinks).foreach((Function1)new Serializable(env){
                public static final long serialVersionUID = 0L;
                private final HashMap env$2;

                public final Option<String> apply(String entry) {
                    return ClientBase$.MODULE$.org$apache$spark$deploy$yarn$ClientBase$$addPwdClasspathEntry$1(entry, this.env$2);
                }
                {
                    this.env$2 = env$2;
                }
            });
            this.org$apache$spark$deploy$yarn$ClientBase$$addPwdClasspathEntry$1(this.SPARK_JAR(), env);
            this.populateHadoopClasspath(conf, env);
        } else {
            this.org$apache$spark$deploy$yarn$ClientBase$$addPwdClasspathEntry$1(this.SPARK_JAR(), env);
            this.populateHadoopClasspath(conf, env);
            this.org$apache$spark$deploy$yarn$ClientBase$$addPwdClasspathEntry$1(this.APP_JAR(), env);
            Predef$.MODULE$.refArrayOps((Object[])cachedSecondaryJarLinks).foreach((Function1)new Serializable(env){
                public static final long serialVersionUID = 0L;
                private final HashMap env$2;

                public final Option<String> apply(String entry) {
                    return ClientBase$.MODULE$.org$apache$spark$deploy$yarn$ClientBase$$addPwdClasspathEntry$1(entry, this.env$2);
                }
                {
                    this.env$2 = env$2;
                }
            });
        }
        this.org$apache$spark$deploy$yarn$ClientBase$$addClasspathEntry$1(ApplicationConstants.Environment.PWD.$(), env);
        this.org$apache$spark$deploy$yarn$ClientBase$$addPwdClasspathEntry$1("*", env);
    }

    public Option<String> populateClasspath$default$5() {
        return None$.MODULE$;
    }

    private String getLocalPath(String resource) {
        URI uri = new URI(resource);
        if (this.LOCAL_SCHEME().equals(uri.getScheme())) {
            return uri.getPath();
        }
        return null;
    }

    public final Option org$apache$spark$deploy$yarn$ClientBase$$addClasspathEntry$1(String path, HashMap env$2) {
        return YarnSparkHadoopUtil$.MODULE$.addToEnvironment((HashMap<String, String>)env$2, ApplicationConstants.Environment.CLASSPATH.name(), path, File.pathSeparator);
    }

    public final Option org$apache$spark$deploy$yarn$ClientBase$$addPwdClasspathEntry$1(String entry, HashMap env$2) {
        return this.org$apache$spark$deploy$yarn$ClientBase$$addClasspathEntry$1(new StringBuilder().append((Object)ApplicationConstants.Environment.PWD.$()).append((Object)"/").append((Object)entry).toString(), env$2);
    }

    private ClientBase$() {
        MODULE$ = this;
        this.SPARK_JAR = "__spark__.jar";
        this.APP_JAR = "__app__.jar";
        this.LOG4J_PROP = "log4j.properties";
        this.LOG4J_CONF_ENV_KEY = "SPARK_LOG4J_CONF";
        this.LOCAL_SCHEME = "local";
        this.CONF_SPARK_YARN_SECONDARY_JARS = "spark.yarn.secondary.jars";
    }
}

